/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.yaml;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.fulib.yaml.StrUtil;

public class Reflector {
    private String className = "";
    private Method emfCreateMethod;
    private Object emfFactory;
    private Class<?> eObjectClass;
    private Class<?> clazz = null;
    private String[] properties = null;

    public Class<?> getClazz() {
        if (this.clazz == null) {
            try {
                this.clazz = Class.forName(this.className);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return this.clazz;
    }

    public Reflector setClazz(Class<?> clazz) {
        this.clazz = clazz;
        return this;
    }

    public String getClassName() {
        return this.className;
    }

    public Reflector setClassName(String className) {
        this.className = className;
        return this;
    }

    public void removeObject(Object object) {
        try {
            Class<?> clazz = this.getClazz();
            Method removeYou = clazz.getMethod("removeYou", new Class[0]);
            removeYou.invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String[] getProperties() {
        if (this.properties != null) {
            return this.properties;
        }
        Class<?> clazz = this.getClazz();
        Method[] methods = clazz.getMethods();
        LinkedHashSet<String> fieldNames = new LinkedHashSet<String>();
        for (Method method : methods) {
            String methodName = method.getName();
            if (!methodName.startsWith("get") || methodName.equals("getClass") || method.getParameterCount() != 0) continue;
            methodName = methodName.substring(3);
            if ("".equals((methodName = StrUtil.downFirstChar(methodName)).trim())) continue;
            fieldNames.add(methodName);
        }
        this.properties = fieldNames.toArray(new String[0]);
        Arrays.sort(this.properties);
        return this.properties;
    }

    public Object newInstance() {
        try {
            if (this.emfCreateMethod != null) {
                Object emfObject = this.emfCreateMethod.invoke(this.emfFactory, new Object[0]);
                return emfObject;
            }
            Class<?> clazz = this.getClazz();
            return clazz.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Object getValue(Object object, String attribute) {
        if (object == null) {
            return null;
        }
        try {
            Class<?> clazz = this.getClazz();
            Method method = clazz.getMethod("get" + StrUtil.cap(attribute), new Class[0]);
            Object invoke = method.invoke(object, new Object[0]);
            return invoke;
        }
        catch (Exception clazz) {
            try {
                Class<?> clazz2 = this.getClazz();
                Method method = clazz2.getMethod(attribute, new Class[0]);
                Object invoke = method.invoke(object, new Object[0]);
                return invoke;
            }
            catch (Exception clazz2) {
                try {
                    Class<?> clazz3 = this.getClazz();
                    Method method = clazz3.getMethod("is" + StrUtil.cap(attribute), new Class[0]);
                    Object invoke = method.invoke(object, new Object[0]);
                    return invoke;
                }
                catch (Exception exception) {
                    return null;
                }
            }
        }
    }

    public Object setValue(Object object, String attribute, Object value, String type) {
        if (object == null) {
            return null;
        }
        try {
            Class<?> clazz = this.getClazz();
            Class<?> valueClass = value.getClass();
            if (this.eObjectClass != null && this.eObjectClass.isAssignableFrom(valueClass)) {
                valueClass = valueClass.getInterfaces()[0];
            }
            Method method = clazz.getMethod("set" + StrUtil.cap(attribute), valueClass);
            Object result = method.invoke(object, value);
            return result;
        }
        catch (Exception clazz) {
            try {
                int intValue = Integer.parseInt((String)value);
                Class<?> clazz2 = this.getClazz();
                Method method = clazz2.getMethod("set" + StrUtil.cap(attribute), Integer.TYPE);
                method.invoke(object, intValue);
                return true;
            }
            catch (Exception intValue) {
                try {
                    long longValue = Long.parseLong((String)value);
                    Class<?> clazz3 = this.getClazz();
                    Method method = clazz3.getMethod("set" + StrUtil.cap(attribute), Long.TYPE);
                    method.invoke(object, longValue);
                    return true;
                }
                catch (Exception longValue) {
                    try {
                        double doubleValue = Double.parseDouble((String)value);
                        Class<?> clazz4 = this.getClazz();
                        Method method = clazz4.getMethod("set" + StrUtil.cap(attribute), Double.TYPE);
                        method.invoke(object, doubleValue);
                        return true;
                    }
                    catch (Exception doubleValue) {
                        try {
                            float floatValue = Float.parseFloat((String)value);
                            Class<?> clazz5 = this.getClazz();
                            Method method = clazz5.getMethod("set" + StrUtil.cap(attribute), Float.TYPE);
                            method.invoke(object, Float.valueOf(floatValue));
                            return true;
                        }
                        catch (Exception floatValue) {
                            try {
                                Class<?> clazz6 = this.getClazz();
                                Method method = clazz6.getMethod("with" + StrUtil.cap(attribute), Object[].class);
                                method.invoke(object, new Object[]{new Object[]{value}});
                                return true;
                            }
                            catch (Exception clazz6) {
                                try {
                                    if (this.emfCreateMethod != null) {
                                        Class<?> clazz7 = this.getClazz();
                                        Method getMethod = clazz7.getMethod("get" + StrUtil.cap(attribute), new Class[0]);
                                        Object collection = getMethod.invoke(object, new Object[0]);
                                        Method addMethod = collection.getClass().getMethod("add", Object.class);
                                        addMethod.invoke(collection, value);
                                        return true;
                                    }
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                return null;
                            }
                        }
                    }
                }
            }
        }
    }

    public Reflector setUseEMF() {
        String packageName = this.className;
        int pos = packageName.lastIndexOf(46);
        String simpleClassName = packageName.substring(pos + 1);
        simpleClassName = simpleClassName.substring(0, simpleClassName.length() - "Impl".length());
        packageName = packageName.substring(0, pos);
        packageName = packageName.substring(0, packageName.length() - ".impl".length());
        pos = packageName.lastIndexOf(46);
        String lastPart = packageName.substring(pos + 1);
        String simpleFactoryName = StrUtil.cap(lastPart) + "Factory";
        try {
            Class<?> factoryClass = Class.forName(packageName + "." + simpleFactoryName);
            Field eInstanceField = factoryClass.getField("eINSTANCE");
            this.emfFactory = eInstanceField.get(null);
            this.emfCreateMethod = this.emfFactory.getClass().getMethod("create" + simpleClassName, new Class[0]);
            this.eObjectClass = Class.forName("org.eclipse.emf.ecore.EObject");
        }
        catch (Exception e) {
            Logger.getGlobal().log(Level.SEVERE, "could not find EMF Factory createXY method", e);
        }
        return this;
    }
}

