/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.ast;

import java.util.List;
import java.util.Map;
import org.fulib.scenarios.ast.Node;
import org.fulib.scenarios.ast.ScenarioGroup;
import org.fulib.scenarios.library.Library;
import org.fulib.scenarios.tool.Config;

public interface CompilationContext
extends Node {
    public static CompilationContext of(Config config, Map<String, ScenarioGroup> groups, List<Library> libraries) {
        return new Impl(config, groups, libraries);
    }

    public Config getConfig();

    public void setConfig(Config var1);

    public Map<String, ScenarioGroup> getGroups();

    public void setGroups(Map<String, ScenarioGroup> var1);

    public List<Library> getLibraries();

    public void setLibraries(List<Library> var1);

    default public <P, R> R accept(Visitor<P, R> visitor, P par) {
        return visitor.visit(this, par);
    }

    @Override
    default public <P, R> R accept(Node.Visitor<P, R> visitor, P par) {
        return visitor.visit(this, par);
    }

    public static interface Visitor<P, R> {
        default public R visit(CompilationContext compilationContext, P par) {
            throw new UnsupportedOperationException(this.getClass().getName() + ".visit(" + compilationContext.getClass().getName() + ")");
        }
    }

    public static class Impl
    implements CompilationContext {
        private Config config;
        private Map<String, ScenarioGroup> groups;
        private List<Library> libraries;

        public Impl() {
        }

        public Impl(Config config, Map<String, ScenarioGroup> groups, List<Library> libraries) {
            this.config = config;
            this.groups = groups;
            this.libraries = libraries;
        }

        @Override
        public Config getConfig() {
            return this.config;
        }

        @Override
        public void setConfig(Config config) {
            this.config = config;
        }

        @Override
        public Map<String, ScenarioGroup> getGroups() {
            return this.groups;
        }

        @Override
        public void setGroups(Map<String, ScenarioGroup> groups) {
            this.groups = groups;
        }

        @Override
        public List<Library> getLibraries() {
            return this.libraries;
        }

        @Override
        public void setLibraries(List<Library> libraries) {
            this.libraries = libraries;
        }
    }
}

