/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.ast.decl;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.fulib.scenarios.ast.ScenarioGroup;
import org.fulib.scenarios.ast.decl.AssociationDecl;
import org.fulib.scenarios.ast.decl.AttributeDecl;
import org.fulib.scenarios.ast.decl.ClassDecl;
import org.fulib.scenarios.ast.decl.MethodDecl;
import org.fulib.scenarios.ast.scope.GlobalScope;
import org.fulib.scenarios.ast.type.ListType;
import org.fulib.scenarios.ast.type.Type;
import org.fulib.scenarios.visitor.ExtractClassDecl;
import org.fulib.scenarios.visitor.resolve.TypeResolver;

public class ExternalClassDecl
extends ClassDecl.Impl {
    private volatile boolean attributesResolved = true;

    public ExternalClassDecl() {
    }

    public ExternalClassDecl(ScenarioGroup group, String name, Type type, Map<String, AttributeDecl> attributes, Map<String, AssociationDecl> associations, List<MethodDecl> methods) {
        super(group, name, type, attributes, associations, methods);
    }

    public void markUnresolved() {
        this.attributesResolved = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveAttributes() {
        if (!this.attributesResolved) {
            ExternalClassDecl externalClassDecl = this;
            synchronized (externalClassDecl) {
                if (!this.attributesResolved) {
                    this.filterAttributes();
                    this.attributesResolved = true;
                }
            }
        }
    }

    private void filterAttributes() {
        GlobalScope scope = new GlobalScope(this.getGroup().getContext());
        Iterator<AttributeDecl> iterator = super.getAttributes().values().iterator();
        while (iterator.hasNext()) {
            AttributeDecl attribute = iterator.next();
            Type type = attribute.getType().accept(TypeResolver.INSTANCE, scope);
            ClassDecl otherClass = type.accept(ExtractClassDecl.INSTANCE, null);
            if (otherClass == null) {
                attribute.setType(type);
                continue;
            }
            int cardinality = type instanceof ListType ? 42 : 1;
            String name = attribute.getName();
            AssociationDecl assoc = AssociationDecl.of(this, name, cardinality, otherClass, type, null);
            iterator.remove();
            super.getAssociations().put(name, assoc);
        }
    }

    @Override
    public Map<String, AttributeDecl> getAttributes() {
        this.resolveAttributes();
        return super.getAttributes();
    }

    @Override
    public Map<String, AssociationDecl> getAssociations() {
        this.resolveAttributes();
        return super.getAssociations();
    }
}

