/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.visitor.resolve;

import org.fulib.scenarios.ast.scope.Scope;
import org.fulib.scenarios.ast.type.ClassType;
import org.fulib.scenarios.ast.type.ListType;
import org.fulib.scenarios.ast.type.PrimitiveType;
import org.fulib.scenarios.ast.type.Type;
import org.fulib.scenarios.ast.type.UnresolvedType;
import org.fulib.scenarios.visitor.resolve.DeclResolver;

public enum TypeResolver implements Type.Visitor<Scope, Type>
{
    INSTANCE;


    @Override
    public Type visit(UnresolvedType unresolvedType, Scope par) {
        String name = unresolvedType.getName();
        String primitiveName = name.startsWith("java/lang/") ? name.substring(10) : name;
        PrimitiveType primitive = PrimitiveType.javaNameMap.get(primitiveName);
        if (primitive != null) {
            return primitive;
        }
        return DeclResolver.resolveClass(par, name, unresolvedType.getPosition()).getType();
    }

    @Override
    public Type visit(PrimitiveType primitiveType, Scope par) {
        return primitiveType;
    }

    @Override
    public Type visit(ClassType classType, Scope par) {
        return classType;
    }

    @Override
    public Type visit(ListType listType, Scope par) {
        listType.setElementType(listType.getElementType().accept(this, par));
        return listType;
    }
}

