/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.ast.scope;

import java.util.function.Function;
import org.fulib.scenarios.ast.ScenarioGroup;
import org.fulib.scenarios.ast.decl.ClassDecl;
import org.fulib.scenarios.ast.decl.Decl;
import org.fulib.scenarios.ast.scope.DelegatingScope;
import org.fulib.scenarios.ast.scope.Scope;

public class GroupScope
extends DelegatingScope {
    private final ScenarioGroup group;

    public GroupScope(Scope scope, ScenarioGroup group) {
        super(scope);
        this.group = group;
    }

    @Override
    public Decl resolve(String name) {
        ClassDecl classDecl = this.group.getClasses().get(name);
        return classDecl != null ? classDecl : super.resolve(name);
    }

    @Override
    public <T extends Decl> T resolve(String name, Class<T> type, Function<? super String, ? extends T> create) {
        if (!ClassDecl.class.isAssignableFrom(type) || name.indexOf(47) >= 0) {
            return super.resolve(name, type, create);
        }
        Decl superDecl = super.resolve(name);
        if (superDecl instanceof ClassDecl) {
            return (T)superDecl;
        }
        return (T)this.group.getClasses().computeIfAbsent(name, n -> {
            ClassDecl classDecl = (ClassDecl)create.apply(name);
            classDecl.setGroup(this.group);
            return classDecl;
        });
    }
}

