/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.parser;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.text.StringEscapeUtils;
import org.fulib.scenarios.ast.MultiDescriptor;
import org.fulib.scenarios.ast.NamedExpr;
import org.fulib.scenarios.ast.Node;
import org.fulib.scenarios.ast.Scenario;
import org.fulib.scenarios.ast.ScenarioFile;
import org.fulib.scenarios.ast.decl.Name;
import org.fulib.scenarios.ast.decl.VarDecl;
import org.fulib.scenarios.ast.expr.Expr;
import org.fulib.scenarios.ast.expr.access.AttributeAccess;
import org.fulib.scenarios.ast.expr.access.ExampleAccess;
import org.fulib.scenarios.ast.expr.call.CallExpr;
import org.fulib.scenarios.ast.expr.call.CreationExpr;
import org.fulib.scenarios.ast.expr.collection.FilterExpr;
import org.fulib.scenarios.ast.expr.collection.ListExpr;
import org.fulib.scenarios.ast.expr.collection.RangeExpr;
import org.fulib.scenarios.ast.expr.conditional.AttributeCheckExpr;
import org.fulib.scenarios.ast.expr.conditional.ConditionalOperator;
import org.fulib.scenarios.ast.expr.conditional.ConditionalOperatorExpr;
import org.fulib.scenarios.ast.expr.conditional.PredicateOperator;
import org.fulib.scenarios.ast.expr.conditional.PredicateOperatorExpr;
import org.fulib.scenarios.ast.expr.primary.AnswerLiteral;
import org.fulib.scenarios.ast.expr.primary.DoubleLiteral;
import org.fulib.scenarios.ast.expr.primary.IntLiteral;
import org.fulib.scenarios.ast.expr.primary.NameAccess;
import org.fulib.scenarios.ast.expr.primary.StringLiteral;
import org.fulib.scenarios.ast.sentence.AddSentence;
import org.fulib.scenarios.ast.sentence.AnswerSentence;
import org.fulib.scenarios.ast.sentence.AreSentence;
import org.fulib.scenarios.ast.sentence.CallSentence;
import org.fulib.scenarios.ast.sentence.CommentLevel;
import org.fulib.scenarios.ast.sentence.ConditionalSentence;
import org.fulib.scenarios.ast.sentence.CreateSentence;
import org.fulib.scenarios.ast.sentence.DiagramSentence;
import org.fulib.scenarios.ast.sentence.ExpectSentence;
import org.fulib.scenarios.ast.sentence.HasSentence;
import org.fulib.scenarios.ast.sentence.IsSentence;
import org.fulib.scenarios.ast.sentence.RemoveSentence;
import org.fulib.scenarios.ast.sentence.SectionSentence;
import org.fulib.scenarios.ast.sentence.Sentence;
import org.fulib.scenarios.ast.sentence.SentenceList;
import org.fulib.scenarios.ast.sentence.TakeSentence;
import org.fulib.scenarios.ast.sentence.ThereSentence;
import org.fulib.scenarios.ast.sentence.WriteSentence;
import org.fulib.scenarios.ast.type.Type;
import org.fulib.scenarios.ast.type.UnresolvedType;
import org.fulib.scenarios.diagnostic.Marker;
import org.fulib.scenarios.diagnostic.Position;
import org.fulib.scenarios.parser.Identifiers;
import org.fulib.scenarios.parser.ScenarioParser;
import org.fulib.scenarios.parser.ScenarioParserBaseListener;

public class ASTListener
extends ScenarioParserBaseListener {
    private List<Marker> markers = new ArrayList<Marker>();
    private ScenarioFile file;
    private Deque<Node> stack = new ArrayDeque<Node>();

    public ScenarioFile getFile() {
        return this.file;
    }

    private <T> T pop() {
        return (T)this.stack.pop();
    }

    private <T> List<T> pop(Class<T> type, int count) {
        ArrayList<Object> result = new ArrayList<Object>(Collections.nCopies(count, null));
        for (int i = count - 1; i >= 0; --i) {
            result.set(i, type.cast(this.stack.pop()));
        }
        return result;
    }

    private void report(Marker marker) {
        this.markers.add(marker);
    }

    @Override
    public void exitFile(ScenarioParser.FileContext ctx) {
        List<Scenario> scenarios = this.pop(Scenario.class, ctx.scenario().size());
        LinkedHashMap<String, Scenario> scenarioMap = new LinkedHashMap<String, Scenario>();
        this.file = ScenarioFile.of(null, null, scenarioMap, null);
        this.file.setMarkers(this.markers);
        for (Scenario scenario : scenarios) {
            scenarioMap.put(scenario.getName(), scenario);
            scenario.setFile(this.file);
        }
    }

    @Override
    public void exitScenario(ScenarioParser.ScenarioContext ctx) {
        String name = ctx.header().HEADLINE_TEXT().getText().trim();
        List<Sentence> sentences = this.pop(Sentence.class, ctx.sentence().size());
        SentenceList body = SentenceList.of(sentences);
        Scenario scenario = Scenario.of(null, name, body, null);
        scenario.setPosition(ASTListener.position(ctx.header().HEADLINE_TEXT()));
        this.stack.push(scenario);
    }

    @Override
    public void exitSectionSentence(ScenarioParser.SectionSentenceContext ctx) {
        String text = ctx.HEADLINE_TEXT().getText().trim();
        SectionSentence sectionSentence = SectionSentence.of(text, CommentLevel.CODE_SECTION);
        sectionSentence.setPosition(ASTListener.position(ctx));
        this.stack.push(sectionSentence);
    }

    @Override
    public void exitCommentSentence(ScenarioParser.CommentSentenceContext ctx) {
        String text = ctx.HEADLINE_TEXT().getText().trim();
        SectionSentence sectionSentence = SectionSentence.of(text, CommentLevel.REGULAR);
        sectionSentence.setPosition(ASTListener.position(ctx));
        this.stack.push(sectionSentence);
    }

    @Override
    public void exitThereSentence(ScenarioParser.ThereSentenceContext ctx) {
        MultiDescriptor desc = (MultiDescriptor)this.pop();
        ThereSentence thereSentence = ThereSentence.of(desc);
        thereSentence.setPosition(ASTListener.position(ctx.THERE()));
        this.stack.push(thereSentence);
    }

    private List<NamedExpr> popAttributes(ScenarioParser.WithClausesContext withClauses) {
        int numAttributes = withClauses != null ? withClauses.withClause().size() : 0;
        return this.pop(NamedExpr.class, numAttributes);
    }

    private MultiDescriptor multiDescriptor(List<Name> names, ScenarioParser.WithClausesContext withClausesContext) {
        List<NamedExpr> attributes = this.popAttributes(withClausesContext);
        Type type = (Type)this.pop();
        return MultiDescriptor.of(type, names, attributes);
    }

    @Override
    public void exitSimpleDescriptor(ScenarioParser.SimpleDescriptorContext ctx) {
        List<Name> names;
        ScenarioParser.NameContext nameCtx = ctx.name();
        List<Name> list = names = nameCtx == null ? Collections.emptyList() : Collections.singletonList(Identifiers.name(nameCtx));
        if (nameCtx != null && ctx.THE() == null) {
            this.report(Marker.warning(ASTListener.position(ctx), "descriptor.indefinite.deprecated", ASTListener.inputText((ParseTree)ctx.typeName()), ASTListener.inputText((ParseTree)nameCtx)));
        }
        this.stack.push(this.multiDescriptor(names, ctx.withClauses()));
    }

    @Override
    public void exitMultiDescriptor(ScenarioParser.MultiDescriptorContext ctx) {
        List<Name> names = ctx.name().stream().map(Identifiers::name).collect(Collectors.toList());
        if (!names.isEmpty() && ctx.THE() == null) {
            this.report(Marker.warning(ASTListener.position(ctx), "descriptor.multi.indefinite.deprecated", ASTListener.inputText((ParseTree)ctx.typesName()), ASTListener.inputText(ctx.name())));
        }
        this.stack.push(this.multiDescriptor(names, ctx.withClauses()));
    }

    @Override
    public void exitExpectSentence(ScenarioParser.ExpectSentenceContext ctx) {
        List<Expr> exprs = this.pop(Expr.class, ctx.thatClauses().thatClause().size());
        ExpectSentence expectSentence = ExpectSentence.of(exprs);
        expectSentence.setPosition(ASTListener.position(ctx.EXPECT()));
        this.stack.push(expectSentence);
    }

    @Override
    public void exitDiagramSentence(ScenarioParser.DiagramSentenceContext ctx) {
        Expr object = (Expr)this.pop();
        String fileName = ctx.fileName.getText();
        DiagramSentence diagramSentence = DiagramSentence.of(object, fileName);
        diagramSentence.setPosition(ASTListener.position(ctx));
        this.stack.push(diagramSentence);
    }

    @Override
    public void exitHasSentence(ScenarioParser.HasSentenceContext ctx) {
        List<NamedExpr> clauses = this.pop(NamedExpr.class, ctx.hasClauses().hasClause().size());
        Expr object = (Expr)this.pop();
        HasSentence hasSentence = HasSentence.of(object, clauses);
        hasSentence.setPosition(ASTListener.position(ctx.hasClauses().hasClause((int)0).verb));
        this.stack.push(hasSentence);
    }

    @Override
    public void exitIsSentence(ScenarioParser.IsSentenceContext ctx) {
        List<NamedExpr> attributes = this.popAttributes(ctx.withClauses());
        Type type = (Type)this.pop();
        CreationExpr ctor = CreationExpr.of(type, attributes);
        ctor.setPosition(type.getPosition());
        String name = Identifiers.varName(ctx.name());
        VarDecl varDecl = VarDecl.of(name, null, ctor);
        varDecl.setPosition(ASTListener.position(ctx.name()));
        IsSentence isSentence = IsSentence.of(varDecl);
        isSentence.setPosition(ASTListener.position(ctx.IS()));
        this.stack.push(isSentence);
    }

    @Override
    public void exitAreSentence(ScenarioParser.AreSentenceContext ctx) {
        List<Name> names = ctx.name().stream().map(Identifiers::name).collect(Collectors.toList());
        MultiDescriptor descriptor = this.multiDescriptor(names, ctx.withClauses());
        AreSentence areSentence = AreSentence.of(descriptor);
        areSentence.setPosition(ASTListener.position(ctx.ARE()));
        this.stack.push(areSentence);
    }

    @Override
    public void exitCreateSentence(ScenarioParser.CreateSentenceContext ctx) {
        Name actor = Identifiers.name(ctx.actor().name());
        MultiDescriptor desc = (MultiDescriptor)this.pop();
        CreateSentence createSentence = CreateSentence.of(actor, desc);
        createSentence.setPosition(ASTListener.position(ctx.verb));
        this.stack.push(createSentence);
    }

    @Override
    public void exitCallSentence(ScenarioParser.CallSentenceContext ctx) {
        Name actor = Identifiers.name(ctx.actor().name());
        Name name = Identifiers.name(ctx.name());
        List<NamedExpr> args = this.pop(NamedExpr.class, ctx.withClauses() != null ? ctx.withClauses().withClause().size() : 0);
        Expr receiver = ctx.ON() != null ? (Expr)this.pop() : null;
        SentenceList body = SentenceList.of(new ArrayList<Sentence>());
        CallExpr callExpr = CallExpr.of(name, receiver, args, body);
        callExpr.setPosition(ASTListener.position(ctx.name()));
        CallSentence callSentence = CallSentence.of(actor, callExpr);
        callSentence.setPosition(ASTListener.position(ctx.verb));
        this.stack.push(callSentence);
    }

    @Override
    public void exitAnswerSentence(ScenarioParser.AnswerSentenceContext ctx) {
        Name actor = Identifiers.name(ctx.actor().name());
        Expr result = (Expr)this.pop();
        String varName = Identifiers.varName(ctx.name());
        AnswerSentence answerSentence = AnswerSentence.of(actor, result, varName);
        answerSentence.setPosition(ASTListener.position(ctx.verb));
        this.stack.push(answerSentence);
    }

    @Override
    public void exitWriteSentence(ScenarioParser.WriteSentenceContext ctx) {
        Expr target = (Expr)this.pop();
        Expr source = (Expr)this.pop();
        Name actor = Identifiers.name(ctx.actor().name());
        WriteSentence writeSentence = WriteSentence.of(actor, source, target);
        writeSentence.setPosition(ASTListener.position(ctx.verb));
        this.stack.push(writeSentence);
    }

    @Override
    public void exitAddSentence(ScenarioParser.AddSentenceContext ctx) {
        Expr target = (Expr)this.pop();
        Expr source = (Expr)this.pop();
        Name actor = Identifiers.name(ctx.actor().name());
        AddSentence addSentence = AddSentence.of(actor, source, target);
        addSentence.setPosition(ASTListener.position(ctx.verb));
        this.stack.push(addSentence);
    }

    @Override
    public void exitRemoveSentence(ScenarioParser.RemoveSentenceContext ctx) {
        Expr target = (Expr)this.pop();
        Expr source = (Expr)this.pop();
        Name actor = Identifiers.name(ctx.actor().name());
        RemoveSentence removeSentence = RemoveSentence.of(actor, source, target);
        removeSentence.setPosition(ASTListener.position(ctx.verb));
        this.stack.push(removeSentence);
    }

    @Override
    public void exitSimpleSentences(ScenarioParser.SimpleSentencesContext ctx) {
        int count = ctx.simpleSentence().size() + (ctx.compoundSentence() != null ? 1 : 0);
        List<Sentence> sentences = this.pop(Sentence.class, count);
        SentenceList list = SentenceList.of(sentences);
        this.stack.push(list);
    }

    @Override
    public void exitConditionalSentence(ScenarioParser.ConditionalSentenceContext ctx) {
        SentenceList body = (SentenceList)this.pop();
        Expr condition = (Expr)this.pop();
        ConditionalSentence sentence = ConditionalSentence.of(condition, body);
        sentence.setPosition(ASTListener.position(ctx.AS()));
        this.stack.push(sentence);
    }

    @Override
    public void exitTakeSentence(ScenarioParser.TakeSentenceContext ctx) {
        Name varName;
        Expr example;
        Sentence body = (Sentence)this.pop();
        Expr collection = (Expr)this.pop();
        Expr expr = example = ctx.example != null ? (Expr)this.pop() : null;
        if (ctx.simpleVarName != null) {
            varName = Identifiers.name(ctx.simpleVarName);
            this.report(Marker.warning(ASTListener.position(ctx.simpleVarName), "take.syntax.deprecated", ASTListener.inputText((ParseTree)ctx.simpleVarName), ASTListener.inputText((ParseTree)ctx.example)));
        } else {
            varName = Identifiers.name(ctx.name());
        }
        Name actor = Identifiers.name(ctx.actor().name());
        TakeSentence takeSentence = TakeSentence.of(actor, varName, example, collection, body);
        takeSentence.setPosition(ASTListener.position(ctx.verb));
        this.stack.push(takeSentence);
    }

    @Override
    public void exitNamedSimple(ScenarioParser.NamedSimpleContext ctx) {
        Name name = Identifiers.name(ctx.simpleName());
        Expr expr = (Expr)this.pop();
        this.stack.push(NamedExpr.of(name, expr));
    }

    @Override
    public void exitNamedNumber(ScenarioParser.NamedNumberContext ctx) {
        Name name = Identifiers.name(ctx.name());
        Expr expr = (Expr)this.pop();
        this.stack.push(NamedExpr.of(name, expr));
    }

    @Override
    public void exitBidiNamedExpr(ScenarioParser.BidiNamedExprContext ctx) {
        Expr expr = (Expr)this.pop();
        Name name = Identifiers.name(ctx.firstName);
        NamedExpr namedExpr = NamedExpr.of(name, expr);
        namedExpr.setOtherName(Identifiers.name(ctx.otherName));
        namedExpr.setOtherMany(ctx.ONE() != null);
        this.stack.push(namedExpr);
    }

    @Override
    public void exitTypeName(ScenarioParser.TypeNameContext ctx) {
        UnresolvedType type;
        if (ctx.CARD() != null) {
            ScenarioParser.NameContext name = ctx.name();
            type = ASTListener.unresolvedType(ASTListener.position(name), Identifiers.joinCaps(name));
        } else {
            ScenarioParser.SimpleNameContext simpleName = ctx.simpleName();
            type = ASTListener.unresolvedType(ASTListener.position(simpleName), Identifiers.joinCaps(simpleName));
        }
        this.stack.push(type);
    }

    @Override
    public void exitTypesName(ScenarioParser.TypesNameContext ctx) {
        UnresolvedType type;
        if (ctx.CARDS() != null) {
            ScenarioParser.NameContext name = ctx.name();
            type = ASTListener.unresolvedType(ASTListener.position(name), Identifiers.joinCaps(name));
        } else {
            ScenarioParser.SimpleNameContext simpleName = ctx.simpleName();
            type = ASTListener.unresolvedTypePlural(ASTListener.position(simpleName), Identifiers.joinCaps(simpleName));
        }
        this.stack.push(type);
    }

    private static UnresolvedType unresolvedTypePlural(Position position, String caps) {
        String typeName = caps.endsWith("s") ? caps.substring(0, caps.length() - 1) : caps;
        return ASTListener.unresolvedType(position, typeName);
    }

    private static UnresolvedType unresolvedType(Position position, String typeName) {
        UnresolvedType type = UnresolvedType.of(typeName);
        type.setPosition(position);
        return type;
    }

    @Override
    public void exitNumber(ScenarioParser.NumberContext ctx) {
        TerminalNode decimal = ctx.DECIMAL();
        if (decimal != null) {
            double value = Double.parseDouble(decimal.getText());
            DoubleLiteral doubleLiteral = DoubleLiteral.of(value);
            doubleLiteral.setPosition(ASTListener.position(decimal));
            this.stack.push(doubleLiteral);
        } else {
            int value = Integer.parseInt(ctx.INTEGER().getText());
            IntLiteral intLiteral = IntLiteral.of(value);
            intLiteral.setPosition(ASTListener.position(ctx.INTEGER()));
            this.stack.push(intLiteral);
        }
    }

    @Override
    public void exitStringLiteral(ScenarioParser.StringLiteralContext ctx) {
        String text = ctx.STRING_LITERAL().getText();
        String stripped = text.substring(1, text.length() - 1);
        String value = StringEscapeUtils.unescapeJava((String)stripped);
        StringLiteral stringLiteral = StringLiteral.of(value);
        stringLiteral.setPosition(ASTListener.position(ctx.STRING_LITERAL()));
        this.stack.push(stringLiteral);
    }

    @Override
    public void exitAnswer(ScenarioParser.AnswerContext ctx) {
        AnswerLiteral answer = AnswerLiteral.of();
        answer.setPosition(ASTListener.position(ctx.ANSWER()));
        this.stack.push(answer);
    }

    @Override
    public void exitNameAccess(ScenarioParser.NameAccessContext ctx) {
        Name name = Identifiers.name(ctx.name());
        NameAccess nameAccess = NameAccess.of(name);
        nameAccess.setPosition(name.getPosition());
        this.stack.push(nameAccess);
    }

    @Override
    public void exitAttributeAccess(ScenarioParser.AttributeAccessContext ctx) {
        Name name = Identifiers.name(ctx.name());
        Expr receiver = (Expr)this.pop();
        AttributeAccess attributeAccess = AttributeAccess.of(name, receiver);
        attributeAccess.setPosition(ASTListener.position(ctx.OF()));
        this.stack.push(attributeAccess);
    }

    @Override
    public void exitExampleAccess(ScenarioParser.ExampleAccessContext ctx) {
        Expr expr = (Expr)this.pop();
        Expr value = (Expr)this.pop();
        ExampleAccess exampleAccess = ExampleAccess.of(value, expr);
        exampleAccess.setPosition(ASTListener.position(ctx.FROM()));
        this.stack.push(exampleAccess);
    }

    @Override
    public void exitFilterExpr(ScenarioParser.FilterExprContext ctx) {
        Expr predicate = (Expr)this.pop();
        Expr source = (Expr)this.pop();
        FilterExpr filterExpr = FilterExpr.of(source, predicate);
        filterExpr.setPosition(ASTListener.position(ctx.ALL()));
        this.stack.push(filterExpr);
    }

    @Override
    public void exitAttrCheck(ScenarioParser.AttrCheckContext ctx) {
        NamedExpr valueAndAttribute = (NamedExpr)this.pop();
        Expr value = valueAndAttribute.getExpr();
        Name attribute = valueAndAttribute.getName();
        Expr receiver = ctx.access() != null ? (Expr)this.pop() : null;
        AttributeCheckExpr attributeCheckExpr = AttributeCheckExpr.of(receiver, attribute, value);
        attributeCheckExpr.setPosition(ASTListener.position(ctx.HAS()));
        this.stack.push(attributeCheckExpr);
    }

    @Override
    public void exitAndCondExpr(ScenarioParser.AndCondExprContext ctx) {
        List<TerminalNode> ands = ctx.AND();
        for (int i = ands.size() - 1; i >= 0; --i) {
            Expr rhs = (Expr)this.pop();
            Expr lhs = (Expr)this.pop();
            ConditionalOperatorExpr condOp = ConditionalOperatorExpr.of(lhs, ConditionalOperator.AND, rhs);
            condOp.setPosition(ASTListener.position(ands.get(i)));
            this.stack.push(condOp);
        }
    }

    @Override
    public void exitOrCondExpr(ScenarioParser.OrCondExprContext ctx) {
        List<TerminalNode> ors = ctx.OR();
        for (int i = ors.size() - 1; i >= 0; --i) {
            Expr rhs = (Expr)this.pop();
            Expr lhs = (Expr)this.pop();
            ConditionalOperatorExpr condOp = ConditionalOperatorExpr.of(lhs, ConditionalOperator.OR, rhs);
            condOp.setPosition(ASTListener.position(ors.get(i)));
            this.stack.push(condOp);
        }
    }

    @Override
    public void exitCondOpExpr(ScenarioParser.CondOpExprContext ctx) {
        Expr rhs = (Expr)this.pop();
        Expr lhs = ctx.lhs != null ? (Expr)this.pop() : null;
        String opText = ASTListener.inputText((ParseTree)ctx.condOp());
        ConditionalOperator op = ConditionalOperator.getByOp(opText);
        if (op == null) {
            throw new UnsupportedOperationException("no ConditionalOperator constant for '" + opText + "'");
        }
        ConditionalOperatorExpr operatorExpr = ConditionalOperatorExpr.of(lhs, op, rhs);
        operatorExpr.setPosition(ASTListener.position(ctx.condOp()));
        this.stack.push(operatorExpr);
    }

    @Override
    public void exitPredOpExpr(ScenarioParser.PredOpExprContext ctx) {
        Expr lhs = ctx.lhs != null ? (Expr)this.pop() : null;
        String opText = ASTListener.inputText((ParseTree)ctx.predOp());
        PredicateOperator op = PredicateOperator.nameMap.get(opText);
        if (op == null) {
            throw new UnsupportedOperationException("no PredicateOperator constant for '" + opText + "'");
        }
        PredicateOperatorExpr expr = PredicateOperatorExpr.of(lhs, op);
        expr.setPosition(ASTListener.position(ctx.predOp()));
        this.stack.push(expr);
    }

    @Override
    public void exitList(ScenarioParser.ListContext ctx) {
        List<Expr> elements = this.pop(Expr.class, ctx.listElem().size());
        ListExpr listExpr = ListExpr.of(elements);
        listExpr.setPosition(ASTListener.position(ctx));
        this.stack.push(listExpr);
    }

    @Override
    public void exitRange(ScenarioParser.RangeContext ctx) {
        Expr end = (Expr)this.pop();
        Expr start = (Expr)this.pop();
        RangeExpr rangeExpr = RangeExpr.of(start, end);
        rangeExpr.setPosition(ASTListener.position(ctx.TO()));
        this.stack.push(rangeExpr);
    }

    static Position position(Token token) {
        return new Position(token.getInputStream().getSourceName(), token.getStartIndex(), token.getStopIndex(), token.getLine(), token.getCharPositionInLine());
    }

    static Position position(TerminalNode terminal) {
        return ASTListener.position(terminal.getSymbol());
    }

    static Position position(ParserRuleContext ctx) {
        Token start = ctx.getStart();
        return new Position(start.getInputStream().getSourceName(), start.getStartIndex(), ctx.getStop().getStopIndex(), start.getLine(), start.getCharPositionInLine());
    }

    static String rawInputText(ParserRuleContext ctx) {
        CharStream inputStream = ctx.getStart().getInputStream();
        Interval interval = Interval.of((int)ctx.getStart().getStartIndex(), (int)ctx.getStop().getStopIndex());
        return inputStream.getText(interval);
    }

    static String inputText(ParseTree tree) {
        StringJoiner joiner = new StringJoiner(" ");
        ASTListener.inputText(tree, joiner);
        return joiner.toString();
    }

    static String inputText(Iterable<? extends ParseTree> trees) {
        StringJoiner joiner = new StringJoiner(" ");
        ASTListener.inputText(trees, joiner);
        return joiner.toString();
    }

    private static void inputText(Iterable<? extends ParseTree> trees, StringJoiner joiner) {
        for (ParseTree parseTree : trees) {
            ASTListener.inputText(parseTree, joiner);
        }
    }

    private static void inputText(ParseTree tree, StringJoiner joiner) {
        if (tree instanceof TerminalNode) {
            joiner.add(tree.getText());
        }
        for (int i = 0; i < tree.getChildCount(); ++i) {
            ParseTree child = tree.getChild(i);
            ASTListener.inputText(child, joiner);
        }
    }
}

