/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.visitor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.fulib.scenarios.ast.NamedExpr;
import org.fulib.scenarios.ast.decl.UnresolvedName;
import org.fulib.scenarios.ast.expr.ErrorExpr;
import org.fulib.scenarios.ast.expr.Expr;
import org.fulib.scenarios.ast.expr.access.ExampleAccess;
import org.fulib.scenarios.ast.expr.call.CallExpr;
import org.fulib.scenarios.ast.expr.collection.ListExpr;
import org.fulib.scenarios.ast.expr.collection.RangeExpr;
import org.fulib.scenarios.ast.expr.primary.DoubleLiteral;
import org.fulib.scenarios.ast.expr.primary.IntLiteral;
import org.fulib.scenarios.ast.expr.primary.NameAccess;
import org.fulib.scenarios.ast.expr.primary.StringLiteral;
import org.fulib.scenarios.ast.scope.Scope;
import org.fulib.scenarios.ast.sentence.AnswerSentence;
import org.fulib.scenarios.ast.sentence.SentenceList;
import org.fulib.scenarios.ast.type.ListType;
import org.fulib.scenarios.ast.type.PrimitiveType;
import org.fulib.scenarios.ast.type.Type;
import org.fulib.scenarios.diagnostic.Marker;
import org.fulib.scenarios.visitor.Namer;
import org.fulib.scenarios.visitor.TypeComparer;
import org.fulib.scenarios.visitor.resolve.SentenceResolver;

public enum TypeConversion implements Expr.Visitor<Type, Expr>
{
    INSTANCE;


    public static boolean isConvertible(Type from, Type to) {
        if (TypeComparer.isSuperType(to, from)) {
            return true;
        }
        if (to == PrimitiveType.STRING) {
            return true;
        }
        if (from == PrimitiveType.STRING && to instanceof PrimitiveType) {
            return PrimitiveType.isPrimitiveOrWrapperValue(to);
        }
        return from == PrimitiveType.primitiveToWrapper(to) || to == PrimitiveType.primitiveToWrapper(from);
    }

    public static Expr convert(Expr expr, Type to) {
        return expr.accept(INSTANCE, to);
    }

    public static Expr convert(Expr expr, Type to, Scope scope, String code) {
        Expr converted = TypeConversion.convert(expr, to);
        if (converted != null) {
            return converted;
        }
        Marker error = Marker.error(expr.getPosition(), code, expr.getType().getDescription(), to.getDescription());
        SentenceResolver.addStringLiteralTypoNotes(scope, expr, error);
        scope.report(error);
        return expr;
    }

    private static Expr staticCall(Type type, String method, Expr arg, Type returnType) {
        NameAccess receiver = NameAccess.of(UnresolvedName.of(type.accept(Namer.INSTANCE, null), null));
        return TypeConversion.methodCall(receiver, method, arg, returnType);
    }

    private static Expr methodCall(Expr receiver, String method, Expr arg, Type returnType) {
        UnresolvedName name = UnresolvedName.of(method, null);
        List<NamedExpr> args = Collections.singletonList(NamedExpr.of(null, arg));
        SentenceList body = SentenceList.of(Collections.singletonList(AnswerSentence.of(null, ErrorExpr.of(returnType), null)));
        return CallExpr.of(name, receiver, args, body);
    }

    @Override
    public Expr visit(Expr expr, Type to) {
        Type from = expr.getType();
        if (TypeComparer.isSuperType(to, from)) {
            return expr;
        }
        if (to == PrimitiveType.STRING) {
            return TypeConversion.staticCall(PrimitiveType.STRING, "valueOf", expr, PrimitiveType.STRING);
        }
        if (from == PrimitiveType.STRING && to instanceof PrimitiveType) {
            switch ((PrimitiveType)to) {
                case BOOLEAN: {
                    return TypeConversion.staticCall(PrimitiveType.BOOLEAN_WRAPPER, "parseBoolean", expr, PrimitiveType.BOOLEAN);
                }
                case BYTE: {
                    return TypeConversion.staticCall(PrimitiveType.BYTE_WRAPPER, "parseByte", expr, PrimitiveType.BYTE);
                }
                case SHORT: {
                    return TypeConversion.staticCall(PrimitiveType.SHORT_WRAPPER, "parseShort", expr, PrimitiveType.SHORT);
                }
                case INT: {
                    return TypeConversion.staticCall(PrimitiveType.INT_WRAPPER, "parseInt", expr, PrimitiveType.INT);
                }
                case LONG: {
                    return TypeConversion.staticCall(PrimitiveType.LONG_WRAPPER, "parseLong", expr, PrimitiveType.LONG);
                }
                case FLOAT: {
                    return TypeConversion.staticCall(PrimitiveType.FLOAT_WRAPPER, "parseFloat", expr, PrimitiveType.FLOAT);
                }
                case DOUBLE: {
                    return TypeConversion.staticCall(PrimitiveType.DOUBLE_WRAPPER, "parseDouble", expr, PrimitiveType.DOUBLE);
                }
                case BOOLEAN_WRAPPER: 
                case BYTE_WRAPPER: 
                case SHORT_WRAPPER: 
                case INT_WRAPPER: 
                case LONG_WRAPPER: 
                case FLOAT_WRAPPER: 
                case DOUBLE_WRAPPER: {
                    return TypeConversion.staticCall(to, "valueOf", expr, to);
                }
                case CHAR: 
                case CHAR_WRAPPER: {
                    return TypeConversion.methodCall(expr, "charAt", IntLiteral.of(1), to);
                }
            }
        }
        if (from == PrimitiveType.primitiveToWrapper(to) || to == PrimitiveType.primitiveToWrapper(from)) {
            return expr;
        }
        return null;
    }

    @Override
    public Expr visit(ErrorExpr errorExpr, Type par) {
        errorExpr.setType(par);
        return errorExpr;
    }

    @Override
    public Expr visit(IntLiteral intLiteral, Type par) {
        if (!(par instanceof PrimitiveType)) {
            return null;
        }
        switch ((PrimitiveType)par) {
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case INT_WRAPPER: 
            case LONG_WRAPPER: 
            case FLOAT_WRAPPER: 
            case DOUBLE_WRAPPER: 
            case OBJECT: {
                return intLiteral;
            }
            case STRING: {
                return StringLiteral.of(Integer.toString(intLiteral.getValue()));
            }
        }
        return null;
    }

    @Override
    public Expr visit(DoubleLiteral doubleLiteral, Type par) {
        if (!(par instanceof PrimitiveType)) {
            return null;
        }
        switch ((PrimitiveType)par) {
            case DOUBLE: 
            case DOUBLE_WRAPPER: 
            case OBJECT: {
                return doubleLiteral;
            }
            case STRING: {
                return StringLiteral.of(Double.toString(doubleLiteral.getValue()));
            }
        }
        return null;
    }

    @Override
    public Expr visit(StringLiteral stringLiteral, Type par) {
        if (!(par instanceof PrimitiveType)) {
            return null;
        }
        switch ((PrimitiveType)par) {
            case OBJECT: 
            case STRING: {
                return stringLiteral;
            }
            case INT: 
            case INT_WRAPPER: {
                try {
                    return IntLiteral.of(Integer.parseInt(stringLiteral.getValue()));
                }
                catch (NumberFormatException ex) {
                    return null;
                }
            }
            case DOUBLE: 
            case DOUBLE_WRAPPER: {
                try {
                    return DoubleLiteral.of(Double.parseDouble(stringLiteral.getValue()));
                }
                catch (NumberFormatException ex) {
                    return null;
                }
            }
        }
        return null;
    }

    @Override
    public Expr visit(ExampleAccess exampleAccess, Type par) {
        Expr value = exampleAccess.getValue().accept(this, par);
        if (value == null) {
            return null;
        }
        exampleAccess.setValue(value);
        return exampleAccess;
    }

    @Override
    public Expr visit(ListExpr listExpr, Type par) {
        if (par == PrimitiveType.OBJECT) {
            return listExpr;
        }
        if (par == PrimitiveType.STRING) {
            return TypeConversion.staticCall(PrimitiveType.STRING, "valueOf", listExpr, PrimitiveType.STRING);
        }
        if (!(par instanceof ListType)) {
            return null;
        }
        Type elementType = ((ListType)par).getElementType();
        List<Expr> oldElements = listExpr.getElements();
        ArrayList<Expr> newElements = new ArrayList<Expr>(oldElements.size());
        for (Expr oldElement : oldElements) {
            Expr newElement = oldElement.accept(this, elementType);
            if (newElement == null) {
                return null;
            }
            newElements.add(newElement);
        }
        listExpr.setElements(newElements);
        return listExpr;
    }

    @Override
    public Expr visit(RangeExpr rangeExpr, Type par) {
        if (par == PrimitiveType.OBJECT) {
            return rangeExpr;
        }
        if (par == PrimitiveType.STRING) {
            return TypeConversion.staticCall(PrimitiveType.STRING, "valueOf", rangeExpr, PrimitiveType.STRING);
        }
        if (!(par instanceof ListType)) {
            return null;
        }
        Type elementType = ((ListType)par).getElementType();
        Expr start = rangeExpr.getStart().accept(this, elementType);
        if (start == null) {
            return null;
        }
        Expr end = rangeExpr.getEnd().accept(this, elementType);
        if (end == null) {
            return null;
        }
        rangeExpr.setStart(start);
        rangeExpr.setEnd(end);
        return rangeExpr;
    }
}

