/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.visitor.codegen;

import java.util.List;
import org.apache.commons.text.StringEscapeUtils;
import org.fulib.builder.ClassModelDecorator;
import org.fulib.builder.ClassModelManager;
import org.fulib.classmodel.Clazz;
import org.fulib.scenarios.ast.Scenario;
import org.fulib.scenarios.ast.ScenarioGroup;
import org.fulib.scenarios.tool.Config;

class CodeGenDTO {
    private static final String INDENT = "   ";
    Config config;
    List<Class<? extends ClassModelDecorator>> decoratorClasses;
    ScenarioGroup group;
    Scenario scenario;
    ClassModelManager modelManager;
    Clazz clazz;
    StringBuilder bodyBuilder;
    int indentLevel = 2;

    CodeGenDTO() {
    }

    void emit(String code) {
        this.bodyBuilder.append(code);
    }

    void emitLine(String line) {
        this.emitIndent();
        this.emit(line);
        this.bodyBuilder.append('\n');
    }

    void emitStringLiteral(String text) {
        this.bodyBuilder.append('\"').append(StringEscapeUtils.escapeJava((String)text)).append('\"');
    }

    void emitIndent() {
        for (int i = 0; i < this.indentLevel; ++i) {
            this.bodyBuilder.append(INDENT);
        }
    }

    void addImport(String s) {
        this.clazz.getImportList().add("import " + s + ";");
    }
}

