/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.visitor.resolve;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.fulib.scenarios.ast.decl.Decl;
import org.fulib.scenarios.ast.decl.Name;
import org.fulib.scenarios.ast.decl.ResolvedName;
import org.fulib.scenarios.ast.decl.VarDecl;
import org.fulib.scenarios.ast.expr.Expr;
import org.fulib.scenarios.ast.expr.conditional.ConditionalOperator;
import org.fulib.scenarios.ast.expr.conditional.ConditionalOperatorExpr;
import org.fulib.scenarios.ast.expr.primary.NameAccess;
import org.fulib.scenarios.ast.pattern.AndConstraint;
import org.fulib.scenarios.ast.pattern.AttributeConditionalConstraint;
import org.fulib.scenarios.ast.pattern.AttributeConstraint;
import org.fulib.scenarios.ast.pattern.AttributeEqualityConstraint;
import org.fulib.scenarios.ast.pattern.AttributePredicateConstraint;
import org.fulib.scenarios.ast.pattern.Constraint;
import org.fulib.scenarios.ast.pattern.LinkConstraint;
import org.fulib.scenarios.ast.pattern.MatchConstraint;
import org.fulib.scenarios.ast.pattern.Pattern;
import org.fulib.scenarios.ast.scope.PatternReferenceCollectingScope;
import org.fulib.scenarios.ast.scope.Scope;
import org.fulib.scenarios.ast.type.PrimitiveType;
import org.fulib.scenarios.ast.type.Type;
import org.fulib.scenarios.diagnostic.Marker;
import org.fulib.scenarios.diagnostic.Position;
import org.fulib.scenarios.visitor.resolve.ExprResolver;
import org.fulib.scenarios.visitor.resolve.NameResolver;

public class ConstraintResolver
implements Constraint.Visitor<Scope, Constraint> {
    private int uniqueIndex;

    @Override
    public Constraint visit(AndConstraint andConstraint, Scope par) {
        andConstraint.getConstraints().replaceAll(c -> {
            c.setOwner(andConstraint.getOwner());
            return c.accept(this, par);
        });
        if (andConstraint.getConstraints().size() == 1) {
            return andConstraint.getConstraints().get(0);
        }
        return andConstraint;
    }

    @Override
    public Constraint visit(LinkConstraint linkConstraint, Scope par) {
        Name target = linkConstraint.getTarget();
        Name resolvedTarget = target.accept(NameResolver.INSTANCE, par);
        linkConstraint.setTarget(resolvedTarget);
        Decl decl = resolvedTarget.getDecl();
        if (decl == null) {
            par.report(Marker.error(target.getPosition(), "link-constraint.target.unresolved", target.getValue()));
        } else if (!(decl instanceof VarDecl) || ((VarDecl)decl).getPattern() == null) {
            par.report(Marker.error(target.getPosition(), "link-constraint.target.not.pattern-object", target.getValue()));
        }
        return linkConstraint;
    }

    @Override
    public Constraint visit(AttributeConstraint attributeConstraint, Scope par) {
        if (attributeConstraint.getPattern() == null) {
            this.makePattern(attributeConstraint, PrimitiveType.OBJECT);
        }
        return attributeConstraint;
    }

    private void makePattern(AttributeConstraint ac, Type type) {
        Pattern owner = ac.getOwner();
        Name attribute = ac.getAttribute();
        String attributeName = attribute == null ? "Attr" + ++this.uniqueIndex : attribute.getValue();
        VarDecl varDecl = VarDecl.of(owner.getName().getValue() + attributeName, type, null);
        Pattern pattern = Pattern.of(type, ResolvedName.of(varDecl), Collections.emptyList());
        ac.setPattern(pattern);
    }

    static Pattern getPatternIfRef(Expr expr) {
        if (!(expr instanceof NameAccess)) {
            return null;
        }
        NameAccess access = (NameAccess)expr;
        Name targetName = access.getName();
        Decl decl = targetName.getDecl();
        if (!(decl instanceof VarDecl)) {
            return null;
        }
        VarDecl varDecl = (VarDecl)decl;
        return varDecl.getPattern();
    }

    @Override
    public Constraint visit(AttributeEqualityConstraint aec, Scope par) {
        Expr expr = aec.getExpr().accept(ExprResolver.INSTANCE, par);
        Pattern target = ConstraintResolver.getPatternIfRef(expr);
        if (target != null) {
            LinkConstraint lc = LinkConstraint.of(aec.getAttribute(), target.getName());
            lc.setOwner(aec.getOwner());
            lc.setPosition(aec.getPosition());
            return lc.accept(this, par);
        }
        aec.setExpr(expr);
        this.makePattern(aec, expr.getType());
        return aec;
    }

    @Override
    public Constraint visit(AttributePredicateConstraint attributePredicateConstraint, Scope par) {
        return attributePredicateConstraint;
    }

    @Override
    public Constraint visit(AttributeConditionalConstraint acc, Scope par) {
        Type lhsType;
        Pattern owner = acc.getOwner();
        Position position = acc.getPosition();
        Name attribute = acc.getAttribute();
        Expr rhs = acc.getRhs();
        ConditionalOperator operator = acc.getOperator();
        switch (operator) {
            case NOT_CONTAINS: {
                par.report(Marker.error(acc.getPosition(), "attribute-constraint.conditional.not-contains", new Object[0]));
                break;
            }
            case CONTAINS: 
            case IS: {
                AttributeEqualityConstraint aec = AttributeEqualityConstraint.of(attribute, rhs);
                aec.setOwner(owner);
                aec.setPosition(position);
                return aec.accept(this, par);
            }
        }
        HashSet<Pattern> patterns = new HashSet<Pattern>();
        PatternReferenceCollectingScope scope = new PatternReferenceCollectingScope(par, patterns);
        Expr resolvedRhs = rhs.accept(ExprResolver.INSTANCE, scope);
        Type nullableLhsType = operator.getLhsType();
        Type type = lhsType = nullableLhsType != null ? nullableLhsType : PrimitiveType.OBJECT;
        if (patterns.isEmpty()) {
            acc.setRhs(resolvedRhs);
            this.makePattern(acc, lhsType);
            return acc;
        }
        AttributeConstraint ac = AttributeConstraint.of(attribute);
        ac.setOwner(owner);
        ac.setPosition(position);
        this.makePattern(ac, lhsType);
        NameAccess lhs = NameAccess.of(ac.getPattern().getName());
        lhs.setPosition(position);
        Expr condExpr = ConditionalOperatorExpr.of(lhs, operator, resolvedRhs).accept(ExprResolver.INSTANCE, par);
        condExpr.setPosition(position);
        MatchConstraint matchConstraint = MatchConstraint.of(condExpr, ConstraintResolver.prepend(ac.getPattern(), patterns));
        matchConstraint.setOwner(owner);
        matchConstraint.setPosition(position);
        AndConstraint andConstraint = AndConstraint.of(Arrays.asList(ac, matchConstraint));
        andConstraint.setOwner(owner);
        andConstraint.setPosition(position);
        return andConstraint;
    }

    private static List<Pattern> prepend(Pattern pattern, Collection<Pattern> patterns) {
        ArrayList<Pattern> result = new ArrayList<Pattern>(1 + patterns.size());
        result.add(pattern);
        result.addAll(patterns);
        return result;
    }

    @Override
    public Constraint visit(MatchConstraint matchConstraint, Scope par) {
        HashSet<Pattern> patterns = new HashSet<Pattern>();
        PatternReferenceCollectingScope scope = new PatternReferenceCollectingScope(par, patterns);
        matchConstraint.setExpr(matchConstraint.getExpr().accept(ExprResolver.INSTANCE, scope));
        matchConstraint.getPatterns().addAll(patterns);
        return matchConstraint;
    }
}

