/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.ast;

import org.fulib.scenarios.ast.Node;
import org.fulib.scenarios.ast.Positioned;
import org.fulib.scenarios.ast.ScenarioFile;
import org.fulib.scenarios.ast.decl.MethodDecl;
import org.fulib.scenarios.ast.sentence.SentenceList;

public interface Scenario
extends Positioned {
    public static Scenario of(ScenarioFile file, String name, SentenceList body, MethodDecl methodDecl) {
        return new Impl(file, name, body, methodDecl);
    }

    public ScenarioFile getFile();

    public void setFile(ScenarioFile var1);

    public String getName();

    public void setName(String var1);

    public SentenceList getBody();

    public void setBody(SentenceList var1);

    public MethodDecl getMethodDecl();

    public void setMethodDecl(MethodDecl var1);

    default public <P, R> R accept(Visitor<P, R> visitor, P par) {
        return visitor.visit(this, par);
    }

    @Override
    default public <P, R> R accept(Positioned.Visitor<P, R> visitor, P par) {
        return visitor.visit(this, par);
    }

    @Override
    default public <P, R> R accept(Node.Visitor<P, R> visitor, P par) {
        return visitor.visit(this, par);
    }

    public static interface Visitor<P, R> {
        default public R visit(Scenario scenario, P par) {
            throw new UnsupportedOperationException(this.getClass().getName() + ".visit(" + scenario.getClass().getName() + ")");
        }
    }

    public static class Impl
    extends Positioned.Impl
    implements Scenario {
        private ScenarioFile file;
        private String name;
        private SentenceList body;
        private MethodDecl methodDecl;

        public Impl() {
        }

        public Impl(ScenarioFile file, String name, SentenceList body, MethodDecl methodDecl) {
            this.file = file;
            this.name = name;
            this.body = body;
            this.methodDecl = methodDecl;
        }

        @Override
        public ScenarioFile getFile() {
            return this.file;
        }

        @Override
        public void setFile(ScenarioFile file) {
            this.file = file;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void setName(String name) {
            this.name = name;
        }

        @Override
        public SentenceList getBody() {
            return this.body;
        }

        @Override
        public void setBody(SentenceList body) {
            this.body = body;
        }

        @Override
        public MethodDecl getMethodDecl() {
            return this.methodDecl;
        }

        @Override
        public void setMethodDecl(MethodDecl methodDecl) {
            this.methodDecl = methodDecl;
        }
    }
}

