/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.ast.expr.conditional;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.fulib.scenarios.ast.type.PrimitiveType;
import org.fulib.scenarios.ast.type.Type;

public enum ConditionalOperator {
    OR("or", "or"),
    AND("and", "and"),
    IS("is", "are"),
    IS_NOT("is not", "are not"),
    IS_SAME("is the same as", "are the same as"),
    IS_NOT_SAME("is not the same as", "are not the same as"),
    LT("is less than", "are less than"),
    LE("is less equal", "are less equal"),
    NOT_LT("is not less than", "are not less than"),
    GT("is greater than", "are greater than"),
    GE("is greater equal", "are greater equal"),
    NOT_GT("is not greater than", "are not greater than"),
    CONTAINS("contains", "contain"),
    NOT_CONTAINS("does not contain", "do not contain"),
    MATCHES("matches", "match");

    public static final Map<String, ConditionalOperator> opMap;
    private final String singular;
    private final String plural;
    private Type lhsType;

    private ConditionalOperator(String singular, String plural) {
        this.singular = singular;
        this.plural = plural;
    }

    private static Map<String, ConditionalOperator> buildOpMap() {
        ConditionalOperator[] values = ConditionalOperator.values();
        HashMap<String, ConditionalOperator> map = new HashMap<String, ConditionalOperator>(values.length);
        for (ConditionalOperator operator : values) {
            map.put(operator.getSingular(), operator);
            String plural = operator.getPlural();
            if (plural == null) continue;
            map.put(plural, operator);
        }
        return Collections.unmodifiableMap(map);
    }

    public static ConditionalOperator getByOp(String op) {
        return opMap.get(op);
    }

    public String getSingular() {
        return this.singular;
    }

    public String getPlural() {
        return this.plural;
    }

    public Type getLhsType() {
        return this.lhsType;
    }

    static {
        opMap = ConditionalOperator.buildOpMap();
        ConditionalOperator.LT.lhsType = PrimitiveType.NUMBER;
        ConditionalOperator.LE.lhsType = PrimitiveType.NUMBER;
        ConditionalOperator.NOT_LT.lhsType = PrimitiveType.NUMBER;
        ConditionalOperator.GT.lhsType = PrimitiveType.NUMBER;
        ConditionalOperator.GE.lhsType = PrimitiveType.NUMBER;
        ConditionalOperator.NOT_GT.lhsType = PrimitiveType.NUMBER;
        ConditionalOperator.MATCHES.lhsType = PrimitiveType.STRING;
    }
}

