/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.visitor.codegen;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.fulib.FulibTools;
import org.fulib.Generator;
import org.fulib.TablesGenerator;
import org.fulib.builder.ClassModelDecorator;
import org.fulib.builder.ClassModelDecorators;
import org.fulib.builder.ClassModelManager;
import org.fulib.classmodel.ClassModel;
import org.fulib.classmodel.Clazz;
import org.fulib.classmodel.FMethod;
import org.fulib.scenarios.ast.CompilationContext;
import org.fulib.scenarios.ast.Scenario;
import org.fulib.scenarios.ast.ScenarioFile;
import org.fulib.scenarios.ast.ScenarioGroup;
import org.fulib.scenarios.ast.decl.ClassDecl;
import org.fulib.scenarios.ast.expr.collection.ListExpr;
import org.fulib.scenarios.ast.sentence.DiagramSentence;
import org.fulib.scenarios.ast.sentence.Sentence;
import org.fulib.scenarios.tool.Config;
import org.fulib.scenarios.visitor.codegen.CodeGenDTO;
import org.fulib.scenarios.visitor.codegen.DeclGenerator;
import org.fulib.scenarios.visitor.resolve.SymbolCollector;

public enum CodeGenerator implements CompilationContext.Visitor<Object, Object>,
ScenarioGroup.Visitor<CodeGenDTO, Object>,
ScenarioFile.Visitor<CodeGenDTO, Object>
{
    INSTANCE;


    @Override
    public Object visit(CompilationContext context, Object par) {
        Config config = context.getConfig();
        if (config.isDryRun()) {
            return null;
        }
        List<Class<? extends ClassModelDecorator>> decoratorClasses = CodeGenerator.resolveDecoratorClasses(config.getDecoratorClasses());
        context.getGroups().values().parallelStream().forEach(it -> {
            CodeGenDTO dto = new CodeGenDTO();
            dto.config = config;
            dto.decoratorClasses = decoratorClasses;
            it.accept(this, dto);
        });
        Set<String> otherPackageNames = this.getOtherPackageNames(context, decoratorClasses);
        for (String packageName : otherPackageNames) {
            ClassModelManager manager = new ClassModelManager().setPackageName(packageName).setMainJavaDir(config.getModelDir());
            CodeGenerator.decorate(manager, decoratorClasses);
            this.dumpClassDiagrams(manager, config);
            if (config.isGenerateTables()) {
                new TablesGenerator().generate(manager.getClassModel());
            }
            new Generator().generate(manager.getClassModel());
        }
        return null;
    }

    private Set<String> getOtherPackageNames(CompilationContext context, List<Class<? extends ClassModelDecorator>> decoratorClasses) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Class<? extends ClassModelDecorator> decoratorClass : decoratorClasses) {
            String packageName = decoratorClass.getPackage().getName();
            String packageDir = packageName.replace('.', '/');
            if (context.getGroups().containsKey(packageDir)) continue;
            result.add(packageName);
        }
        return result;
    }

    @Override
    public Object visit(ScenarioGroup scenarioGroup, CodeGenDTO par) {
        par.group = scenarioGroup;
        String modelDir = par.config.getModelDir();
        String testDir = par.config.getTestDir();
        String packageDir = scenarioGroup.getPackageDir();
        String packageName = packageDir.replace('/', '.');
        par.modelManager = new ClassModelManager().setPackageName(packageName).setMainJavaDir(modelDir);
        boolean modelClasses = this.populateModel(scenarioGroup, par);
        if (modelClasses) {
            this.dumpClassDiagrams(par.modelManager, par.config);
            if (par.config.isGenerateTables()) {
                new TablesGenerator().generate(par.modelManager.getClassModel());
            }
        }
        if (CodeGenerator.sameFile(modelDir, testDir)) {
            boolean testClasses = this.populateTests(scenarioGroup, par);
            if (modelClasses || testClasses) {
                new Generator().generate(par.modelManager.getClassModel());
            }
            return null;
        }
        if (modelClasses) {
            new Generator().generate(par.modelManager.getClassModel());
        }
        par.modelManager = new ClassModelManager().setPackageName(packageName).setMainJavaDir(testDir);
        boolean testClasses = this.populateTests(scenarioGroup, par);
        if (testClasses) {
            new Generator().generate(par.modelManager.getClassModel());
        }
        return null;
    }

    private boolean populateTests(ScenarioGroup scenarioGroup, CodeGenDTO par) {
        Map<String, ScenarioFile> files = scenarioGroup.getFiles();
        for (ScenarioFile file : files.values()) {
            file.accept(this, par);
        }
        return files.values().stream().anyMatch(f -> !f.getExternal());
    }

    private boolean populateModel(ScenarioGroup scenarioGroup, CodeGenDTO par) {
        Map<String, ClassDecl> classes = scenarioGroup.getClasses();
        for (ClassDecl classDecl : classes.values()) {
            classDecl.accept(DeclGenerator.INSTANCE, par);
        }
        boolean decorators = CodeGenerator.decorate(par.modelManager, par.decoratorClasses);
        return decorators || classes.values().stream().anyMatch(c -> !c.getExternal());
    }

    private void dumpClassDiagrams(ClassModelManager modelManager, Config config) {
        ClassModel classModel = modelManager.getClassModel();
        if (config.isClassDiagram()) {
            FulibTools.classDiagrams().dumpPng(classModel, classModel.getPackageSrcFolder() + "/classDiagram.png");
        }
        if (config.isClassDiagramSVG()) {
            FulibTools.classDiagrams().dumpSVG(classModel, classModel.getPackageSrcFolder() + "/classDiagram.svg");
        }
    }

    private static boolean sameFile(String modelDir, String testDir) {
        try {
            return Files.isSameFile(Paths.get(modelDir, new String[0]), Paths.get(testDir, new String[0]));
        }
        catch (IOException e) {
            File modelFile = new File(modelDir);
            File testFile = new File(testDir);
            try {
                return modelFile.getCanonicalPath().equals(testFile.getCanonicalPath());
            }
            catch (IOException e2) {
                return modelFile.getAbsolutePath().equals(testFile.getAbsolutePath());
            }
        }
    }

    private static boolean decorate(ClassModelManager manager, List<Class<? extends ClassModelDecorator>> decoratorClasses) {
        String packageName = manager.getClassModel().getPackageName();
        List<Class<? extends ClassModelDecorator>> filteredDecoratorClasses = CodeGenerator.getDecoratorClassesForPackage(packageName, decoratorClasses);
        if (filteredDecoratorClasses.isEmpty()) {
            return false;
        }
        Throwable failure = null;
        for (Class<? extends ClassModelDecorator> decoratorClass : filteredDecoratorClasses) {
            try {
                ClassModelDecorator decorator = decoratorClass.newInstance();
                decorator.decorate(manager);
            }
            catch (Exception e) {
                if (failure == null) {
                    failure = new RuntimeException("class model decoration failed");
                }
                failure.addSuppressed(e);
            }
        }
        if (failure != null) {
            throw failure;
        }
        return true;
    }

    private static List<Class<? extends ClassModelDecorator>> getDecoratorClassesForPackage(String packageName, List<Class<? extends ClassModelDecorator>> decoratorClasses) {
        ClassModelDecorators decorators;
        Package thePackage = Package.getPackage(packageName);
        if (thePackage != null && (decorators = thePackage.getAnnotation(ClassModelDecorators.class)) != null) {
            return Arrays.asList(decorators.value());
        }
        return decoratorClasses.stream().filter(c -> packageName.equals(c.getPackage().getName())).collect(Collectors.toList());
    }

    public static List<Class<? extends ClassModelDecorator>> resolveDecoratorClasses(Set<String> decoratorClassNames) {
        ArrayList<Class<? extends ClassModelDecorator>> result = new ArrayList<Class<? extends ClassModelDecorator>>();
        for (String decoratorClassName : decoratorClassNames) {
            Class<?> decoratorClass;
            try {
                decoratorClass = Class.forName(decoratorClassName);
            }
            catch (ClassNotFoundException ignored) {
                continue;
            }
            if (!ClassModelDecorator.class.isAssignableFrom(decoratorClass)) continue;
            result.add(decoratorClass);
        }
        return result;
    }

    @Override
    public Object visit(ScenarioFile scenarioFile, CodeGenDTO par) {
        if (scenarioFile.getExternal()) {
            return null;
        }
        par.clazz = par.modelManager.haveClass(scenarioFile.getClassDecl().getName());
        Iterator<Scenario> iterator = scenarioFile.getScenarios().iterator();
        while (iterator.hasNext()) {
            Scenario scenario;
            par.scenario = scenario = iterator.next();
            this.addDiagramSentences(scenario, par);
        }
        par.scenario = null;
        scenarioFile.getClassDecl().accept(DeclGenerator.INSTANCE, par);
        par.addImport("org.junit.Test");
        for (Scenario scenario : scenarioFile.getScenarios()) {
            String methodName = scenario.getMethodDecl().getName();
            CodeGenerator.getFMethod(par.clazz, methodName).setAnnotations("@Test");
        }
        return null;
    }

    private void addDiagramSentences(Scenario scenario, CodeGenDTO par) {
        DiagramSentence diagramSentence;
        if (!par.config.isObjectDiagram() && !par.config.isObjectDiagramSVG()) {
            return;
        }
        ListExpr listExpr = SymbolCollector.getRoots(scenario);
        if (listExpr == null) {
            return;
        }
        List<Sentence> sentences = scenario.getBody().getItems();
        String methodName = scenario.getMethodDecl().getName();
        if (par.config.isObjectDiagram()) {
            diagramSentence = DiagramSentence.of(listExpr, methodName + ".png");
            sentences.add(diagramSentence);
        }
        if (par.config.isObjectDiagramSVG()) {
            diagramSentence = DiagramSentence.of(listExpr, methodName + ".svg");
            sentences.add(diagramSentence);
        }
    }

    private static FMethod getFMethod(Clazz clazz, String name) {
        for (FMethod fMethod : clazz.getMethods()) {
            if (!name.equals(fMethod.getName())) continue;
            return fMethod;
        }
        throw new IllegalStateException("method " + clazz.getName() + "." + name + " not found");
    }
}

