/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.visitor.codegen;

import java.util.List;
import java.util.stream.Collectors;
import org.fulib.StrUtil;
import org.fulib.scenarios.ast.NamedExpr;
import org.fulib.scenarios.ast.decl.Decl;
import org.fulib.scenarios.ast.expr.Expr;
import org.fulib.scenarios.ast.expr.PlaceholderExpr;
import org.fulib.scenarios.ast.expr.access.AttributeAccess;
import org.fulib.scenarios.ast.expr.operator.BinaryOperator;
import org.fulib.scenarios.ast.pattern.Constraint;
import org.fulib.scenarios.ast.pattern.Pattern;
import org.fulib.scenarios.ast.sentence.AddSentence;
import org.fulib.scenarios.ast.sentence.AnswerSentence;
import org.fulib.scenarios.ast.sentence.AssignSentence;
import org.fulib.scenarios.ast.sentence.ConditionalSentence;
import org.fulib.scenarios.ast.sentence.DiagramSentence;
import org.fulib.scenarios.ast.sentence.ExpectSentence;
import org.fulib.scenarios.ast.sentence.ExprSentence;
import org.fulib.scenarios.ast.sentence.HasSentence;
import org.fulib.scenarios.ast.sentence.IsSentence;
import org.fulib.scenarios.ast.sentence.MatchSentence;
import org.fulib.scenarios.ast.sentence.RemoveSentence;
import org.fulib.scenarios.ast.sentence.SectionSentence;
import org.fulib.scenarios.ast.sentence.Sentence;
import org.fulib.scenarios.ast.sentence.SentenceList;
import org.fulib.scenarios.ast.sentence.TakeSentence;
import org.fulib.scenarios.ast.type.ListType;
import org.fulib.scenarios.ast.type.PrimitiveType;
import org.fulib.scenarios.ast.type.Type;
import org.fulib.scenarios.visitor.codegen.AssertionGenerator;
import org.fulib.scenarios.visitor.codegen.CodeGenDTO;
import org.fulib.scenarios.visitor.codegen.ConstraintGenerator;
import org.fulib.scenarios.visitor.codegen.DeclGenerator;
import org.fulib.scenarios.visitor.codegen.ExprGenerator;
import org.fulib.scenarios.visitor.codegen.TypeGenerator;

public enum SentenceGenerator implements Sentence.Visitor<CodeGenDTO, Object>
{
    INSTANCE;


    @Override
    public Object visit(Sentence sentence, CodeGenDTO par) {
        return null;
    }

    @Override
    public Object visit(SentenceList sentenceList, CodeGenDTO par) {
        for (Sentence item : sentenceList.getItems()) {
            item.accept(this, par);
        }
        return null;
    }

    @Override
    public Object visit(SectionSentence sectionSentence, CodeGenDTO par) {
        par.emitIndent();
        par.bodyBuilder.append(sectionSentence.getLevel().format(sectionSentence.getText().trim()));
        par.bodyBuilder.append('\n');
        return null;
    }

    @Override
    public Object visit(ExpectSentence expectSentence, CodeGenDTO par) {
        for (Expr expr : expectSentence.getPredicates()) {
            par.emitIndent();
            expr.accept(AssertionGenerator.INSTANCE, par);
            par.bodyBuilder.append(";\n");
        }
        return null;
    }

    @Override
    public Object visit(MatchSentence matchSentence, CodeGenDTO par) {
        par.addImport("org.fulib.FulibTables");
        par.addImport("org.fulib.patterns.PatternMatcher");
        par.addImport("org.fulib.patterns.PatternBuilder");
        par.addImport("org.fulib.patterns.model.PatternObject");
        par.addImport("org.fulib.yaml.ReflectorMap");
        List<Pattern> patterns = matchSentence.getPatterns();
        for (Pattern pattern : patterns) {
            Decl decl = pattern.getName().getDecl();
            par.emitLine("final " + decl.getType().accept(TypeGenerator.INSTANCE, par) + " " + decl.getName() + ";");
        }
        par.emitLine("{");
        ++par.indentLevel;
        par.emitLine("final PatternBuilder builder = FulibTables.patternBuilder();");
        for (Pattern pattern : patterns) {
            SentenceGenerator.generatePO(pattern, par);
        }
        for (Pattern pattern : patterns) {
            ConstraintGenerator gen = new ConstraintGenerator();
            for (Constraint constraint : pattern.getConstraints()) {
                constraint.accept(gen, par);
            }
        }
        String commaSeparatedPOs = patterns.stream().map(p -> p.getName().getValue() + "PO").collect(Collectors.joining(", "));
        if (patterns.size() > 1) {
            par.emitLine("builder.buildDistinctConstraint(" + commaSeparatedPOs + ");");
        }
        par.emitLine("final PatternMatcher matcher = FulibTables.matcher(builder.getPattern());");
        par.emitLine("matcher.withRootPatternObjects(" + commaSeparatedPOs + ");");
        this.generateRootObjects(matchSentence, par);
        par.emitLine("matcher.match();");
        for (Pattern pattern : patterns) {
            this.generateResultExtractor(pattern, par);
        }
        --par.indentLevel;
        par.emitLine("}");
        return null;
    }

    static void generatePO(Pattern pattern, CodeGenDTO par) {
        String typeParam;
        String name = pattern.getName().getValue();
        Type type = pattern.getType();
        if (type instanceof ListType) {
            type = ((ListType)type).getElementType();
        }
        if (type != PrimitiveType.OBJECT) {
            type = PrimitiveType.primitiveToWrapper(type);
            typeParam = ", " + type.accept(TypeGenerator.INSTANCE, par) + ".class";
        } else {
            typeParam = "";
        }
        par.emitLine(String.format("final PatternObject %sPO = builder.buildPatternObject(\"%s\"%s);", name, name, typeParam));
    }

    private void generateRootObjects(MatchSentence matchSentence, CodeGenDTO par) {
        Expr roots = matchSentence.getRoots();
        if (roots == null) {
            return;
        }
        String packageName = par.modelManager.getClassModel().getPackageName();
        par.emitIndent();
        par.emit("matcher.withRootObjects(new ReflectorMap(\"" + packageName + "\").discoverObjects(");
        roots.accept(ExprGenerator.FLAT, par);
        par.emit("));\n");
    }

    private void generateResultExtractor(Pattern pattern, CodeGenDTO par) {
        String name = pattern.getName().getValue();
        if (pattern.getType() instanceof ListType) {
            par.addImport("java.util.ArrayList");
            par.emitLine(name + " = new ArrayList<>(matcher.findAll(" + name + "PO));");
        } else {
            par.emitLine(name + " = matcher.findOne(" + name + "PO);");
        }
    }

    @Override
    public Object visit(DiagramSentence diagramSentence, CodeGenDTO par) {
        String toolMethod;
        String toolClass;
        String extension;
        String sourceDir = par.group.getSourceDir();
        String packageDir = par.group.getPackageDir();
        String fileName = diagramSentence.getFileName();
        String target = (sourceDir + "/" + packageDir + "/" + fileName).replace('\\', '/');
        int dotIndex = fileName.lastIndexOf(46);
        if (dotIndex < 0) {
            throw new IllegalStateException("invalid file name '" + fileName + "' - missing extension");
        }
        switch (extension = fileName.substring(dotIndex).toLowerCase()) {
            case ".svg": {
                toolClass = "org.fulib.FulibTools";
                toolMethod = "FulibTools.objectDiagrams().dumpSVG";
                break;
            }
            case ".png": {
                toolClass = "org.fulib.FulibTools";
                toolMethod = "FulibTools.objectDiagrams().dumpPng";
                break;
            }
            case ".yaml": {
                toolClass = "org.fulib.FulibTools";
                toolMethod = "FulibTools.objectDiagrams().dumpYaml";
                break;
            }
            case ".html": {
                toolClass = "org.fulib.scenarios.MockupTools";
                toolMethod = "MockupTools.htmlTool().dump";
                break;
            }
            case ".txt": {
                toolClass = "org.fulib.scenarios.MockupTools";
                toolMethod = "MockupTools.htmlTool().dumpToString";
                break;
            }
            default: {
                throw new IllegalStateException("invalid file name '" + fileName + "' - unsupported extension");
            }
        }
        par.addImport(toolClass);
        par.emitIndent();
        par.bodyBuilder.append(toolMethod).append('(');
        par.emitStringLiteral(target);
        par.bodyBuilder.append(", ");
        diagramSentence.getObject().accept(ExprGenerator.FLAT, par);
        par.bodyBuilder.append(");\n");
        return null;
    }

    @Override
    public Object visit(HasSentence hasSentence, CodeGenDTO par) {
        Expr receiver = hasSentence.getObject();
        if (receiver instanceof PlaceholderExpr || hasSentence.getClauses().stream().allMatch(c -> c.getExpr() instanceof PlaceholderExpr)) {
            return null;
        }
        par.emitIndent();
        receiver.accept(ExprGenerator.INSTANCE, par);
        Type receiverType = receiver.getType();
        if (receiverType instanceof ListType) {
            par.bodyBuilder.append(".forEach(it -> it");
        }
        for (NamedExpr attribute : hasSentence.getClauses()) {
            if (attribute.getExpr() instanceof PlaceholderExpr) continue;
            ExprGenerator.generateSetterCall(par, attribute);
        }
        if (receiverType instanceof ListType) {
            par.bodyBuilder.append(")");
        }
        par.bodyBuilder.append(";\n");
        return null;
    }

    @Override
    public Object visit(IsSentence isSentence, CodeGenDTO par) {
        isSentence.getDescriptor().accept(DeclGenerator.INSTANCE, par);
        return null;
    }

    @Override
    public Object visit(AnswerSentence answerSentence, CodeGenDTO par) {
        par.emitIndent();
        par.bodyBuilder.append("return ");
        answerSentence.getResult().accept(ExprGenerator.INSTANCE, par);
        par.bodyBuilder.append(";\n");
        return null;
    }

    @Override
    public Object visit(AddSentence addSentence, CodeGenDTO par) {
        par.emitIndent();
        Expr target = addSentence.getTarget();
        Expr source = addSentence.getSource();
        if (target instanceof AttributeAccess) {
            AttributeAccess attributeAccess = (AttributeAccess)target;
            attributeAccess.getReceiver().accept(ExprGenerator.INSTANCE, par);
            par.bodyBuilder.append(".with").append(StrUtil.cap((String)attributeAccess.getName().getValue())).append('(');
            source.accept(ExprGenerator.WITHER, par);
            par.bodyBuilder.append(");\n");
            return null;
        }
        target.accept(ExprGenerator.INSTANCE, par);
        if (source.getType() instanceof ListType) {
            par.bodyBuilder.append(".addAll(");
        } else {
            par.bodyBuilder.append(".add(");
        }
        source.accept(ExprGenerator.INSTANCE, par);
        par.bodyBuilder.append(");\n");
        return null;
    }

    @Override
    public Object visit(RemoveSentence removeSentence, CodeGenDTO par) {
        par.emitIndent();
        Expr target = removeSentence.getTarget();
        Expr source = removeSentence.getSource();
        if (target instanceof AttributeAccess) {
            AttributeAccess attributeAccess = (AttributeAccess)target;
            attributeAccess.getReceiver().accept(ExprGenerator.INSTANCE, par);
            par.bodyBuilder.append(".without").append(StrUtil.cap((String)attributeAccess.getName().getValue())).append('(');
            source.accept(ExprGenerator.WITHER, par);
            par.bodyBuilder.append(");\n");
            return null;
        }
        target.accept(ExprGenerator.INSTANCE, par);
        if (source.getType() instanceof ListType) {
            par.bodyBuilder.append(".removeAll(");
            source.accept(ExprGenerator.INSTANCE, par);
            par.bodyBuilder.append(");\n");
            return null;
        }
        par.addImport("java.util.Collections");
        par.bodyBuilder.append(".removeAll(Collections.singletonList(");
        source.accept(ExprGenerator.INSTANCE, par);
        par.bodyBuilder.append("));\n");
        return null;
    }

    @Override
    public Object visit(TakeSentence takeSentence, CodeGenDTO par) {
        par.emitIndent();
        par.bodyBuilder.append("for (final ");
        Type elementType = takeSentence.getVarName().getDecl().getType();
        String varName = takeSentence.getVarName().getValue();
        par.bodyBuilder.append(elementType.accept(TypeGenerator.INSTANCE, par));
        par.bodyBuilder.append(' ');
        par.bodyBuilder.append(varName);
        par.bodyBuilder.append(" : ");
        takeSentence.getCollection().accept(ExprGenerator.INSTANCE, par);
        par.bodyBuilder.append(") {\n");
        ++par.indentLevel;
        takeSentence.getBody().accept(this, par);
        --par.indentLevel;
        par.emitIndent();
        par.bodyBuilder.append("}\n");
        return null;
    }

    @Override
    public Object visit(ConditionalSentence conditionalSentence, CodeGenDTO par) {
        par.emitIndent();
        par.bodyBuilder.append("if (");
        conditionalSentence.getCondition().accept(ExprGenerator.INSTANCE, par);
        par.bodyBuilder.append(") {\n");
        ++par.indentLevel;
        conditionalSentence.getBody().accept(this, par);
        --par.indentLevel;
        par.emitIndent();
        par.bodyBuilder.append("}\n");
        return null;
    }

    @Override
    public Object visit(AssignSentence assignSentence, CodeGenDTO par) {
        par.emitIndent();
        par.bodyBuilder.append(assignSentence.getTarget().getName());
        par.bodyBuilder.append(' ');
        BinaryOperator operator = assignSentence.getOperator();
        if (operator != null) {
            par.bodyBuilder.append(operator.getSymbol());
        }
        par.bodyBuilder.append("= ");
        assignSentence.getValue().accept(ExprGenerator.INSTANCE, par);
        par.bodyBuilder.append(";\n");
        return null;
    }

    @Override
    public Object visit(ExprSentence exprSentence, CodeGenDTO par) {
        par.emitIndent();
        exprSentence.getExpr().accept(ExprGenerator.INSTANCE, par);
        par.bodyBuilder.append(";\n");
        return null;
    }
}

