/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.library;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.fulib.StrUtil;
import org.fulib.scenarios.ast.decl.AttributeDecl;
import org.fulib.scenarios.ast.decl.ExternalClassDecl;
import org.fulib.scenarios.ast.decl.ExternalMethodDecl;
import org.fulib.scenarios.ast.decl.ExternalParameterDecl;
import org.fulib.scenarios.ast.decl.ParameterDecl;
import org.fulib.scenarios.ast.type.ListType;
import org.fulib.scenarios.ast.type.PrimitiveType;
import org.fulib.scenarios.ast.type.Type;
import org.fulib.scenarios.ast.type.UnresolvedType;
import org.fulib.scenarios.parser.Identifiers;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class ClassModelVisitor
extends ClassVisitor {
    private final ExternalClassDecl classDecl;
    private final Set<String> properties = new LinkedHashSet<String>();

    public ClassModelVisitor(ExternalClassDecl classDecl) {
        super(458752);
        this.classDecl = classDecl;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        int slashIndex = name.lastIndexOf(47);
        String simpleName = slashIndex < 0 ? name : name.substring(slashIndex + 1);
        this.classDecl.setName(simpleName);
    }

    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        String attributeName;
        if (value != null && name.startsWith("PROPERTY_") && (attributeName = Identifiers.toLowerCamelCase(name.substring("PROPERTY_".length()))).equals(value)) {
            this.properties.add(attributeName);
        }
        return null;
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        String attributeName;
        String lowerAttributeName;
        if (name.isEmpty() || "<init>".equals(name) || "<clinit>".equals(name)) {
            return null;
        }
        int prefixLength = name.startsWith("get") || name.startsWith("set") ? 3 : (name.startsWith("without") ? 7 : (name.startsWith("with") ? 4 : 0));
        if (prefixLength > 0 && name.length() > prefixLength && this.properties.contains(lowerAttributeName = StrUtil.downFirstChar((String)(attributeName = name.substring(prefixLength))))) {
            if (name.charAt(0) == 'g') {
                this.tryCreateAttribute(lowerAttributeName, descriptor, signature);
            }
            return null;
        }
        if ((access & 1) != 0 && (access & 8) == 0) {
            this.tryCreateMethod(name, descriptor);
        }
        return null;
    }

    public void visitEnd() {
        this.classDecl.markUnresolved();
    }

    private void tryCreateAttribute(String name, String descriptor, String signature) {
        try {
            this.createAttribute(name, descriptor, signature);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    private void createAttribute(String name, String descriptor, String signature) {
        int returnTypeIndex = descriptor.indexOf(41) + 1;
        if (descriptor.endsWith(")Ljava/util/List;") || descriptor.endsWith(")Ljava/util/ArrayList;")) {
            ListType listType = ListType.of(null);
            int elementTypeIndex = signature.indexOf(60, returnTypeIndex) + 1;
            ClassModelVisitor.parseType(signature, elementTypeIndex, listType::setElementType);
            AttributeDecl attribute = AttributeDecl.of(this.classDecl, name, listType);
            this.classDecl.getAttributes().put(name, attribute);
            return;
        }
        AttributeDecl attribute = AttributeDecl.of(this.classDecl, name, null);
        ClassModelVisitor.parseType(descriptor, returnTypeIndex, attribute::setType);
        this.classDecl.getAttributes().put(name, attribute);
    }

    private void tryCreateMethod(String name, String descriptor) {
        try {
            ExternalMethodDecl methodDecl = new ExternalMethodDecl(this.classDecl, name, new ArrayList<ParameterDecl>(), null, null);
            ClassModelVisitor.parseType(descriptor, descriptor.lastIndexOf(41) + 1, methodDecl::setType);
            ExternalParameterDecl thisParam = new ExternalParameterDecl(methodDecl, "this", this.classDecl.getType());
            methodDecl.getParameters().add(thisParam);
            int index = 1;
            while (descriptor.charAt(index) != ')') {
                ExternalParameterDecl param = new ExternalParameterDecl(methodDecl, null, null);
                index = ClassModelVisitor.parseType(descriptor, index, param::setType);
                methodDecl.getParameters().add(param);
            }
            this.classDecl.getMethods().add(methodDecl);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public static Type parseType(String descriptor, int index) {
        Type[] holder = new Type[1];
        ClassModelVisitor.parseType(descriptor, index, t -> {
            holder[0] = t;
        });
        return holder[0];
    }

    public static int parseType(String descriptor, int index, Consumer<? super Type> consumer) {
        char c = descriptor.charAt(index);
        switch (c) {
            case '[': {
                throw new UnsupportedOperationException("array types");
            }
            case 'T': {
                throw new UnsupportedOperationException("generic type variables");
            }
            case 'L': {
                int genericStart = descriptor.indexOf(60, index + 1);
                if (genericStart > 0) {
                    throw new UnsupportedOperationException("generic type arguments");
                }
                int semi = descriptor.indexOf(59, index + 1);
                int slash = descriptor.lastIndexOf(47, semi - 1);
                String text = descriptor.substring(index + 1, semi);
                String name = descriptor.substring(Math.max(slash, index) + 1, semi);
                consumer.accept(UnresolvedType.of(name, text, false));
                return semi + 1;
            }
        }
        consumer.accept(ClassModelVisitor.parsePrimitiveType(c));
        return index + 1;
    }

    private static PrimitiveType parsePrimitiveType(char c) {
        switch (c) {
            case 'V': {
                return PrimitiveType.VOID;
            }
            case 'Z': {
                return PrimitiveType.BOOLEAN;
            }
            case 'B': {
                return PrimitiveType.BYTE;
            }
            case 'S': {
                return PrimitiveType.SHORT;
            }
            case 'C': {
                return PrimitiveType.CHAR;
            }
            case 'I': {
                return PrimitiveType.INT;
            }
            case 'J': {
                return PrimitiveType.LONG;
            }
            case 'F': {
                return PrimitiveType.FLOAT;
            }
            case 'D': {
                return PrimitiveType.DOUBLE;
            }
        }
        throw new UnsupportedOperationException("unknown type char " + c);
    }
}

