/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.visitor.resolve;

import org.fulib.scenarios.ast.scope.Scope;
import org.fulib.scenarios.ast.type.ClassType;
import org.fulib.scenarios.ast.type.ListType;
import org.fulib.scenarios.ast.type.PrimitiveType;
import org.fulib.scenarios.ast.type.Type;
import org.fulib.scenarios.ast.type.UnresolvedType;
import org.fulib.scenarios.visitor.resolve.DeclResolver;

public enum TypeResolver implements Type.Visitor<Scope, Type>
{
    INSTANCE;


    @Override
    public Type visit(UnresolvedType unresolvedType, Scope par) {
        String primitiveName = this.getPrimitiveNameFromText(unresolvedType);
        PrimitiveType primitive = PrimitiveType.fromJavaName(primitiveName);
        if (primitive != null) {
            return primitive;
        }
        String name = unresolvedType.getName();
        String singularName = unresolvedType.getPlural() ? TypeResolver.depluralize(name) : name;
        PrimitiveType primitive2 = PrimitiveType.fromJavaName(singularName);
        if (primitive2 != null) {
            return primitive2;
        }
        return DeclResolver.resolveClass(par, singularName, unresolvedType.getPosition()).getType();
    }

    private String getPrimitiveNameFromText(UnresolvedType unresolvedType) {
        String text = unresolvedType.getText();
        String primitiveName = text.startsWith("java/lang/") ? text.substring(10) : (unresolvedType.getPlural() ? TypeResolver.depluralize(text) : text);
        return primitiveName;
    }

    private static String depluralize(String caps) {
        return caps.endsWith("s") ? caps.substring(0, caps.length() - 1) : caps;
    }

    @Override
    public Type visit(PrimitiveType primitiveType, Scope par) {
        return primitiveType;
    }

    @Override
    public Type visit(ClassType classType, Scope par) {
        return classType;
    }

    @Override
    public Type visit(ListType listType, Scope par) {
        listType.setElementType(listType.getElementType().accept(this, par));
        return listType;
    }
}

