/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.ast.type;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.fulib.scenarios.ast.Node;
import org.fulib.scenarios.ast.type.Type;
import org.fulib.scenarios.diagnostic.Position;

public enum PrimitiveType implements Type
{
    ERROR("ERROR"),
    VOID("void"),
    BOOLEAN("boolean"),
    BYTE("byte"),
    SHORT("short"),
    CHAR("char"),
    INT("int"),
    LONG("long"),
    FLOAT("float"),
    DOUBLE("double"),
    OBJECT("Object"),
    STRING("String"),
    NUMBER("Number"),
    VOID_WRAPPER("Void"),
    BOOLEAN_WRAPPER("Boolean"),
    BYTE_WRAPPER("Byte"),
    SHORT_WRAPPER("Short"),
    CHAR_WRAPPER("Character"),
    INT_WRAPPER("Integer"),
    LONG_WRAPPER("Long"),
    FLOAT_WRAPPER("Float"),
    DOUBLE_WRAPPER("Double");

    private static final Map<String, PrimitiveType> javaNameMap;
    private final String javaName;

    private PrimitiveType(String javaName) {
        this.javaName = javaName;
    }

    public String getJavaName() {
        return this.javaName;
    }

    @Override
    public Position getPosition() {
        return null;
    }

    @Override
    public void setPosition(Position position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <P, R> R accept(Node.Visitor<P, R> visitor, P par) {
        return visitor.visit(this, par);
    }

    @Override
    public <P, R> R accept(Type.Visitor<P, R> visitor, P par) {
        return visitor.visit(this, par);
    }

    public <P, R> R accept(Visitor<P, R> visitor, P par) {
        return visitor.visit(this, par);
    }

    public static PrimitiveType fromJavaName(String javaName) {
        return javaNameMap.get(javaName);
    }

    public static Type primitiveToWrapper(Type type) {
        return type instanceof PrimitiveType ? PrimitiveType.primitiveToWrapper((PrimitiveType)type) : type;
    }

    public static PrimitiveType primitiveToWrapper(PrimitiveType type) {
        switch (type) {
            case VOID: {
                return VOID_WRAPPER;
            }
            case BOOLEAN: {
                return BOOLEAN_WRAPPER;
            }
            case BYTE: {
                return BYTE_WRAPPER;
            }
            case SHORT: {
                return SHORT_WRAPPER;
            }
            case CHAR: {
                return CHAR_WRAPPER;
            }
            case INT: {
                return INT_WRAPPER;
            }
            case LONG: {
                return LONG_WRAPPER;
            }
            case FLOAT: {
                return FLOAT_WRAPPER;
            }
            case DOUBLE: {
                return DOUBLE_WRAPPER;
            }
        }
        return type;
    }

    public static boolean isNumeric(Type type) {
        return type instanceof PrimitiveType && PrimitiveType.isNumeric((PrimitiveType)type);
    }

    public static boolean isNumeric(PrimitiveType type) {
        int ordinal = type.ordinal();
        return ordinal >= BYTE.ordinal() && ordinal <= DOUBLE.ordinal() || ordinal >= BYTE_WRAPPER.ordinal() && ordinal <= DOUBLE_WRAPPER.ordinal();
    }

    public static boolean isIntegral(Type type) {
        return type instanceof PrimitiveType && PrimitiveType.isIntegral((PrimitiveType)type);
    }

    public static boolean isIntegral(PrimitiveType type) {
        switch (type) {
            case BYTE: 
            case SHORT: 
            case CHAR: 
            case INT: 
            case LONG: 
            case BYTE_WRAPPER: 
            case SHORT_WRAPPER: 
            case CHAR_WRAPPER: 
            case INT_WRAPPER: 
            case LONG_WRAPPER: {
                return true;
            }
        }
        return false;
    }

    public static boolean isJavaPrimitive(Type type) {
        return type instanceof PrimitiveType && PrimitiveType.isJavaPrimitive((PrimitiveType)type);
    }

    public static boolean isJavaPrimitive(PrimitiveType type) {
        int ordinal = type.ordinal();
        return ordinal >= VOID.ordinal() && ordinal <= DOUBLE.ordinal();
    }

    public static boolean isPrimitiveOrWrapperValue(Type type) {
        return type instanceof PrimitiveType && PrimitiveType.isPrimitiveOrWrapperValue((PrimitiveType)type);
    }

    public static boolean isPrimitiveOrWrapperValue(PrimitiveType type) {
        int ordinal = type.ordinal();
        return ordinal >= BOOLEAN.ordinal() && ordinal <= DOUBLE.ordinal() || ordinal >= BOOLEAN_WRAPPER.ordinal() && ordinal <= DOUBLE_WRAPPER.ordinal();
    }

    static {
        PrimitiveType[] values = PrimitiveType.values();
        HashMap<String, PrimitiveType> map = new HashMap<String, PrimitiveType>(values.length);
        for (PrimitiveType value : values) {
            map.put(value.javaName, value);
        }
        javaNameMap = Collections.unmodifiableMap(map);
    }

    static interface Visitor<P, R> {
        public R visit(PrimitiveType var1, P var2);
    }
}

