/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.library;

import java.io.File;
import java.io.IOException;
import org.fulib.scenarios.library.DirLibrary;
import org.fulib.scenarios.library.JarLibrary;
import org.fulib.scenarios.tool.ScenarioCompiler;

public class LibraryHelper {
    public static void loadLibraries(ScenarioCompiler compiler) {
        for (String entry : compiler.getConfig().getClasspath()) {
            LibraryHelper.loadLibrary(entry, compiler);
        }
        String url = Object.class.getResource("/java/lang/Object.class").getFile();
        String path = url.substring(url.indexOf(58) + 1, url.indexOf(".jar!/") + 4);
        LibraryHelper.loadLibrary(path, compiler);
    }

    private static void loadLibrary(String classpathEntry, ScenarioCompiler compiler) {
        if (classpathEntry.endsWith(".jar")) {
            LibraryHelper.loadJarLibrary(classpathEntry, compiler);
        } else {
            LibraryHelper.loadDirLibrary(classpathEntry, compiler);
        }
    }

    private static void loadDirLibrary(String src, ScenarioCompiler compiler) {
        DirLibrary library = new DirLibrary(new File(src));
        compiler.getContext().getLibraries().add(library);
    }

    private static void loadJarLibrary(String src, ScenarioCompiler compiler) {
        try {
            JarLibrary library = new JarLibrary(new File(src));
            compiler.getContext().getLibraries().add(library);
        }
        catch (IOException e) {
            compiler.getOut().println("warning: failed to load library: " + src);
            e.printStackTrace(compiler.getErr());
        }
    }
}

