/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.visitor;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.fulib.scenarios.ast.decl.ClassDecl;
import org.fulib.scenarios.ast.type.ClassType;
import org.fulib.scenarios.ast.type.ListType;
import org.fulib.scenarios.ast.type.PrimitiveType;
import org.fulib.scenarios.ast.type.Type;
import org.fulib.scenarios.ast.type.UnresolvedType;
import org.fulib.scenarios.visitor.ExtractClassDecl;

public enum TypeComparer implements Type.Visitor<Type, Result>
{
    INSTANCE;


    public static boolean equals(Type a, Type b) {
        return a.accept(INSTANCE, b) == Result.EQUAL;
    }

    public static boolean isSuperType(Type a, Type b) {
        Result relation = a.accept(INSTANCE, b);
        return relation == Result.EQUAL || relation == Result.SUPERTYPE;
    }

    public static Type getCommonSuperType(Type a, Type b) {
        Result relation = a.accept(INSTANCE, b);
        switch (relation) {
            case EQUAL: 
            case SUPERTYPE: {
                return a;
            }
            case SUBTYPE: {
                return b;
            }
            case UNRELATED: {
                ClassDecl superClass;
                ClassDecl classB;
                ClassDecl classA = a.accept(ExtractClassDecl.INSTANCE, null);
                if (classA == null || (classB = b.accept(ExtractClassDecl.INSTANCE, null)) == null || (superClass = TypeComparer.getCommonSuperClass(classA, classB)) == null) break;
                return ClassType.of(superClass);
            }
        }
        return PrimitiveType.OBJECT;
    }

    public static boolean isSuperClass(ClassDecl a, ClassDecl b) {
        return b.getSuperClasses().contains(a);
    }

    public static Set<ClassDecl> getCommonSuperClasses(Iterable<? extends ClassDecl> classDecls) {
        Iterator<? extends ClassDecl> iterator = classDecls.iterator();
        if (!iterator.hasNext()) {
            return Collections.emptySet();
        }
        LinkedHashSet<ClassDecl> commonSuperClasses = new LinkedHashSet<ClassDecl>(iterator.next().getSuperClasses());
        while (iterator.hasNext()) {
            commonSuperClasses.retainAll(iterator.next().getSuperClasses());
        }
        return commonSuperClasses;
    }

    public static ClassDecl getCommonSuperClass(Iterable<? extends ClassDecl> classDecls) {
        return TypeComparer.first(TypeComparer.getCommonSuperClasses(classDecls));
    }

    private static ClassDecl first(Set<ClassDecl> commonClasses) {
        if (commonClasses.isEmpty()) {
            return null;
        }
        return commonClasses.iterator().next();
    }

    public static Set<ClassDecl> getCommonSuperClasses(ClassDecl a, ClassDecl b) {
        LinkedHashSet<ClassDecl> superClasses = new LinkedHashSet<ClassDecl>(a.getSuperClasses());
        superClasses.retainAll(b.getSuperClasses());
        return superClasses;
    }

    public static ClassDecl getCommonSuperClass(ClassDecl a, ClassDecl b) {
        return TypeComparer.first(TypeComparer.getCommonSuperClasses(a, b));
    }

    @Override
    public Result visit(UnresolvedType unresolvedType, Type par) {
        return Result.UNRELATED;
    }

    @Override
    public Result visit(PrimitiveType primitiveType, Type par) {
        if (primitiveType == par) {
            return Result.EQUAL;
        }
        if (primitiveType == PrimitiveType.OBJECT) {
            return Result.SUPERTYPE;
        }
        return Result.UNRELATED;
    }

    @Override
    public Result visit(ClassType classType, Type par) {
        if (par == PrimitiveType.OBJECT) {
            return Result.SUBTYPE;
        }
        ClassDecl classA = classType.getClassDecl();
        ClassDecl classB = par.accept(ExtractClassDecl.INSTANCE, null);
        if (classB == null) {
            return Result.UNRELATED;
        }
        if (classA == classB) {
            return Result.EQUAL;
        }
        if (TypeComparer.isSuperClass(classA, classB)) {
            return Result.SUPERTYPE;
        }
        if (TypeComparer.isSuperClass(classB, classA)) {
            return Result.SUBTYPE;
        }
        return Result.UNRELATED;
    }

    @Override
    public Result visit(ListType listType, Type par) {
        if (par == PrimitiveType.OBJECT) {
            return Result.SUBTYPE;
        }
        if (!(par instanceof ListType)) {
            return Result.UNRELATED;
        }
        Type elementTypeA = listType.getElementType();
        Type elementTypeB = ((ListType)par).getElementType();
        return elementTypeA.accept(this, elementTypeB);
    }

    public static enum Result {
        EQUAL,
        SUBTYPE,
        SUPERTYPE,
        UNRELATED;

    }
}

