/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.visitor.codegen;

import java.util.List;
import java.util.stream.Collectors;
import org.fulib.scenarios.ast.decl.Decl;
import org.fulib.scenarios.ast.decl.Name;
import org.fulib.scenarios.ast.expr.Expr;
import org.fulib.scenarios.ast.expr.conditional.ConditionalOperatorExpr;
import org.fulib.scenarios.ast.expr.conditional.PredicateOperatorExpr;
import org.fulib.scenarios.ast.expr.primary.NameAccess;
import org.fulib.scenarios.ast.pattern.AndConstraint;
import org.fulib.scenarios.ast.pattern.AttributeConditionalConstraint;
import org.fulib.scenarios.ast.pattern.AttributeConstraint;
import org.fulib.scenarios.ast.pattern.AttributeEqualityConstraint;
import org.fulib.scenarios.ast.pattern.AttributePredicateConstraint;
import org.fulib.scenarios.ast.pattern.Constraint;
import org.fulib.scenarios.ast.pattern.LinkConstraint;
import org.fulib.scenarios.ast.pattern.MatchConstraint;
import org.fulib.scenarios.ast.pattern.Pattern;
import org.fulib.scenarios.ast.type.ListType;
import org.fulib.scenarios.ast.type.Type;
import org.fulib.scenarios.visitor.codegen.CodeGenDTO;
import org.fulib.scenarios.visitor.codegen.ExprGenerator;
import org.fulib.scenarios.visitor.codegen.SentenceGenerator;
import org.fulib.scenarios.visitor.codegen.TypeGenerator;

public class ConstraintGenerator
implements Constraint.Visitor<CodeGenDTO, Void> {
    @Override
    public Void visit(AndConstraint andConstraint, CodeGenDTO par) {
        for (Constraint constraint : andConstraint.getConstraints()) {
            constraint.accept(this, par);
        }
        return null;
    }

    @Override
    public Void visit(LinkConstraint linkConstraint, CodeGenDTO par) {
        String ownerName = linkConstraint.getOwner().getName().getValue();
        String linkName = linkConstraint.getName() != null ? linkConstraint.getName().getValue() : "*";
        String targetName = linkConstraint.getTarget().getValue();
        par.emitLine(String.format("builder.buildPatternLink(%sPO, \"%s\", %sPO);", ownerName, linkName, targetName));
        return null;
    }

    @Override
    public Void visit(AttributeConstraint ac, CodeGenDTO par) {
        this.generateAttributePOAndLink(ac, par);
        return null;
    }

    @Override
    public Void visit(AttributeEqualityConstraint aec, CodeGenDTO par) {
        this.generateAttributePOAndLink(aec, par);
        par.emitIndent();
        par.emit("builder.buildEqualityConstraint(" + aec.getPattern().getName().getValue() + "PO, ");
        aec.getExpr().accept(ExprGenerator.INSTANCE, par);
        par.emit(");\n");
        return null;
    }

    @Override
    public Void visit(AttributeConditionalConstraint acc, CodeGenDTO par) {
        NameAccess it = NameAccess.of(acc.getPattern().getName());
        ConditionalOperatorExpr condOpExpr = ConditionalOperatorExpr.of(it, acc.getOperator(), acc.getRhs());
        this.generateAttributePOAndLink(acc, par);
        this.generateAttributeConstraint(acc.getPattern(), condOpExpr, par);
        return null;
    }

    @Override
    public Void visit(AttributePredicateConstraint apc, CodeGenDTO par) {
        NameAccess it = NameAccess.of(apc.getPattern().getName());
        PredicateOperatorExpr predOpExpr = PredicateOperatorExpr.of(it, apc.getPredicate());
        this.generateAttributePOAndLink(apc, par);
        this.generateAttributeConstraint(apc.getPattern(), predOpExpr, par);
        return null;
    }

    private void generateAttributePOAndLink(AttributeConstraint ac, CodeGenDTO gen) {
        String ownerName = ac.getOwner().getName().getValue();
        Name attribute = ac.getAttribute();
        String attributeNameValue = attribute == null ? "*" : attribute.getValue();
        Pattern pattern = ac.getPattern();
        String patternName = pattern.getName().getValue();
        SentenceGenerator.generatePO(pattern, gen);
        gen.emitLine(String.format("builder.buildPatternLink(%sPO, \"%s\", %sPO);", ownerName, attributeNameValue, patternName));
    }

    private void generateAttributeConstraint(Pattern pattern, Expr expr, CodeGenDTO gen) {
        String patternName = pattern.getName().getValue();
        String typeStr = pattern.getType().accept(TypeGenerator.INSTANCE, gen);
        gen.emitIndent();
        gen.emit("builder.buildAttributeConstraint(" + patternName + "PO, (" + typeStr + " " + patternName + ") -> ");
        expr.accept(ExprGenerator.INSTANCE, gen);
        gen.emit(");\n");
    }

    @Override
    public Void visit(MatchConstraint matchConstraint, CodeGenDTO par) {
        Decl decl;
        List<Pattern> patterns = matchConstraint.getPatterns();
        par.emitLine("builder.buildMatchConstraint(row -> {");
        ++par.indentLevel;
        for (Pattern pattern : patterns) {
            decl = pattern.getName().getDecl();
            String poName = decl.getName();
            String varName = "_" + poName;
            decl.setName(varName);
            Type type = decl.getType();
            if (type instanceof ListType) {
                type = ((ListType)type).getElementType();
            }
            String typeStr = type.accept(TypeGenerator.INSTANCE, par);
            par.emitLine(String.format("final %s %s = (%s) row.get(\"%s\");", typeStr, varName, typeStr, poName));
        }
        par.emitIndent();
        par.emit("return ");
        matchConstraint.getExpr().accept(ExprGenerator.INSTANCE, par);
        par.emit(";\n");
        for (Pattern pattern : patterns) {
            decl = pattern.getName().getDecl();
            decl.setName(decl.getName().substring(1));
        }
        --par.indentLevel;
        String commaSeparatedPONames = patterns.stream().map(p -> p.getName().getValue() + "PO").collect(Collectors.joining(", "));
        par.emitLine("}, " + commaSeparatedPONames + ");");
        return null;
    }
}

