/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.visitor.resolve;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.fulib.scenarios.ast.CompilationContext;
import org.fulib.scenarios.ast.ScenarioFile;
import org.fulib.scenarios.ast.ScenarioGroup;
import org.fulib.scenarios.ast.decl.AssociationDecl;
import org.fulib.scenarios.ast.decl.AttributeDecl;
import org.fulib.scenarios.ast.decl.ClassDecl;
import org.fulib.scenarios.ast.decl.Decl;
import org.fulib.scenarios.ast.decl.MethodDecl;
import org.fulib.scenarios.ast.decl.Name;
import org.fulib.scenarios.ast.decl.ParameterDecl;
import org.fulib.scenarios.ast.decl.ResolvedName;
import org.fulib.scenarios.ast.expr.Expr;
import org.fulib.scenarios.ast.scope.Scope;
import org.fulib.scenarios.ast.sentence.Sentence;
import org.fulib.scenarios.ast.sentence.SentenceList;
import org.fulib.scenarios.ast.type.ClassType;
import org.fulib.scenarios.ast.type.ListType;
import org.fulib.scenarios.ast.type.PrimitiveType;
import org.fulib.scenarios.ast.type.Type;
import org.fulib.scenarios.diagnostic.Marker;
import org.fulib.scenarios.diagnostic.Position;
import org.fulib.scenarios.visitor.ExtractClassDecl;
import org.fulib.scenarios.visitor.TypeComparer;
import org.fulib.scenarios.visitor.TypeConversion;
import org.fulib.scenarios.visitor.describe.DeclDescriber;
import org.fulib.scenarios.visitor.resolve.SentenceResolver;

public class DeclResolver {
    protected static final String ENCLOSING_CLASS = "<enclosing:class>";
    private static final int UNRESOLVED_HINT_DISTANCE_THRESHOLD = 3;

    public static ScenarioGroup resolveGroup(CompilationContext context, String packageDir) {
        return context.getGroups().computeIfAbsent(packageDir, p -> ScenarioGroup.of(context, null, p, new HashMap<String, ScenarioFile>(), new ConcurrentHashMap<String, ClassDecl>()));
    }

    static ClassDecl getEnclosingClass(Scope scope) {
        return (ClassDecl)scope.resolve(ENCLOSING_CLASS);
    }

    static ClassDecl resolveClass(Scope scope, String name, Position position) {
        return scope.resolve(name, ClassDecl.class, n -> {
            ClassDecl decl = ClassDecl.of(null, name, null, PrimitiveType.OBJECT, new LinkedHashMap<String, AttributeDecl>(), new LinkedHashMap<String, AssociationDecl>(), new ArrayList<MethodDecl>());
            decl.setPosition(position);
            ClassType classType = ClassType.of(decl);
            classType.setPosition(position);
            decl.setType(classType);
            return decl;
        });
    }

    private static MethodDecl getMethod(ClassDecl owner, String name) {
        for (ClassDecl superClass : owner.getSuperClasses()) {
            MethodDecl decl = DeclResolver.getOwnMethod(superClass, name);
            if (decl == null) continue;
            return decl;
        }
        return null;
    }

    private static MethodDecl getOwnMethod(ClassDecl owner, String name) {
        for (MethodDecl decl : owner.getMethods()) {
            if (!name.equals(decl.getName())) continue;
            return decl;
        }
        return null;
    }

    static MethodDecl resolveMethod(Scope scope, Position position, ClassDecl owner, String name) {
        MethodDecl existing = DeclResolver.getMethod(owner, name);
        return existing != null ? existing : DeclResolver.createMethod(scope, position, owner, name);
    }

    private static MethodDecl createMethod(Scope scope, Position position, ClassDecl owner, String name) {
        if (owner.getExternal()) {
            scope.report(Marker.error(position, "method.unresolved.external", name, owner.getName()));
            return null;
        }
        if (owner.getFrozen()) {
            scope.report(Marker.error(position, "method.unresolved.frozen", name, owner.getName()));
            return null;
        }
        return DeclResolver.createMethod(position, owner, name);
    }

    private static MethodDecl createMethod(Position position, ClassDecl owner, String name) {
        SentenceList body = SentenceList.of(new ArrayList<Sentence>());
        MethodDecl decl = MethodDecl.of(owner, name, new ArrayList<ParameterDecl>(), null, body);
        decl.setPosition(position);
        owner.getMethods().add(decl);
        return decl;
    }

    static Name getAttributeOrAssociation(Scope scope, Expr receiver, Name name) {
        return DeclResolver.getAttributeOrAssociation(scope, receiver, receiver.getType(), name);
    }

    static Name getAttributeOrAssociation(Scope scope, Type owner, Name name) {
        return DeclResolver.getAttributeOrAssociation(scope, null, owner, name);
    }

    static Name getAttributeOrAssociation(Scope scope, Expr receiver, Type owner, Name name) {
        if (owner == PrimitiveType.ERROR) {
            return name;
        }
        ClassDecl ownerClass = owner.accept(ExtractClassDecl.INSTANCE, null);
        if (ownerClass != null) {
            return DeclResolver.getAttributeOrAssociation(scope, ownerClass, name);
        }
        Marker error = Marker.error(name.getPosition(), "property.unresolved.primitive", name.getValue(), owner.getDescription());
        if (receiver != null) {
            SentenceResolver.addStringLiteralTypoNotes(scope, receiver, error);
        }
        scope.report(error);
        return name;
    }

    static Name getAttributeOrAssociation(Scope scope, ClassDecl owner, Name name) {
        if (name.getDecl() != null) {
            return name;
        }
        String nameValue = name.getValue();
        Decl decl = DeclResolver.getAttributeOrAssociation(owner, nameValue);
        if (decl != null) {
            return ResolvedName.of(decl);
        }
        Position position = name.getPosition();
        Marker error = Marker.error(position, "property.unresolved", owner.getName(), nameValue);
        Stream.concat(owner.getAttributes().keySet().stream(), owner.getAssociations().keySet().stream()).filter(SentenceResolver.caseInsensitiveLevenshteinDistance(nameValue, 3)).forEach(suggestion -> error.note(Marker.note(position, "property.typo", suggestion, nameValue)));
        scope.report(error);
        return name;
    }

    static Decl getAttributeOrAssociation(ClassDecl owner, String name) {
        AttributeDecl attribute = DeclResolver.getAttribute(owner, name);
        return attribute != null ? attribute : DeclResolver.getAssociation(owner, name);
    }

    static Decl resolveAttributeOrAssociation(Scope scope, ClassDecl classDecl, String attributeName, Expr rhs, Position position) {
        Type attributeType = rhs.getType();
        ClassDecl otherClassDecl = attributeType.accept(ExtractClassDecl.INSTANCE, null);
        if (otherClassDecl != null && otherClassDecl.getGroup() == classDecl.getGroup()) {
            int cardinality = attributeType instanceof ListType ? 42 : 1;
            return DeclResolver.resolveAssociation(scope, classDecl, attributeName, cardinality, otherClassDecl, position, rhs);
        }
        return DeclResolver.resolveAttribute(scope, classDecl, attributeName, attributeType, position, rhs);
    }

    static AttributeDecl getAttribute(ClassDecl owner, String name) {
        for (ClassDecl superClass : owner.getSuperClasses()) {
            AttributeDecl decl = DeclResolver.getOwnAttribute(superClass, name);
            if (decl == null) continue;
            return decl;
        }
        return null;
    }

    static AttributeDecl getOwnAttribute(ClassDecl owner, String name) {
        return owner.getAttributes().get(name);
    }

    static Decl resolveAttribute(Scope scope, ClassDecl owner, String name, Type type, Position position, Expr rhs) {
        AttributeDecl existingAttribute = DeclResolver.getAttribute(owner, name);
        if (existingAttribute != null) {
            Type existingType = existingAttribute.getType();
            if (type != PrimitiveType.ERROR && existingType != PrimitiveType.ERROR && !TypeConversion.isConvertible(type, existingType)) {
                String newDesc = DeclDescriber.describeAttribute(type);
                Marker conflict = DeclResolver.conflict(position, owner, name, existingAttribute, newDesc);
                SentenceResolver.addStringLiteralTypoNotes(scope, rhs, conflict);
                scope.report(conflict);
            }
            return existingAttribute;
        }
        AssociationDecl existingAssociation = DeclResolver.getAssociation(owner, name);
        if (existingAssociation != null) {
            String newDesc = DeclDescriber.describeAttribute(type);
            Marker conflict = DeclResolver.conflict(position, owner, name, existingAssociation, newDesc);
            SentenceResolver.addStringLiteralTypoNotes(scope, rhs, conflict);
            scope.report(conflict);
            return existingAssociation;
        }
        return DeclResolver.createAttribute(scope, position, owner, name, type);
    }

    private static AttributeDecl createAttribute(Scope scope, Position position, ClassDecl owner, String name, Type type) {
        if (owner.getExternal()) {
            scope.report(Marker.error(position, "attribute.unresolved.external", name, owner.getName()));
            return null;
        }
        if (owner.getFrozen()) {
            scope.report(Marker.error(position, "attribute.unresolved.frozen", name, owner.getName()));
            return null;
        }
        return DeclResolver.createAttribute(position, owner, name, type);
    }

    private static AttributeDecl createAttribute(Position position, ClassDecl owner, String name, Type type) {
        AttributeDecl attribute = AttributeDecl.of(owner, name, type);
        attribute.setPosition(position);
        owner.getAttributes().put(name, attribute);
        return attribute;
    }

    static AssociationDecl getAssociation(ClassDecl owner, String name) {
        for (ClassDecl superClass : owner.getSuperClasses()) {
            AssociationDecl decl = DeclResolver.getOwnAssociation(superClass, name);
            if (decl == null) continue;
            return decl;
        }
        return null;
    }

    static AssociationDecl getOwnAssociation(ClassDecl owner, String name) {
        return owner.getAssociations().get(name);
    }

    static AssociationDecl resolveAssociation(Scope scope, ClassDecl owner, String name, int cardinality, ClassDecl otherClass, Position position, Expr rhs) {
        return DeclResolver.resolveAssociation(scope, owner, name, cardinality, otherClass, null, 0, position, null, rhs);
    }

    static AssociationDecl resolveAssociation(Scope scope, ClassDecl owner, String name, int cardinality, ClassDecl otherClass, String otherName, int otherCardinality, Position position, Position otherPosition, Expr rhs) {
        AssociationDecl other;
        AttributeDecl existingAttribute = DeclResolver.getAttribute(owner, name);
        if (existingAttribute != null) {
            String newDesc = DeclDescriber.describeAssociation(cardinality, otherClass);
            Marker conflict = DeclResolver.conflict(position, owner, name, existingAttribute, newDesc);
            SentenceResolver.addStringLiteralTypoNotes(scope, rhs, conflict);
            scope.report(conflict);
            return null;
        }
        AssociationDecl existing = DeclResolver.getAssociation(owner, name);
        if (existing != null) {
            if (!TypeComparer.isSuperClass(existing.getTarget(), otherClass) || existing.getCardinality() < cardinality) {
                String newDesc = DeclDescriber.describeAssociation(cardinality, otherClass);
                Marker conflict = DeclResolver.conflict(position, owner, name, existing, newDesc);
                SentenceResolver.addStringLiteralTypoNotes(scope, rhs, conflict);
                scope.report(conflict);
            } else if (otherName != null) {
                AssociationDecl other2 = existing.getOther();
                if (other2 == null) {
                    Marker error = Marker.error(otherPosition, "association.reverse.late", otherName, owner.getName(), name);
                    if (existing.getPosition() != null) {
                        error.note(DeclResolver.firstDeclaration(existing.getPosition(), owner, name));
                    }
                    scope.report(error);
                } else if (!otherName.equals(other2.getName()) || otherCardinality != other2.getCardinality()) {
                    String existingDesc = other2.accept(DeclDescriber.INSTANCE, null);
                    String newDesc = DeclDescriber.describeAssociation(otherCardinality, owner);
                    Marker error = Marker.error(otherPosition, "association.reverse.conflict", owner.getName(), name);
                    error.note(Marker.note(otherPosition, "conflict.old", otherClass.getName() + "." + other2.getName() + ", " + existingDesc));
                    error.note(Marker.note(otherPosition, "conflict.new", otherClass.getName() + "." + otherName + ", " + newDesc));
                    if (other2.getPosition() != null) {
                        error.note(DeclResolver.firstDeclaration(other2.getPosition(), other2.getOwner(), other2.getName()));
                    }
                    scope.report(error);
                }
            }
            return existing;
        }
        AssociationDecl association = DeclResolver.createAssociation(scope, position, owner, name, cardinality, otherClass);
        if (association == null) {
            return null;
        }
        if (otherClass == owner && name.equals(otherName)) {
            if (cardinality != otherCardinality) {
                scope.report(Marker.error(position, "association.self.cardinality.mismatch", owner.getName(), name));
            }
            association.setOther(association);
        } else if (otherName != null && (other = DeclResolver.createAssociation(scope, otherPosition, otherClass, otherName, otherCardinality, owner)) != null) {
            association.setOther(other);
            other.setOther(association);
        }
        return association;
    }

    private static AssociationDecl createAssociation(Scope scope, Position position, ClassDecl owner, String name, int cardinality, ClassDecl target) {
        if (owner.getExternal()) {
            scope.report(Marker.error(position, "association.unresolved.external", name, owner.getName()));
            return null;
        }
        if (owner.getFrozen()) {
            scope.report(Marker.error(position, "association.unresolved.frozen", name, owner.getName()));
            return null;
        }
        return DeclResolver.createAssociation(position, owner, name, cardinality, target);
    }

    private static AssociationDecl createAssociation(Position position, ClassDecl owner, String name, int cardinality, ClassDecl target) {
        Type type = DeclResolver.createType(cardinality, target);
        AssociationDecl association = AssociationDecl.of(owner, name, cardinality, target, type, null);
        association.setPosition(position);
        owner.getAssociations().put(association.getName(), association);
        return association;
    }

    private static Type createType(int cardinality, ClassDecl target) {
        return cardinality != 1 ? ListType.of(target.getType()) : target.getType();
    }

    static Marker firstDeclaration(Position position, ClassDecl owner, String name) {
        return Marker.note(position, "property.declaration.first", owner.getName(), name);
    }

    private static Marker conflict(Position position, ClassDecl owner, String name, Decl existing, String newDesc) {
        String existingDesc = existing.accept(DeclDescriber.INSTANCE, null);
        Marker error = Marker.error(position, "property.redeclaration.conflict", owner.getName(), name);
        error.note(Marker.note(position, "conflict.old", existingDesc));
        error.note(Marker.note(position, "conflict.new", newDesc));
        Position existingPosition = existing.getPosition();
        if (existingPosition != null) {
            error.note(DeclResolver.firstDeclaration(existingPosition, owner, name));
        }
        return error;
    }

    private static String kindString(Decl decl) {
        String simpleName = decl.getClass().getEnclosingClass().getSimpleName();
        String stripped = simpleName.endsWith("Decl") ? simpleName.substring(0, simpleName.length() - 4) : simpleName;
        String key = stripped.toLowerCase() + ".kind";
        return Marker.localize(key, new Object[0]);
    }
}

