/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.visitor.resolve;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeSet;
import java.util.function.Predicate;
import org.apache.commons.text.similarity.LevenshteinDistance;
import org.fulib.StrUtil;
import org.fulib.scenarios.ast.MultiDescriptor;
import org.fulib.scenarios.ast.NamedExpr;
import org.fulib.scenarios.ast.decl.AssociationDecl;
import org.fulib.scenarios.ast.decl.ClassDecl;
import org.fulib.scenarios.ast.decl.Decl;
import org.fulib.scenarios.ast.decl.Name;
import org.fulib.scenarios.ast.decl.ResolvedName;
import org.fulib.scenarios.ast.decl.UnresolvedName;
import org.fulib.scenarios.ast.decl.VarDecl;
import org.fulib.scenarios.ast.expr.Expr;
import org.fulib.scenarios.ast.expr.access.AttributeAccess;
import org.fulib.scenarios.ast.expr.call.CallExpr;
import org.fulib.scenarios.ast.expr.call.CreationExpr;
import org.fulib.scenarios.ast.expr.collection.ListExpr;
import org.fulib.scenarios.ast.expr.operator.BinaryExpr;
import org.fulib.scenarios.ast.expr.operator.BinaryOperator;
import org.fulib.scenarios.ast.expr.primary.NameAccess;
import org.fulib.scenarios.ast.expr.primary.StringLiteral;
import org.fulib.scenarios.ast.pattern.Pattern;
import org.fulib.scenarios.ast.scope.ExtendingScope;
import org.fulib.scenarios.ast.scope.HidingScope;
import org.fulib.scenarios.ast.scope.Scope;
import org.fulib.scenarios.ast.sentence.AddSentence;
import org.fulib.scenarios.ast.sentence.AnswerSentence;
import org.fulib.scenarios.ast.sentence.AreSentence;
import org.fulib.scenarios.ast.sentence.AssignSentence;
import org.fulib.scenarios.ast.sentence.CallSentence;
import org.fulib.scenarios.ast.sentence.ConditionalSentence;
import org.fulib.scenarios.ast.sentence.CreateSentence;
import org.fulib.scenarios.ast.sentence.DiagramSentence;
import org.fulib.scenarios.ast.sentence.ExpectSentence;
import org.fulib.scenarios.ast.sentence.ExprSentence;
import org.fulib.scenarios.ast.sentence.FlattenSentenceList;
import org.fulib.scenarios.ast.sentence.HasSentence;
import org.fulib.scenarios.ast.sentence.InheritanceSentence;
import org.fulib.scenarios.ast.sentence.IsSentence;
import org.fulib.scenarios.ast.sentence.MatchSentence;
import org.fulib.scenarios.ast.sentence.MutatingSentence;
import org.fulib.scenarios.ast.sentence.RemoveSentence;
import org.fulib.scenarios.ast.sentence.SectionSentence;
import org.fulib.scenarios.ast.sentence.Sentence;
import org.fulib.scenarios.ast.sentence.SentenceList;
import org.fulib.scenarios.ast.sentence.TakeSentence;
import org.fulib.scenarios.ast.sentence.ThereSentence;
import org.fulib.scenarios.ast.sentence.WriteSentence;
import org.fulib.scenarios.ast.type.ListType;
import org.fulib.scenarios.ast.type.PrimitiveType;
import org.fulib.scenarios.ast.type.Type;
import org.fulib.scenarios.diagnostic.Marker;
import org.fulib.scenarios.diagnostic.Position;
import org.fulib.scenarios.tool.Config;
import org.fulib.scenarios.visitor.ExtractClassDecl;
import org.fulib.scenarios.visitor.Namer;
import org.fulib.scenarios.visitor.TypeConversion;
import org.fulib.scenarios.visitor.resolve.AssignmentResolve;
import org.fulib.scenarios.visitor.resolve.ConstraintResolver;
import org.fulib.scenarios.visitor.resolve.DeclResolver;
import org.fulib.scenarios.visitor.resolve.ExprResolver;
import org.fulib.scenarios.visitor.resolve.NameResolver;
import org.fulib.scenarios.visitor.resolve.SymbolCollector;
import org.fulib.scenarios.visitor.resolve.TypeResolver;

public enum SentenceResolver implements Sentence.Visitor<Scope, Sentence>
{
    INSTANCE;


    @Override
    public Sentence visit(SentenceList sentenceList, Scope par) {
        HashMap decls = new HashMap();
        ExtendingScope scope = new ExtendingScope(decls, par);
        List<Sentence> oldItems = sentenceList.getItems();
        ArrayList<Sentence> newItems = new ArrayList<Sentence>(oldItems.size());
        for (Sentence item : oldItems) {
            Sentence resolved = item.accept(this, scope);
            resolved.accept(SymbolCollector.INSTANCE, decls);
            FlattenSentenceList.add(newItems, resolved);
        }
        sentenceList.setItems(newItems);
        return sentenceList;
    }

    @Override
    public Sentence visit(SectionSentence sectionSentence, Scope par) {
        return sectionSentence;
    }

    @Override
    public Sentence visit(ThereSentence thereSentence, Scope par) {
        return SentenceResolver.expand(thereSentence.getDescriptor(), par).accept(this, par);
    }

    private static Sentence expand(MultiDescriptor descriptor, Scope scope) {
        ArrayList<Sentence> result = new ArrayList<Sentence>();
        SentenceResolver.expand(descriptor, result, scope);
        return new FlattenSentenceList(result);
    }

    private static void expand(MultiDescriptor multiDesc, List<Sentence> result, Scope scope) {
        Type type = multiDesc.getType();
        List<Name> names = SentenceResolver.getNames(multiDesc);
        ArrayList<VarDecl> varDecls = new ArrayList<VarDecl>(names.size());
        for (Name name : names) {
            String nameValue = name.getValue();
            CreationExpr expr = CreationExpr.of(type, Collections.emptyList());
            expr.setPosition(name.getPosition());
            VarDecl varDecl = VarDecl.of(nameValue, null, expr);
            varDecl.setPosition(name.getPosition());
            varDecls.add(varDecl);
            IsSentence isSentence = IsSentence.of(varDecl);
            isSentence.setPosition(name.getPosition());
            result.add(isSentence);
        }
        for (NamedExpr attribute : multiDesc.getAttributes()) {
            List<Expr> elements;
            Name attributeName = attribute.getName();
            Expr attributeExpr = attribute.getExpr();
            if (names.size() == 1) {
                HasSentence hasSentence = SentenceResolver.buildHasSentence((Decl)varDecls.get(0), attribute);
                result.add(hasSentence);
                continue;
            }
            if (attributeExpr instanceof ListExpr && (elements = ((ListExpr)attributeExpr).getElements()).size() == names.size()) {
                for (int i = 0; i < names.size(); ++i) {
                    NamedExpr partialAttribute = NamedExpr.of(attributeName, elements.get(i));
                    HasSentence hasSentence = SentenceResolver.buildHasSentence((Decl)varDecls.get(i), partialAttribute);
                    result.add(hasSentence);
                }
                continue;
            }
            VarDecl temp = VarDecl.of("temp++", null, attributeExpr);
            ResolvedName tempName = ResolvedName.of(temp);
            NameAccess tempAccess = NameAccess.of(tempName);
            result.add(IsSentence.of(temp));
            for (int i = 0; i < names.size(); ++i) {
                NamedExpr partialAttribute = NamedExpr.of(attributeName, tempAccess);
                HasSentence hasSentence = SentenceResolver.buildHasSentence((Decl)varDecls.get(i), partialAttribute);
                result.add(hasSentence);
            }
        }
    }

    private static HasSentence buildHasSentence(Decl varDecl, NamedExpr attribute) {
        Position position = varDecl.getPosition();
        ResolvedName receiverName = ResolvedName.of(varDecl);
        receiverName.setPosition(position);
        NameAccess receiver = NameAccess.of(receiverName);
        receiver.setPosition(position);
        HasSentence hasSentence = HasSentence.of(receiver, Collections.singletonList(attribute));
        hasSentence.setPosition(position);
        return hasSentence;
    }

    private static List<Name> getNames(MultiDescriptor multiDesc) {
        List<Name> names = multiDesc.getNames();
        if (!names.isEmpty()) {
            return names;
        }
        block0: for (NamedExpr attribute : multiDesc.getAttributes()) {
            Expr expr = attribute.getExpr();
            if (expr instanceof ListExpr) {
                List<Expr> elements = ((ListExpr)expr).getElements();
                ArrayList<Name> result = new ArrayList<Name>(elements.size());
                for (Expr element : elements) {
                    String potentialName = element.accept(Namer.INSTANCE, null);
                    if (potentialName == null) continue block0;
                    result.add(SentenceResolver.unresolvedName(potentialName, element.getPosition()));
                }
                return result;
            }
            String potentialName = expr.accept(Namer.INSTANCE, null);
            if (potentialName == null) continue;
            Name name = SentenceResolver.unresolvedName(potentialName, expr.getPosition());
            return Collections.singletonList(name);
        }
        String className = multiDesc.getType().accept(Namer.INSTANCE, null);
        String objectName = StrUtil.downFirstChar((String)className);
        Name name = SentenceResolver.unresolvedName(objectName, multiDesc.getType().getPosition());
        return Collections.singletonList(name);
    }

    private static Name unresolvedName(String potentialName, Position position) {
        UnresolvedName name = UnresolvedName.of(potentialName, null);
        name.setPosition(position);
        return name;
    }

    @Override
    public Sentence visit(ExpectSentence expectSentence, Scope par) {
        expectSentence.getPredicates().replaceAll(predicate -> {
            Expr resolved = predicate.accept(ExprResolver.INSTANCE, par);
            return ExprResolver.checkConditional(resolved, par);
        });
        return expectSentence;
    }

    @Override
    public Sentence visit(MatchSentence matchSentence, Scope par) {
        if (matchSentence.getRoots() == null) {
            matchSentence.setRoots(SymbolCollector.getRoots(par));
            if (matchSentence.getRoots() == null) {
                par.report(Marker.error(matchSentence.getPosition(), "match.no.roots", new Object[0]));
            }
        } else {
            matchSentence.setRoots(matchSentence.getRoots().accept(ExprResolver.INSTANCE, par));
        }
        HashMap<String, VarDecl> newDecls = new HashMap<String, VarDecl>();
        for (Pattern pattern : matchSentence.getPatterns()) {
            pattern.setType(pattern.getType().accept(TypeResolver.INSTANCE, par));
            Decl oldDecl = pattern.getName().getDecl();
            if (oldDecl != null) continue;
            String name = pattern.getName().getValue();
            Position position = pattern.getName().getPosition();
            this.checkForExisting(par, name, position);
            Decl existing = (Decl)newDecls.get(name);
            if (existing != null) {
                Marker error = Marker.error(position, "pattern.object.duplicate", name);
                error.note(Marker.note(existing.getPosition(), "pattern.object.first", name));
                par.report(error);
            }
            VarDecl varDecl = VarDecl.of(name, pattern.getType(), null);
            varDecl.setPosition(position);
            varDecl.setPattern(pattern);
            pattern.setName(ResolvedName.of(varDecl));
            newDecls.put(varDecl.getName(), varDecl);
        }
        ExtendingScope scope = new ExtendingScope(newDecls, par);
        for (Pattern pattern : matchSentence.getPatterns()) {
            ConstraintResolver resolver = new ConstraintResolver();
            pattern.getConstraints().replaceAll(c -> {
                c.setOwner(pattern);
                return c.accept(resolver, scope);
            });
        }
        return matchSentence;
    }

    @Override
    public Sentence visit(DiagramSentence diagramSentence, Scope par) {
        diagramSentence.setObject(diagramSentence.getObject().accept(ExprResolver.INSTANCE, par));
        Config config = DeclResolver.getEnclosingClass(par).getGroup().getContext().getConfig();
        String fileName = diagramSentence.getFileName();
        String diagramHandler = config.getDiagramHandlerFromFile(fileName);
        if (diagramHandler == null) {
            Position position = diagramSentence.getPosition();
            Marker error = Marker.error(position, "diagram.filename.extension.unsupported", fileName);
            error.note(Marker.note(position, "diagram.filename.extension.hint", new TreeSet<String>(config.getDiagramHandlerExtensions())));
            par.report(error);
        }
        return diagramSentence;
    }

    @Override
    public Sentence visit(HasSentence hasSentence, Scope par) {
        Expr receiver = hasSentence.getObject().accept(ExprResolver.INSTANCE, par);
        hasSentence.setObject(receiver);
        Type receiverType = receiver.getType();
        if (receiverType == PrimitiveType.ERROR) {
            return hasSentence;
        }
        ClassDecl receiverClass = receiverType.accept(ExtractClassDecl.INSTANCE, null);
        if (receiverClass == null) {
            Marker error = Marker.error(receiver.getPosition(), "has.subject.primitive", receiverType.getDescription());
            SentenceResolver.addStringLiteralTypoNotes(par, receiver, error);
            par.report(error);
            return hasSentence;
        }
        String receiverName = receiver.accept(Namer.INSTANCE, null);
        Scope scope = receiverName != null ? new HidingScope(receiverName, par) : par;
        for (NamedExpr namedExpr : hasSentence.getClauses()) {
            SentenceResolver.resolveHasNamedExpr(namedExpr, receiverClass, scope);
        }
        return hasSentence;
    }

    public static void addStringLiteralTypoNotes(Scope scope, Expr expr, Marker parent) {
        if (expr instanceof ListExpr) {
            ListType type = (ListType)expr.getType();
            Marker note = Marker.note(expr.getPosition(), "list.type", type.getElementType().getDescription());
            parent.note(note);
            for (Expr element : ((ListExpr)expr).getElements()) {
                SentenceResolver.addStringLiteralTypoNotes(scope, element, note);
            }
            return;
        }
        if (!(expr instanceof StringLiteral)) {
            return;
        }
        StringLiteral stringLiteral = (StringLiteral)expr;
        String stringValue = stringLiteral.getValue();
        String identifier = stringValue.replaceAll("\\s+", "");
        LinkedHashMap decls = new LinkedHashMap();
        scope.list(decls::putIfAbsent);
        decls.keySet().stream().filter(SentenceResolver.caseInsensitiveLevenshteinDistance(identifier, 2)).forEach(key -> parent.note(Marker.note(expr.getPosition(), "stringliteral.typo", key, stringValue)));
    }

    static Predicate<String> caseInsensitiveLevenshteinDistance(String base, int threshold) {
        String lowerBase = base.toLowerCase();
        LevenshteinDistance levenshteinDistance = new LevenshteinDistance(Integer.valueOf(2));
        return s -> {
            int result = levenshteinDistance.apply((CharSequence)lowerBase, (CharSequence)s);
            return 0 <= result && result <= threshold;
        };
    }

    static void resolveHasNamedExpr(NamedExpr namedExpr, ClassDecl objectClass, Scope scope) {
        int otherCardinality;
        Name name = namedExpr.getName();
        Name otherName = namedExpr.getOtherName();
        Expr expr = namedExpr.getExpr().accept(ExprResolver.INSTANCE, scope);
        namedExpr.setExpr(expr);
        if (otherName == null) {
            SentenceResolver.resolveSimpleHasNamedExpr(namedExpr, objectClass, scope);
            return;
        }
        String assocName = name.getValue();
        Type exprType = expr.getType();
        int cardinality = exprType instanceof ListType ? 42 : 1;
        ClassDecl otherClass = exprType.accept(ExtractClassDecl.INSTANCE, null);
        String otherAssocName = otherName.getValue();
        int n = otherCardinality = namedExpr.getOtherMany() ? 42 : 1;
        if (otherClass == null) {
            SentenceResolver.resolveSimpleHasNamedExpr(namedExpr, objectClass, scope);
            Marker error = Marker.error(otherName.getPosition(), "attribute.reverse.name", otherAssocName, objectClass.getName(), assocName);
            SentenceResolver.addStringLiteralTypoNotes(scope, expr, error);
            scope.report(error);
            return;
        }
        AssociationDecl assoc = DeclResolver.resolveAssociation(scope, objectClass, assocName, cardinality, otherClass, otherAssocName, otherCardinality, name.getPosition(), otherName.getPosition(), expr);
        if (assoc != null) {
            AssociationDecl other = assoc.getOther();
            namedExpr.setName(ResolvedName.of(assoc));
            if (other != null) {
                namedExpr.setOtherName(ResolvedName.of(other));
            }
        }
    }

    private static void resolveSimpleHasNamedExpr(NamedExpr namedExpr, ClassDecl classDecl, Scope scope) {
        Name name = namedExpr.getName();
        if (name.getDecl() != null) {
            return;
        }
        Expr expr = namedExpr.getExpr();
        Decl decl = DeclResolver.resolveAttributeOrAssociation(scope, classDecl, name.getValue(), expr, name.getPosition());
        if (decl == null) {
            return;
        }
        namedExpr.setName(ResolvedName.of(decl));
        Expr converted = TypeConversion.convert(expr, decl.getType());
        if (converted != null) {
            namedExpr.setExpr(converted);
        }
    }

    @Override
    public Sentence visit(IsSentence isSentence, Scope par) {
        VarDecl varDecl = isSentence.getDescriptor();
        Expr expr = varDecl.getExpr().accept(ExprResolver.INSTANCE, par);
        Type exprType = expr.getType();
        if (exprType == PrimitiveType.VOID) {
            return ExprSentence.of(expr);
        }
        String name = varDecl.getName();
        if (name == null) {
            name = expr.accept(Namer.INSTANCE, null);
        } else if (name.contains("++")) {
            name = SentenceResolver.findUnique(name, par);
        }
        Position position = varDecl.getPosition();
        this.checkForExisting(par, name, position);
        varDecl.setName(name);
        if (varDecl.getType() == null) {
            varDecl.setType(exprType);
            varDecl.setExpr(expr);
        } else {
            varDecl.setExpr(SentenceResolver.checkAssignment(expr, varDecl, true, par));
        }
        return isSentence;
    }

    private void checkForExisting(Scope par, String name, Position position) {
        Decl existing = par.resolve(name);
        if (existing != null) {
            par.report(Marker.error(position, "variable.redeclaration", name).note(Marker.note(position, "variable.redeclaration.hint", new Object[0])).note(Marker.note(existing.getPosition(), "variable.declaration.first", name)));
        }
    }

    private static String findUnique(String name, Scope par) {
        int index = name.indexOf("++");
        String prefix = name.substring(0, index);
        String suffix = name.substring(index + 2);
        int i = 1;
        String numbered;
        while (par.resolve(numbered = prefix + i + suffix) != null) {
            ++i;
        }
        return numbered;
    }

    @Override
    public Sentence visit(AreSentence areSentence, Scope par) {
        return SentenceResolver.expand(areSentence.getDescriptor(), par).accept(this, par);
    }

    @Override
    public Sentence visit(InheritanceSentence inheritanceSentence, Scope par) {
        Type subType = inheritanceSentence.getSubType();
        Type resolvedSubType = subType.accept(TypeResolver.INSTANCE, par);
        inheritanceSentence.setSubType(resolvedSubType);
        Type superType = inheritanceSentence.getSuperType();
        Type resolvedSuperType = superType.accept(TypeResolver.INSTANCE, par);
        inheritanceSentence.setSuperType(resolvedSuperType);
        ClassDecl subClassDecl = SentenceResolver.getClassDecl(par, subType, resolvedSubType, "inherit.subtype.not.class", "inherit.subtype.external");
        ClassDecl superClassDecl = SentenceResolver.getClassDecl(par, superType, resolvedSuperType, "inherit.supertype.not.class", "inherit.supertype.external");
        if (subClassDecl != null && superClassDecl != null) {
            Type oldSuperType = subClassDecl.getSuperType();
            if (oldSuperType != null && oldSuperType != PrimitiveType.OBJECT && oldSuperType.accept(ExtractClassDecl.INSTANCE, null) != superClassDecl) {
                String subClassName = subClassDecl.getName();
                String oldSuperTypeDesc = oldSuperType.getDescription();
                Marker error = Marker.error(subType.getPosition(), "inherit.conflict", subClassName, oldSuperTypeDesc);
                Position position = oldSuperType.getPosition();
                if (position != null) {
                    error.note(Marker.note(position, "inherit.declaration.first", subClassName, oldSuperTypeDesc));
                }
                par.report(error);
            } else {
                subClassDecl.setSuperType(resolvedSuperType);
                subClassDecl.setStoredSuperClasses(null);
            }
        }
        return inheritanceSentence;
    }

    private static ClassDecl getClassDecl(Scope par, Type subType, Type resolvedSubType, String notClassError, String externalError) {
        ClassDecl classDecl = resolvedSubType.accept(ExtractClassDecl.INSTANCE, null);
        if (classDecl == null) {
            par.report(Marker.error(subType.getPosition(), notClassError, resolvedSubType.getDescription()));
            return null;
        }
        if (classDecl.getExternal()) {
            par.report(Marker.error(subType.getPosition(), externalError, classDecl.getName()));
            return null;
        }
        return classDecl;
    }

    @Override
    public Sentence visit(CreateSentence createSentence, Scope par) {
        return SentenceResolver.expand(createSentence.getDescriptor(), par).accept(this, par);
    }

    @Override
    public Sentence visit(CallSentence callSentence, Scope par) {
        CallExpr call = callSentence.getCall();
        String name = call.accept(Namer.INSTANCE, null);
        if (name == null) {
            return ExprSentence.of(call).accept(this, par);
        }
        Name actor = callSentence.getActor();
        NameAccess target = NameAccess.of(UnresolvedName.of(name, null));
        WriteSentence writeSentence = WriteSentence.of(actor, call, target);
        return writeSentence.accept(this, par);
    }

    @Override
    public Sentence visit(AnswerSentence answerSentence, Scope par) {
        if (answerSentence.getActor() != null) {
            answerSentence.setActor(answerSentence.getActor().accept(NameResolver.INSTANCE, par));
        }
        answerSentence.setResult(answerSentence.getResult().accept(ExprResolver.INSTANCE, par));
        return answerSentence;
    }

    @Override
    public Sentence visit(WriteSentence writeSentence, Scope par) {
        Expr source = writeSentence.getSource();
        Expr target = writeSentence.getTarget();
        Sentence sentence = target.accept(new AssignmentResolve(par), source);
        if (sentence != null) {
            return sentence;
        }
        par.report(Marker.error(target.getPosition(), "write.target.invalid", target.getClass().getEnclosingClass().getSimpleName()));
        return writeSentence;
    }

    @Override
    public Sentence visit(AddSentence addSentence, Scope par) {
        return SentenceResolver.resolveMutating(addSentence, true, BinaryOperator.PLUS, par, "add.source.type", "add.target.type", "add.target.not.name");
    }

    @Override
    public Sentence visit(RemoveSentence removeSentence, Scope par) {
        return SentenceResolver.resolveMutating(removeSentence, true, BinaryOperator.MINUS, par, "remove.source.type", "remove.target.type", "remove.target.not.name");
    }

    private static Sentence resolveMutating(MutatingSentence sentence, boolean allowLists, BinaryOperator operator, Scope par, String sourceTypeCode, String targetTypeCode, String targetShapeCode) {
        Expr resolvedSource = sentence.getSource().accept(ExprResolver.INSTANCE, par);
        Expr target = sentence.getTarget().accept(ExprResolver.INSTANCE, par);
        sentence.setTarget(target);
        Type targetType = target.getType();
        if (allowLists && !PrimitiveType.isNumeric(targetType) && (targetType != PrimitiveType.STRING || operator != BinaryOperator.PLUS)) {
            sentence.setSource(SentenceResolver.convertAsList(resolvedSource, target, sourceTypeCode, targetTypeCode, par));
            return sentence;
        }
        Expr checkedSource = TypeConversion.convert(resolvedSource, targetType, par, sourceTypeCode);
        sentence.setSource(checkedSource);
        Sentence compoundAssignment = SentenceResolver.compoundAssignment(target, operator, checkedSource, par, sentence.getPosition());
        if (compoundAssignment != null) {
            return compoundAssignment;
        }
        par.report(Marker.error(target.getPosition(), targetShapeCode, target.getClass().getEnclosingClass().getSimpleName()));
        return sentence;
    }

    private static Expr convertAsList(Expr source, Expr target, String invalidSource, String invalidTarget, Scope par) {
        Type targetType = target.getType();
        if (targetType == PrimitiveType.ERROR) {
            return source;
        }
        if (!(targetType instanceof ListType)) {
            Marker error = Marker.error(target.getPosition(), invalidTarget, targetType.getDescription());
            SentenceResolver.addStringLiteralTypoNotes(par, target, error);
            par.report(error);
            return source;
        }
        Type elementType = ((ListType)targetType).getElementType();
        Expr sourceAsElement = TypeConversion.convert(source, elementType);
        if (sourceAsElement != null) {
            return sourceAsElement;
        }
        Expr sourceAsList = TypeConversion.convert(source, targetType);
        if (sourceAsList != null) {
            return sourceAsList;
        }
        Type sourceType = source.getType();
        Marker error = Marker.error(source.getPosition(), invalidSource, sourceType.getDescription(), targetType.getDescription());
        SentenceResolver.addStringLiteralTypoNotes(par, source, error);
        par.report(error);
        return source;
    }

    private static Sentence compoundAssignment(Expr lhs, BinaryOperator operator, Expr rhs, Scope par, Position position) {
        if (lhs instanceof AttributeAccess) {
            AttributeAccess attributeAccess = (AttributeAccess)lhs;
            Expr receiver = attributeAccess.getReceiver();
            Type receiverType = receiver.getType();
            Position receiverPos = receiver.getPosition();
            VarDecl temp = VarDecl.of(SentenceResolver.findUnique("temp++", par), receiverType, receiver);
            temp.setPosition(receiverPos);
            IsSentence isSentence = IsSentence.of(temp);
            isSentence.setPosition(receiverPos);
            NameAccess tempAccess = NameAccess.of(ResolvedName.of(temp));
            tempAccess.setPosition(receiverPos);
            attributeAccess.setReceiver(tempAccess);
            BinaryExpr binaryOp = BinaryExpr.of(attributeAccess, operator, rhs);
            binaryOp.setPosition(position);
            HasSentence hasSentence = HasSentence.of(tempAccess, Collections.singletonList(NamedExpr.of(attributeAccess.getName(), binaryOp)));
            hasSentence.setPosition(attributeAccess.getPosition());
            return new FlattenSentenceList(Arrays.asList(isSentence, hasSentence));
        }
        if (lhs instanceof NameAccess) {
            Decl decl = ((NameAccess)lhs).getName().getDecl();
            AssignSentence assignSentence = AssignSentence.of(decl, operator, rhs);
            assignSentence.setPosition(position);
            return assignSentence;
        }
        return null;
    }

    @Override
    public Sentence visit(TakeSentence takeSentence, Scope par) {
        Type type;
        String exampleName;
        Expr example = takeSentence.getExample();
        if (example != null) {
            example = example.accept(ExprResolver.INSTANCE, par);
            exampleName = example.accept(Namer.INSTANCE, null);
            takeSentence.setExample(example);
        } else {
            exampleName = null;
        }
        Expr collection = takeSentence.getCollection().accept(ExprResolver.INSTANCE, par);
        takeSentence.setCollection(collection);
        Type listType = collection.getType();
        if (listType instanceof ListType) {
            type = ((ListType)listType).getElementType();
        } else {
            if (listType != PrimitiveType.ERROR) {
                par.report(Marker.error(collection.getPosition(), "take.source.type", listType.getDescription()));
            }
            type = PrimitiveType.ERROR;
        }
        Decl varDecl = SentenceResolver.resolveVar(takeSentence, par, exampleName, type);
        HashMap<String, Decl> decls = new HashMap<String, Decl>();
        decls.put(varDecl.getName(), varDecl);
        decls.put(exampleName, varDecl);
        ExtendingScope scope = new ExtendingScope(decls, par);
        takeSentence.setBody(takeSentence.getBody().accept(this, scope));
        return takeSentence;
    }

    private static Decl resolveVar(TakeSentence takeSentence, Scope par, String exampleName, Type type) {
        String varName;
        Name name = takeSentence.getVarName();
        if (name != null) {
            Decl decl = name.getDecl();
            if (decl != null) {
                return decl;
            }
            varName = name.getValue();
        } else {
            varName = exampleName != null ? exampleName : SentenceResolver.findUnique("i++", par);
        }
        VarDecl varDecl = VarDecl.of(varName, type, null);
        takeSentence.setVarName(ResolvedName.of(varDecl));
        return varDecl;
    }

    @Override
    public Sentence visit(ConditionalSentence conditionalSentence, Scope par) {
        Expr condition = conditionalSentence.getCondition();
        Expr resolvedCondition = condition.accept(ExprResolver.INSTANCE, par);
        Expr checkedCondition = ExprResolver.checkConditional(resolvedCondition, par);
        conditionalSentence.setCondition(checkedCondition);
        conditionalSentence.setBody(conditionalSentence.getBody().accept(this, par));
        return conditionalSentence;
    }

    @Override
    public Sentence visit(AssignSentence assignSentence, Scope par) {
        Expr expr = assignSentence.getValue().accept(ExprResolver.INSTANCE, par);
        Decl target = assignSentence.getTarget();
        assignSentence.setValue(SentenceResolver.checkAssignment(expr, target, false, par));
        return assignSentence;
    }

    private static Expr checkAssignment(Expr expr, Decl target, boolean isNew, Scope par) {
        Type targetType = target.getType();
        Expr converted = TypeConversion.convert(expr, targetType);
        if (converted != null) {
            return converted;
        }
        Type exprType = expr.getType();
        Marker error = Marker.error(expr.getPosition(), "assign.type", exprType.getDescription(), target.getName(), targetType.getDescription());
        if (!isNew) {
            error.note(Marker.note(target.getPosition(), "variable.declaration.first", target.getName()));
        }
        par.report(error);
        return expr;
    }

    @Override
    public Sentence visit(ExprSentence exprSentence, Scope par) {
        exprSentence.setExpr(exprSentence.getExpr().accept(ExprResolver.INSTANCE, par));
        return exprSentence;
    }
}

