/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.ast.decl;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.fulib.scenarios.ast.ScenarioGroup;
import org.fulib.scenarios.ast.decl.AssociationDecl;
import org.fulib.scenarios.ast.decl.AttributeDecl;
import org.fulib.scenarios.ast.decl.ClassDecl;
import org.fulib.scenarios.ast.decl.LazyType;
import org.fulib.scenarios.ast.decl.MethodDecl;
import org.fulib.scenarios.ast.scope.GlobalScope;
import org.fulib.scenarios.ast.type.ListType;
import org.fulib.scenarios.ast.type.Type;
import org.fulib.scenarios.visitor.ExtractClassDecl;
import org.fulib.scenarios.visitor.resolve.TypeResolver;

public class ExternalClassDecl
extends ClassDecl.Impl {
    private final Object attributesLock = new Object();
    private volatile boolean attributesResolved = true;
    private final LazyType superType = new LazyType();

    public ExternalClassDecl() {
    }

    public ExternalClassDecl(ScenarioGroup group, String name, Type type, Type superType, Map<String, AttributeDecl> attributes, Map<String, AssociationDecl> associations, List<MethodDecl> methods) {
        super(group, name, type, superType, attributes, associations, methods);
    }

    public void markUnresolved() {
        this.attributesResolved = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveAttributes() {
        if (!this.attributesResolved) {
            Object object = this.attributesLock;
            synchronized (object) {
                if (!this.attributesResolved) {
                    this.filterAttributes();
                    this.attributesResolved = true;
                }
            }
        }
    }

    private void filterAttributes() {
        ScenarioGroup group = this.getGroup();
        GlobalScope scope = new GlobalScope(group.getContext());
        Iterator<AttributeDecl> iterator = super.getAttributes().values().iterator();
        while (iterator.hasNext()) {
            AttributeDecl attribute = iterator.next();
            Type type = attribute.getType().accept(TypeResolver.INSTANCE, scope);
            ClassDecl otherClass = type.accept(ExtractClassDecl.INSTANCE, null);
            if (otherClass == null || otherClass.getGroup() != group) {
                attribute.setType(type);
                continue;
            }
            int cardinality = type instanceof ListType ? 42 : 1;
            String name = attribute.getName();
            AssociationDecl assoc = AssociationDecl.of(this, name, cardinality, otherClass, type, null);
            iterator.remove();
            super.getAssociations().put(name, assoc);
        }
    }

    @Override
    public Type getSuperType() {
        return this.superType.get(this.getGroup().getContext());
    }

    @Override
    public void setSuperType(Type superType) {
        this.superType.set(superType);
    }

    @Override
    public Map<String, AttributeDecl> getAttributes() {
        this.resolveAttributes();
        return super.getAttributes();
    }

    @Override
    public Map<String, AssociationDecl> getAssociations() {
        this.resolveAttributes();
        return super.getAssociations();
    }
}

