/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.parser;

import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.fulib.StrUtil;
import org.fulib.scenarios.ast.decl.Name;
import org.fulib.scenarios.ast.decl.UnresolvedName;
import org.fulib.scenarios.parser.ASTListener;
import org.fulib.scenarios.parser.ScenarioParser;

public class Identifiers {
    public static String toUpperCamelCase(String text) {
        return Identifiers.joinCaps(Identifiers.splitCaps(text));
    }

    public static String toLowerCamelCase(String text) {
        return StrUtil.downFirstChar((String)Identifiers.toUpperCamelCase(text));
    }

    private static Stream<String> splitCaps(String text) {
        return Arrays.stream(text.split("[\\W_]+"));
    }

    private static String joinCaps(Stream<String> stream) {
        return stream.map(StrUtil::cap).collect(Collectors.joining());
    }

    static String joinCaps(ScenarioParser.SimpleNameContext simpleName) {
        return Identifiers.joinCaps(Identifiers.splitCaps(simpleName.identifier().getText()));
    }

    static String joinCaps(ScenarioParser.NameContext name) {
        return Identifiers.joinCaps(name.children.stream().map(ParseTree::getText).flatMap(Identifiers::splitCaps));
    }

    static String varName(ScenarioParser.SimpleNameContext simpleName) {
        return simpleName == null ? null : StrUtil.downFirstChar((String)Identifiers.joinCaps(simpleName));
    }

    static String varName(ScenarioParser.NameContext name) {
        return name == null ? null : StrUtil.downFirstChar((String)Identifiers.joinCaps(name));
    }

    static Name name(ScenarioParser.SimpleNameContext simpleName) {
        return simpleName == null ? null : Identifiers.name(Identifiers.varName(simpleName), simpleName);
    }

    static Name name(ScenarioParser.NameContext name) {
        return name == null ? null : Identifiers.name(Identifiers.varName(name), name);
    }

    private static Name name(String value, ParserRuleContext rule) {
        String text = ASTListener.inputText((ParseTree)rule);
        UnresolvedName name = UnresolvedName.of(value, text);
        name.setPosition(ASTListener.position(rule));
        return name;
    }
}

