/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.scenarios.visitor.resolve;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.function.BiConsumer;
import org.fulib.scenarios.ast.CompilationContext;
import org.fulib.scenarios.ast.Scenario;
import org.fulib.scenarios.ast.ScenarioFile;
import org.fulib.scenarios.ast.ScenarioGroup;
import org.fulib.scenarios.ast.decl.AssociationDecl;
import org.fulib.scenarios.ast.decl.AttributeDecl;
import org.fulib.scenarios.ast.decl.ClassDecl;
import org.fulib.scenarios.ast.decl.Decl;
import org.fulib.scenarios.ast.decl.MethodDecl;
import org.fulib.scenarios.ast.decl.Name;
import org.fulib.scenarios.ast.decl.ParameterDecl;
import org.fulib.scenarios.ast.decl.ResolvedName;
import org.fulib.scenarios.ast.decl.UnresolvedName;
import org.fulib.scenarios.ast.scope.DelegatingScope;
import org.fulib.scenarios.ast.scope.ExtendingScope;
import org.fulib.scenarios.ast.scope.GlobalScope;
import org.fulib.scenarios.ast.scope.GroupScope;
import org.fulib.scenarios.ast.scope.Scope;
import org.fulib.scenarios.ast.type.ClassType;
import org.fulib.scenarios.ast.type.PrimitiveType;
import org.fulib.scenarios.diagnostic.Marker;
import org.fulib.scenarios.diagnostic.Position;
import org.fulib.scenarios.parser.Identifiers;
import org.fulib.scenarios.visitor.resolve.DeclResolver;
import org.fulib.scenarios.visitor.resolve.SentenceResolver;
import org.fulib.util.Validator;

public enum NameResolver implements CompilationContext.Visitor<Object, Object>,
ScenarioGroup.Visitor<Scope, Object>,
ScenarioFile.Visitor<Scope, Object>,
Scenario.Visitor<Scope, Object>,
Name.Visitor<Scope, Name>
{
    INSTANCE;

    protected static final String PREDICATE_RECEIVER = "<predicate-receiver>";
    protected static final String ANSWER_VAR = "<answer-var>";

    @Override
    public Object visit(CompilationContext compilationContext, Object par) {
        GlobalScope globalScope = new GlobalScope(compilationContext);
        ArrayList<ScenarioGroup> groups = new ArrayList<ScenarioGroup>(compilationContext.getGroups().values());
        groups.parallelStream().forEach(it -> it.accept(this, globalScope));
        return null;
    }

    @Override
    public Object visit(ScenarioGroup scenarioGroup, Scope par) {
        GroupScope scope = new GroupScope(par, scenarioGroup);
        for (ScenarioFile file : scenarioGroup.getFiles().values()) {
            if (file.getExternal()) continue;
            file.accept(this, scope);
        }
        return null;
    }

    @Override
    public Object visit(final ScenarioFile scenarioFile, Scope par) {
        ScenarioGroup group = scenarioFile.getGroup();
        final String className = Identifiers.toUpperCamelCase(scenarioFile.getName()) + "Test";
        final ClassDecl classDecl = ClassDecl.of(group, className, null, PrimitiveType.OBJECT, new LinkedHashMap<String, AttributeDecl>(), new LinkedHashMap<String, AssociationDecl>(), new ArrayList<MethodDecl>());
        classDecl.setExternal(scenarioFile.getExternal());
        classDecl.setType(ClassType.of(classDecl));
        scenarioFile.setClassDecl(classDecl);
        DelegatingScope scope = new DelegatingScope(par){

            @Override
            public Decl resolve(String name) {
                return className.equals(name) || "<enclosing:class>".equals(name) ? classDecl : super.resolve(name);
            }

            @Override
            public void list(BiConsumer<? super String, ? super Decl> consumer) {
                consumer.accept(className, classDecl);
                consumer.accept("<enclosing:class>", classDecl);
                super.list(consumer);
            }

            @Override
            public void report(Marker marker) {
                scenarioFile.getMarkers().add(marker);
            }
        };
        for (Scenario scenario : scenarioFile.getScenarios()) {
            scenario.accept(this, scope);
        }
        return null;
    }

    @Override
    public Object visit(Scenario scenario, Scope par) {
        ParameterDecl thisParam;
        Position position;
        MethodDecl methodDecl;
        ClassDecl classDecl = scenario.getFile().getClassDecl();
        String methodName = Identifiers.toLowerCamelCase(scenario.getName());
        if (!Validator.isSimpleName((String)methodName)) {
            methodName = "_" + methodName;
        }
        if ((methodDecl = DeclResolver.resolveMethod(par, position = scenario.getPosition(), classDecl, methodName)).getParameters().isEmpty()) {
            thisParam = ParameterDecl.of(methodDecl, "this", classDecl.getType());
            thisParam.setPosition(position);
            methodDecl.getParameters().add(thisParam);
            methodDecl.setType(PrimitiveType.VOID);
        } else {
            thisParam = methodDecl.getParameters().get(0);
        }
        scenario.setMethodDecl(methodDecl);
        ExtendingScope scope = new ExtendingScope(new Decl[]{thisParam, methodDecl}, par);
        scenario.getBody().accept(SentenceResolver.INSTANCE, scope);
        methodDecl.getBody().getItems().addAll(scenario.getBody().getItems());
        return null;
    }

    @Override
    public Name visit(Name name, Scope par) {
        return name;
    }

    @Override
    public Name visit(ResolvedName resolvedName, Scope par) {
        return resolvedName;
    }

    @Override
    public Name visit(UnresolvedName unresolvedName, Scope par) {
        Decl decl = par.resolve(unresolvedName.getValue());
        return decl == null ? unresolvedName : ResolvedName.of(decl);
    }
}

