/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.patterns;

import java.util.function.Predicate;
import org.fulib.patterns.model.AttributeConstraint;
import org.fulib.patterns.model.MatchConstraint;
import org.fulib.patterns.model.Pattern;
import org.fulib.patterns.model.PatternObject;
import org.fulib.patterns.model.RoleObject;

public class PatternBuilder {
    private String packageName;
    private final Pattern pattern;

    public PatternBuilder(String packageName) {
        this.packageName = packageName;
        this.pattern = new Pattern();
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public PatternObject buildPatternObject(String name) {
        PatternObject patternObject = new PatternObject().setName(name);
        this.pattern.withObjects(patternObject);
        return patternObject;
    }

    public PatternBuilder buildPatternLink(PatternObject src, String srcRoleName, String tgtRoleName, PatternObject tgt) {
        RoleObject srcRole = new RoleObject().setName(srcRoleName).setObject(src).setPattern(this.pattern);
        new RoleObject().setName(tgtRoleName).setObject(tgt).setOther(srcRole).setPattern(this.pattern);
        return this;
    }

    public PatternBuilder buildAttibuteConstraint(Predicate predicate, PatternObject object) {
        AttributeConstraint constraint = new AttributeConstraint().setPredicate(predicate).setObject(object).setPattern(this.pattern);
        return this;
    }

    public PatternBuilder buildMatchConstraint(Predicate predicate, PatternObject ... objects) {
        MatchConstraint constraint = new MatchConstraint().setPredicate(predicate).withObjects(objects).setPattern(this.pattern);
        return this;
    }
}

