/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.patterns;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.fulib.patterns.model.AttributeConstraint;
import org.fulib.patterns.model.MatchConstraint;
import org.fulib.patterns.model.Pattern;
import org.fulib.patterns.model.PatternObject;
import org.fulib.patterns.model.RoleObject;
import org.fulib.tables.ObjectTable;

public class PatternMatcher {
    private Pattern pattern;
    private LinkedHashMap<PatternObject, ObjectTable> object2TableMap;

    public LinkedHashMap<PatternObject, ObjectTable> getObject2TableMap() {
        return this.object2TableMap;
    }

    public PatternMatcher(Pattern pattern) {
        this.pattern = pattern;
    }

    public ObjectTable match(String patternObjectName, Object ... startObjects) {
        ArrayList roles = (ArrayList)this.pattern.getRoles().clone();
        ArrayList attributeConstraints = (ArrayList)this.pattern.getAttributeConstraints().clone();
        ArrayList matchConstraints = (ArrayList)this.pattern.getMatchConstraints().clone();
        ObjectTable result = new ObjectTable(patternObjectName, startObjects);
        PatternObject current = this.pattern.getObjects(patternObjectName);
        this.object2TableMap = new LinkedHashMap();
        this.object2TableMap.put(current, result);
        while (!(roles.isEmpty() && attributeConstraints.isEmpty() && matchConstraints.isEmpty())) {
            if (this.checkAttributeConstraint(attributeConstraints, this.object2TableMap) || this.checkMatchConstraint(matchConstraints, this.object2TableMap) || this.checkHasLink(roles, this.object2TableMap) || !this.expandByRole(roles, this.object2TableMap)) continue;
        }
        return result;
    }

    private boolean checkAttributeConstraint(ArrayList<AttributeConstraint> attributeConstraints, LinkedHashMap<PatternObject, ObjectTable> object2TableMap) {
        for (AttributeConstraint constraint : attributeConstraints) {
            PatternObject src = constraint.getObject();
            ObjectTable srcTable = object2TableMap.get(src);
            if (srcTable == null) continue;
            ObjectTable nextTable = srcTable.filter(constraint.predicate);
            attributeConstraints.remove(constraint);
            return true;
        }
        return false;
    }

    private boolean checkMatchConstraint(ArrayList<MatchConstraint> matchConstraints, LinkedHashMap<PatternObject, ObjectTable> object2TableMap) {
        block0: for (MatchConstraint constraint : matchConstraints) {
            for (PatternObject patternObject : constraint.getObjects()) {
                ObjectTable srcTable = object2TableMap.get(patternObject);
                if (srcTable != null) continue;
                continue block0;
            }
            object2TableMap.get(constraint.getObjects().get(0)).filterRow(constraint.predicate);
            matchConstraints.remove(constraint);
            return true;
        }
        return false;
    }

    private boolean checkHasLink(ArrayList<RoleObject> roles, LinkedHashMap<PatternObject, ObjectTable> object2TableMap) {
        for (RoleObject role : roles) {
            RoleObject otherRole;
            PatternObject tgt;
            ObjectTable tgtTable;
            PatternObject src = role.getObject();
            ObjectTable srcTable = object2TableMap.get(src);
            if (srcTable == null || (tgtTable = object2TableMap.get(tgt = (otherRole = role.getOther()).getObject())) == null) continue;
            ObjectTable nextTable = srcTable.hasLink(otherRole.getName(), tgtTable);
            roles.remove(role);
            roles.remove(otherRole);
            return true;
        }
        return false;
    }

    private boolean expandByRole(ArrayList<RoleObject> roles, LinkedHashMap<PatternObject, ObjectTable> object2TableMap) {
        for (RoleObject role : roles) {
            PatternObject src = role.getObject();
            ObjectTable srcTable = object2TableMap.get(src);
            if (srcTable == null) continue;
            RoleObject otherRole = role.getOther();
            PatternObject tgt = otherRole.getObject();
            ObjectTable nextTable = srcTable.expandLink(tgt.getName(), otherRole.getName());
            object2TableMap.put(tgt, nextTable);
            roles.remove(role);
            roles.remove(otherRole);
            return true;
        }
        return false;
    }
}

