/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.tables;

import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.fulib.tables.AttrChangeListener;
import org.fulib.tables.HasLinkChangeListener;
import org.fulib.tables.IncrementalDoubleTable;
import org.fulib.tables.IncrementalTable;
import org.fulib.tables.ListeningTable;
import org.fulib.tables.StringTable;
import org.fulib.tables.floatTable;
import org.fulib.tables.intTable;
import org.fulib.tables.longTable;
import org.fulib.yaml.Reflector;
import org.fulib.yaml.ReflectorMap;

public class IncrementalObjectTable
extends IncrementalTable {
    private String columnName = null;

    public IncrementalObjectTable(Object ... start) {
        this("A", start);
    }

    public IncrementalObjectTable(String colName, Object ... start) {
        this.setTable(new ArrayList<ArrayList<Object>>());
        this.setListeningTable(new ListeningTable(this, this.getTable()));
        this.getAllObjectTables().add(this);
        this.setAllListeningTables(new ArrayList<ListeningTable>());
        this.setAllListeningTables(this.getAllObjectTables().get(0).getAllListeningTables());
        this.getAllListeningTables().add(this.getListeningTable());
        this.setColumnName(colName);
        this.getColumnMap().put(colName, 0);
        for (Object current : start) {
            ArrayList<Object> row = new ArrayList<Object>();
            row.add(current);
            this.getListeningTable().addRow(row);
            if (this.getReflectorMap() != null) continue;
            this.setReflectorMap(new ReflectorMap(current.getClass().getPackage().getName()));
        }
    }

    public String getColumnName() {
        return this.columnName;
    }

    public IncrementalObjectTable setColumnName(String value) {
        this.columnName = value;
        return this;
    }

    public IncrementalObjectTable expandLink(String newColumnName, String linkName) {
        IncrementalObjectTable result = new IncrementalObjectTable(new Object[0]);
        this.getAllObjectTables().add(result);
        result.setAllObjectTables(this.getAllObjectTables());
        result.setAllListeningTables(this.getAllListeningTables());
        result.getAllListeningTables().add(result.getListeningTable());
        result.setColumnMap(this.getColumnMap());
        result.setReflectorMap(this.getReflectorMap());
        int newColumnNumber = this.getTable().size() > 0 ? this.getTable().get(0).size() : 0;
        result.setColumnName(newColumnName);
        this.getColumnMap().put(newColumnName, newColumnNumber);
        ListeningTable oldListeningTable = this.getListeningTable();
        ArrayList oldTable = (ArrayList)this.getTable().clone();
        ListeningTable targetTable = result.getListeningTable();
        this.updateAllObjectTables(targetTable);
        oldListeningTable.setTargetTable(targetTable);
        targetTable.setColumnAndLink(this.columnName, linkName);
        for (ArrayList row : oldTable) {
            this.addRowsForLink(linkName, this.getColumnName(), this.getListeningTable(), oldListeningTable, row);
        }
        return result;
    }

    public IncrementalDoubleTable expandDouble(String newColumnName, String attrName) {
        IncrementalDoubleTable result = new IncrementalDoubleTable(new Double[0]);
        this.getAllObjectTables().add(result);
        result.setAllObjectTables(this.getAllObjectTables());
        result.setAllListeningTables(this.getAllListeningTables());
        result.getAllListeningTables().add(result.getListeningTable());
        result.setColumnMap(this.getColumnMap());
        result.setReflectorMap(this.getReflectorMap());
        int newColumnNumber = this.getTable().size() > 0 ? this.getTable().get(0).size() : 0;
        result.setColumnName(newColumnName);
        this.getColumnMap().put(newColumnName, newColumnNumber);
        ListeningTable oldListeningTable = this.getListeningTable();
        ArrayList oldTable = (ArrayList)this.getTable().clone();
        ListeningTable targetTable = result.getListeningTable();
        this.updateAllObjectTables(targetTable);
        oldListeningTable.setTargetTable(targetTable);
        targetTable.setColumnAndLink(this.columnName, attrName);
        for (ArrayList row : oldTable) {
            Object start = row.get(this.getColumnMap().get(this.getColumnName()));
            Reflector reflector = this.getReflectorMap().getReflector(start);
            Object value = reflector.getValue(start, attrName);
            ArrayList newRow = (ArrayList)row.clone();
            newRow.add(value);
            this.getTable().add(newRow);
            AttrChangeListener attrChangeListener = new AttrChangeListener(start, row, newRow, targetTable);
            oldListeningTable.getRowListeners().put(row, attrChangeListener);
            try {
                Method addPropertyChangeListenerMethod = start.getClass().getMethod("addPropertyChangeListener", String.class, PropertyChangeListener.class);
                addPropertyChangeListenerMethod.invoke(start, attrName, attrChangeListener);
            }
            catch (Exception e) {
                Logger.getGlobal().log(Level.SEVERE, "could not add property change listener to " + start, e);
            }
        }
        return result;
    }

    public IncrementalObjectTable hasLink(String linkName, IncrementalObjectTable rowName) {
        ListeningTable oldListeningTable = this.getListeningTable();
        ArrayList oldTable = (ArrayList)this.getTable().clone();
        this.setTable(new ArrayList<ArrayList<Object>>());
        ListeningTable targetTable = new ListeningTable(this, this.getTable());
        this.updateAllObjectTables(targetTable);
        oldListeningTable.setTargetTable(targetTable);
        targetTable.setColumnAndLink(this.columnName, linkName);
        for (ArrayList row : oldTable) {
            Object start = row.get(this.getColumnMap().get(this.getColumnName()));
            Object other = row.get(this.getColumnMap().get(rowName.getColumnName()));
            Reflector reflector = this.getReflectorMap().getReflector(start);
            Object value = reflector.getValue(start, linkName);
            HasLinkChangeListener hasLinkChangeListener = new HasLinkChangeListener(start, other, row, targetTable);
            try {
                Method addPropertyChangeListenerMethod = start.getClass().getMethod("addPropertyChangeListener", String.class, PropertyChangeListener.class);
                addPropertyChangeListenerMethod.invoke(start, linkName, hasLinkChangeListener);
            }
            catch (Exception e) {
                Logger.getGlobal().log(Level.SEVERE, "could not add property change listener to " + start, e);
            }
            oldListeningTable.getRowListeners().put(row, hasLinkChangeListener);
            if ((!(value instanceof Collection) || !((Collection)value).contains(other)) && value != other) continue;
            this.getTable().add(row);
        }
        return this;
    }

    public floatTable expandFloat(String newColumnName, String attrName) {
        floatTable result = new floatTable(new Float[0]);
        result.setColumnMap(this.getColumnMap());
        result.setTable(this.getTable());
        int newColumnNumber = this.getTable().size() > 0 ? this.getTable().get(0).size() : 0;
        result.setColumnName(newColumnName);
        this.getColumnMap().put(newColumnName, newColumnNumber);
        ArrayList oldTable = (ArrayList)this.getTable().clone();
        this.getTable().clear();
        for (ArrayList row : oldTable) {
            Object start = row.get(this.getColumnMap().get(this.getColumnName()));
            Reflector reflector = this.getReflectorMap().getReflector(start);
            Object value = reflector.getValue(start, attrName);
            ArrayList newRow = (ArrayList)row.clone();
            newRow.add(value);
            this.getTable().add(newRow);
        }
        return result;
    }

    public intTable expandInt(String newColumnName, String attrName) {
        intTable result = new intTable(new Integer[0]);
        result.setColumnMap(this.getColumnMap());
        result.setTable(this.getTable());
        int newColumnNumber = this.getTable().size() > 0 ? this.getTable().get(0).size() : 0;
        result.setColumnName(newColumnName);
        this.getColumnMap().put(newColumnName, newColumnNumber);
        ArrayList oldTable = (ArrayList)this.getTable().clone();
        this.getTable().clear();
        for (ArrayList row : oldTable) {
            Object start = row.get(this.getColumnMap().get(this.getColumnName()));
            Reflector reflector = this.getReflectorMap().getReflector(start);
            Object value = reflector.getValue(start, attrName);
            ArrayList newRow = (ArrayList)row.clone();
            newRow.add(value);
            this.getTable().add(newRow);
        }
        return result;
    }

    public longTable expandLong(String newColumnName, String attrName) {
        longTable result = new longTable(new Long[0]);
        result.setColumnMap(this.getColumnMap());
        result.setTable(this.getTable());
        int newColumnNumber = this.getTable().size() > 0 ? this.getTable().get(0).size() : 0;
        result.setColumnName(newColumnName);
        this.getColumnMap().put(newColumnName, newColumnNumber);
        ArrayList oldTable = (ArrayList)this.getTable().clone();
        this.getTable().clear();
        for (ArrayList row : oldTable) {
            Object start = row.get(this.getColumnMap().get(this.getColumnName()));
            Reflector reflector = this.getReflectorMap().getReflector(start);
            Object value = reflector.getValue(start, attrName);
            ArrayList newRow = (ArrayList)row.clone();
            newRow.add(value);
            this.getTable().add(newRow);
        }
        return result;
    }

    public StringTable expandString(String newColumnName, String attrName) {
        StringTable result = new StringTable(new String[0]);
        result.setColumnMap(this.getColumnMap());
        result.setTable(this.getTable());
        int newColumnNumber = this.getTable().size() > 0 ? this.getTable().get(0).size() : 0;
        result.setColumnName(newColumnName);
        this.getColumnMap().put(newColumnName, newColumnNumber);
        ArrayList oldTable = (ArrayList)this.getTable().clone();
        this.getTable().clear();
        for (ArrayList row : oldTable) {
            Object start = row.get(this.getColumnMap().get(this.getColumnName()));
            Reflector reflector = this.getReflectorMap().getReflector(start);
            Object value = reflector.getValue(start, attrName);
            ArrayList newRow = (ArrayList)row.clone();
            newRow.add(value);
            this.getTable().add(newRow);
        }
        return result;
    }

    public void addColumn(String columnName, Function<LinkedHashMap<String, Object>, Object> function) {
        int newColumnNumber = this.getTable().size() > 0 ? this.getTable().get(0).size() : 0;
        for (ArrayList<Object> row : this.getTable()) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            for (String key : this.getColumnMap().keySet()) {
                map.put(key, row.get(this.getColumnMap().get(key)));
            }
            Object result = function.apply(map);
            row.add(result);
        }
        this.getColumnMap().put(columnName, newColumnNumber);
    }

    public IncrementalObjectTable dropColumns(String ... columnNames) {
        LinkedHashMap oldColumnMap = (LinkedHashMap)this.getColumnMap().clone();
        this.getColumnMap().clear();
        LinkedHashSet<String> dropNames = new LinkedHashSet<String>();
        dropNames.addAll(Arrays.asList(columnNames));
        int i = 0;
        for (String name : oldColumnMap.keySet()) {
            if (dropNames.contains(name)) continue;
            this.getColumnMap().put(name, i);
            ++i;
        }
        ArrayList oldTable = (ArrayList)this.getTable().clone();
        this.getTable().clear();
        LinkedHashSet rowSet = new LinkedHashSet();
        for (ArrayList row : oldTable) {
            ArrayList newRow = new ArrayList();
            for (String name : this.getColumnMap().keySet()) {
                Object value = row.get((Integer)oldColumnMap.get(name));
                newRow.add(value);
            }
            if (!rowSet.add(newRow)) continue;
            this.getTable().add(newRow);
        }
        return this;
    }

    public IncrementalObjectTable selectColumns(String ... columnNames) {
        LinkedHashMap oldColumnMap = (LinkedHashMap)this.getColumnMap().clone();
        this.getColumnMap().clear();
        int i = 0;
        for (String name : columnNames) {
            if (oldColumnMap.get(name) == null) {
                throw new IllegalArgumentException("unknown column name: " + name);
            }
            this.getColumnMap().put(name, i);
            ++i;
        }
        ArrayList oldTable = (ArrayList)this.getTable().clone();
        this.getTable().clear();
        LinkedHashSet rowSet = new LinkedHashSet();
        for (ArrayList row : oldTable) {
            ArrayList newRow = new ArrayList();
            for (String name : columnNames) {
                Object value = row.get((Integer)oldColumnMap.get(name));
                newRow.add(value);
            }
            if (!rowSet.add(newRow)) continue;
            this.getTable().add(newRow);
        }
        return this;
    }

    public IncrementalObjectTable filter(Predicate<Object> predicate) {
        ArrayList oldTable = (ArrayList)this.getTable().clone();
        this.getTable().clear();
        for (ArrayList row : oldTable) {
            Object start = row.get(this.getColumnMap().get(this.getColumnName()));
            if (!predicate.test(start)) continue;
            this.getTable().add(row);
        }
        return this;
    }

    public IncrementalObjectTable filterRow(Predicate<LinkedHashMap<String, Object>> predicate) {
        ArrayList oldTable = (ArrayList)this.getTable().clone();
        this.getTable().clear();
        for (ArrayList row : oldTable) {
            LinkedHashMap map = new LinkedHashMap();
            for (String key : this.getColumnMap().keySet()) {
                map.put(key, row.get(this.getColumnMap().get(key)));
            }
            if (!predicate.test(map)) continue;
            this.getTable().add(row);
        }
        return this;
    }

    public LinkedHashSet<Object> toSet() {
        LinkedHashSet<Object> result = new LinkedHashSet<Object>();
        for (ArrayList<Object> row : this.getTable()) {
            Object value = row.get(this.getColumnMap().get(this.columnName));
            result.add(value);
        }
        return result;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("| ");
        for (String string : this.getColumnMap().keySet()) {
            buf.append(string).append(" \t| ");
        }
        buf.append("\n| ");
        for (String string : this.getColumnMap().keySet()) {
            buf.append(" --- \t| ");
        }
        buf.append("\n");
        for (ArrayList arrayList : this.getTable()) {
            buf.append("| ");
            for (Object cell : arrayList) {
                buf.append(cell).append(" \t| ");
            }
            buf.append("\n");
        }
        buf.append("\n");
        return buf.toString();
    }
}

