/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.tables;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.function.Function;
import java.util.function.Predicate;
import org.fulib.tables.StringTable;
import org.fulib.tables.doubleTable;
import org.fulib.tables.floatTable;
import org.fulib.tables.intTable;
import org.fulib.tables.longTable;
import org.fulib.yaml.Reflector;
import org.fulib.yaml.ReflectorMap;

public class ObjectTable {
    private ReflectorMap reflectorMap;
    private ArrayList<ArrayList<Object>> table = new ArrayList();
    private String columnName = null;
    private LinkedHashMap<String, Integer> columnMap = new LinkedHashMap();

    public ObjectTable(Object ... start) {
        this("A", start);
    }

    public ObjectTable(String colName, Object ... start) {
        this.setColumnName(colName);
        this.columnMap.put(colName, 0);
        for (Object current : start) {
            ArrayList<Object> row = new ArrayList<Object>();
            row.add(current);
            this.table.add(row);
            if (this.reflectorMap != null) continue;
            this.reflectorMap = new ReflectorMap(current.getClass().getPackage().getName());
        }
    }

    public ReflectorMap getReflectorMap() {
        return this.reflectorMap;
    }

    public void setReflectorMap(ReflectorMap reflectorMap) {
        this.reflectorMap = reflectorMap;
    }

    public ArrayList<ArrayList<Object>> getTable() {
        return this.table;
    }

    public ObjectTable setTable(ArrayList<ArrayList<Object>> value) {
        this.table = value;
        return this;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public ObjectTable setColumnName(String value) {
        this.columnName = value;
        return this;
    }

    public LinkedHashMap<String, Integer> getColumnMap() {
        return this.columnMap;
    }

    public ObjectTable setColumnMap(LinkedHashMap<String, Integer> value) {
        this.columnMap = value;
        return this;
    }

    public ObjectTable expandLink(String newColumnName, String linkName) {
        ObjectTable result = new ObjectTable(new Object[0]);
        result.setColumnMap(this.columnMap);
        result.setTable(this.table);
        result.setReflectorMap(this.reflectorMap);
        int newColumnNumber = this.table.size() > 0 ? this.table.get(0).size() : 0;
        result.setColumnName(newColumnName);
        this.columnMap.put(newColumnName, newColumnNumber);
        ArrayList oldTable = (ArrayList)this.table.clone();
        this.table.clear();
        for (ArrayList row : oldTable) {
            Object start = row.get(this.columnMap.get(this.getColumnName()));
            Reflector reflector = this.reflectorMap.getReflector(start);
            Object value = reflector.getValue(start, linkName);
            if (value instanceof Collection) {
                for (Object current : (Collection)value) {
                    ArrayList newRow = (ArrayList)row.clone();
                    newRow.add(current);
                    this.table.add(newRow);
                }
                continue;
            }
            if (value == null) continue;
            ArrayList newRow = (ArrayList)row.clone();
            newRow.add(value);
            this.table.add(newRow);
        }
        return result;
    }

    public ObjectTable hasLink(String linkName, ObjectTable rowName) {
        ArrayList oldTable = (ArrayList)this.table.clone();
        this.table.clear();
        for (ArrayList row : oldTable) {
            Object start = row.get(this.columnMap.get(this.getColumnName()));
            Object other = row.get(this.columnMap.get(rowName.getColumnName()));
            Reflector reflector = this.reflectorMap.getReflector(start);
            Object value = reflector.getValue(start, linkName);
            if ((!(value instanceof Collection) || !((Collection)value).contains(other)) && value != other) continue;
            this.table.add(row);
        }
        return this;
    }

    public doubleTable expandDouble(String newColumnName, String attrName) {
        doubleTable result = new doubleTable(new Double[0]);
        result.setColumnMap(this.columnMap);
        result.setTable(this.table);
        int newColumnNumber = this.table.size() > 0 ? this.table.get(0).size() : 0;
        result.setColumnName(newColumnName);
        this.columnMap.put(newColumnName, newColumnNumber);
        ArrayList oldTable = (ArrayList)this.table.clone();
        this.table.clear();
        for (ArrayList row : oldTable) {
            Object start = row.get(this.columnMap.get(this.getColumnName()));
            Reflector reflector = this.reflectorMap.getReflector(start);
            Object value = reflector.getValue(start, attrName);
            ArrayList newRow = (ArrayList)row.clone();
            newRow.add(value);
            this.table.add(newRow);
        }
        return result;
    }

    public floatTable expandFloat(String newColumnName, String attrName) {
        floatTable result = new floatTable(new Float[0]);
        result.setColumnMap(this.columnMap);
        result.setTable(this.table);
        int newColumnNumber = this.table.size() > 0 ? this.table.get(0).size() : 0;
        result.setColumnName(newColumnName);
        this.columnMap.put(newColumnName, newColumnNumber);
        ArrayList oldTable = (ArrayList)this.table.clone();
        this.table.clear();
        for (ArrayList row : oldTable) {
            Object start = row.get(this.columnMap.get(this.getColumnName()));
            Reflector reflector = this.reflectorMap.getReflector(start);
            Object value = reflector.getValue(start, attrName);
            ArrayList newRow = (ArrayList)row.clone();
            newRow.add(value);
            this.table.add(newRow);
        }
        return result;
    }

    public intTable expandInt(String newColumnName, String attrName) {
        intTable result = new intTable(new Integer[0]);
        result.setColumnMap(this.columnMap);
        result.setTable(this.table);
        int newColumnNumber = this.table.size() > 0 ? this.table.get(0).size() : 0;
        result.setColumnName(newColumnName);
        this.columnMap.put(newColumnName, newColumnNumber);
        ArrayList oldTable = (ArrayList)this.table.clone();
        this.table.clear();
        for (ArrayList row : oldTable) {
            Object start = row.get(this.columnMap.get(this.getColumnName()));
            Reflector reflector = this.reflectorMap.getReflector(start);
            Object value = reflector.getValue(start, attrName);
            ArrayList newRow = (ArrayList)row.clone();
            newRow.add(value);
            this.table.add(newRow);
        }
        return result;
    }

    public longTable expandLong(String newColumnName, String attrName) {
        longTable result = new longTable(new Long[0]);
        result.setColumnMap(this.columnMap);
        result.setTable(this.table);
        int newColumnNumber = this.table.size() > 0 ? this.table.get(0).size() : 0;
        result.setColumnName(newColumnName);
        this.columnMap.put(newColumnName, newColumnNumber);
        ArrayList oldTable = (ArrayList)this.table.clone();
        this.table.clear();
        for (ArrayList row : oldTable) {
            Object start = row.get(this.columnMap.get(this.getColumnName()));
            Reflector reflector = this.reflectorMap.getReflector(start);
            Object value = reflector.getValue(start, attrName);
            ArrayList newRow = (ArrayList)row.clone();
            newRow.add(value);
            this.table.add(newRow);
        }
        return result;
    }

    public StringTable expandString(String newColumnName, String attrName) {
        StringTable result = new StringTable(new String[0]);
        result.setColumnMap(this.columnMap);
        result.setTable(this.table);
        int newColumnNumber = this.table.size() > 0 ? this.table.get(0).size() : 0;
        result.setColumnName(newColumnName);
        this.columnMap.put(newColumnName, newColumnNumber);
        ArrayList oldTable = (ArrayList)this.table.clone();
        this.table.clear();
        for (ArrayList row : oldTable) {
            Object start = row.get(this.columnMap.get(this.getColumnName()));
            Reflector reflector = this.reflectorMap.getReflector(start);
            Object value = reflector.getValue(start, attrName);
            ArrayList newRow = (ArrayList)row.clone();
            newRow.add(value);
            this.table.add(newRow);
        }
        return result;
    }

    public StringTable expandBoolean(String newColumnName, String attrName) {
        StringTable result = new StringTable(new String[0]);
        result.setColumnMap(this.columnMap);
        result.setTable(this.table);
        int newColumnNumber = this.table.size() > 0 ? this.table.get(0).size() : 0;
        result.setColumnName(newColumnName);
        this.columnMap.put(newColumnName, newColumnNumber);
        ArrayList oldTable = (ArrayList)this.table.clone();
        this.table.clear();
        for (ArrayList row : oldTable) {
            Object start = row.get(this.columnMap.get(this.getColumnName()));
            Reflector reflector = this.reflectorMap.getReflector(start);
            Object value = reflector.getValue(start, attrName);
            ArrayList newRow = (ArrayList)row.clone();
            newRow.add(value);
            this.table.add(newRow);
        }
        return result;
    }

    public void addColumn(String columnName, Function<LinkedHashMap<String, Object>, Object> function) {
        int newColumnNumber = this.table.size() > 0 ? this.table.get(0).size() : 0;
        for (ArrayList<Object> row : this.table) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            for (String key : this.columnMap.keySet()) {
                map.put(key, row.get(this.columnMap.get(key)));
            }
            Object result = function.apply(map);
            row.add(result);
        }
        this.columnMap.put(columnName, newColumnNumber);
    }

    public ObjectTable dropColumns(String ... columnNames) {
        LinkedHashMap oldColumnMap = (LinkedHashMap)this.columnMap.clone();
        this.columnMap.clear();
        LinkedHashSet<String> dropNames = new LinkedHashSet<String>();
        dropNames.addAll(Arrays.asList(columnNames));
        int i = 0;
        for (String name : oldColumnMap.keySet()) {
            if (dropNames.contains(name)) continue;
            this.columnMap.put(name, i);
            ++i;
        }
        ArrayList oldTable = (ArrayList)this.table.clone();
        this.table.clear();
        LinkedHashSet rowSet = new LinkedHashSet();
        for (ArrayList row : oldTable) {
            ArrayList newRow = new ArrayList();
            for (String name : this.columnMap.keySet()) {
                Object value = row.get((Integer)oldColumnMap.get(name));
                newRow.add(value);
            }
            if (!rowSet.add(newRow)) continue;
            this.table.add(newRow);
        }
        return this;
    }

    public ObjectTable selectColumns(String ... columnNames) {
        LinkedHashMap oldColumnMap = (LinkedHashMap)this.columnMap.clone();
        this.columnMap.clear();
        int i = 0;
        for (String name : columnNames) {
            if (oldColumnMap.get(name) == null) {
                throw new IllegalArgumentException("unknown column name: " + name);
            }
            this.columnMap.put(name, i);
            ++i;
        }
        ArrayList oldTable = (ArrayList)this.table.clone();
        this.table.clear();
        LinkedHashSet rowSet = new LinkedHashSet();
        for (ArrayList row : oldTable) {
            ArrayList newRow = new ArrayList();
            for (String name : columnNames) {
                Object value = row.get((Integer)oldColumnMap.get(name));
                newRow.add(value);
            }
            if (!rowSet.add(newRow)) continue;
            this.table.add(newRow);
        }
        return this;
    }

    public ObjectTable filter(Predicate<Object> predicate) {
        ArrayList oldTable = (ArrayList)this.table.clone();
        this.table.clear();
        for (ArrayList row : oldTable) {
            Object start = row.get(this.columnMap.get(this.getColumnName()));
            if (!predicate.test(start)) continue;
            this.table.add(row);
        }
        return this;
    }

    public ObjectTable filterRow(Predicate<LinkedHashMap<String, Object>> predicate) {
        ArrayList oldTable = (ArrayList)this.table.clone();
        this.table.clear();
        for (ArrayList row : oldTable) {
            LinkedHashMap map = new LinkedHashMap();
            for (String key : this.columnMap.keySet()) {
                map.put(key, row.get(this.columnMap.get(key)));
            }
            if (!predicate.test(map)) continue;
            this.table.add(row);
        }
        return this;
    }

    public LinkedHashSet<Object> toSet() {
        LinkedHashSet<Object> result = new LinkedHashSet<Object>();
        for (ArrayList<Object> row : this.table) {
            Object value = row.get(this.columnMap.get(this.columnName));
            result.add(value);
        }
        return result;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("| ");
        for (String string : this.columnMap.keySet()) {
            buf.append(string).append(" \t| ");
        }
        buf.append("\n| ");
        for (String string : this.columnMap.keySet()) {
            buf.append(" --- \t| ");
        }
        buf.append("\n");
        for (ArrayList arrayList : this.table) {
            buf.append("| ");
            for (Object cell : arrayList) {
                buf.append(cell).append(" \t| ");
            }
            buf.append("\n");
        }
        buf.append("\n");
        return buf.toString();
    }
}

