/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.tables;

import java.util.ArrayList;
import java.util.LinkedHashMap;

public class StringTable {
    private ArrayList<ArrayList<Object>> table = new ArrayList();
    private String columnName = "A";
    LinkedHashMap<String, Integer> columnMap = new LinkedHashMap();

    public ArrayList<ArrayList<Object>> getTable() {
        return this.table;
    }

    public void setTable(ArrayList<ArrayList<Object>> table) {
        this.table = table;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public void setColumnMap(LinkedHashMap<String, Integer> columnMap) {
        this.columnMap = columnMap;
    }

    public StringTable(String ... start) {
        this.columnMap.put(this.columnName, 0);
        for (String current : start) {
            ArrayList<String> row = new ArrayList<String>();
            row.add(current);
            this.table.add(row);
        }
    }

    public ArrayList<String> toList() {
        ArrayList<String> result = new ArrayList<String>();
        for (ArrayList<Object> row : this.table) {
            String value = (String)row.get(this.columnMap.get(this.columnName));
            result.add(value);
        }
        return result;
    }

    public String join(String seperator) {
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        for (ArrayList<Object> row : this.table) {
            String value = (String)row.get(this.columnMap.get(this.columnName));
            if (!first) {
                buf.append(seperator);
            }
            first = false;
            buf.append(value);
        }
        return buf.toString();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (String string : this.columnMap.keySet()) {
            buf.append(string).append(" \t");
        }
        buf.append("\n");
        for (ArrayList arrayList : this.table) {
            for (Object cell : arrayList) {
                buf.append(cell).append(" \t");
            }
            buf.append("\n");
        }
        buf.append("\n");
        return buf.toString();
    }
}

