/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.tables;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;

public class longTable {
    private ArrayList<ArrayList<Object>> table = new ArrayList();
    private String columnName = "A";
    LinkedHashMap<String, Integer> columnMap = new LinkedHashMap();

    public ArrayList<ArrayList<Object>> getTable() {
        return this.table;
    }

    public void setTable(ArrayList<ArrayList<Object>> table) {
        this.table = table;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public void setColumnMap(LinkedHashMap<String, Integer> columnMap) {
        this.columnMap = columnMap;
    }

    public longTable(Long ... start) {
        this.columnMap.put(this.columnName, 0);
        for (Long current : start) {
            ArrayList<Long> row = new ArrayList<Long>();
            row.add(current);
            this.table.add(row);
        }
    }

    public long sum() {
        long result = 0L;
        for (ArrayList<Object> row : this.table) {
            result += ((Long)row.get(this.columnMap.get(this.columnName))).longValue();
        }
        return result;
    }

    public long min() {
        long result = Long.MAX_VALUE;
        for (ArrayList<Object> row : this.table) {
            long value = (Long)row.get(this.columnMap.get(this.columnName));
            if (value >= result) continue;
            result = value;
        }
        return result;
    }

    public long max() {
        long result = Long.MIN_VALUE;
        for (ArrayList<Object> row : this.table) {
            long value = (Long)row.get(this.columnMap.get(this.columnName));
            if (value <= result) continue;
            result = value;
        }
        return result;
    }

    public long median() {
        ArrayList<Long> list = this.toList();
        Collections.sort(list);
        int index = list.size() / 2;
        long result = list.get(index);
        return result;
    }

    public ArrayList<Long> toList() {
        ArrayList<Long> result = new ArrayList<Long>();
        for (ArrayList<Object> row : this.table) {
            long value = (Long)row.get(this.columnMap.get(this.columnName));
            result.add(value);
        }
        return result;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (String string : this.columnMap.keySet()) {
            buf.append(string).append(" \t");
        }
        buf.append("\n");
        for (ArrayList arrayList : this.table) {
            for (Object cell : arrayList) {
                buf.append(cell).append(" \t");
            }
            buf.append("\n");
        }
        buf.append("\n");
        return buf.toString();
    }
}

