/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.patterns;

import java.util.Map;
import java.util.function.Predicate;
import org.fulib.FulibTables;
import org.fulib.patterns.PatternMatcher;
import org.fulib.patterns.model.AttributeConstraint;
import org.fulib.patterns.model.MatchConstraint;
import org.fulib.patterns.model.Pattern;
import org.fulib.patterns.model.PatternObject;
import org.fulib.patterns.model.RoleObject;

public class PatternBuilder {
    private final Pattern pattern = new Pattern();

    public PatternBuilder() {
    }

    @Deprecated
    public PatternBuilder(String packageName) {
        this();
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public PatternObject buildPatternObject(String name) {
        PatternObject patternObject = new PatternObject().setName(name);
        this.pattern.withObjects(patternObject);
        return patternObject;
    }

    public PatternBuilder buildPatternLink(PatternObject src, String attrName, PatternObject tgt) {
        return this.buildPatternLink(src, null, attrName, tgt);
    }

    public PatternBuilder buildPatternLink(PatternObject src, String srcRoleName, String tgtRoleName, PatternObject tgt) {
        RoleObject srcRole = new RoleObject().setName(srcRoleName).setObject(src).setPattern(this.pattern);
        new RoleObject().setName(tgtRoleName).setObject(tgt).setOther(srcRole).setPattern(this.pattern);
        return this;
    }

    @Deprecated
    public PatternBuilder buildAttibuteConstraint(Predicate<? super Object> predicate, PatternObject object) {
        return this.buildAttributeConstraint(object, predicate);
    }

    public <T> PatternBuilder buildAttributeConstraint(PatternObject object, Predicate<? super T> predicate) {
        new AttributeConstraint().setPredicate(predicate).setObject(object).setPattern(this.pattern);
        return this;
    }

    public PatternBuilder buildMatchConstraint(Predicate<? super Map<String, Object>> predicate, PatternObject ... objects) {
        new MatchConstraint().setPredicate(predicate).withObjects(objects).setPattern(this.pattern);
        return this;
    }

    public PatternMatcher matcher() {
        return FulibTables.matcher(this.getPattern());
    }
}

