/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.patterns;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.fulib.patterns.NoApplicableConstraintException;
import org.fulib.patterns.model.AttributeConstraint;
import org.fulib.patterns.model.MatchConstraint;
import org.fulib.patterns.model.Pattern;
import org.fulib.patterns.model.PatternObject;
import org.fulib.patterns.model.RoleObject;
import org.fulib.tables.ObjectTable;

public class PatternMatcher {
    private Pattern pattern;
    private Map<PatternObject, ObjectTable> object2TableMap;

    public PatternMatcher(Pattern pattern) {
        this.pattern = pattern;
    }

    @Deprecated
    public LinkedHashMap<PatternObject, ObjectTable> getObject2TableMap() {
        return new LinkedHashMap<PatternObject, ObjectTable>(this.object2TableMap);
    }

    public ObjectTable getMatchTable(PatternObject pattern) {
        return this.object2TableMap.get(pattern);
    }

    public ObjectTable match(String patternObjectName, Object ... startObjects) {
        return this.match(this.pattern.getObject(patternObjectName), startObjects);
    }

    public ObjectTable match(PatternObject patternObject, Object ... startObjects) {
        ArrayList<RoleObject> roles = new ArrayList<RoleObject>(this.pattern.getRoles());
        ArrayList<AttributeConstraint> attributeConstraints = new ArrayList<AttributeConstraint>(this.pattern.getAttributeConstraints());
        ArrayList<MatchConstraint> matchConstraints = new ArrayList<MatchConstraint>(this.pattern.getMatchConstraints());
        ObjectTable<Object> result = new ObjectTable<Object>(patternObject.getName(), startObjects);
        this.object2TableMap = new LinkedHashMap<PatternObject, ObjectTable>();
        this.object2TableMap.put(patternObject, result);
        while (!(roles.isEmpty() && attributeConstraints.isEmpty() && matchConstraints.isEmpty())) {
            if (this.checkAttributeConstraint(attributeConstraints) || this.checkMatchConstraint(matchConstraints) || this.checkHasLink(roles) || this.expandByRole(roles)) continue;
            throw new NoApplicableConstraintException();
        }
        return result;
    }

    private boolean checkAttributeConstraint(List<AttributeConstraint> attributeConstraints) {
        for (AttributeConstraint constraint : attributeConstraints) {
            PatternObject src = constraint.getObject();
            ObjectTable srcTable = this.object2TableMap.get(src);
            if (srcTable == null) continue;
            srcTable.filter(constraint.getPredicate());
            attributeConstraints.remove(constraint);
            return true;
        }
        return false;
    }

    private boolean checkMatchConstraint(List<MatchConstraint> matchConstraints) {
        block0: for (MatchConstraint constraint : matchConstraints) {
            for (PatternObject patternObject : constraint.getObjects()) {
                ObjectTable srcTable = this.object2TableMap.get(patternObject);
                if (srcTable != null) continue;
                continue block0;
            }
            this.object2TableMap.get(constraint.getObjects().get(0)).filterRows(constraint.getPredicate());
            matchConstraints.remove(constraint);
            return true;
        }
        return false;
    }

    private boolean checkHasLink(List<RoleObject> roles) {
        for (RoleObject role : roles) {
            RoleObject otherRole;
            PatternObject tgt;
            ObjectTable tgtTable;
            PatternObject src = role.getObject();
            ObjectTable srcTable = this.object2TableMap.get(src);
            if (srcTable == null || (tgtTable = this.object2TableMap.get(tgt = (otherRole = role.getOther()).getObject())) == null) continue;
            srcTable.hasLink(otherRole.getName(), tgtTable);
            roles.remove(role);
            roles.remove(otherRole);
            return true;
        }
        return false;
    }

    private boolean expandByRole(List<RoleObject> roles) {
        for (RoleObject role : roles) {
            PatternObject src = role.getObject();
            ObjectTable srcTable = this.object2TableMap.get(src);
            if (srcTable == null) continue;
            RoleObject otherRole = role.getOther();
            PatternObject tgt = otherRole.getObject();
            ObjectTable nextTable = srcTable.expandLink(tgt.getName(), otherRole.getName());
            this.object2TableMap.put(tgt, nextTable);
            roles.remove(role);
            roles.remove(otherRole);
            return true;
        }
        return false;
    }
}

