/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.patterns.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.fulib.patterns.model.AttributeConstraint;
import org.fulib.patterns.model.MatchConstraint;
import org.fulib.patterns.model.PatternObject;
import org.fulib.patterns.model.RoleObject;

public class Pattern {
    public static final String PROPERTY_objects = "objects";
    public static final String PROPERTY_roles = "roles";
    public static final String PROPERTY_attributeConstraints = "attributeConstraints";
    public static final String PROPERTY_matchConstraints = "matchConstraints";
    @Deprecated
    public static final ArrayList<PatternObject> EMPTY_objects = new ArrayList<PatternObject>(){

        @Override
        public boolean add(PatternObject value) {
            throw new UnsupportedOperationException("No direct add! Use xy.withObjects(obj)");
        }
    };
    @Deprecated
    public static final ArrayList<RoleObject> EMPTY_roles = new ArrayList<RoleObject>(){

        @Override
        public boolean add(RoleObject value) {
            throw new UnsupportedOperationException("No direct add! Use xy.withRoles(obj)");
        }
    };
    @Deprecated
    public static final ArrayList<AttributeConstraint> EMPTY_attributeConstraints = new ArrayList<AttributeConstraint>(){

        @Override
        public boolean add(AttributeConstraint value) {
            throw new UnsupportedOperationException("No direct add! Use xy.withAttributeConstraints(obj)");
        }
    };
    @Deprecated
    public static final ArrayList<MatchConstraint> EMPTY_matchConstraints = new ArrayList<MatchConstraint>(){

        @Override
        public boolean add(MatchConstraint value) {
            throw new UnsupportedOperationException("No direct add! Use xy.withMatchConstraints(obj)");
        }
    };
    private ArrayList<PatternObject> objects;
    private ArrayList<RoleObject> roles;
    private ArrayList<AttributeConstraint> attributeConstraints;
    private ArrayList<MatchConstraint> matchConstraints;
    protected PropertyChangeSupport listeners;

    public ArrayList<PatternObject> getObjects() {
        if (this.objects == null) {
            return EMPTY_objects;
        }
        return this.objects;
    }

    @Deprecated
    public PatternObject getObjects(String name) {
        return this.getObject(name);
    }

    public PatternObject getObject(String name) {
        for (PatternObject object : this.getObjects()) {
            if (!Objects.equals(name, object.getName())) continue;
            return object;
        }
        return null;
    }

    public Pattern withObjects(Object ... value) {
        if (value == null) {
            return this;
        }
        for (Object item : value) {
            if (item == null) continue;
            if (item instanceof Collection) {
                for (Object i : (Collection)item) {
                    this.withObjects(i);
                }
                continue;
            }
            if (item instanceof PatternObject) {
                if (this.objects == null) {
                    this.objects = new ArrayList();
                }
                if (this.objects.contains(item)) continue;
                this.objects.add((PatternObject)item);
                ((PatternObject)item).setPattern(this);
                this.firePropertyChange(PROPERTY_objects, null, item);
                continue;
            }
            throw new IllegalArgumentException();
        }
        return this;
    }

    public Pattern withoutObjects(Object ... value) {
        if (this.objects == null || value == null) {
            return this;
        }
        for (Object item : value) {
            if (item == null) continue;
            if (item instanceof Collection) {
                for (Object i : (Collection)item) {
                    this.withoutObjects(i);
                }
                continue;
            }
            if (!(item instanceof PatternObject) || !this.objects.contains(item)) continue;
            this.objects.remove(item);
            ((PatternObject)item).setPattern(null);
            this.firePropertyChange(PROPERTY_objects, item, null);
        }
        return this;
    }

    public ArrayList<RoleObject> getRoles() {
        if (this.roles == null) {
            return EMPTY_roles;
        }
        return this.roles;
    }

    public Pattern withRoles(Object ... value) {
        if (value == null) {
            return this;
        }
        for (Object item : value) {
            if (item == null) continue;
            if (item instanceof Collection) {
                for (Object i : (Collection)item) {
                    this.withRoles(i);
                }
                continue;
            }
            if (item instanceof RoleObject) {
                if (this.roles == null) {
                    this.roles = new ArrayList();
                }
                if (this.roles.contains(item)) continue;
                this.roles.add((RoleObject)item);
                ((RoleObject)item).setPattern(this);
                this.firePropertyChange(PROPERTY_roles, null, item);
                continue;
            }
            throw new IllegalArgumentException();
        }
        return this;
    }

    public Pattern withoutRoles(Object ... value) {
        if (this.roles == null || value == null) {
            return this;
        }
        for (Object item : value) {
            if (item == null) continue;
            if (item instanceof Collection) {
                for (Object i : (Collection)item) {
                    this.withoutRoles(i);
                }
                continue;
            }
            if (!(item instanceof RoleObject) || !this.roles.contains(item)) continue;
            this.roles.remove(item);
            ((RoleObject)item).setPattern(null);
            this.firePropertyChange(PROPERTY_roles, item, null);
        }
        return this;
    }

    public ArrayList<AttributeConstraint> getAttributeConstraints() {
        if (this.attributeConstraints == null) {
            return EMPTY_attributeConstraints;
        }
        return this.attributeConstraints;
    }

    public Pattern withAttributeConstraints(Object ... value) {
        if (value == null) {
            return this;
        }
        for (Object item : value) {
            if (item == null) continue;
            if (item instanceof Collection) {
                for (Object i : (Collection)item) {
                    this.withAttributeConstraints(i);
                }
                continue;
            }
            if (item instanceof AttributeConstraint) {
                if (this.attributeConstraints == null) {
                    this.attributeConstraints = new ArrayList();
                }
                if (this.attributeConstraints.contains(item)) continue;
                this.attributeConstraints.add((AttributeConstraint)item);
                ((AttributeConstraint)item).setPattern(this);
                this.firePropertyChange(PROPERTY_attributeConstraints, null, item);
                continue;
            }
            throw new IllegalArgumentException();
        }
        return this;
    }

    public Pattern withoutAttributeConstraints(Object ... value) {
        if (this.attributeConstraints == null || value == null) {
            return this;
        }
        for (Object item : value) {
            if (item == null) continue;
            if (item instanceof Collection) {
                for (Object i : (Collection)item) {
                    this.withoutAttributeConstraints(i);
                }
                continue;
            }
            if (!(item instanceof AttributeConstraint) || !this.attributeConstraints.contains(item)) continue;
            this.attributeConstraints.remove(item);
            ((AttributeConstraint)item).setPattern(null);
            this.firePropertyChange(PROPERTY_attributeConstraints, item, null);
        }
        return this;
    }

    public ArrayList<MatchConstraint> getMatchConstraints() {
        if (this.matchConstraints == null) {
            return EMPTY_matchConstraints;
        }
        return this.matchConstraints;
    }

    public Pattern withMatchConstraints(Object ... value) {
        if (value == null) {
            return this;
        }
        for (Object item : value) {
            if (item == null) continue;
            if (item instanceof Collection) {
                for (Object i : (Collection)item) {
                    this.withMatchConstraints(i);
                }
                continue;
            }
            if (item instanceof MatchConstraint) {
                if (this.matchConstraints == null) {
                    this.matchConstraints = new ArrayList();
                }
                if (this.matchConstraints.contains(item)) continue;
                this.matchConstraints.add((MatchConstraint)item);
                ((MatchConstraint)item).setPattern(this);
                this.firePropertyChange(PROPERTY_matchConstraints, null, item);
                continue;
            }
            throw new IllegalArgumentException();
        }
        return this;
    }

    public Pattern withoutMatchConstraints(Object ... value) {
        if (this.matchConstraints == null || value == null) {
            return this;
        }
        for (Object item : value) {
            if (item == null) continue;
            if (item instanceof Collection) {
                for (Object i : (Collection)item) {
                    this.withoutMatchConstraints(i);
                }
                continue;
            }
            if (!(item instanceof MatchConstraint) || !this.matchConstraints.contains(item)) continue;
            this.matchConstraints.remove(item);
            ((MatchConstraint)item).setPattern(null);
            this.firePropertyChange(PROPERTY_matchConstraints, item, null);
        }
        return this;
    }

    public boolean firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.listeners != null) {
            this.listeners.firePropertyChange(propertyName, oldValue, newValue);
            return true;
        }
        return false;
    }

    public boolean addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new PropertyChangeSupport(this);
        }
        this.listeners.addPropertyChangeListener(listener);
        return true;
    }

    public boolean addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new PropertyChangeSupport(this);
        }
        this.listeners.addPropertyChangeListener(propertyName, listener);
        return true;
    }

    public boolean removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.listeners != null) {
            this.listeners.removePropertyChangeListener(listener);
        }
        return true;
    }

    public boolean removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.listeners != null) {
            this.listeners.removePropertyChangeListener(propertyName, listener);
        }
        return true;
    }

    public void removeYou() {
        this.withoutObjects(this.getObjects().clone());
        this.withoutRoles(this.getRoles().clone());
        this.withoutAttributeConstraints(this.getAttributeConstraints().clone());
        this.withoutMatchConstraints(this.getMatchConstraints().clone());
    }
}

