/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.tables;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.fulib.tables.BooleanTable;
import org.fulib.tables.StringTable;
import org.fulib.tables.Table;
import org.fulib.tables.doubleTable;
import org.fulib.tables.floatTable;
import org.fulib.tables.intTable;
import org.fulib.tables.longTable;
import org.fulib.yaml.Reflector;
import org.fulib.yaml.ReflectorMap;

public class ObjectTable<T>
extends Table<T> {
    private ReflectorMap reflectorMap;

    @SafeVarargs
    public ObjectTable(T ... start) {
        super(start);
        this.initReflector(start);
    }

    @SafeVarargs
    public ObjectTable(String colName, T ... start) {
        super(colName, start);
        this.initReflector(start);
    }

    ObjectTable(Table<?> base) {
        super(base);
        if (base instanceof ObjectTable) {
            this.reflectorMap = ((ObjectTable)base).getReflectorMap();
        }
    }

    @SafeVarargs
    private final void initReflector(T ... start) {
        if (start.length == 0) {
            return;
        }
        Set packageNames = Arrays.stream(start).map(o -> o.getClass().getPackage().getName()).collect(Collectors.toSet());
        this.reflectorMap = new ReflectorMap(packageNames);
    }

    public ReflectorMap getReflectorMap() {
        return this.reflectorMap;
    }

    public void setReflectorMap(ReflectorMap reflectorMap) {
        this.reflectorMap = reflectorMap;
    }

    public ObjectTable<T> hasLink(String linkName, ObjectTable<?> otherTable) {
        int thisColumn = this.getColumnIndex();
        int otherColumn = otherTable.getColumnIndex();
        this.table.removeIf(row -> {
            Object source = row.get(thisColumn);
            Object target = row.get(otherColumn);
            Reflector reflector = this.reflectorMap.getReflector(source);
            Object linkValue = reflector.getValue(source, linkName);
            boolean keep = linkValue == target || linkValue instanceof Collection && ((Collection)linkValue).contains(target);
            return !keep;
        });
        return this;
    }

    public <U> ObjectTable<U> expandLink(String newColumnName, String linkName) {
        this.expandAllImpl(newColumnName, start -> {
            Reflector reflector = this.reflectorMap.getReflector(start);
            Object value = reflector.getValue(start, linkName);
            if (value instanceof Collection) {
                return (Collection)value;
            }
            if (value != null) {
                return Collections.singleton(value);
            }
            return Collections.emptySet();
        });
        ObjectTable<T> result = new ObjectTable<T>(this);
        result.setColumnName_(newColumnName);
        return result;
    }

    public <U> Table<U> expandAttribute(String newColumnName, String attrName) {
        this.expandAttributeImpl(newColumnName, attrName);
        Table result = new Table(this);
        result.setColumnName_(newColumnName);
        return result;
    }

    public doubleTable expandDouble(String newColumnName, String attrName) {
        this.expandAttributeImpl(newColumnName, attrName);
        doubleTable result = new doubleTable(this);
        result.setColumnName_(newColumnName);
        return result;
    }

    public floatTable expandFloat(String newColumnName, String attrName) {
        this.expandAttributeImpl(newColumnName, attrName);
        floatTable result = new floatTable(this);
        result.setColumnName_(newColumnName);
        return result;
    }

    public intTable expandInt(String newColumnName, String attrName) {
        this.expandAttributeImpl(newColumnName, attrName);
        intTable result = new intTable(this);
        result.setColumnName_(newColumnName);
        return result;
    }

    public longTable expandLong(String newColumnName, String attrName) {
        this.expandAttributeImpl(newColumnName, attrName);
        longTable result = new longTable(this);
        result.setColumnName_(newColumnName);
        return result;
    }

    public StringTable expandString(String newColumnName, String attrName) {
        this.expandAttributeImpl(newColumnName, attrName);
        StringTable result = new StringTable(this);
        result.setColumnName_(newColumnName);
        return result;
    }

    public BooleanTable expandBoolean(String newColumnName, String attrName) {
        this.expandAttributeImpl(newColumnName, attrName);
        BooleanTable result = new BooleanTable(this);
        result.setColumnName_(newColumnName);
        return result;
    }

    private void expandAttributeImpl(String newColumnName, String attrName) {
        this.expandImpl(newColumnName, start -> {
            Reflector reflector = this.reflectorMap.getReflector(start);
            return reflector.getValue(start, attrName);
        });
    }

    @Override
    public <U> ObjectTable<U> expand(String columnName, Function<? super T, ? extends U> function) {
        this.expandImpl(columnName, function);
        ObjectTable<T> result = new ObjectTable<T>(this);
        result.setColumnName_(columnName);
        return result;
    }

    @Override
    public <U> ObjectTable<U> expandAll(String columnName, Function<? super T, ? extends Collection<? extends U>> function) {
        this.expandAllImpl(columnName, function);
        ObjectTable<T> result = new ObjectTable<T>(this);
        result.setColumnName_(columnName);
        return result;
    }

    @Override
    public ObjectTable<T> selectColumns(String ... columnNames) {
        super.selectColumns(columnNames);
        return this;
    }

    @Override
    public ObjectTable<T> dropColumns(String ... columnNames) {
        super.dropColumns(columnNames);
        return this;
    }

    @Override
    public ObjectTable<T> filter(Predicate<? super T> predicate) {
        super.filter(predicate);
        return this;
    }

    @Override
    public LinkedHashSet<T> toSet() {
        return this.stream().collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Deprecated
    public ObjectTable<T> setColumnName(String columnName) {
        this.setColumnName_(columnName);
        return this;
    }

    @Deprecated
    public ObjectTable<T> setTable(ArrayList<ArrayList<Object>> table) {
        this.table = new ArrayList<ArrayList<Object>>(table);
        return this;
    }

    @Deprecated
    public ObjectTable<T> setColumnMap(LinkedHashMap<String, Integer> columnMap) {
        this.setColumnMap_(columnMap);
        return this;
    }

    @Deprecated
    public void addColumn(String columnName, Function<LinkedHashMap<String, Object>, Object> function) {
        this.deriveImpl(columnName, function);
    }

    @Deprecated
    public ObjectTable<T> filterRow(Predicate<LinkedHashMap<String, Object>> predicate) {
        this.filterRowsImpl(predicate);
        return this;
    }
}

