/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.patterns;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fulib.patterns.AmbiguousMatchException;
import org.fulib.patterns.NoApplicableConstraintException;
import org.fulib.patterns.NoMatchException;
import org.fulib.patterns.debug.AttributeConstraintEvent;
import org.fulib.patterns.debug.DebugEvent;
import org.fulib.patterns.debug.ExpandRoleEvent;
import org.fulib.patterns.debug.HasLinkEvent;
import org.fulib.patterns.debug.MatchConstraintEvent;
import org.fulib.patterns.debug.MultiplyRootsEvent;
import org.fulib.patterns.model.AttributeConstraint;
import org.fulib.patterns.model.MatchConstraint;
import org.fulib.patterns.model.Pattern;
import org.fulib.patterns.model.PatternObject;
import org.fulib.patterns.model.RoleObject;
import org.fulib.tables.ObjectTable;
import org.fulib.tables.Table;

public class PatternMatcher {
    private final Pattern pattern;
    private final Map<PatternObject, ObjectTable> object2TableMap = new LinkedHashMap<PatternObject, ObjectTable>();
    private final List<PatternObject> rootPatternObjects = new ArrayList<PatternObject>();
    private final List<Object> rootObjects = new ArrayList<Object>();
    private List<DebugEvent> events;

    public PatternMatcher(Pattern pattern) {
        this.pattern = pattern;
    }

    @Deprecated
    public LinkedHashMap<PatternObject, ObjectTable> getObject2TableMap() {
        return new LinkedHashMap<PatternObject, ObjectTable>(this.object2TableMap);
    }

    public boolean isDebugLogging() {
        return this.events != null;
    }

    public void setDebugLogging(boolean eventLogging) {
        if (!eventLogging) {
            this.events = null;
            return;
        }
        if (this.events == null) {
            this.events = new ArrayList<DebugEvent>();
        }
    }

    public List<DebugEvent> getDebugEvents() {
        return this.events == null ? Collections.emptyList() : Collections.unmodifiableList(this.events);
    }

    public List<PatternObject> getRootPatternObjects() {
        return this.rootPatternObjects;
    }

    public PatternMatcher withRootPatternObjects(PatternObject patternObject) {
        this.rootPatternObjects.add(patternObject);
        return this;
    }

    public PatternMatcher withRootPatternObjects(PatternObject ... patternObjects) {
        Collections.addAll(this.rootPatternObjects, patternObjects);
        return this;
    }

    public PatternMatcher withRootPatternObjects(Collection<? extends PatternObject> patternObjects) {
        this.rootPatternObjects.addAll(patternObjects);
        return this;
    }

    public List<Object> getRootObjects() {
        return this.rootObjects;
    }

    public PatternMatcher withRootObjects(Object object) {
        this.rootObjects.add(object);
        return this;
    }

    public PatternMatcher withRootObjects(Object ... objects) {
        Collections.addAll(this.rootObjects, objects);
        return this;
    }

    public PatternMatcher withRootObjects(Collection<?> objects) {
        this.rootObjects.addAll(objects);
        return this;
    }

    public ObjectTable match(String rootPatternObjectName, Object ... rootObjects) {
        return this.match(this.pattern.getObject(rootPatternObjectName), rootObjects);
    }

    public ObjectTable match(PatternObject rootPatternObject, Object ... rootObjects) {
        this.withRootPatternObjects(rootPatternObject);
        this.withRootObjects(rootObjects);
        this.match();
        return this.getMatchTable(rootPatternObject);
    }

    public void match() {
        this.object2TableMap.clear();
        ArrayDeque<PatternObject> rootPatternObjects = new ArrayDeque<PatternObject>(this.rootPatternObjects);
        ArrayList<RoleObject> roles = new ArrayList<RoleObject>(this.pattern.getRoles());
        ArrayList<AttributeConstraint> attributeConstraints = new ArrayList<AttributeConstraint>(this.pattern.getAttributeConstraints());
        ArrayList<MatchConstraint> matchConstraints = new ArrayList<MatchConstraint>(this.pattern.getMatchConstraints());
        PatternObject firstPatternObject = (PatternObject)rootPatternObjects.removeFirst();
        ObjectTable<Object> firstTable = new ObjectTable<Object>(firstPatternObject.getName(), this.rootObjects.toArray());
        this.object2TableMap.put(firstPatternObject, firstTable);
        if (this.events != null) {
            this.events.add(new MultiplyRootsEvent(firstPatternObject, firstTable));
        }
        while (!(roles.isEmpty() && attributeConstraints.isEmpty() && matchConstraints.isEmpty())) {
            if (this.checkAttributeConstraint(attributeConstraints) || this.checkMatchConstraint(matchConstraints) || this.checkHasLink(roles) || this.expandByRole(roles) || this.multiplyRoots(rootPatternObjects, firstTable)) continue;
            throw new NoApplicableConstraintException("the following constraints could not be applied:\n" + Stream.of(attributeConstraints, roles, matchConstraints).flatMap(Collection::stream).map(Object::toString).collect(Collectors.joining("\n")));
        }
    }

    public ObjectTable getMatchTable(PatternObject pattern) {
        return this.object2TableMap.get(pattern);
    }

    public <T> T findOne(PatternObject patternObject) {
        ObjectTable table = this.getMatchTable(patternObject);
        int count = table.rowCount();
        if (count == 0) {
            throw new NoMatchException(patternObject);
        }
        if (count == 1) {
            return table.iterator().next();
        }
        Set set = table.toSet();
        if (set.size() == 1) {
            return (T)set.iterator().next();
        }
        throw new AmbiguousMatchException(patternObject, set);
    }

    public <T> Set<T> findAll(PatternObject patternObject) {
        ObjectTable table = this.getMatchTable(patternObject);
        return table.toSet();
    }

    private boolean checkAttributeConstraint(List<AttributeConstraint> attributeConstraints) {
        for (AttributeConstraint constraint : attributeConstraints) {
            PatternObject src = constraint.getObject();
            ObjectTable srcTable = this.object2TableMap.get(src);
            if (srcTable == null) continue;
            srcTable.filter(constraint.getPredicate());
            attributeConstraints.remove(constraint);
            if (this.events != null) {
                this.events.add(new AttributeConstraintEvent(constraint, srcTable));
            }
            return true;
        }
        return false;
    }

    private boolean checkMatchConstraint(List<MatchConstraint> matchConstraints) {
        for (MatchConstraint constraint : matchConstraints) {
            if (!this.areAllPatternObjectsAvailable(constraint)) continue;
            ObjectTable table = this.object2TableMap.get(constraint.getObjects().get(0));
            table.filterRows(constraint.getPredicate());
            matchConstraints.remove(constraint);
            if (this.events != null) {
                this.events.add(new MatchConstraintEvent(constraint, table));
            }
            return true;
        }
        return false;
    }

    private boolean areAllPatternObjectsAvailable(MatchConstraint constraint) {
        return constraint.getObjects().stream().allMatch(this.object2TableMap::containsKey);
    }

    private boolean checkHasLink(List<RoleObject> roles) {
        for (RoleObject role : roles) {
            RoleObject otherRole;
            PatternObject tgt;
            ObjectTable tgtTable;
            PatternObject src = role.getObject();
            ObjectTable srcTable = this.object2TableMap.get(src);
            if (srcTable == null || (tgtTable = this.object2TableMap.get(tgt = (otherRole = role.getOther()).getObject())) == null) continue;
            String linkName = otherRole.getName();
            if ("*".equals(linkName)) {
                srcTable.hasAnyLink(tgtTable);
            } else {
                srcTable.hasLink(linkName, tgtTable);
            }
            roles.remove(role);
            roles.remove(otherRole);
            if (this.events != null) {
                this.events.add(new HasLinkEvent(role, srcTable));
            }
            return true;
        }
        return false;
    }

    private boolean expandByRole(List<RoleObject> roles) {
        for (RoleObject role : roles) {
            RoleObject otherRole;
            String linkName;
            PatternObject src = role.getObject();
            ObjectTable srcTable = this.object2TableMap.get(src);
            if (srcTable == null || (linkName = (otherRole = role.getOther()).getName()) == null) continue;
            PatternObject tgt = otherRole.getObject();
            ObjectTable nextTable = "*".equals(linkName) ? srcTable.expandAll(tgt.getName()) : srcTable.expandLink(tgt.getName(), linkName);
            this.object2TableMap.put(tgt, nextTable);
            roles.remove(role);
            roles.remove(otherRole);
            if (this.events != null) {
                this.events.add(new ExpandRoleEvent(role, srcTable));
            }
            return true;
        }
        return false;
    }

    private boolean multiplyRoots(Deque<PatternObject> rootPatternObjects, ObjectTable firstTable) {
        if (rootPatternObjects.isEmpty()) {
            return false;
        }
        PatternObject nextRoot = rootPatternObjects.removeFirst();
        Table nextTable = firstTable.expandAll(nextRoot.getName(), x -> this.rootObjects);
        this.object2TableMap.put(nextRoot, (ObjectTable)nextTable);
        if (this.events != null) {
            this.events.add(new MultiplyRootsEvent(nextRoot, nextTable));
        }
        return true;
    }
}

