/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.patterns.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.fulib.patterns.model.AttributeConstraint;
import org.fulib.patterns.model.MatchConstraint;
import org.fulib.patterns.model.PatternObject;
import org.fulib.patterns.model.RoleObject;

public class Pattern {
    public static final String PROPERTY_objects = "objects";
    public static final String PROPERTY_roles = "roles";
    public static final String PROPERTY_attributeConstraints = "attributeConstraints";
    public static final String PROPERTY_matchConstraints = "matchConstraints";
    @Deprecated
    public static final ArrayList<PatternObject> EMPTY_objects = new ArrayList<PatternObject>(){

        @Override
        public boolean add(PatternObject value) {
            throw new UnsupportedOperationException("No direct add! Use xy.withObjects(obj)");
        }
    };
    @Deprecated
    public static final ArrayList<RoleObject> EMPTY_roles = new ArrayList<RoleObject>(){

        @Override
        public boolean add(RoleObject value) {
            throw new UnsupportedOperationException("No direct add! Use xy.withRoles(obj)");
        }
    };
    @Deprecated
    public static final ArrayList<AttributeConstraint> EMPTY_attributeConstraints = new ArrayList<AttributeConstraint>(){

        @Override
        public boolean add(AttributeConstraint value) {
            throw new UnsupportedOperationException("No direct add! Use xy.withAttributeConstraints(obj)");
        }
    };
    @Deprecated
    public static final ArrayList<MatchConstraint> EMPTY_matchConstraints = new ArrayList<MatchConstraint>(){

        @Override
        public boolean add(MatchConstraint value) {
            throw new UnsupportedOperationException("No direct add! Use xy.withMatchConstraints(obj)");
        }
    };
    private ArrayList<PatternObject> objects;
    private ArrayList<RoleObject> roles;
    private ArrayList<AttributeConstraint> attributeConstraints;
    private ArrayList<MatchConstraint> matchConstraints;
    protected PropertyChangeSupport listeners;

    public ArrayList<PatternObject> getObjects() {
        return this.objects != null ? this.objects : EMPTY_objects;
    }

    @Deprecated
    public PatternObject getObjects(String name) {
        return this.getObject(name);
    }

    public PatternObject getObject(String name) {
        for (PatternObject object : this.getObjects()) {
            if (!Objects.equals(name, object.getName())) continue;
            return object;
        }
        return null;
    }

    public Pattern withObjects(Object ... value) {
        if (value == null) {
            return this;
        }
        for (Object item : value) {
            if (item == null) continue;
            if (item instanceof Collection) {
                for (Object i : (Collection)item) {
                    this.withObjects(i);
                }
                continue;
            }
            if (item instanceof PatternObject) {
                if (this.objects == null) {
                    this.objects = new ArrayList();
                }
                if (this.objects.contains(item)) continue;
                this.objects.add((PatternObject)item);
                ((PatternObject)item).setPattern(this);
                this.firePropertyChange(PROPERTY_objects, null, item);
                continue;
            }
            throw new IllegalArgumentException();
        }
        return this;
    }

    public Pattern withObjects(PatternObject value) {
        if (this.objects == null) {
            this.objects = new ArrayList();
        }
        if (!this.objects.contains(value)) {
            this.objects.add(value);
            value.setPattern(this);
            this.firePropertyChange(PROPERTY_objects, null, value);
        }
        return this;
    }

    public Pattern withObjects(PatternObject ... value) {
        for (PatternObject item : value) {
            this.withObjects(item);
        }
        return this;
    }

    public Pattern withObjects(Collection<? extends PatternObject> value) {
        for (PatternObject patternObject : value) {
            this.withObjects(patternObject);
        }
        return this;
    }

    public Pattern withoutObjects(Object ... value) {
        if (this.objects == null || value == null) {
            return this;
        }
        for (Object item : value) {
            if (item == null) continue;
            if (item instanceof Collection) {
                for (Object i : (Collection)item) {
                    this.withoutObjects(i);
                }
                continue;
            }
            if (!(item instanceof PatternObject) || !this.objects.contains(item)) continue;
            this.objects.remove(item);
            ((PatternObject)item).setPattern(null);
            this.firePropertyChange(PROPERTY_objects, item, null);
        }
        return this;
    }

    public Pattern withoutObjects(PatternObject value) {
        if (this.objects != null && this.objects.remove(value)) {
            value.setPattern(null);
            this.firePropertyChange(PROPERTY_objects, value, null);
        }
        return this;
    }

    public Pattern withoutObjects(PatternObject ... value) {
        for (PatternObject item : value) {
            this.withoutObjects(item);
        }
        return this;
    }

    public Pattern withoutObjects(Collection<? extends PatternObject> value) {
        for (PatternObject patternObject : value) {
            this.withoutObjects(patternObject);
        }
        return this;
    }

    public ArrayList<RoleObject> getRoles() {
        return this.roles != null ? this.roles : EMPTY_roles;
    }

    public Pattern withRoles(Object ... value) {
        if (value == null) {
            return this;
        }
        for (Object item : value) {
            if (item == null) continue;
            if (item instanceof Collection) {
                for (Object i : (Collection)item) {
                    this.withRoles(i);
                }
                continue;
            }
            if (item instanceof RoleObject) {
                if (this.roles == null) {
                    this.roles = new ArrayList();
                }
                if (this.roles.contains(item)) continue;
                this.roles.add((RoleObject)item);
                ((RoleObject)item).setPattern(this);
                this.firePropertyChange(PROPERTY_roles, null, item);
                continue;
            }
            throw new IllegalArgumentException();
        }
        return this;
    }

    public Pattern withRoles(RoleObject value) {
        if (this.roles == null) {
            this.roles = new ArrayList();
        }
        if (!this.roles.contains(value)) {
            this.roles.add(value);
            value.setPattern(this);
            this.firePropertyChange(PROPERTY_roles, null, value);
        }
        return this;
    }

    public Pattern withRoles(RoleObject ... value) {
        for (RoleObject item : value) {
            this.withRoles(item);
        }
        return this;
    }

    public Pattern withRoles(Collection<? extends RoleObject> value) {
        for (RoleObject roleObject : value) {
            this.withRoles(roleObject);
        }
        return this;
    }

    public Pattern withoutRoles(Object ... value) {
        if (this.roles == null || value == null) {
            return this;
        }
        for (Object item : value) {
            if (item == null) continue;
            if (item instanceof Collection) {
                for (Object i : (Collection)item) {
                    this.withoutRoles(i);
                }
                continue;
            }
            if (!(item instanceof RoleObject) || !this.roles.contains(item)) continue;
            this.roles.remove(item);
            ((RoleObject)item).setPattern(null);
            this.firePropertyChange(PROPERTY_roles, item, null);
        }
        return this;
    }

    public Pattern withoutRoles(RoleObject value) {
        if (this.roles != null && this.roles.remove(value)) {
            value.setPattern(null);
            this.firePropertyChange(PROPERTY_roles, value, null);
        }
        return this;
    }

    public Pattern withoutRoles(RoleObject ... value) {
        for (RoleObject item : value) {
            this.withoutRoles(item);
        }
        return this;
    }

    public Pattern withoutRoles(Collection<? extends RoleObject> value) {
        for (RoleObject roleObject : value) {
            this.withoutRoles(roleObject);
        }
        return this;
    }

    public ArrayList<AttributeConstraint> getAttributeConstraints() {
        return this.attributeConstraints != null ? this.attributeConstraints : EMPTY_attributeConstraints;
    }

    public Pattern withAttributeConstraints(Object ... value) {
        if (value == null) {
            return this;
        }
        for (Object item : value) {
            if (item == null) continue;
            if (item instanceof Collection) {
                for (Object i : (Collection)item) {
                    this.withAttributeConstraints(i);
                }
                continue;
            }
            if (item instanceof AttributeConstraint) {
                if (this.attributeConstraints == null) {
                    this.attributeConstraints = new ArrayList();
                }
                if (this.attributeConstraints.contains(item)) continue;
                this.attributeConstraints.add((AttributeConstraint)item);
                ((AttributeConstraint)item).setPattern(this);
                this.firePropertyChange(PROPERTY_attributeConstraints, null, item);
                continue;
            }
            throw new IllegalArgumentException();
        }
        return this;
    }

    public Pattern withAttributeConstraints(AttributeConstraint value) {
        if (this.attributeConstraints == null) {
            this.attributeConstraints = new ArrayList();
        }
        if (!this.attributeConstraints.contains(value)) {
            this.attributeConstraints.add(value);
            value.setPattern(this);
            this.firePropertyChange(PROPERTY_attributeConstraints, null, value);
        }
        return this;
    }

    public Pattern withAttributeConstraints(AttributeConstraint ... value) {
        for (AttributeConstraint item : value) {
            this.withAttributeConstraints(item);
        }
        return this;
    }

    public Pattern withAttributeConstraints(Collection<? extends AttributeConstraint> value) {
        for (AttributeConstraint attributeConstraint : value) {
            this.withAttributeConstraints(attributeConstraint);
        }
        return this;
    }

    public Pattern withoutAttributeConstraints(Object ... value) {
        if (this.attributeConstraints == null || value == null) {
            return this;
        }
        for (Object item : value) {
            if (item == null) continue;
            if (item instanceof Collection) {
                for (Object i : (Collection)item) {
                    this.withoutAttributeConstraints(i);
                }
                continue;
            }
            if (!(item instanceof AttributeConstraint) || !this.attributeConstraints.contains(item)) continue;
            this.attributeConstraints.remove(item);
            ((AttributeConstraint)item).setPattern(null);
            this.firePropertyChange(PROPERTY_attributeConstraints, item, null);
        }
        return this;
    }

    public Pattern withoutAttributeConstraints(AttributeConstraint value) {
        if (this.attributeConstraints != null && this.attributeConstraints.remove(value)) {
            value.setPattern(null);
            this.firePropertyChange(PROPERTY_attributeConstraints, value, null);
        }
        return this;
    }

    public Pattern withoutAttributeConstraints(AttributeConstraint ... value) {
        for (AttributeConstraint item : value) {
            this.withoutAttributeConstraints(item);
        }
        return this;
    }

    public Pattern withoutAttributeConstraints(Collection<? extends AttributeConstraint> value) {
        for (AttributeConstraint attributeConstraint : value) {
            this.withoutAttributeConstraints(attributeConstraint);
        }
        return this;
    }

    public ArrayList<MatchConstraint> getMatchConstraints() {
        return this.matchConstraints != null ? this.matchConstraints : EMPTY_matchConstraints;
    }

    public Pattern withMatchConstraints(Object ... value) {
        if (value == null) {
            return this;
        }
        for (Object item : value) {
            if (item == null) continue;
            if (item instanceof Collection) {
                for (Object i : (Collection)item) {
                    this.withMatchConstraints(i);
                }
                continue;
            }
            if (item instanceof MatchConstraint) {
                if (this.matchConstraints == null) {
                    this.matchConstraints = new ArrayList();
                }
                if (this.matchConstraints.contains(item)) continue;
                this.matchConstraints.add((MatchConstraint)item);
                ((MatchConstraint)item).setPattern(this);
                this.firePropertyChange(PROPERTY_matchConstraints, null, item);
                continue;
            }
            throw new IllegalArgumentException();
        }
        return this;
    }

    public Pattern withMatchConstraints(MatchConstraint value) {
        if (this.matchConstraints == null) {
            this.matchConstraints = new ArrayList();
        }
        if (!this.matchConstraints.contains(value)) {
            this.matchConstraints.add(value);
            value.setPattern(this);
            this.firePropertyChange(PROPERTY_matchConstraints, null, value);
        }
        return this;
    }

    public Pattern withMatchConstraints(MatchConstraint ... value) {
        for (MatchConstraint item : value) {
            this.withMatchConstraints(item);
        }
        return this;
    }

    public Pattern withMatchConstraints(Collection<? extends MatchConstraint> value) {
        for (MatchConstraint matchConstraint : value) {
            this.withMatchConstraints(matchConstraint);
        }
        return this;
    }

    public Pattern withoutMatchConstraints(Object ... value) {
        if (this.matchConstraints == null || value == null) {
            return this;
        }
        for (Object item : value) {
            if (item == null) continue;
            if (item instanceof Collection) {
                for (Object i : (Collection)item) {
                    this.withoutMatchConstraints(i);
                }
                continue;
            }
            if (!(item instanceof MatchConstraint) || !this.matchConstraints.contains(item)) continue;
            this.matchConstraints.remove(item);
            ((MatchConstraint)item).setPattern(null);
            this.firePropertyChange(PROPERTY_matchConstraints, item, null);
        }
        return this;
    }

    public Pattern withoutMatchConstraints(MatchConstraint value) {
        if (this.matchConstraints != null && this.matchConstraints.remove(value)) {
            value.setPattern(null);
            this.firePropertyChange(PROPERTY_matchConstraints, value, null);
        }
        return this;
    }

    public Pattern withoutMatchConstraints(MatchConstraint ... value) {
        for (MatchConstraint item : value) {
            this.withoutMatchConstraints(item);
        }
        return this;
    }

    public Pattern withoutMatchConstraints(Collection<? extends MatchConstraint> value) {
        for (MatchConstraint matchConstraint : value) {
            this.withoutMatchConstraints(matchConstraint);
        }
        return this;
    }

    public boolean firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.listeners != null) {
            this.listeners.firePropertyChange(propertyName, oldValue, newValue);
            return true;
        }
        return false;
    }

    public boolean addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new PropertyChangeSupport(this);
        }
        this.listeners.addPropertyChangeListener(listener);
        return true;
    }

    public boolean addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new PropertyChangeSupport(this);
        }
        this.listeners.addPropertyChangeListener(propertyName, listener);
        return true;
    }

    public boolean removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.listeners != null) {
            this.listeners.removePropertyChangeListener(listener);
        }
        return true;
    }

    public boolean removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.listeners != null) {
            this.listeners.removePropertyChangeListener(propertyName, listener);
        }
        return true;
    }

    public void removeYou() {
        this.withoutObjects(new ArrayList<PatternObject>(this.getObjects()));
        this.withoutRoles(new ArrayList<RoleObject>(this.getRoles()));
        this.withoutAttributeConstraints(new ArrayList<AttributeConstraint>(this.getAttributeConstraints()));
        this.withoutMatchConstraints(new ArrayList<MatchConstraint>(this.getMatchConstraints()));
    }

    public String toString() {
        return "Pattern{objects=" + this.objects + ", roles=" + this.roles + ", attributeConstraints=" + this.attributeConstraints + ", matchConstraints=" + this.matchConstraints + '}';
    }
}

