/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.tables;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fulib.tables.MarkdownRenderer;
import org.fulib.tables.Renderer;

public class Table<T>
implements Iterable<T> {
    private static final String DEFAULT_COLUMN_NAME = "A";
    private static final Renderer TOSTRING_RENDERER = new MarkdownRenderer();
    private String columnName;
    List<List<Object>> table;
    List<String> columns;

    public Table() {
        this.table = new ArrayList<List<Object>>();
        this.columns = new ArrayList<String>();
    }

    public Table(String columnName) {
        this();
        this.columnName = columnName;
        this.columns.add(columnName);
    }

    @SafeVarargs
    public Table(T ... start) {
        this(DEFAULT_COLUMN_NAME, start);
    }

    @SafeVarargs
    public Table(String columnName, T ... start) {
        this(columnName);
        for (T current : start) {
            ArrayList<T> row = new ArrayList<T>();
            row.add(current);
            this.table.add(row);
        }
    }

    Table(Table<?> base) {
        this.columnName = base.columnName;
        this.columns = base.columns;
        this.table = base.table;
    }

    public Table<T> copy() {
        Table<T> result = new Table<T>();
        this.copyTo(result);
        return result;
    }

    void copyTo(Table<T> copy) {
        copy.columnName = this.columnName;
        copy.columns.addAll(this.columns);
        for (List<Object> row : this.table) {
            copy.table.add(new ArrayList<Object>(row));
        }
    }

    public String getColumnName() {
        return this.columnName;
    }

    void setColumnName_(String columnName) {
        this.columnName = columnName;
    }

    int getColumnIndex() {
        return this.getColumnIndex(this.columnName);
    }

    int getColumnIndex(String columnName) {
        int index = this.columns.indexOf(columnName);
        if (index < 0) {
            throw new IllegalStateException("Column '" + columnName + "' is no longer part of table columns " + this.columns + ". It was likely evicted after a selectColumns or dropColumns operation. This Table instance is no longer valid");
        }
        return index;
    }

    void addColumn(String columnName) {
        this.columns.add(columnName);
    }

    public <TAB extends Table<T>> TAB as(Class<? extends TAB> type) {
        try {
            return (TAB)((Table)type.getDeclaredConstructor(Table.class).newInstance(this));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            throw new RuntimeException(type + " does not provide a constructor '" + type.getCanonicalName() + "(Table)'", e.getCause());
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getTargetException());
        }
    }

    <TAB extends Table<T>> TAB as(Function<? super Table<T>, ? extends TAB> constructor) {
        return (TAB)((Table)constructor.apply(this));
    }

    public <U> Table<U> expand(String targetColumn, Function<? super T, ? extends U> function) {
        return this.expand(this.columnName, targetColumn, function);
    }

    public <V, U> Table<U> expand(String sourceColumn, String targetColumn, Function<? super V, ? extends U> function) {
        this.expandImpl(sourceColumn, targetColumn, function);
        Table<T> result = new Table<T>(this);
        result.setColumnName_(targetColumn);
        return result;
    }

    <V> void expandImpl(String sourceColumn, String targetColumn, Function<? super V, ?> function) {
        int column = this.getColumnIndex(sourceColumn);
        this.addColumn(targetColumn);
        for (List<Object> row : this.table) {
            Object result = function.apply(row.get(column));
            row.add(result);
        }
    }

    public <U> Table<U> expandAll(String targetColumn, Function<? super T, ? extends Collection<? extends U>> function) {
        return this.expandAll(this.columnName, targetColumn, function);
    }

    public <V, U> Table<U> expandAll(String sourceColumn, String targetColumn, Function<? super V, ? extends Collection<? extends U>> function) {
        this.expandAllImpl(sourceColumn, targetColumn, function);
        Table<T> result = new Table<T>(this);
        result.setColumnName_(targetColumn);
        return result;
    }

    <V> void expandAllImpl(String sourceColumn, String targetColumn, Function<? super V, ? extends Collection<?>> function) {
        int column = this.getColumnIndex(sourceColumn);
        this.addColumn(targetColumn);
        ArrayList<List<Object>> oldTable = new ArrayList<List<Object>>(this.table);
        this.table.clear();
        for (List list : oldTable) {
            Collection<?> newItems = function.apply(list.get(column));
            for (Object item : newItems) {
                ArrayList newRow = new ArrayList(list);
                newRow.add(item);
                this.table.add(newRow);
            }
        }
    }

    public <U> Table<U> derive(String targetColumn, Function<? super Map<String, Object>, ? extends U> function) {
        this.deriveImpl(targetColumn, function);
        Table<T> result = new Table<T>(this);
        result.setColumnName_(targetColumn);
        return result;
    }

    void deriveImpl(String targetColumn, Function<? super LinkedHashMap<String, Object>, ?> function) {
        for (List<Object> row : this.table) {
            LinkedHashMap<String, Object> map = this.convertRowToMap(row);
            Object result = function.apply(map);
            row.add(result);
        }
        this.addColumn(targetColumn);
    }

    public <U> Table<U> deriveAll(String targetColumn, Function<? super Map<String, Object>, ? extends Collection<? extends U>> function) {
        this.deriveAllImpl(targetColumn, function);
        Table<T> result = new Table<T>(this);
        result.setColumnName_(targetColumn);
        return result;
    }

    void deriveAllImpl(String targetColumn, Function<? super LinkedHashMap<String, Object>, ? extends Collection<?>> function) {
        ArrayList<List<Object>> oldTable = new ArrayList<List<Object>>(this.table);
        this.table.clear();
        for (List list : oldTable) {
            LinkedHashMap<String, Object> map = this.convertRowToMap(list);
            Collection<?> result = function.apply(map);
            for (Object item : result) {
                ArrayList newRow = new ArrayList(list);
                newRow.add(item);
                this.table.add(newRow);
            }
        }
        this.addColumn(targetColumn);
    }

    public Table<T> dropColumns(String ... columnNames) {
        for (String name : columnNames) {
            this.dropColumnImpl(name);
        }
        this.removeDuplicateRows();
        return this;
    }

    private void dropColumnImpl(String columnName) {
        int index = this.columns.indexOf(columnName);
        if (index < 0) {
            return;
        }
        this.columns.remove(index);
        for (List<Object> row : this.table) {
            row.remove(index);
        }
    }

    private void removeDuplicateRows() {
        LinkedHashSet<List<Object>> rowSet = new LinkedHashSet<List<Object>>(this.table);
        if (this.table.size() != rowSet.size()) {
            this.table.clear();
            this.table.addAll(rowSet);
        }
    }

    public Table<T> selectColumns(String ... columnNames) {
        HashSet<String> toBeDropped = new HashSet<String>(this.columns);
        for (String columnName : columnNames) {
            if (toBeDropped.remove(columnName)) continue;
            throw new IllegalArgumentException("unknown column name: " + columnName);
        }
        for (String drop : toBeDropped) {
            this.dropColumnImpl(drop);
        }
        this.removeDuplicateRows();
        return this;
    }

    public Table<T> filter(Predicate<? super T> predicate) {
        return this.filter(this.columnName, predicate);
    }

    public <V> Table<T> filter(String sourceColumn, Predicate<? super V> predicate) {
        int column = this.getColumnIndex(sourceColumn);
        this.table.removeIf(row -> !predicate.test((Object)row.get(column)));
        return this;
    }

    public Table<T> filterRows(Predicate<? super Map<String, Object>> predicate) {
        return this.filterRowsImpl(predicate);
    }

    Table<T> filterRowsImpl(Predicate<? super LinkedHashMap<String, Object>> predicate) {
        this.table.removeIf(row -> !predicate.test(this.convertRowToMap((List<Object>)row)));
        return this;
    }

    private LinkedHashMap<String, Object> convertRowToMap(List<Object> row) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        List<String> strings = this.columns;
        for (int i = 0; i < strings.size(); ++i) {
            String column = strings.get(i);
            map.put(column, row.get(i));
        }
        return map;
    }

    public int rowCount() {
        return this.table.size();
    }

    @Override
    public Iterator<T> iterator() {
        return this.iterator(this.columnName);
    }

    public <V> Iterator<V> iterator(final String sourceColumn) {
        return new Iterator<V>(){
            private final Iterator<List<Object>> listIterator;
            private final int column;
            {
                this.listIterator = Table.this.table.iterator();
                this.column = Table.this.getColumnIndex(sourceColumn);
            }

            @Override
            public boolean hasNext() {
                return this.listIterator.hasNext();
            }

            @Override
            public V next() {
                return this.listIterator.next().get(this.column);
            }
        };
    }

    public List<T> toList() {
        return this.toList(this.columnName);
    }

    public <V> List<V> toList(String sourceColumn) {
        return this.stream(sourceColumn).collect(Collectors.toList());
    }

    public Set<T> toSet() {
        return this.toSet(this.columnName);
    }

    public <V> Set<V> toSet(String sourceColumn) {
        return this.stream(sourceColumn).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Stream<T> stream() {
        return this.stream(this.columnName);
    }

    public <V> Stream<V> stream(String sourceColumn) {
        int column = this.getColumnIndex(sourceColumn);
        return this.table.stream().map(l -> l.get(column));
    }

    public String toString() {
        return TOSTRING_RENDERER.render(this);
    }

    @Deprecated
    public ArrayList<ArrayList<Object>> getTable() {
        return this.table.stream().map(ArrayList::new).collect(Collectors.toCollection(ArrayList::new));
    }

    @Deprecated
    public LinkedHashMap<String, Integer> getColumnMap() {
        int columnCount = this.columns.size();
        LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            map.put(this.columns.get(i), i);
        }
        return map;
    }

    @Deprecated
    void setColumnMap_(LinkedHashMap<String, Integer> columnMap) {
        int max = columnMap.values().stream().mapToInt(Integer::intValue).max().orElse(0);
        ArrayList<Object> columns = new ArrayList<Object>(Collections.nCopies(max + 1, null));
        for (Map.Entry<String, Integer> entry : columnMap.entrySet()) {
            columns.set(entry.getValue(), entry.getKey());
        }
        this.columns = columns;
    }
}

