/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.tools;

import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.engine.Graphviz;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import org.fulib.StrUtil;
import org.fulib.tools.ScenarioDiagrams;
import org.fulib.yaml.Reflector;
import org.fulib.yaml.ReflectorMap;
import org.fulib.yaml.YamlIdMap;
import org.fulib.yaml.YamlObject;
import org.stringtemplate.v4.ST;

public class ObjectDiagrams {
    private LinkedHashMap<Object, String> diagramNames = new LinkedHashMap();

    public String dumpPng(Object ... objectList) {
        Objects.requireNonNull(objectList);
        if (objectList.length < 1) {
            throw new IllegalArgumentException("missing root object");
        }
        Object firstRoot = objectList[0];
        String diagramFileName = this.diagramNames.get(firstRoot);
        if (diagramFileName == null) {
            diagramFileName = "tmp/" + this.lastDotSplit(firstRoot.getClass().getName()) + "." + (this.diagramNames.size() + 1) + ".png";
            this.diagramNames.put(firstRoot, diagramFileName);
        }
        return this.dumpPng(diagramFileName, objectList);
    }

    private String lastDotSplit(String name) {
        String[] split = name.split("\\.");
        return split[split.length - 1];
    }

    public String dumpPng(String diagramFileName, Object ... objectList) {
        return this.dump(Format.PNG, diagramFileName, objectList);
    }

    public String dumpSVG(String diagramFileName, Object ... objectList) {
        if (diagramFileName.endsWith(".scenario.svg")) {
            new ScenarioDiagrams().dump(diagramFileName, objectList[0]);
            return diagramFileName;
        }
        return this.dump(Format.SVG_STANDALONE, diagramFileName, objectList);
    }

    public String dumpYaml(String diagramFileName, Object ... objectList) {
        Objects.requireNonNull(objectList);
        if (objectList.length < 1) {
            throw new IllegalArgumentException("empty objectList");
        }
        ArrayList<Object> flatList = new ArrayList<Object>();
        for (Object obj : objectList) {
            if (obj instanceof Collection) {
                flatList.addAll((Collection)obj);
                continue;
            }
            flatList.add(obj);
        }
        objectList = flatList.toArray();
        Object firstObject = objectList[0];
        String packageName = firstObject.getClass().getPackage().getName();
        YamlIdMap idMap = new YamlIdMap(new String[]{packageName});
        String yaml = idMap.encode(objectList);
        try {
            Files.write(Paths.get(diagramFileName, new String[0]), yaml.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return diagramFileName;
    }

    private String dump(Format format, String diagramFileName, Object ... objectList) {
        try {
            Objects.requireNonNull(objectList);
            if (objectList.length < 1) {
                throw new IllegalArgumentException("empty objectList");
            }
            ArrayList<Object> flatList = new ArrayList<Object>();
            for (Object obj : objectList) {
                if (obj instanceof Collection) {
                    flatList.addAll((Collection)obj);
                    continue;
                }
                flatList.add(obj);
            }
            objectList = flatList.toArray();
            Object firstRoot = objectList[0];
            String packageName = firstRoot.getClass().getPackage().getName();
            YamlIdMap idMap = new YamlIdMap(new String[]{packageName});
            ReflectorMap reflectorMap = new ReflectorMap(packageName);
            LinkedHashSet diagramObjects = idMap.collectObjects(objectList);
            LinkedHashMap<String, LinkedHashMap<String, String>> edgesMap = new LinkedHashMap<String, LinkedHashMap<String, String>>();
            String dotString = "digraph H {\n<nodes> \n<edges> \n}\n";
            String nodesString = this.makeNodes(diagramObjects, idMap, reflectorMap, edgesMap);
            String edgesString = this.makeEdges(diagramObjects, idMap, reflectorMap, edgesMap);
            ST st = new ST(dotString);
            st.add("nodes", (Object)nodesString);
            st.add("edges", (Object)edgesString);
            dotString = st.render();
            Graphviz.fromString((String)dotString.toString()).render(format).toFile(new File(diagramFileName));
            return diagramFileName;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String makeEdges(LinkedHashSet<Object> diagramObjects, YamlIdMap idMap, ReflectorMap reflectorMap, LinkedHashMap<String, LinkedHashMap<String, String>> edgesMap) {
        StringBuilder buf = new StringBuilder();
        for (LinkedHashMap<String, String> edge : edgesMap.values()) {
            String sourceId = edge.get("src");
            String targetId = edge.get("tgt");
            String sourceLabel = edge.get("tail");
            sourceLabel = sourceLabel == null ? " " : sourceLabel;
            String targetLabel = edge.get("head");
            buf.append(sourceId).append(" -> ").append(targetId).append(" [arrowhead=none fontsize=\"10\" taillabel=\"" + sourceLabel + "\" headlabel=\"" + targetLabel + "\"];\n");
        }
        return buf.toString();
    }

    private String makeNodes(LinkedHashSet<Object> diagramObjects, YamlIdMap idMap, ReflectorMap reflectorMap, LinkedHashMap<String, LinkedHashMap<String, String>> edgesMap) {
        StringBuilder buf = new StringBuilder();
        for (Map.Entry entry : idMap.getObjIdMap().entrySet()) {
            YamlObject yamlObj;
            Object type;
            String key = (String)entry.getKey();
            Object obj = entry.getValue();
            if (!diagramObjects.contains(obj)) continue;
            String className = obj.getClass().getSimpleName();
            if (obj instanceof YamlObject && (type = (yamlObj = (YamlObject)obj).getMap().get("type")) != null) {
                className = type.toString();
            }
            Reflector creator = reflectorMap.getReflector(obj);
            String userKey = key;
            Object tmp = creator.getValue(obj, "id");
            if (tmp != null) {
                userKey = StrUtil.downFirstChar((String)tmp.toString());
            } else {
                tmp = creator.getValue(obj, "name");
                if (tmp != null) {
                    userKey = StrUtil.downFirstChar((String)tmp.toString());
                }
            }
            buf.append(key).append(" [\n   shape=plaintext\n   fontsize=\"10\"\n   label=<\n     <table border='0' cellborder='1' cellspacing='0'>\n       <tr><td>").append("<u>").append(userKey).append(" :").append(className).append("</u>").append("</td></tr>\n       <tr><td>");
            for (String prop : creator.getProperties()) {
                if (obj instanceof YamlObject && ".id".equals(prop) || obj instanceof YamlObject && "type".equals(prop)) continue;
                Object value = creator.getValue(obj, prop);
                if (value == null) {
                    try {
                        Method method = obj.getClass().getMethod("get" + StrUtil.cap((String)prop), new Class[0]);
                        Class<?> fieldType = method.getReturnType();
                        if (fieldType != String.class) continue;
                        buf.append("  ").append(prop).append(" = null").append("<br  align='left'/>");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (value instanceof Collection) {
                    for (Object elem : (Collection)value) {
                        if (!diagramObjects.contains(elem)) continue;
                        String targetKey = (String)idMap.getIdObjMap().get(elem);
                        this.addEdge(edgesMap, key, targetKey, prop);
                    }
                    continue;
                }
                String valueKey = (String)idMap.getIdObjMap().get(value);
                if (valueKey != null) {
                    if (!diagramObjects.contains(value)) continue;
                    String targetKey = (String)idMap.getIdObjMap().get(value);
                    this.addEdge(edgesMap, key, targetKey, prop);
                    continue;
                }
                if (value instanceof String) {
                    value = this.encodeDotString(value);
                }
                buf.append("  ").append(prop).append(" = ").append(value.toString()).append("<br  align='left'/>");
            }
            buf.append("</td></tr>\n     </table>\n  >];\n");
        }
        return buf.toString();
    }

    private void addEdge(LinkedHashMap<String, LinkedHashMap<String, String>> edgesMap, String key, String targetKey, String prop) {
        String fwdKey = key + ">" + targetKey;
        String reverseKey = targetKey + ">" + key;
        LinkedHashMap<String, String> reverseEdge = edgesMap.get(reverseKey);
        if (reverseEdge != null) {
            String tailLabel = reverseEdge.get("tail");
            tailLabel = tailLabel == null ? prop : tailLabel + "\\n" + prop;
            reverseEdge.put("tail", tailLabel);
        } else {
            String label;
            LinkedHashMap<String, String> edge = edgesMap.get(fwdKey);
            if (edge == null) {
                edge = new LinkedHashMap();
                edgesMap.put(fwdKey, edge);
                edge.put("src", key);
                edge.put("tgt", targetKey);
            }
            label = (label = edge.get("head")) == null ? prop : label + "\\n" + prop;
            edge.put("head", label);
        }
    }

    private Object encodeDotString(Object value) {
        String newValue = (String)value;
        newValue = "\"" + newValue.replaceAll("\"", "\\\"") + "\"";
        newValue = newValue.replaceAll("<", "&lt;");
        newValue = newValue.replaceAll(">", "&gt;");
        newValue = newValue.replaceAll("&", "&amp;");
        return newValue;
    }
}

