/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.tools;

import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.engine.Graphviz;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.fulib.StrUtil;
import org.fulib.tools.ScenarioDiagrams;
import org.fulib.yaml.Reflector;
import org.fulib.yaml.ReflectorMap;
import org.fulib.yaml.YamlIdMap;
import org.fulib.yaml.YamlObject;

public class ObjectDiagrams {
    private final Map<Object, String> diagramNames = new LinkedHashMap<Object, String>();
    private double scale = 1.0;

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public ObjectDiagrams withScale(double scale) {
        this.setScale(scale);
        return this;
    }

    public String dumpPng(Object ... objectList) {
        if (objectList.length == 0) {
            throw new IllegalArgumentException("missing root object");
        }
        Object firstRoot = objectList[0];
        String diagramFileName = this.getDiagramFileName(firstRoot);
        return this.dumpPng(diagramFileName, objectList);
    }

    private String getDiagramFileName(Object firstRoot) {
        return this.diagramNames.computeIfAbsent(firstRoot, obj -> {
            String className = obj.getClass().getSimpleName();
            int uniqueNumber = this.diagramNames.size() + 1;
            return "tmp/" + className + "." + uniqueNumber + ".png";
        });
    }

    public String dumpPng(String diagramFileName, Object ... objectList) {
        return this.dump(Format.PNG, diagramFileName, objectList);
    }

    public String dumpSVG(String diagramFileName, Object ... objectList) {
        if (diagramFileName.endsWith(".scenario.svg")) {
            new ScenarioDiagrams().dump(diagramFileName, objectList[0]);
            return diagramFileName;
        }
        return this.dump(Format.SVG_STANDALONE, diagramFileName, objectList);
    }

    public String dumpYaml(String diagramFileName, Object ... objectList) {
        if ((objectList = ObjectDiagrams.flatten(objectList)).length == 0) {
            throw new IllegalArgumentException("empty objectList");
        }
        Object firstObject = objectList[0];
        String packageName = firstObject.getClass().getPackage().getName();
        YamlIdMap idMap = new YamlIdMap(packageName);
        String yaml = idMap.encode(objectList);
        try {
            Files.write(Paths.get(diagramFileName, new String[0]), yaml.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return diagramFileName;
    }

    private String dump(Format format, String diagramFileName, Object ... objectList) {
        if ((objectList = ObjectDiagrams.flatten(objectList)).length == 0) {
            throw new IllegalArgumentException("empty objectList");
        }
        Object firstRoot = objectList[0];
        String packageName = firstRoot.getClass().getPackage().getName();
        YamlIdMap idMap = new YamlIdMap(packageName);
        ReflectorMap reflectorMap = new ReflectorMap(packageName);
        LinkedHashSet diagramObjects = idMap.collectObjects(objectList);
        LinkedHashMap<String, Map<String, String>> edgesMap = new LinkedHashMap<String, Map<String, String>>();
        String nodesString = this.makeNodes(diagramObjects, idMap, reflectorMap, edgesMap);
        String edgesString = this.makeEdges(edgesMap);
        String dotString = "digraph H {\n" + nodesString + "\n" + edgesString + "\n}\n";
        try {
            Graphviz.fromString((String)dotString).scale(this.scale).render(format).toFile(new File(diagramFileName));
            return diagramFileName;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Object[] flatten(Object ... objectList) {
        ArrayList<Object> flatList = new ArrayList<Object>();
        for (Object obj : objectList) {
            if (obj instanceof Collection) {
                flatList.addAll((Collection)obj);
                continue;
            }
            flatList.add(obj);
        }
        return flatList.toArray();
    }

    private String makeEdges(Map<String, Map<String, String>> edgesMap) {
        StringBuilder buf = new StringBuilder();
        for (Map<String, String> edge : edgesMap.values()) {
            String sourceId = edge.get("src");
            String targetId = edge.get("tgt");
            String sourceLabel = edge.get("tail");
            sourceLabel = sourceLabel == null ? " " : sourceLabel;
            String targetLabel = edge.get("head");
            buf.append(sourceId).append(" -> ").append(targetId).append(" [arrowhead=none fontsize=\"10\" taillabel=\"").append(sourceLabel).append("\" ").append("headlabel=\"").append(targetLabel).append("\"];\n");
        }
        return buf.toString();
    }

    private String makeNodes(Set<Object> diagramObjects, YamlIdMap idMap, ReflectorMap reflectorMap, Map<String, Map<String, String>> edgesMap) {
        StringBuilder buf = new StringBuilder();
        for (Map.Entry entry : idMap.getObjIdMap().entrySet()) {
            YamlObject yamlObj;
            String type;
            String key = (String)entry.getKey();
            Object obj = entry.getValue();
            if (!diagramObjects.contains(obj)) continue;
            String className = obj.getClass().getSimpleName();
            if (obj instanceof YamlObject && (type = (yamlObj = (YamlObject)obj).getType()) != null) {
                className = type.toString();
            }
            Reflector creator = reflectorMap.getReflector(obj);
            String userKey = key;
            Object tmp = creator.getValue(obj, "id");
            if (tmp != null) {
                userKey = StrUtil.downFirstChar((String)tmp.toString());
            } else {
                tmp = creator.getValue(obj, "name");
                if (tmp != null) {
                    userKey = StrUtil.downFirstChar((String)tmp.toString());
                }
            }
            buf.append(key).append(" [\n   shape=plaintext\n   fontsize=\"10\"\n   label=<\n     <table border='0' cellborder='1' cellspacing='0'>\n       <tr><td>").append("<u>").append(userKey).append(" :").append(className).append("</u>").append("</td></tr>\n       <tr><td>");
            for (String prop : creator.getOwnProperties()) {
                if (obj instanceof YamlObject && ".id".equals(prop) || obj instanceof YamlObject && "type".equals(prop)) continue;
                Object value = creator.getValue(obj, prop);
                if (value == null) {
                    try {
                        Method method = obj.getClass().getMethod("get" + StrUtil.cap((String)prop), new Class[0]);
                        Class<?> fieldType = method.getReturnType();
                        if (fieldType != String.class) continue;
                        buf.append("  ").append(prop).append(" = null").append("<br  align='left'/>");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (value instanceof Collection) {
                    for (Object elem : (Collection)value) {
                        if (!diagramObjects.contains(elem)) continue;
                        String targetKey = idMap.getId(elem);
                        this.addEdge(edgesMap, key, targetKey, prop);
                    }
                    continue;
                }
                String valueKey = idMap.getId(value);
                if (valueKey != null) {
                    if (!diagramObjects.contains(value)) continue;
                    String targetKey = idMap.getId(value);
                    this.addEdge(edgesMap, key, targetKey, prop);
                    continue;
                }
                if (value instanceof String) {
                    value = ObjectDiagrams.encodeDotString((String)value);
                } else if (ObjectDiagrams.isLambdaClass(value.getClass())) {
                    value = "&lt;lambda expression&gt;";
                }
                buf.append("  ").append(prop).append(" = ").append(value.toString()).append("<br  align='left'/>");
            }
            buf.append("</td></tr>\n     </table>\n  >];\n");
        }
        return buf.toString();
    }

    private static boolean isLambdaClass(Class<?> aClass) {
        String className = aClass.getName();
        int lambdaIndex = className.indexOf("$$Lambda$");
        return 0 <= lambdaIndex && lambdaIndex <= className.indexOf(47);
    }

    private void addEdge(Map<String, Map<String, String>> edgesMap, String key, String targetKey, String prop) {
        String fwdKey = key + ">" + targetKey;
        String reverseKey = targetKey + ">" + key;
        Map<String, String> reverseEdge = edgesMap.get(reverseKey);
        if (reverseEdge != null) {
            String tailLabel = reverseEdge.get("tail");
            tailLabel = tailLabel == null ? prop : tailLabel + "\\n" + prop;
            reverseEdge.put("tail", tailLabel);
        } else {
            String label;
            Map<String, String> edge = edgesMap.get(fwdKey);
            if (edge == null) {
                edge = new LinkedHashMap<String, String>();
                edgesMap.put(fwdKey, edge);
                edge.put("src", key);
                edge.put("tgt", targetKey);
            }
            label = (label = edge.get("head")) == null ? prop : label + "\\n" + prop;
            edge.put("head", label);
        }
    }

    private static String encodeDotString(String value) {
        value = value.replace("&", "&amp;");
        value = value.replace("<", "&lt;");
        value = value.replace(">", "&gt;");
        value = "\"" + value.replace("\"", "\\\"") + "\"";
        return value;
    }
}

