/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.tools;

import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.engine.Graphviz;
import guru.nidi.graphviz.engine.GraphvizException;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.fulib.classmodel.AssocRole;
import org.fulib.classmodel.ClassModel;
import org.fulib.classmodel.Clazz;
import org.stringtemplate.v4.AttributeRenderer;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STGroupFile;
import org.stringtemplate.v4.StringRenderer;

public class ClassDiagrams {
    private static final STGroup TEMPLATE_GROUP = new STGroupFile(ClassDiagrams.class.getResource("templates/classDiagram.stg"));
    private double scale = 1.0;

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public ClassDiagrams withScale(double scale) {
        this.setScale(scale);
        return this;
    }

    public String dumpPng(ClassModel model) {
        String diagramFileName = model.getPackageSrcFolder() + "/doc-files/classDiagram.png";
        return this.dumpPng(model, diagramFileName);
    }

    public String dumpPng(ClassModel model, String diagramFileName) {
        return this.dump(model, diagramFileName, Format.PNG);
    }

    public String dumpSVG(ClassModel model, String diagramFileName) {
        return this.dump(model, diagramFileName, Format.SVG);
    }

    public String dump(ClassModel model, String diagramFileName, Format format) {
        ST classDiagram = TEMPLATE_GROUP.getInstanceOf("classDiagram");
        classDiagram.add("classModel", (Object)model);
        classDiagram.add("roles", ClassDiagrams.getRolesWithoutOthers(model));
        String dotString = classDiagram.render();
        try {
            Graphviz.fromString((String)dotString).scale(this.getScale()).render(format).toFile(new File(diagramFileName));
            return diagramFileName;
        }
        catch (GraphvizException graphvizException) {
            throw new RuntimeException("Graphviz rendering failed for dot string from class model:\n" + dotString, graphvizException);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Set<AssocRole> getRolesWithoutOthers(ClassModel model) {
        HashSet<AssocRole> result = new HashSet<AssocRole>();
        for (Clazz clazz : model.getClasses()) {
            for (AssocRole role : clazz.getRoles()) {
                if (result.contains(role.getOther())) continue;
                result.add(role);
            }
        }
        return result;
    }

    static {
        TEMPLATE_GROUP.registerRenderer(String.class, (AttributeRenderer)new StringRenderer());
    }
}

