/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.tools;

import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.engine.Graphviz;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.fulib.StrUtil;
import org.fulib.tools.ClassDiagrams;
import org.fulib.tools.ScenarioDiagrams;
import org.fulib.tools.diagrams.DiagramEdge;
import org.fulib.tools.diagrams.DiagramObject;
import org.fulib.yaml.Reflector;
import org.fulib.yaml.ReflectorMap;
import org.fulib.yaml.YamlIdMap;
import org.fulib.yaml.YamlObject;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STGroupFile;
import org.stringtemplate.v4.StringRenderer;

public class ObjectDiagrams {
    private static final STGroup TEMPLATE_GROUP = new STGroupFile(ClassDiagrams.class.getResource("templates/objectDiagram.stg"));
    private final Map<Object, String> diagramNames = new LinkedHashMap<Object, String>();
    private double scale = 1.0;

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public ObjectDiagrams withScale(double scale) {
        this.setScale(scale);
        return this;
    }

    public String dumpPng(Object ... objectList) {
        if (objectList.length == 0) {
            throw new IllegalArgumentException("missing root object");
        }
        Object firstRoot = objectList[0];
        String diagramFileName = this.getDiagramFileName(firstRoot);
        return this.dumpPng(diagramFileName, objectList);
    }

    private String getDiagramFileName(Object firstRoot) {
        return this.diagramNames.computeIfAbsent(firstRoot, obj -> {
            String className = obj.getClass().getSimpleName();
            int uniqueNumber = this.diagramNames.size() + 1;
            return "tmp/" + className + "." + uniqueNumber + ".png";
        });
    }

    public String dumpPng(String diagramFileName, Object ... objectList) {
        return this.dump(Format.PNG, diagramFileName, objectList);
    }

    public String dumpSVG(String diagramFileName, Object ... objectList) {
        if (diagramFileName.endsWith(".scenario.svg")) {
            new ScenarioDiagrams().dump(diagramFileName, objectList[0]);
            return diagramFileName;
        }
        return this.dump(Format.SVG_STANDALONE, diagramFileName, objectList);
    }

    public String dumpYaml(String diagramFileName, Object ... objectList) {
        if ((objectList = ObjectDiagrams.flatten(objectList)).length == 0) {
            throw new IllegalArgumentException("empty objectList");
        }
        Object firstObject = objectList[0];
        String packageName = firstObject.getClass().getPackage().getName();
        YamlIdMap idMap = new YamlIdMap(packageName);
        String yaml = idMap.encode(objectList);
        try {
            Path path = Paths.get(diagramFileName, new String[0]);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.write(path, yaml.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return diagramFileName;
    }

    private String dump(Format format, String diagramFileName, Object ... objectList) {
        if ((objectList = ObjectDiagrams.flatten(objectList)).length == 0) {
            throw new IllegalArgumentException("empty objectList");
        }
        Object firstRoot = objectList[0];
        String packageName = firstRoot.getClass().getPackage().getName();
        YamlIdMap idMap = new YamlIdMap(packageName);
        ReflectorMap reflectorMap = new ReflectorMap(packageName);
        LinkedHashSet relevantObjects = idMap.collectObjects(objectList);
        LinkedHashSet<DiagramObject> diagramObjects = new LinkedHashSet<DiagramObject>();
        LinkedHashSet<DiagramEdge> edges = new LinkedHashSet<DiagramEdge>();
        this.makeNodes(relevantObjects, idMap, reflectorMap, diagramObjects, edges);
        ST st = TEMPLATE_GROUP.getInstanceOf("objectDiagram");
        st.add("title", (Object)packageName);
        st.add("objects", diagramObjects);
        st.add("edges", edges);
        String dotString = st.render();
        try {
            Graphviz.fromString((String)dotString).scale(this.scale).render(format).toFile(new File(diagramFileName));
            return diagramFileName;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Object[] flatten(Object ... objectList) {
        ArrayList<Object> flatList = new ArrayList<Object>();
        for (Object obj : objectList) {
            if (obj instanceof Collection) {
                flatList.addAll((Collection)obj);
                continue;
            }
            flatList.add(obj);
        }
        return flatList.toArray();
    }

    private void makeNodes(Set<Object> relevantObjects, YamlIdMap idMap, ReflectorMap reflectorMap, Set<DiagramObject> objects, Set<DiagramEdge> edges) {
        for (Map.Entry entry : idMap.getObjIdMap().entrySet()) {
            YamlObject yamlObj;
            String type;
            String key = (String)entry.getKey();
            Object obj = entry.getValue();
            if (!relevantObjects.contains(obj)) continue;
            String className = obj.getClass().getSimpleName();
            if (obj instanceof YamlObject && (type = (yamlObj = (YamlObject)obj).getType()) != null) {
                className = type.toString();
            }
            Reflector creator = reflectorMap.getReflector(obj);
            String userKey = key;
            Object tmp = creator.getValue(obj, "id");
            if (tmp != null) {
                userKey = StrUtil.downFirstChar((String)tmp.toString());
            } else {
                tmp = creator.getValue(obj, "name");
                if (tmp != null) {
                    userKey = StrUtil.downFirstChar((String)tmp.toString());
                }
            }
            LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
            DiagramObject diagramObject = new DiagramObject(key, userKey, className, attributes);
            objects.add(diagramObject);
            for (String prop : creator.getOwnProperties()) {
                if (obj instanceof YamlObject && ".id".equals(prop) || obj instanceof YamlObject && "type".equals(prop)) continue;
                Object value = creator.getValue(obj, prop);
                if (value == null) {
                    try {
                        Method method = obj.getClass().getMethod("get" + StrUtil.cap((String)prop), new Class[0]);
                        Class<?> fieldType = method.getReturnType();
                        if (fieldType != String.class) continue;
                        attributes.put(prop, "null");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (value instanceof Collection) {
                    for (Object elem : (Collection)value) {
                        if (!relevantObjects.contains(elem)) continue;
                        String targetKey = idMap.getId(elem);
                        this.addEdge(edges, key, targetKey, prop);
                    }
                    continue;
                }
                String valueKey = idMap.getId(value);
                if (valueKey != null) {
                    if (!relevantObjects.contains(value)) continue;
                    String targetKey = idMap.getId(value);
                    this.addEdge(edges, key, targetKey, prop);
                    continue;
                }
                if (value instanceof String) {
                    value = "\"" + ((String)value).replace("\"", "\\\"") + "\"";
                } else if (ObjectDiagrams.isLambdaClass(value.getClass())) {
                    value = "<lambda expression>";
                }
                attributes.put(prop, value);
            }
        }
    }

    private static boolean isLambdaClass(Class<?> aClass) {
        String className = aClass.getName();
        int lambdaIndex = className.indexOf("$$Lambda$");
        return 0 <= lambdaIndex && lambdaIndex <= className.indexOf(47);
    }

    private void addEdge(Set<DiagramEdge> edges, String key, String targetKey, String prop) {
        for (DiagramEdge existing : edges) {
            if (key.equals(existing.getSource()) && targetKey.equals(existing.getTarget())) {
                existing.setSourceLabel(prop);
                return;
            }
            if (!key.equals(existing.getTarget()) || !targetKey.equals(existing.getSource())) continue;
            existing.setTargetLabel(prop);
            return;
        }
        DiagramEdge edge = new DiagramEdge(key, targetKey, prop, null);
        edges.add(edge);
    }

    static {
        StringRenderer stringRenderer = new StringRenderer();
        TEMPLATE_GROUP.registerRenderer(Object.class, (value, formatString, locale) -> stringRenderer.toString(Objects.toString(value), formatString, locale));
    }
}

