/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.tools;

import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.engine.Graphviz;
import guru.nidi.graphviz.engine.GraphvizException;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.fulib.classmodel.AssocRole;
import org.fulib.classmodel.ClassModel;
import org.fulib.classmodel.Clazz;
import org.stringtemplate.v4.AttributeRenderer;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.STGroupFile;
import org.stringtemplate.v4.StringRenderer;

public class ClassDiagrams {
    private static final STGroup TEMPLATE_GROUP = new STGroupFile(ClassDiagrams.class.getResource("templates/classDiagram.stg"));
    private static final Comparator<AssocRole> ASSOC_ROLE_COMPARATOR;
    private static final Comparator<Clazz> CLAZZ_COMPARATOR;
    private double scale = 1.0;

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public ClassDiagrams withScale(double scale) {
        this.setScale(scale);
        return this;
    }

    public String dumpPng(ClassModel model) {
        String diagramFileName = model.getPackageSrcFolder() + "/doc-files/classDiagram.png";
        return this.dumpPng(model, diagramFileName);
    }

    public String dumpPng(ClassModel model, String diagramFileName) {
        return this.dump(model, diagramFileName, Format.PNG);
    }

    public String dumpSVG(ClassModel model, String diagramFileName) {
        return this.dump(model, diagramFileName, Format.SVG);
    }

    public String dump(ClassModel model, String diagramFileName, Format format) {
        List<Clazz> sortedClasses = ClassDiagrams.getSortedClasses(model);
        ST classDiagram = TEMPLATE_GROUP.getInstanceOf("classDiagram");
        classDiagram.add("classModel", (Object)model);
        classDiagram.add("classes", sortedClasses);
        classDiagram.add("roles", ClassDiagrams.getRolesWithoutOthers(sortedClasses));
        classDiagram.add("subClasses", ClassDiagrams.getClassesWithSuperClasses(sortedClasses));
        String dotString = classDiagram.render();
        try {
            Graphviz.fromString((String)dotString).scale(this.getScale()).render(format).toFile(new File(diagramFileName));
            return diagramFileName;
        }
        catch (GraphvizException graphvizException) {
            throw new RuntimeException("Graphviz rendering failed for dot string from class model:\n" + dotString, graphvizException);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static List<Clazz> getSortedClasses(ClassModel model) {
        return model.getClasses().stream().sorted(CLAZZ_COMPARATOR).collect(Collectors.toList());
    }

    private static Set<AssocRole> getRolesWithoutOthers(List<Clazz> classes) {
        LinkedHashSet<AssocRole> result = new LinkedHashSet<AssocRole>();
        classes.stream().map(Clazz::getRoles).flatMap(Collection::stream).sorted(ASSOC_ROLE_COMPARATOR).forEach(role -> {
            if (!result.contains(role.getOther())) {
                result.add((AssocRole)role);
            }
        });
        return result;
    }

    private static List<Clazz> getClassesWithSuperClasses(List<Clazz> classes) {
        return classes.stream().filter(c -> c.getSuperClass() != null).collect(Collectors.toList());
    }

    static {
        TEMPLATE_GROUP.registerRenderer(String.class, (AttributeRenderer)new StringRenderer());
        ASSOC_ROLE_COMPARATOR = Comparator.nullsFirst(Comparator.comparing(AssocRole::getName));
        CLAZZ_COMPARATOR = Comparator.comparing(Clazz::getName);
    }
}

