/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.workflows;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Logger;
import org.fulib.StrUtil;
import org.fulib.workflows.BrokerTopicNote;
import org.fulib.workflows.ClassNote;
import org.fulib.workflows.CommandNote;
import org.fulib.workflows.DataNote;
import org.fulib.workflows.DataType;
import org.fulib.workflows.EventNote;
import org.fulib.workflows.EventStormingBoard;
import org.fulib.workflows.EventType;
import org.fulib.workflows.ExternalSystemNote;
import org.fulib.workflows.Interaction;
import org.fulib.workflows.PageLine;
import org.fulib.workflows.PageNote;
import org.fulib.workflows.Policy;
import org.fulib.workflows.QueryNote;
import org.fulib.workflows.ServiceNote;
import org.fulib.workflows.SubprocessNote;
import org.fulib.workflows.UserInteraction;
import org.fulib.workflows.UserNote;
import org.fulib.workflows.Workflow;
import org.fulib.workflows.WorkflowNote;
import org.fulib.yaml.Yamler2;

public class EventModel {
    public String workflowName;
    private EventStormingBoard eventStormingBoard = null;
    private Workflow rootWorkflow;
    private Interaction lastActor;
    private EventNote lastEvent;
    private LinkedList<String> yamlFileList;
    private UserInteraction lastUser;
    private ServiceNote lastService;
    private ExternalSystemNote externalSystemNote = null;
    private Workflow lastWorkflow = null;

    public EventStormingBoard getEventStormingBoard() {
        if (this.eventStormingBoard == null) {
            this.eventStormingBoard = new EventStormingBoard();
        }
        return this.eventStormingBoard;
    }

    public Workflow getRootWorkflow() {
        if (this.rootWorkflow == null) {
            this.rootWorkflow = new Workflow().setName("working smoothly");
            this.getEventStormingBoard().withWorkflows(this.rootWorkflow);
        }
        return this.rootWorkflow;
    }

    public EventStormingBoard buildEventStormModel(String fileName) {
        this.yamlFileList = new LinkedList();
        this.yamlFileList.add(fileName);
        while (!this.yamlFileList.isEmpty()) {
            fileName = this.yamlFileList.poll();
            String oneYaml = null;
            try {
                oneYaml = Files.readString(Path.of(fileName, new String[0]));
            }
            catch (IOException e) {
                continue;
            }
            ArrayList<LinkedHashMap<String, String>> maps = new Yamler2().decodeList(oneYaml);
            LinkedHashMap<String, PageNote> userLastPage = new LinkedHashMap<String, PageNote>();
            this.lastActor = null;
            this.lastUser = null;
            while (!maps.isEmpty()) {
                String value;
                LinkedHashMap<String, String> map = maps.remove(0);
                Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
                Map.Entry<String, String> entry = iterator.next();
                if (entry.getKey().equalsIgnoreCase("workflow")) {
                    this.workflowName = entry.getValue();
                    this.workflowName = org.fulib.workflows.StrUtil.toIdentifier(this.workflowName);
                    this.rootWorkflow = new Workflow().setName(this.workflowName);
                    this.rootWorkflow.setMap(map);
                    this.getEventStormingBoard().withWorkflows(this.rootWorkflow);
                    if (this.lastWorkflow != null) {
                        String newTime = this.lastWorkflow.addToTime("01:00:00");
                        this.rootWorkflow.setCurrentTime(newTime);
                    }
                    this.lastWorkflow = this.rootWorkflow;
                    continue;
                }
                if (entry.getKey().equals("user")) {
                    UserNote userNote = new UserNote().setName(map.get("name"));
                    userNote.setMap(map);
                    userNote.setEventStormingBoard(this.getEventStormingBoard());
                    continue;
                }
                if (entry.getKey().equalsIgnoreCase("service")) {
                    ServiceNote note = new ServiceNote();
                    note.setName(entry.getValue());
                    note.setPort(map.get("port"));
                    note.setMap(map);
                    note.withWorkflows(this.getRootWorkflow());
                    note.setEventStormingBoard(this.getEventStormingBoard());
                    this.lastService = note;
                    continue;
                }
                if (entry.getKey().equalsIgnoreCase("Action")) {
                    UserInteraction userInteraction = new UserInteraction();
                    userInteraction.setActorName(entry.getValue());
                    UserNote userNote = this.getEventStormingBoard().getOrCreateFromUsers(userInteraction.getActorName());
                    userNote.withInteractions(userInteraction);
                    this.lastActor = userInteraction;
                    this.lastUser = userInteraction;
                    continue;
                }
                if (entry.getKey().equalsIgnoreCase("subprocess") || entry.getKey().equalsIgnoreCase("boundedContext")) {
                    SubprocessNote subprocessNote = new SubprocessNote();
                    subprocessNote.setSubprocessName(org.fulib.workflows.StrUtil.toIdentifier(entry.getValue()));
                    subprocessNote.setTime(subprocessNote.getSubprocessName());
                    subprocessNote.setMap(map);
                    subprocessNote.setWorkflow(this.getRootWorkflow());
                    subprocessNote.setKind(entry.getKey());
                    subprocessNote.setEventStormingBoard(this.getEventStormingBoard());
                    this.addSubFile(fileName, subprocessNote);
                    continue;
                }
                if (entry.getKey().equalsIgnoreCase("brokerTopic")) {
                    BrokerTopicNote brokerTopicNote = new BrokerTopicNote();
                    brokerTopicNote.setBrokerName(org.fulib.workflows.StrUtil.toIdentifier(entry.getValue()));
                    brokerTopicNote.setTime(brokerTopicNote.getBrokerName());
                    brokerTopicNote.setMap(map);
                    brokerTopicNote.setWorkflow(this.getRootWorkflow());
                    this.addToStepsOfLastActor(brokerTopicNote);
                    continue;
                }
                if (entry.getKey().equalsIgnoreCase("Policy")) {
                    maps = this.buildPolicy(fileName, maps, map, entry);
                    continue;
                }
                if (entry.getKey().equalsIgnoreCase("class")) {
                    ClassNote classNote = new ClassNote();
                    classNote.setMap(map);
                    classNote.setWorkflow(this.getRootWorkflow());
                    this.addToStepsOfLastActor(classNote);
                    continue;
                }
                if (entry.getKey().equalsIgnoreCase("Data")) {
                    this.buildDataNote(map, iterator, entry);
                    continue;
                }
                if (entry.getKey().equalsIgnoreCase("event")) {
                    EventNote eventNote = new EventNote();
                    this.fillEventNote(map, eventNote);
                    continue;
                }
                if (entry.getKey().equalsIgnoreCase("externalSystem")) {
                    value = entry.getValue();
                    ExternalSystemNote externalSystemNote = new ExternalSystemNote();
                    String timeInterval = map.get("events");
                    externalSystemNote.setMap(map);
                    externalSystemNote.setTimeInterval(timeInterval);
                    externalSystemNote.setTime(timeInterval);
                    externalSystemNote.setWorkflow(this.getRootWorkflow());
                    externalSystemNote.setSystemName(this.getTypeName(value));
                    continue;
                }
                if (entry.getKey().equalsIgnoreCase("command")) {
                    CommandNote commandNote = new CommandNote();
                    this.fillEventNote(map, commandNote);
                    continue;
                }
                if (entry.getKey().equalsIgnoreCase("page")) {
                    this.buildPageNote(userLastPage, map, entry);
                    continue;
                }
                if (entry.getKey().equalsIgnoreCase("board")) {
                    this.getEventStormingBoard().setName(map.get("board"));
                    continue;
                }
                if (entry.getKey().equalsIgnoreCase("query")) {
                    value = entry.getValue();
                    String[] split = value.split("\\s+");
                    String key = split[0];
                    String time = split[1];
                    QueryNote queryNote = new QueryNote();
                    queryNote.setTime(time);
                    queryNote.setWorkflow(this.getRootWorkflow());
                    queryNote.setMap(map);
                    queryNote.setKey(key);
                    queryNote.setResult(map.get("result"));
                    this.addToStepsOfLastActor(queryNote);
                    continue;
                }
                Logger.getGlobal().severe("Unknown event type " + this.getEventType(map));
            }
        }
        this.generateExports(fileName);
        return this.getEventStormingBoard();
    }

    private ArrayList<LinkedHashMap<String, String>> buildPolicy(String fileName, ArrayList<LinkedHashMap<String, String>> maps, LinkedHashMap<String, String> map, Map.Entry<String, String> entry) {
        Policy policy = new Policy();
        policy.setActorName(entry.getValue());
        policy.setWorkflow(this.getRootWorkflow());
        ServiceNote service = this.getEventStormingBoard().getOrCreateFromServices(entry.getValue());
        policy.setService(service);
        String triggerTime = map.get("trigger");
        WorkflowNote trigger = null;
        if (triggerTime != null) {
            trigger = this.getRootWorkflow().getFromNotes(triggerTime);
        } else if (this.lastEvent != null) {
            trigger = this.lastEvent;
        }
        if (trigger != null) {
            if (trigger instanceof EventNote) {
                EventNote eventNote = (EventNote)trigger;
                policy.setTrigger(eventNote);
                EventType type = eventNote.getType();
                service.withHandledEventTypes(type);
            } else {
                String oneYaml;
                ExternalSystemNote externalSystemNote = (ExternalSystemNote)trigger;
                policy.setExternalSystem(externalSystemNote);
                String importedFileName = fileName.substring(0, fileName.lastIndexOf(47));
                String exportName = externalSystemNote.getSystemName();
                importedFileName = String.format("%s/export%s.es.yaml", importedFileName, exportName);
                try {
                    oneYaml = Files.readString(Path.of(importedFileName, new String[0]));
                }
                catch (IOException e) {
                    return null;
                }
                ArrayList<LinkedHashMap<String, String>> importedMaps = new Yamler2().decodeList(oneYaml);
                importedMaps.addAll(maps);
                maps = importedMaps;
            }
        }
        this.lastService = service;
        this.lastActor = policy;
        return maps;
    }

    private void generateExports(String fileName) {
        StringBuilder body = new StringBuilder();
        String currentTopic = null;
        for (Workflow workflow : this.getEventStormingBoard().getWorkflows()) {
            for (WorkflowNote note : workflow.getNotes()) {
                if (note instanceof BrokerTopicNote) {
                    BrokerTopicNote brokerTopicNote = (BrokerTopicNote)note;
                    currentTopic = brokerTopicNote.getBrokerName();
                    continue;
                }
                if (!(note instanceof DataNote)) continue;
                String oneNote = this.mapToYaml(note.getMap());
                body.append(oneNote);
            }
        }
        if (currentTopic == null) {
            return;
        }
        int lastIndexOf = fileName.lastIndexOf(47);
        fileName = fileName.substring(0, lastIndexOf);
        fileName = String.format("%s/export%s.es.yaml", fileName, currentTopic);
        try {
            Files.writeString(Path.of(fileName, new String[0]), (CharSequence)body.toString(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String mapToYaml(LinkedHashMap<String, String> map) {
        StringBuilder body = new StringBuilder();
        String indent = "- ";
        for (Map.Entry<String, String> entry : map.entrySet()) {
            body.append(String.format("%s%s: %s\n", indent, entry.getKey(), entry.getValue()));
            indent = "  ";
        }
        return body.toString() + "\n";
    }

    private void addSubFile(String fileName, SubprocessNote subprocessNote) {
        ArrayList fileNameTries = new ArrayList();
        String subFileName = fileName.substring(0, fileName.lastIndexOf(47));
        if (Files.exists(Path.of(subFileName = String.format("%s/%s.es.yaml", subFileName, subprocessNote.getSubprocessName()), new String[0]), new LinkOption[0])) {
            this.yamlFileList.add(subFileName);
            return;
        }
        subFileName = fileName.substring(0, fileName.lastIndexOf(47));
        if (Files.exists(Path.of(subFileName = String.format("%s/%s/%2$s.es.yaml", subFileName, subprocessNote.getSubprocessName()), new String[0]), new LinkOption[0])) {
            this.yamlFileList.add(subFileName);
            return;
        }
        Logger.getGlobal().info("No file for subprocess or bounded context " + subprocessNote.getSubprocessName());
    }

    private void buildDataNote(LinkedHashMap<String, String> map, Iterator<Map.Entry<String, String>> iterator, Map.Entry<String, String> entry) {
        String objectId;
        String className;
        Map.Entry<String, String> typeEntry;
        Object value = entry.getValue();
        String[] split = org.fulib.workflows.StrUtil.split((String)value);
        String time = split[split.length - 1];
        if (time.indexOf(58) < 0) {
            time = this.getRootWorkflow().addToTime("00:00:01");
            value = (String)value + " " + time;
            split = org.fulib.workflows.StrUtil.split((String)value);
        }
        if (split.length == 1) {
            value = split[0];
            typeEntry = iterator.next();
            className = org.fulib.workflows.StrUtil.cap(typeEntry.getKey());
            objectId = typeEntry.getValue();
        } else if (split.length == 2) {
            className = split[0];
            value = split[1];
            typeEntry = iterator.next();
            objectId = typeEntry.getValue();
            objectId = this.getObjectId(objectId);
            map.put("data", String.format("%s %s %s", className, objectId, value));
        } else {
            className = org.fulib.workflows.StrUtil.cap(split[0]);
            objectId = split[1];
            value = split[2];
        }
        DataNote note = new DataNote();
        note.setTime((String)value);
        note.setBlockId(objectId);
        note.setMap(map);
        note.setDataType(className);
        this.addToStepsOfLastActor(note);
        ServiceNote serviceNote = ((Policy)this.lastActor).getService();
        serviceNote.getObjectMap().put(objectId, className);
        DataType dataType = this.eventStormingBoard.getOrCreateDataType(note.getDataType());
        dataType.withDataNotes(note);
        String migratedTo = map.get("@migratedTo");
        if (migratedTo != null) {
            dataType.setMigratedTo(migratedTo);
        }
        serviceNote.withHandledDataTypes(dataType);
    }

    private void buildPageNote(LinkedHashMap<String, PageNote> userLastPage, LinkedHashMap<String, String> map, Map.Entry<String, String> entry) {
        PageNote pageNote = new PageNote();
        pageNote.setWorkflow(this.getRootWorkflow());
        pageNote.setMap(map);
        String multilineValue = entry.getValue();
        ArrayList<LinkedHashMap<String, String>> lineMaps = new Yamler2().decodeList(multilineValue);
        for (LinkedHashMap<String, String> lineMap : lineMaps) {
            String command;
            PageLine pageLine = new PageLine().setPageNote(pageNote).setMap(lineMap);
            Object nameValue = lineMap.get("name");
            if (nameValue != null) {
                String time = this.getEventTime((String)nameValue, "00:01:00");
                if (!((String)nameValue).endsWith(time)) {
                    nameValue = (String)nameValue + " " + time;
                    lineMap.put("name", (String)nameValue);
                }
                String[] split = ((String)nameValue).split("\\s+");
                String pageName = split[split.length - 1];
                String serviceName = split[0];
                pageNote.setTime(pageName);
                ServiceNote serviceNote = this.getEventStormingBoard().getOrCreateFromServices(serviceName);
                pageNote.setService(serviceNote);
                this.addToStepsOfLastActor(pageNote);
                PageNote previousPage = userLastPage.get(this.lastActor.getActorName());
                if (previousPage != null) {
                    previousPage.setNextPage(pageNote);
                }
                userLastPage.put(this.lastActor.getActorName(), pageNote);
            }
            if ((command = lineMap.get("command")) == null) continue;
            String buttonId = lineMap.get("button");
            pageNote.setButtonId(buttonId);
            CommandNote commandNote = new CommandNote();
            LinkedHashMap<String, String> eventMap = new LinkedHashMap<String, String>();
            eventMap.put("command", command);
            for (PageLine line : pageNote.getLines()) {
                String input = line.getMap().get("input");
                if (input == null) continue;
                String fill = line.getMap().get("fill");
                if (fill == null) {
                    fill = "somevalue";
                }
                eventMap.put(input, fill);
            }
            String eventDescription = this.getEventId(eventMap);
            String eventTime = this.getEventTime(eventDescription, "00:00:01");
            String eventTypeName = this.getEventTypeName(eventDescription) + "Command";
            commandNote.setTime(eventTime);
            commandNote.setEventTypeName(eventTypeName);
            commandNote.setWorkflow(this.getRootWorkflow());
            commandNote.setMap(eventMap);
            commandNote.setRaisingPage(pageNote);
            EventType eventType = this.getEventStormingBoard().getOrCreateEventType(commandNote.getEventTypeName());
            eventType.withEvents((EventNote)commandNote);
            this.lastEvent = commandNote;
            this.addToStepsOfLastActor(commandNote);
        }
    }

    private void fillEventNote(LinkedHashMap<String, String> map, EventNote eventNote) {
        String eventTime;
        Object value = this.getEventId(map);
        if (!((String)value).endsWith(eventTime = this.getEventTime((String)value, "00:01:00"))) {
            value = (String)value + " " + eventTime;
        }
        eventNote.setTime(eventTime);
        String suffix = eventNote instanceof CommandNote ? "Command" : "Event";
        String eventTypeName = this.getEventTypeName((String)value) + suffix;
        eventNote.setEventTypeName(eventTypeName);
        eventNote.setWorkflow(this.getRootWorkflow());
        eventNote.setMap(map);
        EventType eventType = this.getEventStormingBoard().getOrCreateEventType(eventNote.getEventTypeName());
        eventType.withEvents(eventNote);
        this.lastEvent = eventNote;
        this.addToStepsOfLastActor(eventNote);
    }

    private String getEventTime(String value, String delta) {
        String[] split = ((String)value).split("\\s");
        String eventTime = split[split.length - 1];
        if (eventTime.indexOf(58) < 0) {
            eventTime = this.getRootWorkflow().addToTime(delta);
            value = (String)value + " " + eventTime;
            split = org.fulib.workflows.StrUtil.split((String)value);
        } else {
            this.getRootWorkflow().setCurrentTime(eventTime);
        }
        return eventTime;
    }

    public String getEventTypeName(String value) {
        String[] split2 = value.split("\\s");
        Object eventTypeName = "";
        for (int i = 0; i < split2.length - 1; ++i) {
            eventTypeName = (String)eventTypeName + StrUtil.cap((String)split2[i]);
        }
        return eventTypeName;
    }

    public String getTypeName(String value) {
        String[] split2 = value.split("\\s");
        Object typeName = "";
        for (int i = 0; i < split2.length; ++i) {
            typeName = (String)typeName + StrUtil.cap((String)split2[i]);
        }
        return typeName;
    }

    public String getVarName(String value) {
        String[] split2 = value.split("\\s");
        Object varName = org.fulib.workflows.StrUtil.decap(split2[0]);
        for (int i = 1; i < split2.length; ++i) {
            varName = (String)varName + StrUtil.cap((String)split2[i]);
        }
        return varName;
    }

    public String getObjectId(String objectId) {
        if (objectId == null) {
            return null;
        }
        return objectId.replaceAll("\\W+", "_");
    }

    private void addToStepsOfLastActor(WorkflowNote note) {
        if (note instanceof EventNote || note instanceof PageNote || note instanceof CommandNote || note instanceof BrokerTopicNote) {
            Object somebody;
            if (this.lastUser == null) {
                somebody = this.getEventStormingBoard().getOrCreateFromUsers("somebody");
                this.lastUser = (UserInteraction)new UserInteraction().setWorkflow(this.getRootWorkflow()).setUser((UserNote)somebody).setActorName("somebody");
            }
            if (this.lastActor == null) {
                this.lastActor = this.lastUser;
            }
            if (this.lastActor instanceof Policy && (note instanceof PageNote || note instanceof CommandNote)) {
                this.lastActor = new UserInteraction().setWorkflow(this.getRootWorkflow()).setUser(this.lastUser.getUser()).setActorName(this.lastUser.getActorName());
            }
            if (note instanceof PageNote || note instanceof CommandNote) {
                somebody = this.lastActor.getActorName();
            }
        } else if (note instanceof DataNote || note instanceof ClassNote || note instanceof QueryNote) {
            if (this.lastEvent == null && this.externalSystemNote == null) {
                this.externalSystemNote = new ExternalSystemNote();
                this.externalSystemNote.setTime("11:00:00");
                this.externalSystemNote.setWorkflow(this.getRootWorkflow());
                this.externalSystemNote.setSystemName("someExternalSystem");
                LinkedHashMap<String, String> exMap = new LinkedHashMap<String, String>();
                exMap.put("externalsystem", "someExternalsystem");
                this.externalSystemNote.setMap(exMap);
            }
            if (this.lastService == null) {
                this.lastService = this.getEventStormingBoard().getOrCreateFromServices("someservice");
            }
            if (this.lastActor == null || !(this.lastActor instanceof Policy)) {
                Interaction action;
                if (this.lastEvent != null) {
                    action = new Policy().setWorkflow(this.getRootWorkflow()).setService(this.lastService).setTrigger(this.lastEvent).setActorName(this.lastService.getName());
                    this.lastService.withHandledEventTypes(this.lastEvent.getType());
                    this.lastActor = action;
                } else {
                    this.lastActor = action = new Policy().setWorkflow(this.getRootWorkflow()).setService(this.lastService).setExternalSystem(this.externalSystemNote).setActorName(this.lastService.getName());
                }
            }
            note.setWorkflow(this.getRootWorkflow());
        } else {
            Logger.getGlobal().severe("Unknown note type " + note.getClass().getSimpleName());
        }
        this.lastActor.withSteps(note);
    }

    public String getEventId(Map<String, String> map) {
        return map.values().iterator().next();
    }

    public String getEventType(Map<String, String> map) {
        return map.keySet().iterator().next();
    }
}

