/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.workflows;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.fulib.Fulib;
import org.fulib.FulibTools;
import org.fulib.StrUtil;
import org.fulib.builder.ClassModelManager;
import org.fulib.classmodel.AssocRole;
import org.fulib.classmodel.Attribute;
import org.fulib.classmodel.Clazz;
import org.fulib.tables.ObjectTable;
import org.fulib.workflows.ClassNote;
import org.fulib.workflows.CommandNote;
import org.fulib.workflows.DataNote;
import org.fulib.workflows.DataType;
import org.fulib.workflows.EventModel;
import org.fulib.workflows.EventNote;
import org.fulib.workflows.EventStormingBoard;
import org.fulib.workflows.EventType;
import org.fulib.workflows.ExternalSystemNote;
import org.fulib.workflows.Interaction;
import org.fulib.workflows.PageLine;
import org.fulib.workflows.PageNote;
import org.fulib.workflows.Policy;
import org.fulib.workflows.QueryNote;
import org.fulib.workflows.ServiceNote;
import org.fulib.workflows.UserInteraction;
import org.fulib.workflows.Workflow;
import org.fulib.workflows.WorkflowNote;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroupFile;

public class WorkflowGenerator {
    private ClassModelManager mm;
    private ClassModelManager em;
    private ClassModelManager tm;
    private Clazz modelClazz;
    private LinkedHashMap<String, ClassModelManager> managerMap;
    private STGroupFile group;
    private Clazz testClazz;
    private EventModel eventModel;
    public Consumer<Object> dumpObjectDiagram;
    private EventStormingBoard eventStormingBoard;
    private StringBuilder testBody;
    private ArrayList<String> testVarNames;
    private Clazz serviceClazz;
    private Clazz logicClass;
    private Clazz builderClass;
    private ServiceNote lastServiceNote;
    private Clazz logic;
    private StringBuilder testClosing;

    public EventModel getEventModel() {
        return this.eventModel;
    }

    public WorkflowGenerator generateWorkflow(ClassModelManager mm, String fileName) {
        this.loadWorkflow(mm, fileName);
        this.generate();
        return this;
    }

    public WorkflowGenerator loadWorkflow(ClassModelManager mm, String fileName) {
        this.mm = mm;
        this.group = new STGroupFile(this.getClass().getResource("templates/Workflows.stg"));
        this.eventModel = new EventModel();
        this.eventStormingBoard = this.eventModel.buildEventStormModel(fileName);
        if (this.dumpObjectDiagram != null) {
            this.dumpObjectDiagram.accept(this.eventStormingBoard);
        }
        this.buildClassModelManagerMap(mm);
        this.buildEventBroker();
        this.buildEventClasses();
        this.buildServices();
        this.buildTest();
        return this;
    }

    public WorkflowGenerator loadPlainModel(ClassModelManager mm, String fileName) {
        this.mm = mm;
        this.group = new STGroupFile(this.getClass().getResource("templates/Workflows.stg"));
        this.eventModel = new EventModel();
        this.eventStormingBoard = this.eventModel.buildEventStormModel(fileName);
        this.managerMap = new LinkedHashMap();
        this.managerMap.put("mm", mm);
        this.buildPlainModel();
        this.buildPlainTest();
        return this;
    }

    private void buildPlainModel() {
        ClassModelManager modelManager = null;
        Iterator<ServiceNote> iterator = this.eventStormingBoard.getServices().iterator();
        while (iterator.hasNext()) {
            ServiceNote currentServiceNote;
            this.lastServiceNote = currentServiceNote = iterator.next();
            String serviceName = currentServiceNote.getName();
            modelManager = this.mm;
            this.managerMap.put(serviceName, modelManager);
            Clazz modelClazz = modelManager.haveClass(serviceName + "Model");
            modelClazz.withImports("import java.util.LinkedHashMap;");
            modelManager.haveAttribute(modelClazz, "modelMap", "LinkedHashMap<String, Object>", "new LinkedHashMap<>()");
            this.buildPlainDataClasses(currentServiceNote, modelManager);
        }
    }

    private void buildPlainDataClasses(ServiceNote serviceNote, ClassModelManager modelManager) {
        for (Workflow workflow : serviceNote.getEventStormingBoard().getWorkflows()) {
            for (WorkflowNote note : workflow.getNotes()) {
                if (!(note instanceof DataNote)) continue;
                serviceNote.getObjectMap().put(((DataNote)note).getBlockId(), ((DataNote)note).getDataType());
            }
        }
        for (Workflow workflow : serviceNote.getEventStormingBoard().getWorkflows()) {
            for (WorkflowNote note : workflow.getNotes()) {
                if (note instanceof DataNote) {
                    DataNote dataNote = (DataNote)note;
                    if (dataNote.getType().getMigratedTo() != null) continue;
                    LinkedHashMap<String, String> map = note.getMap();
                    LinkedHashMap<String, String> mockup = this.getMockup(map);
                    this.addModelClassForDataNote(modelManager, serviceNote, mockup);
                    this.addGetOrCreateMethodToServiceModel(modelManager, serviceNote.getName(), mockup);
                    continue;
                }
                if (!(note instanceof ClassNote)) continue;
                ClassNote classNote = (ClassNote)note;
                this.addModelClassForClassNote(modelManager, serviceNote, classNote);
            }
        }
    }

    private void buildPlainTest() {
        this.tm = new ClassModelManager().setMainJavaDir(this.mm.getClassModel().getMainJavaDir().replace("/main/java", "/test/java")).setPackageName(this.mm.getClassModel().getPackageName());
        this.managerMap.put("tm", this.tm);
        String boardName = org.fulib.workflows.StrUtil.toIdentifier(this.eventStormingBoard.getName());
        this.testClazz = this.tm.haveClass("Test" + boardName);
        this.testClazz.withImports(new String[]{"import org.junit.Test;", "import java.util.LinkedHashMap;", "import org.fulib.FulibTools;", "import static org.assertj.core.api.Assertions.assertThat;"});
        String declaration = "@Test\npublic void test" + org.fulib.workflows.StrUtil.toIdentifier(this.eventModel.getEventStormingBoard().getName()) + "()";
        this.testBody = new StringBuilder();
        this.testVarNames = new ArrayList();
        ClassModelManager modelManager = this.managerMap.get(this.lastServiceNote.getName());
        this.logic = modelManager.haveClass(this.lastServiceNote.getName() + "BusinessLogic");
        this.testBody.append(String.format("%s logic = new %1$s();\n", this.logic.getName()));
        this.addAllObjectCreation();
        this.addAllLinkCreation();
        String allVarNames = String.join((CharSequence)", ", this.testVarNames.toArray(new String[0]));
        this.testBody.append(String.format("\nFulibTools.objectDiagrams().dumpSVG(\"tmp/%sStart.svg\", %s);\n\n", boardName, allVarNames));
        this.addAllCommands();
        this.testBody.append(String.format("\nFulibTools.objectDiagrams().dumpSVG(\"tmp/%sEnd.svg\", %s);\n\n", boardName, allVarNames));
        this.testBody.append("\nSystem.err.println();\n");
        this.tm.haveMethod(this.testClazz, declaration, this.testBody.toString());
    }

    private void addAllObjectCreation() {
        for (Workflow workflow : this.eventStormingBoard.getWorkflows()) {
            for (WorkflowNote note : workflow.getNotes()) {
                if (!(note instanceof ExternalSystemNote)) continue;
                ExternalSystemNote externalSystemNote = (ExternalSystemNote)note;
                for (Policy policy : externalSystemNote.getPolicies()) {
                    for (WorkflowNote step : policy.getSteps()) {
                        if (!(step instanceof DataNote)) continue;
                        this.addObjectCreationToPlainTest(step);
                    }
                }
            }
        }
    }

    private void addAllLinkCreation() {
        this.testBody.append("\n// create links\n");
        for (Workflow workflow : this.eventStormingBoard.getWorkflows()) {
            for (WorkflowNote note : workflow.getNotes()) {
                if (!(note instanceof ExternalSystemNote)) continue;
                ExternalSystemNote externalSystemNote = (ExternalSystemNote)note;
                for (Policy policy : externalSystemNote.getPolicies()) {
                    for (WorkflowNote step : policy.getSteps()) {
                        if (!(step instanceof DataNote)) continue;
                        this.addLinkCreationToPlainTest(step);
                    }
                }
            }
        }
    }

    private void addAllCommands() {
        for (Workflow workflow : this.eventStormingBoard.getWorkflows()) {
            for (WorkflowNote note : workflow.getNotes()) {
                if (!(note instanceof CommandNote)) continue;
                this.addCommandToPlainTest(note);
            }
        }
    }

    private void addCommandToPlainTest(WorkflowNote note) {
        CommandNote commandNote = (CommandNote)note;
        String command = commandNote.getMap().get("command");
        command = this.eventModel.getVarName(command);
        Object params = "";
        Iterator<Map.Entry<String, String>> iterator = commandNote.getMap().entrySet().iterator();
        iterator.next();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            params = (String)params + entry.getValue();
        }
        this.testBody.append(String.format("logic.%s(%s);\n", command, params));
        for (Policy policy : commandNote.getPolicies()) {
            for (WorkflowNote step : policy.getSteps()) {
                LinkedHashMap<String, String> mockup;
                Map.Entry<String, String> entry;
                String blockId;
                if (!(step instanceof DataNote) || !this.testVarNames.contains(blockId = (entry = (iterator = (mockup = this.getMockup(step.getMap())).entrySet().iterator()).next()).getValue())) continue;
                String type = entry.getKey();
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    this.testBody.append(String.format("assertThat(%s.get%s()).isEqualTo(\"%s\");\n", this.eventModel.getVarName(blockId), org.fulib.workflows.StrUtil.cap(entry.getKey()), entry.getValue()));
                }
            }
        }
    }

    private void addObjectCreationToPlainTest(WorkflowNote note) {
        DataNote dataNote = (DataNote)note;
        ClassModelManager modelManager = this.managerMap.get(this.lastServiceNote.getName());
        Clazz dataClass = modelManager.haveClass(dataNote.getDataType());
        LinkedHashMap<String, String> mockup = this.getMockup(dataNote.getMap());
        String blockId = dataNote.getBlockId();
        String varName = org.fulib.workflows.StrUtil.decap(blockId);
        this.testBody.append(String.format("\n%s %s = new %1$s().setId(\"%s\");\n", dataNote.getDataType(), varName, blockId));
        this.testVarNames.add(varName);
        Iterator<Map.Entry<String, String>> iterator = mockup.entrySet().iterator();
        iterator.next();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            String attr = entry.getKey();
            if (attr.endsWith(".back")) continue;
            Object value = entry.getValue();
            Attribute attribute = dataClass.getAttribute(attr);
            AssocRole role = dataClass.getRole(attr);
            if (attribute == null) continue;
            if (attribute.getType().equals("String")) {
                value = "\"" + (String)value + "\"";
            }
            this.testBody.append(String.format("%s.set%s(%s);\n", varName, org.fulib.workflows.StrUtil.cap(attr), value));
        }
    }

    private void addLinkCreationToPlainTest(WorkflowNote note) {
        DataNote dataNote = (DataNote)note;
        ClassModelManager modelManager = this.managerMap.get(this.lastServiceNote.getName());
        Clazz dataClass = modelManager.haveClass(dataNote.getDataType());
        LinkedHashMap<String, String> mockup = this.getMockup(dataNote.getMap());
        String blockId = dataNote.getBlockId();
        String varName = this.eventModel.getVarName(blockId);
        Iterator<Map.Entry<String, String>> iterator = mockup.entrySet().iterator();
        iterator.next();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            String attr = entry.getKey();
            if (attr.endsWith(".back")) continue;
            String value = entry.getValue();
            Attribute attribute = dataClass.getAttribute(attr);
            AssocRole role = dataClass.getRole(attr);
            if (attribute == null && role.getCardinality() <= 1) {
                this.testBody.append(String.format("%s.set%s(%s);\n", varName, org.fulib.workflows.StrUtil.cap(attr), this.eventModel.getVarName(value)));
                continue;
            }
            if (attribute != null || role.getCardinality() <= 1) continue;
            value = org.fulib.workflows.StrUtil.stripBrackets(value);
            this.testBody.append(String.format("%s.with%s(%s);\n", varName, org.fulib.workflows.StrUtil.cap(attr), value));
        }
    }

    private void buildServices() {
        ClassModelManager modelManager = null;
        for (ServiceNote serviceNote : this.eventStormingBoard.getServices()) {
            String port = serviceNote.getPort();
            LinkedHashMap<String, String> map = serviceNote.getMap();
            if (map != null) {
                map.get("port");
            }
            String serviceName = serviceNote.getName();
            modelManager = new ClassModelManager().setMainJavaDir(this.mm.getClassModel().getMainJavaDir()).setPackageName(this.mm.getClassModel().getPackageName() + "." + serviceName);
            this.managerMap.put(serviceName, modelManager);
            Clazz modelClazz = modelManager.haveClass(serviceName + "Model");
            modelClazz.withImports("import java.util.LinkedHashMap;");
            modelManager.haveAttribute(modelClazz, "modelMap", "LinkedHashMap<String, Object>", "new LinkedHashMap<>()");
            this.addBusinessLogicClass(modelManager, serviceName);
            this.addBuilderClass(modelManager, serviceName);
            this.addServiceClass(modelManager, port, serviceName);
            StringBuilder body = new StringBuilder();
            this.addStartMethod(modelManager, serviceName, this.serviceClazz, body);
            this.addGetHelloMethod(modelManager, serviceName, this.serviceClazz, body);
            this.addSubscribeAndLoadOldEventsMethod(modelManager, port, this.serviceClazz, body);
            this.addApplyMethod(modelManager, body);
            this.buildGetPageMethod(modelManager, this.serviceClazz, serviceName, body);
            this.buildModelClasses(modelManager, serviceNote);
            this.buildInitEventHandlerMapMethod(modelManager, serviceNote, body);
            this.buildLoadAndInitLoaderMap(modelManager, serviceNote);
            String declaration = "private void ignoreEvent(Event event)";
            body.setLength(0);
            body.append("// empty\n");
            modelManager.haveMethod(this.logicClass, declaration, body.toString());
            declaration = "public Consumer<Event> getHandler(Event event)";
            body.setLength(0);
            body.append("return getHandlerMap().computeIfAbsent(event.getClass(), k -> this::ignoreEvent);\n");
            modelManager.haveMethod(this.logicClass, declaration, body.toString());
            declaration = "public void publish(Event event)";
            body.setLength(0);
            ST st = this.group.getInstanceOf("servicePublish");
            body.append(st.render());
            modelManager.haveMethod(this.serviceClazz, declaration, body.toString());
            declaration = "private String postApply(Request req, Response res)";
            body.setLength(0);
            st = this.group.getInstanceOf("servicePostApply");
            body.append(st.render());
            modelManager.haveMethod(this.serviceClazz, declaration, body.toString());
            declaration = "public String stripBrackets(String back)";
            body.setLength(0);
            st = this.group.getInstanceOf("stripBrackets");
            body.append(st.render());
            modelManager.haveMethod(this.builderClass, declaration, body.toString());
        }
    }

    private void buildModelClasses(ClassModelManager modelManager, ServiceNote serviceNote) {
        for (Policy policy : serviceNote.getPolicies()) {
            for (WorkflowNote note : policy.getSteps()) {
                if (note instanceof ClassNote) {
                    ClassNote classNote = (ClassNote)note;
                    this.addModelClassForClassNote(modelManager, serviceNote, classNote);
                    continue;
                }
                if (!(note instanceof DataNote)) continue;
                LinkedHashMap<String, String> mockup = this.getMockup(note.getMap());
                this.addModelClassForDataNote(modelManager, serviceNote, mockup);
            }
        }
    }

    private void addBuilderClass(ClassModelManager modelManager, String serviceName) {
        this.builderClass = modelManager.haveClass(serviceName + "Builder");
        modelManager.haveAttribute(this.builderClass, "model", serviceName + "Model");
        this.builderClass.withImports(new String[]{"import java.util.LinkedHashMap;", "import java.util.function.Consumer;", "import " + this.em.getClassModel().getPackageName() + ".*;"});
        modelManager.associate(this.logicClass, "builder", 1, this.builderClass, "businessLogic", 1);
        modelManager.haveAttribute(this.builderClass, "eventStore", "LinkedHashMap<String, DataEvent>", "new LinkedHashMap<>()");
        String declaration = "private boolean outdated(DataEvent event)";
        ST st = this.group.getInstanceOf("builderOutdated");
        String builderBody = st.render();
        modelManager.haveMethod(this.builderClass, declaration, builderBody);
    }

    private void addBusinessLogicClass(ClassModelManager modelManager, String serviceName) {
        this.logicClass = modelManager.haveClass(serviceName + "BusinessLogic");
        modelManager.haveAttribute(this.logicClass, "model", serviceName + "Model");
        this.logicClass.withImports(new String[]{"import java.util.LinkedHashMap;", "import java.util.function.Consumer;", "import " + this.em.getClassModel().getPackageName() + ".*;"});
    }

    private void addServiceClass(ClassModelManager modelManager, String port, String serviceName) {
        this.serviceClazz = modelManager.haveClass(serviceName + "Service");
        this.serviceClazz.withImports(new String[]{"import java.util.LinkedHashMap;", "import java.time.Instant;", "import java.time.format.DateTimeFormatter;", "import java.util.Map;", "import java.util.function.Consumer;", "import " + this.em.getClassModel().getPackageName() + ".*;", "import org.fulib.yaml.Yaml;", "import org.fulib.yaml.YamlIdMap;", "import spark.Service;", "import spark.Request;", "import spark.Response;", "import com.mashape.unirest.http.HttpResponse;", "import com.mashape.unirest.http.Unirest;", "import com.mashape.unirest.http.exceptions.UnirestException;", "import java.util.concurrent.ExecutorService;", "import java.util.concurrent.Executors;", "import java.util.logging.Logger;", "import java.util.logging.Level;"});
        modelManager.haveAttribute(this.serviceClazz, "history", "LinkedHashMap<String, Event>", "new LinkedHashMap<>()");
        modelManager.haveAttribute(this.serviceClazz, "port", "int", port);
        modelManager.haveAttribute(this.serviceClazz, "spark", "Service");
        modelManager.haveAttribute(this.serviceClazz, "model", serviceName + "Model");
        modelManager.associate(this.serviceClazz, "businessLogic", 1, this.logicClass, "service", 1);
        modelManager.associate(this.serviceClazz, "builder", 1, this.builderClass, "service", 1);
        modelManager.haveAttribute(this.logicClass, "handlerMap", "LinkedHashMap<Class, Consumer<Event>>", null);
        String declaration = "public Query query(Query query)";
        ST st = this.group.getInstanceOf("serviceQuery");
        String queryBody = st.render();
        modelManager.haveMethod(this.serviceClazz, declaration, queryBody);
        declaration = "public String isoNow()";
        String isNowBody = "return DateTimeFormatter.ISO_INSTANT.format(Instant.now());\n";
        modelManager.haveMethod(this.serviceClazz, declaration, isNowBody);
    }

    private void buildGetPageMethod(ClassModelManager modelManager, Clazz serviceClazz, String serviceName, StringBuilder body) {
        String declaration = "public String getPage(Request request, Response response)";
        body.setLength(0);
        body.append("// to protect manuel changes to this method insert a 'no' in front of fulib in the next line\n");
        body.append("// fulib\n");
        body.append("return getDemoPage(request, response);\n");
        modelManager.haveMethod(serviceClazz, declaration, body.toString());
        body.setLength(0);
        declaration = "public String getDemoPage(Request request, Response response)";
        StringBuilder eventHandling = new StringBuilder();
        StringBuilder content = new StringBuilder();
        ServiceNote serviceNote = this.eventStormingBoard.getFromServices(serviceName);
        for (PageNote pageNote : serviceNote.getPages()) {
            content.append(String.format("// %s\n", pageNote.getTime()));
            String pageId = org.fulib.workflows.StrUtil.pageId(pageNote.getTime());
            content.append(String.format("if (id.equals(\"%s\")) {\n", pageId));
            this.buildPage(pageNote, eventHandling, content);
            content.append("   return html.toString();\n");
            content.append("}\n\n");
        }
        ST st = this.group.getInstanceOf("serviceGetPage");
        st.add("eventHandling", (Object)eventHandling.toString());
        st.add("content", (Object)content.toString());
        body.append(st.render());
        modelManager.haveMethod(serviceClazz, declaration, body.toString());
    }

    private void buildPage(PageNote pageNote, StringBuilder eventHandling, StringBuilder content) {
        String nextTime = "next_page";
        if (pageNote.getNextPage() != null) {
            nextTime = org.fulib.workflows.StrUtil.pageId(pageNote.getNextPage().getTime());
        }
        content.append(String.format("   html.append(\"<form action=\\\"/page/%s\\\" method=\\\"get\\\">\\n\");\n", nextTime));
        for (PageLine line : pageNote.getLines()) {
            String key;
            String firstTag = line.getMap().keySet().iterator().next();
            if (firstTag.equals("label")) {
                content.append(String.format("   html.append(\"   <p>%s</p>\\n\");\n", line.getMap().get("label")));
                continue;
            }
            if (firstTag.equals("button")) {
                key = line.getMap().get("button");
                String command = line.getMap().get("command");
                if (command != null) {
                    this.buildEventHandling(pageNote, command, eventHandling);
                    content.append(String.format("   html.append(\"   <p><input id=\\\"event\\\" name=\\\"event\\\" type=\\\"hidden\\\" value=\\\"%s\\\"></p>\\n\");\n", command));
                }
                content.append(String.format("   html.append(\"   <p><input id=\\\"%s\\\" name=\\\"button\\\" type=\\\"submit\\\" value=\\\"%1$s\\\"></p>\\n\");\n", key));
                continue;
            }
            if (firstTag.equals("input")) {
                key = line.getMap().get("input");
                content.append(String.format("   html.append(\"   <p><input id=\\\"%s\\\" name=\\\"%1$s\\\" placeholder=\\\"%1$s?\\\"></p>\\n\");\n", key));
                continue;
            }
            if (firstTag.equals("password")) {
                key = line.getMap().get("password");
                content.append(String.format("   html.append(\"   <p><input id=\\\"%s\\\" name=\\\"%1$s\\\" type=\\\"password\\\" placeholder=\\\"%1$s?\\\"></p>\\n\");\n", key));
                continue;
            }
            content.append(String.format("   // %s\n", line.getMap().entrySet().iterator().next().getValue()));
        }
        content.append("   html.append(\"</form>\\n\");\n");
    }

    private void buildEventHandling(PageNote pageNote, String command, StringBuilder eventHandling) {
        EventNote eventNote = pageNote.getRaisedEvent();
        eventHandling.append(String.format("if (\"%s\".equals(event)) {\n", command));
        String varName = this.addCreateAndInitEventCode("   ", eventNote, eventHandling);
        eventHandling.append(String.format("   apply(%s);\n", varName));
        eventHandling.append("}\n\n");
    }

    private void addApplyMethod(ClassModelManager modelManager, StringBuilder body) {
        String declaration = "public void apply(Event event)";
        body.setLength(0);
        ST st = this.group.getInstanceOf("serviceApply");
        body.append(st.render());
        modelManager.haveMethod(this.serviceClazz, declaration, body.toString());
    }

    private void addSubscribeAndLoadOldEventsMethod(ClassModelManager modelManager, String port, Clazz serviceClazz, StringBuilder body) {
        String declaration = "private void subscribeAndLoadOldEvents()";
        body.setLength(0);
        ST st = this.group.getInstanceOf("serviceSubscribeAndLoadOldEvents");
        st.add("port", (Object)port);
        body.append(st.render());
        modelManager.haveMethod(serviceClazz, declaration, body.toString());
    }

    private void addGetHelloMethod(ClassModelManager modelManager, String serviceName, Clazz serviceClazz, StringBuilder body) {
        String declaration = "private String getHello(Request req, Response res)";
        body.setLength(0);
        ST st = this.group.getInstanceOf("serviceGetHelloBody");
        st.add("name", (Object)serviceName);
        body.append(st.render());
        modelManager.haveMethod(serviceClazz, declaration, body.toString());
    }

    private void addStartMethod(ClassModelManager modelManager, String serviceName, Clazz serviceClazz, StringBuilder body) {
        String declaration = "public void start()";
        body.append("Unirest.setTimeouts(3*60*1000, 3*60*1000);\n");
        body.append(String.format("model = new %sModel();\n", serviceName));
        body.append(String.format("setBuilder(new %sBuilder().setModel(model));\n", serviceName));
        body.append(String.format("setBusinessLogic(new %sBusinessLogic());\n", serviceName));
        body.append("businessLogic.setBuilder(getBuilder());\n");
        body.append("businessLogic.setModel(model);\n");
        body.append("ExecutorService executor = Executors.newSingleThreadExecutor();\n");
        body.append("spark = Service.ignite();\n");
        body.append("spark.port(port);\n");
        body.append("spark.get(\"/page/:id\", (req, res) -> executor.submit(() -> this.getPage(req, res)).get());\n");
        body.append("spark.get(\"/\", (req, res) -> executor.submit(() -> this.getHello(req, res)).get());\n");
        body.append("spark.post(\"/apply\", (req, res) -> executor.submit(() -> this.postApply(req, res)).get());\n");
        body.append("spark.init();\n");
        body.append("executor.submit(this::subscribeAndLoadOldEvents);\n");
        body.append(String.format("Logger.getGlobal().info(\"%s service is up and running on port \" + port);\n", serviceName));
        modelManager.haveMethod(serviceClazz, declaration, body.toString());
        declaration = "public void stop()";
        String stopBody = "spark.stop();\n";
        modelManager.haveMethod(serviceClazz, declaration, stopBody);
    }

    private void buildLoadAndInitLoaderMap(ClassModelManager modelManager, ServiceNote serviceNote) {
        String declaration = "public Object load(String blockId)";
        StringBuilder body = new StringBuilder();
        ST st = this.group.getInstanceOf("builderLoad");
        body.append(st.render());
        modelManager.haveMethod(this.builderClass, declaration, body.toString());
        modelManager.haveAttribute(this.builderClass, "loaderMap", "LinkedHashMap<Class, Function<Event, Object>>");
        modelManager.haveAttribute(this.builderClass, "groupStore", "LinkedHashMap<String, LinkedHashMap<String, DataEvent>>", "new LinkedHashMap<>()");
        modelManager.haveImport(this.builderClass, "import java.util.function.Function;");
        declaration = "private void initLoaderMap()";
        body.setLength(0);
        body.append("if (loaderMap == null) {\n");
        body.append("   loaderMap = new LinkedHashMap<>();\n");
        for (DataType dataType : serviceNote.getHandledDataTypes()) {
            if (dataType.getMigratedTo() != null) continue;
            String eventTypeName = dataType.getDataTypeName() + "Built";
            body.append(String.format("   loaderMap.put(%s.class, this::load%s);\n", eventTypeName, eventTypeName));
        }
        body.append("}\n");
        modelManager.haveMethod(this.builderClass, declaration, body.toString());
        declaration = "public String getObjectId(String value)";
        body.setLength(0);
        st = this.group.getInstanceOf("builderGetObjectId");
        body.append(st.render());
        modelManager.haveMethod(this.builderClass, declaration, body.toString());
        declaration = "private void addToGroup(String groupId, String elementId)";
        body.setLength(0);
        st = this.group.getInstanceOf("builderAddToGroup");
        body.append(st.render());
        modelManager.haveMethod(this.builderClass, declaration, body.toString());
    }

    private void buildInitEventHandlerMapMethod(ClassModelManager modelManager, ServiceNote serviceNote, StringBuilder body) {
        String declaration = "public void initEventHandlerMap()";
        body.setLength(0);
        body.append("if (handlerMap == null) {\n");
        body.append("   handlerMap = new LinkedHashMap<>();\n");
        this.addHandlersToInitEventHandlerMap(modelManager, serviceNote, body);
        body.append("}\n");
        modelManager.haveMethod(this.logicClass, declaration, body.toString());
    }

    private void addHandlersToInitEventHandlerMap(ClassModelManager modelManager, ServiceNote serviceNote, StringBuilder body) {
        Object eventTypeName;
        for (DataType dataType : serviceNote.getHandledDataTypes()) {
            eventTypeName = dataType.getDataTypeName() + "Built";
            body.append(String.format("   handlerMap.put(%s.class, builder::store%s);\n", eventTypeName, eventTypeName));
            this.addDataEventHandlerMethod(modelManager, serviceNote, dataType);
        }
        for (EventType eventType : serviceNote.getHandledEventTypes()) {
            eventTypeName = eventType.getEventTypeName();
            body.append(String.format("   handlerMap.put(%s.class, this::handle%s);\n", eventTypeName, eventTypeName));
            this.addEventHandlerMethod(modelManager, serviceNote, eventType);
        }
    }

    private void addDataEventHandlerMethod(ClassModelManager modelManager, ServiceNote serviceNote, DataType dataType) {
        StringBuilder body = new StringBuilder();
        String dataTypeName = dataType.getDataTypeName();
        String eventTypeName = dataTypeName + "Built";
        String declaration = String.format("public void store%s(Event e)", eventTypeName);
        body.append(String.format("%s event = (%1$s) e;\n", eventTypeName));
        if (dataType.getMigratedTo() != null) {
            body.append("// please insert a no before fulib in the next line and insert event upgrading code\n// fulib\n");
        } else {
            body.append("if (outdated(event)) {\n");
            body.append("   return;\n");
            body.append("}\n");
            body.append("// please insert a no before fulib in the next line and insert addToGroup commands as necessary\n// fulib\n");
        }
        modelManager.haveMethod(this.builderClass, declaration, body.toString());
        if (dataType.getMigratedTo() != null) {
            return;
        }
        declaration = String.format("public %s load%s(Event e)", dataTypeName, eventTypeName);
        body.setLength(0);
        body.append(String.format("%s event = (%1$s) e;\n", eventTypeName));
        body.append(String.format("%s object = model.getOrCreate%1$s(event.getBlockId());\n", dataTypeName));
        for (DataNote note : dataType.getDataNotes()) {
            LinkedHashMap<String, String> map = note.getMap();
            LinkedHashMap<String, String> mockup = this.getMockup(map);
            this.addModelClassForDataNote(modelManager, serviceNote, mockup);
            this.addGetOrCreateMethodToServiceModel(modelManager, serviceNote.getName(), mockup);
        }
        Clazz dataClazz = modelManager.haveClass(dataTypeName);
        Clazz eventClazz = this.em.haveClass(eventTypeName);
        for (Attribute attribute : eventClazz.getAttributes()) {
            String attrName = attribute.getName();
            Attribute dataAttr = this.getAttribute(dataClazz, attrName);
            if (dataAttr != null) {
                if (dataAttr.getType().equals("String")) {
                    body.append(String.format("object.set%s(event.get%1$s());\n", org.fulib.workflows.StrUtil.cap(attrName)));
                    continue;
                }
                if (dataAttr.getType().equals("int")) {
                    body.append(String.format("object.set%s(Integer.parseInt(event.get%1$s()));\n", org.fulib.workflows.StrUtil.cap(attrName)));
                    continue;
                }
                if (!dataAttr.getType().equals("double")) continue;
                body.append(String.format("object.set%s(Double.parseDouble(event.get%1$s()));\n", org.fulib.workflows.StrUtil.cap(attrName)));
                continue;
            }
            AssocRole role = this.getRole(dataClazz, attrName);
            AssocRole other = role.getOther();
            Clazz otherClazz = other.getClazz();
            if (role.getCardinality() <= 1) {
                body.append(String.format("object.set%s(model.getOrCreate%s(event.get%1$s()));\n", org.fulib.workflows.StrUtil.cap(attrName), otherClazz.getName()));
                continue;
            }
            body.append(String.format("for (String name : stripBrackets(event.get%s()).split(\",\\\\s+\")) {\n", org.fulib.workflows.StrUtil.cap(attrName)));
            body.append("   if (name.equals(\"\")) continue;\n");
            body.append(String.format("   object.with%s(model.getOrCreate%s(name));\n", org.fulib.workflows.StrUtil.cap(attrName), otherClazz.getName()));
            body.append("}\n");
        }
        body.append("return object;\n");
        modelManager.haveMethod(this.builderClass, declaration, body.toString());
    }

    private void addEventHandlerMethod(ClassModelManager modelManager, ServiceNote serviceNote, EventType eventType) {
        StringBuilder body = new StringBuilder();
        String eventTypeName = eventType.getEventTypeName();
        String declaration = String.format("private void handle%s(Event e)", eventTypeName);
        body.append("// to protect manuel changes to this method insert a 'no' in front of fulib in the next line\n");
        body.append("// fulib\n");
        body.append(String.format("%s event = (%s) e;\n", eventTypeName, eventTypeName));
        body.append(String.format("handleDemo%s(event);\n", eventTypeName));
        modelManager.haveMethod(this.logicClass, declaration, body.toString());
        body.setLength(0);
        declaration = String.format("private void handleDemo%s(%1$s event)", eventTypeName);
        ObjectTable table = new ObjectTable("service", new Object[]{serviceNote});
        LinkedHashSet policies = table.expandLink("eventType", "handledEventTypes").filter(et -> et == eventType).expandLink("event", "events").expandLink("policy", "policies").filter(p -> ((Policy)p).getService() == serviceNote).toSet();
        for (Object obj : policies) {
            Policy policy = (Policy)obj;
            EventNote triggerEvent = policy.getTrigger();
            String eventId = triggerEvent.getTime();
            body.append(String.format("if (event.getId().equals(\"%s\")) {\n", eventId));
            this.addMockupData(modelManager, serviceNote, policy, body, "service.apply");
            body.append("}\n");
        }
        modelManager.haveMethod(this.logicClass, declaration, body.toString());
    }

    private void addMockupData(ClassModelManager modelManager, ServiceNote serviceNote, Policy policy, StringBuilder body, String methodCall) {
        for (WorkflowNote note : policy.getSteps()) {
            WorkflowNote classNote;
            if (note instanceof DataNote) {
                DataNote dataNote = (DataNote)note;
                if (dataNote.getType().getMigratedTo() != null) continue;
                LinkedHashMap<String, String> map = note.getMap();
                LinkedHashMap<String, String> mockup = this.getMockup(map);
                this.addModelClassForDataNote(modelManager, serviceNote, mockup);
                this.addGetOrCreateMethodToServiceModel(modelManager, serviceNote.getName(), mockup);
                this.addCreateAndInitModelObjectCode(modelManager, serviceNote, dataNote, mockup, body, methodCall);
                continue;
            }
            if (note instanceof ClassNote) {
                classNote = (ClassNote)note;
                this.addModelClassForClassNote(modelManager, serviceNote, (ClassNote)classNote);
                continue;
            }
            if (note instanceof QueryNote) {
                classNote = (QueryNote)note;
                System.err.println();
                continue;
            }
            if (note instanceof EventNote) {
                EventNote eventNote = (EventNote)note;
                String varName = eventNote.getTime().replaceAll("\\W+", "");
                body.append(String.format("\n   %s e%s = new %1$s();\n", eventNote.getEventTypeName(), varName));
                body.append(String.format("\n   e%s.setId(\"%s\");\n", varName, eventNote.getTime()));
                LinkedHashMap<String, String> map = eventNote.getMap();
                LinkedHashMap clone = (LinkedHashMap)map.clone();
                clone.remove(eventNote.getEventTypeName());
                if (eventNote instanceof CommandNote) {
                    clone.remove("command");
                } else {
                    clone.remove("event");
                }
                for (Map.Entry entry : clone.entrySet()) {
                    String setterName = StrUtil.cap((String)((String)entry.getKey()));
                    String statement = String.format("   e%s.set%s(\"%s\");\n", varName, setterName, entry.getValue());
                    body.append(statement);
                }
                body.append(String.format("   %s(e%s);\n", methodCall, varName));
                continue;
            }
            Logger.getGlobal().severe("do not know how to deal with " + note);
        }
    }

    private LinkedHashMap<String, String> getMockup(LinkedHashMap<String, String> map) {
        LinkedHashMap<String, String> mockup;
        Map.Entry<String, String> firstEntry = map.entrySet().iterator().next();
        String value = firstEntry.getValue();
        String[] split = org.fulib.workflows.StrUtil.split(value);
        if (split.length == 1) {
            mockup = (LinkedHashMap<String, String>)map.clone();
            mockup.remove(firstEntry.getKey());
        } else {
            mockup = new LinkedHashMap<String, String>();
            mockup.put(split[0], split[1]);
            mockup.putAll(map);
            mockup.remove("data");
        }
        return mockup;
    }

    private void addGetOrCreateMethodToServiceModel(ClassModelManager modelManager, String serviceName, LinkedHashMap<String, String> mockup) {
        String type = StrUtil.cap((String)this.eventModel.getEventType(mockup));
        Clazz modelClazz = modelManager.haveClass(serviceName + "Model");
        String declaration = String.format("public %s getOrCreate%s(String id)", type, type);
        Object body = String.format("if (id == null) return null;\n", type, type);
        body = (String)body + String.format("return (%s) modelMap.computeIfAbsent(id, k -> new %s().setId(k));\n", type, type);
        modelManager.haveMethod(modelClazz, declaration, (String)body);
    }

    private void addModelClassForDataNote(ClassModelManager modelManager, ServiceNote serviceNote, LinkedHashMap<String, String> map) {
        if (map.get("@migratedTo") != null) {
            return;
        }
        Iterator<Map.Entry<String, String>> iter = map.entrySet().iterator();
        Map.Entry<String, String> entry = iter.next();
        String type = entry.getKey();
        String objectId = entry.getValue();
        Clazz clazz = modelManager.haveClass(type = StrUtil.cap((String)type));
        if (clazz.getSuperClass() == null) {
            modelManager.haveAttribute(clazz, "id", "String");
        }
        while (iter.hasNext()) {
            Attribute attribute;
            entry = iter.next();
            String attrName = entry.getKey();
            String value = entry.getValue();
            if (attrName.endsWith(".back")) continue;
            String back = map.get(attrName + ".back");
            if (back != null) {
                int srcSize = value.startsWith("[") ? 42 : 1;
                value = org.fulib.workflows.StrUtil.stripBrackets(value).split(",\\s+")[0];
                value = this.eventModel.getObjectId(value);
                String otherClassName = serviceNote.getObjectMap().get(value);
                Clazz otherClazz = modelManager.haveClass(otherClassName);
                int backSize = back.startsWith("[") ? 42 : 1;
                back = org.fulib.workflows.StrUtil.stripBrackets(back);
                modelManager.associate(clazz, attrName, srcSize, otherClazz, back, backSize);
                clazz.withoutAttributes(clazz.getAttribute(attrName));
                otherClazz.withoutAttributes(otherClazz.getAttribute(back));
                continue;
            }
            if (this.getRole(clazz, attrName) != null || this.getAttribute(clazz, attrName) != null || (attribute = this.getAttribute(clazz, attrName)) != null) continue;
            modelManager.haveAttribute(clazz, attrName, "String");
        }
    }

    private AssocRole getRole(Clazz clazz, String attrName) {
        Clazz superClass;
        AssocRole role = clazz.getRole(attrName);
        if (role == null && (superClass = clazz.getSuperClass()) != null) {
            role = this.getRole(superClass, attrName);
        }
        return role;
    }

    private Attribute getAttribute(Clazz clazz, String attrName) {
        Clazz superClass;
        Attribute attribute = clazz.getAttribute(attrName);
        if (attribute == null && (superClass = clazz.getSuperClass()) != null) {
            attribute = this.getAttribute(superClass, attrName);
        }
        return attribute;
    }

    private void addModelClassForClassNote(ClassModelManager modelManager, ServiceNote serviceNote, ClassNote classNote) {
        LinkedHashMap<String, String> map = classNote.getMap();
        Iterator<Map.Entry<String, String>> iter = map.entrySet().iterator();
        Map.Entry<String, String> entry = iter.next();
        String type = entry.getValue();
        type = StrUtil.cap((String)type);
        Clazz clazz = modelManager.haveClass(type);
        modelManager.haveAttribute(clazz, "id", "String");
        while (iter.hasNext()) {
            entry = iter.next();
            String attrName = entry.getKey();
            String value = entry.getValue();
            if (attrName.endsWith(".back")) continue;
            if (attrName.equals("extends")) {
                Attribute localAttr;
                Clazz superClass = modelManager.haveClass(value);
                clazz.setSuperClass(superClass);
                for (Attribute superAttr : superClass.getAttributes()) {
                    localAttr = clazz.getAttribute(superAttr.getName());
                    if (localAttr == null) continue;
                    clazz.withoutAttributes(localAttr);
                }
                for (AssocRole superRole : superClass.getRoles()) {
                    localAttr = clazz.getAttribute(superRole.getName());
                    if (localAttr == null) continue;
                    clazz.withoutAttributes(localAttr);
                }
                continue;
            }
            String back = map.get(attrName + ".back");
            if (back != null) {
                int srcSize = value.startsWith("[") ? 42 : 1;
                value = org.fulib.workflows.StrUtil.stripBrackets(value).split("\\s+")[0];
                String otherClassName = org.fulib.workflows.StrUtil.cap(value);
                Clazz otherClazz = modelManager.haveClass(otherClassName);
                int backSize = back.startsWith("[") ? 42 : 1;
                back = org.fulib.workflows.StrUtil.stripBrackets(back);
                modelManager.associate(clazz, attrName, srcSize, otherClazz, back, backSize);
                clazz.withoutAttributes(clazz.getAttribute(attrName));
                otherClazz.withoutAttributes(otherClazz.getAttribute(back));
                continue;
            }
            if (this.getRole(clazz, attrName) != null) continue;
            modelManager.haveAttribute(clazz, attrName, value);
        }
    }

    private String addCreateAndInitModelObjectCode(ClassModelManager modelManager, ServiceNote serviceNote, DataNote dataNote, LinkedHashMap<String, String> map, StringBuilder body, String methodCall) {
        boolean first = true;
        String varName = null;
        String id = null;
        Object className = null;
        Clazz clazz = null;
        String statement = null;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String value = entry.getValue();
            if (first) {
                className = StrUtil.cap((String)entry.getKey());
                clazz = modelManager.haveClass((String)className);
                className = (String)className + "Built";
                id = value;
                id = id.replaceAll("\\W+", "");
                varName = StrUtil.downFirstChar((String)id) + "Event";
                statement = String.format("   %s %s = new %1$s();\n", className, varName);
                body.append(statement);
                statement = String.format("   %s.setId(\"%s\");\n", varName, dataNote.getTime());
                body.append(statement);
                statement = String.format("   %s.setBlockId(\"%s\");\n", varName, dataNote.getBlockId());
                body.append(statement);
                first = false;
                continue;
            }
            String attrName = entry.getKey();
            if (attrName.endsWith(".back") || attrName.startsWith("@")) continue;
            String setterName = StrUtil.cap((String)attrName);
            statement = String.format("   %s.set%s(\"%s\");\n", varName, setterName, value);
            body.append(statement);
        }
        statement = String.format("   %s(%s);\n\n", methodCall, varName);
        body.append(statement);
        return varName;
    }

    private void buildEventBroker() {
        try {
            InputStream resource = this.getClass().getResourceAsStream("templates/EventBroker.template");
            BufferedInputStream buf = new BufferedInputStream(resource);
            byte[] bytes = buf.readAllBytes();
            String content = new String(bytes, StandardCharsets.UTF_8);
            content = content.replace("package uks.dpst21.events;", "package " + this.em.getClassModel().getPackageName() + ";");
            String eventBrokerName = this.getPackageDirName(this.em) + "/EventBroker.java";
            Files.createDirectories(Path.of(this.getPackageDirName(this.em), new String[0]), new FileAttribute[0]);
            Files.write(Path.of(eventBrokerName, new String[0]), content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            Logger.getGlobal().log(Level.SEVERE, "could not read resource templates/Eventbroker.template", e);
        }
    }

    private void buildTest() {
        this.tm = new ClassModelManager().setMainJavaDir(this.mm.getClassModel().getMainJavaDir().replace("/main/java", "/test/java")).setPackageName(this.mm.getClassModel().getPackageName());
        this.managerMap.put("tm", this.tm);
        String boardName = org.fulib.workflows.StrUtil.toIdentifier(this.eventStormingBoard.getName());
        this.testClazz = this.tm.haveClass("Test" + boardName);
        this.testClazz.withImports(new String[]{"import org.junit.Test;", "import java.util.LinkedHashMap;", "import java.util.Map;", "import spark.Request;", "import spark.Response;", "import spark.Service;", "import java.util.concurrent.ExecutorService;", "import java.util.concurrent.Executors;", "import java.util.concurrent.LinkedBlockingQueue;", "import static org.assertj.core.api.Assertions.assertThat;", "import org.fulib.yaml.Yaml;", "import org.fulib.yaml.YamlIdMap;", "import java.util.concurrent.TimeUnit;", "import java.util.logging.Level;", "import java.util.logging.Logger;"});
        this.testClazz.withImports(String.format("import %s;", this.em.getClassModel().getPackageName() + ".*"));
        this.tm.haveAttribute(this.testClazz, "eventBroker", "EventBroker");
        this.tm.haveAttribute(this.testClazz, "spark", "Service");
        this.tm.haveAttribute(this.testClazz, "eventQueue", "LinkedBlockingQueue<Event>");
        this.tm.haveAttribute(this.testClazz, "history", "LinkedHashMap<String, Event>");
        this.tm.haveAttribute(this.testClazz, "port", "int");
        Object declaration = "";
        String methodBody = "";
        declaration = "public void start()";
        ST st = this.group.getInstanceOf("testStart");
        methodBody = st.render();
        this.tm.haveMethod(this.testClazz, (String)declaration, methodBody);
        declaration = "private String postApply(Request req, Response res)";
        st = this.group.getInstanceOf("testPostApply");
        methodBody = st.render();
        this.tm.haveMethod(this.testClazz, (String)declaration, methodBody);
        declaration = "private void subscribeAndLoadOldEvents()";
        st = this.group.getInstanceOf("testSubscribe");
        methodBody = st.render();
        this.tm.haveMethod(this.testClazz, (String)declaration, methodBody);
        declaration = "public Event waitForEvent(String id)";
        st = this.group.getInstanceOf("testWaitForEvent");
        methodBody = st.render();
        this.tm.haveMethod(this.testClazz, (String)declaration, methodBody);
        declaration = "@Test\npublic void " + org.fulib.workflows.StrUtil.toIdentifier(this.eventModel.getEventStormingBoard().getName()) + "()";
        this.startServices();
        for (Workflow workflow : this.eventStormingBoard.getWorkflows()) {
            this.testBody.append("\n// workflow " + workflow.getName() + "\n");
            for (WorkflowNote note : workflow.getNotes()) {
                if (note instanceof PageNote) {
                    PageNote pageNote = (PageNote)note;
                    String port = pageNote.getService().getPort();
                    this.testBody.append(String.format("\n// page %s\n", note.getTime()));
                    String pageId = note.getTime().replaceAll("\\:", "_");
                    this.testBody.append(String.format("open(\"http://localhost:%s/page/%s\");\n", port, pageId));
                    for (PageLine line : pageNote.getLines()) {
                        String fill = line.getMap().get("fill");
                        if (fill == null) continue;
                        String id = line.getMap().get("input");
                        if (id == null) {
                            id = line.getMap().get("password");
                        }
                        this.testBody.append(String.format("$(\"#%s\").setValue(\"%s\");\n", id, fill));
                    }
                    String buttonId = pageNote.getButtonId();
                    if (buttonId == null) continue;
                    this.testBody.append(String.format("$(\"#%s\").click();\n", buttonId));
                    continue;
                }
                if (note instanceof EventNote) {
                    EventNote eventNote = (EventNote)note;
                    Interaction interaction = eventNote.getInteraction();
                    if (!(interaction instanceof UserInteraction)) continue;
                    this.testGenerateSendUserEvent(this.testBody, eventNote);
                    continue;
                }
                if (!(note instanceof ExternalSystemNote)) continue;
                ExternalSystemNote externalSystemNote = (ExternalSystemNote)note;
                for (Policy policy : ((ExternalSystemNote)note).getPolicies()) {
                    ClassModelManager modelManager = this.managerMap.get(policy.getService().getName());
                    this.addMockupData(modelManager, policy.getService(), policy, this.testBody, "publish");
                }
            }
        }
        this.testBody.append(this.testClosing.toString());
        this.testBody.append(String.format("\nSystem.err.println(\"%s completed good and gracefully\");\n", boardName));
        this.tm.haveMethod(this.testClazz, (String)declaration, this.testBody.toString());
        declaration = "public void publish(Event event)";
        this.testBody.setLength(0);
        st = this.group.getInstanceOf("publishBody");
        this.testBody.append(st.render());
        this.tm.haveMethod(this.testClazz, (String)declaration, this.testBody.toString());
        this.testClazz.withImports(new String[]{"import org.fulib.yaml.Yaml;", "import com.mashape.unirest.http.HttpResponse;", "import com.mashape.unirest.http.Unirest;", "import com.mashape.unirest.http.exceptions.UnirestException;", "import static com.codeborne.selenide.Selenide.open;", "import static com.codeborne.selenide.Selenide.$;", "import static com.codeborne.selenide.Condition.text;", "import static com.codeborne.selenide.Condition.matchText;", "import com.codeborne.selenide.SelenideElement;"});
    }

    private void startServices() {
        this.testBody = new StringBuilder();
        this.testClosing = new StringBuilder();
        this.testClosing.append("try {\n   Thread.sleep(3000);\n} catch (Exception e) {\n}\neventBroker.stop();\nspark.stop();\n");
        ST st = this.group.getInstanceOf("startEventBroker");
        this.testBody.append(st.render());
        for (ServiceNote service : this.eventStormingBoard.getServices()) {
            this.testGenerateServiceStart(this.testBody, service);
        }
        this.testBody.append("SelenideElement pre;\n");
        this.testBody.append("LinkedHashMap<String, Object> modelMap;\n");
    }

    private void testGenerateServiceStart(StringBuilder body, ServiceNote serviceNote) {
        String serviceName = org.fulib.workflows.StrUtil.cap(serviceNote.getName());
        String imp = String.format("import %s.%s.%sService;", this.mm.getClassModel().getPackageName(), serviceName, serviceName);
        this.testClazz.withImports(imp);
        body.append("\n");
        String serviceVarName = StrUtil.downFirstChar((String)serviceName);
        body.append("// start service\n");
        body.append(String.format("%sService %s = new %sService();\n", serviceName, serviceVarName, serviceName));
        body.append(String.format("%s.start();\n", serviceVarName));
        body.append(String.format("waitForEvent(\"%s\");\n", serviceNote.getPort()));
        this.testClosing.append(String.format("%s.stop();\n", serviceVarName));
    }

    private void testGenerateSendUserEvent(StringBuilder body, EventNote note) {
        if (note.getRaisingPage() == null) {
            String varName = this.addCreateAndInitEventCode("", note, body);
            body.append(String.format("publish(%s);\n", varName));
        }
        body.append(String.format("waitForEvent(\"%s\");\n", note.getTime()));
        String checkHistory = "";
        LinkedHashMap<ServiceNote, String> lastChecks = new LinkedHashMap<ServiceNote, String>();
        LinkedList<Policy> policyList = new LinkedList<Policy>(note.getPolicies());
        while (!policyList.isEmpty()) {
            Policy policy = policyList.poll();
            ServiceNote service = policy.getService();
            ClassModelManager serviceModelManager = this.managerMap.get(service.getName());
            StringBuilder check = new StringBuilder();
            check.append(String.format("\n// check %s\n", service.getName()));
            check.append(String.format("open(\"http://localhost:%s\");\n", service.getPort()));
            check.append(checkHistory);
            String loadDataEventsCode = String.format("for (DataEvent dataEvent : %s.getBuilder().getEventStore().values()) {\n   %1$s.getBuilder().load(dataEvent.getBlockId());\n}\nmodelMap = %1$s.getBuilder().getModel().getModelMap();\nif (modelMap.values().size() > 0) {\n   org.fulib.FulibTools.objectDiagrams().dumpSVG(\"tmp/%1$s%s.svg\", modelMap.values());\n}\n\n", org.fulib.workflows.StrUtil.decap(service.getName()), note.getTime().replaceAll("\\W+", "_"));
            check.append(loadDataEventsCode);
            check.append("");
            check.append(String.format("open(\"http://localhost:%s\");\n", service.getPort()));
            for (WorkflowNote step : policy.getSteps()) {
                if (step instanceof DataNote) {
                    DataNote dataNote = (DataNote)step;
                    String migratedTo = dataNote.getMap().get("@migratedTo");
                    if (migratedTo != null) continue;
                    check.append(String.format("// check data note %s\n", dataNote.getTime()));
                    check.append(String.format("%sBuilt e%s = (%1$sBuilt) waitForEvent(\"%s\");\n", dataNote.getDataType(), this.eventModel.getObjectId(dataNote.getTime()), dataNote.getTime()));
                    LinkedHashMap<String, String> mockup = this.getMockup(dataNote.getMap());
                    Iterator<Map.Entry<String, String>> iterator = mockup.entrySet().iterator();
                    Map.Entry<String, String> entry = iterator.next();
                    String value = entry.getValue();
                    String yamlId = org.fulib.workflows.StrUtil.decap(value.replaceAll("\\W+", "_"));
                    Clazz dataTypeClass = serviceModelManager.haveClass(dataNote.getDataType());
                    while (iterator.hasNext()) {
                        entry = iterator.next();
                        String key = entry.getKey();
                        if (key.endsWith(".back")) continue;
                        AssocRole role = dataTypeClass.getRole(key);
                        Attribute attribute = this.getAttribute(dataTypeClass, key);
                        value = entry.getValue();
                        if (attribute != null && role == null) {
                            check.append(String.format("assertThat(e%s.get%s()).isEqualTo(\"%s\");\n", this.eventModel.getObjectId(dataNote.getTime()), org.fulib.workflows.StrUtil.cap(key), value));
                            continue;
                        }
                        if (role == null) continue;
                        check.append(String.format("assertThat(e%s.get%s()).isEqualTo(\"%s\");\n", this.eventModel.getObjectId(dataNote.getTime()), org.fulib.workflows.StrUtil.cap(key), value));
                    }
                    continue;
                }
                if (!(step instanceof EventNote)) continue;
                EventNote eventNote = (EventNote)step;
                policyList.addAll(eventNote.getPolicies());
            }
            lastChecks.put(service, check.toString());
        }
        for (String check : lastChecks.values()) {
            body.append(check);
        }
    }

    private String addCreateAndInitEventCode(String indent, EventNote note, StringBuilder body) {
        boolean first = true;
        Object varName = null;
        String id = null;
        String statement = null;
        String eventTypeName = null;
        for (Map.Entry<String, String> entry : note.getMap().entrySet()) {
            if (first) {
                String value = entry.getValue();
                String[] split = value.split("\\s");
                String time = note.getTime();
                eventTypeName = note.getEventTypeName();
                id = time;
                varName = time.replaceAll("\\W+", "");
                if (!Character.isAlphabetic(((String)varName).charAt(0))) {
                    varName = "e" + (String)varName;
                }
                statement = String.format("\n%s// create %s: %s\n", indent, eventTypeName, entry.getValue());
                body.append(statement);
                statement = String.format("%s%s %s = new %s();\n", indent, eventTypeName, varName, eventTypeName);
                body.append(statement);
                statement = String.format("%s%s.setId(\"%s\");\n", indent, varName, id);
                body.append(statement);
                first = false;
                continue;
            }
            String setterName = StrUtil.cap((String)entry.getKey());
            statement = indent.equals("") ? String.format("%s%s.set%s(\"%s\");\n", indent, varName, setterName, entry.getValue()) : String.format("%s%s.set%s(request.queryParams(\"%s\"));\n", indent, varName, setterName, entry.getKey());
            body.append(statement);
        }
        return varName;
    }

    private void buildClassModelManagerMap(ClassModelManager mm) {
        this.managerMap = new LinkedHashMap();
        this.managerMap.put("mm", mm);
        this.em = new ClassModelManager().setMainJavaDir(mm.getClassModel().getMainJavaDir()).setPackageName(mm.getClassModel().getPackageName() + ".events");
        this.managerMap.put("em", this.em);
        Clazz event = this.em.haveClass("Event");
        this.em.haveAttribute(event, "id", "String");
        Clazz dataEvent = this.em.haveClass("DataEvent");
        dataEvent.setSuperClass(event);
        this.em.haveAttribute(dataEvent, "blockId", "String");
        Clazz subcribeEvent = this.em.haveClass("SubscribeEvent");
        subcribeEvent.setSuperClass(event);
        this.em.haveAttribute(subcribeEvent, "url", "String");
        Clazz dataGroup = this.em.haveClass("DataGroup");
        dataGroup.setSuperClass(dataEvent);
        this.em.associate(dataGroup, "elements", 42, dataEvent, "sagas", 42);
        Clazz query = this.em.haveClass("Query");
        query.setSuperClass(event);
        this.em.haveAttribute(query, "key", "String");
        this.em.associate(query, "results", 42, dataEvent);
        Clazz serviceSubscribed = this.em.haveClass("ServiceSubscribed");
        serviceSubscribed.setSuperClass(event);
        this.em.haveAttribute(serviceSubscribed, "serviceUrl", "String");
    }

    private void buildEventClasses() {
        for (Workflow workflow : this.eventStormingBoard.getWorkflows()) {
            for (WorkflowNote note : workflow.getNotes()) {
                if (note instanceof EventNote) {
                    EventNote eventNote = (EventNote)note;
                    this.oneEventClass(eventNote);
                    continue;
                }
                if (!(note instanceof DataNote)) continue;
                DataNote dataNote = (DataNote)note;
                this.oneDataEventClass(dataNote);
            }
        }
    }

    private void oneDataEventClass(DataNote note) {
        Clazz event = this.em.haveClass("DataEvent");
        boolean first = true;
        String dataType = note.getDataType();
        String dataEventType = dataType + "Built";
        Clazz clazz = this.em.haveClass(dataEventType);
        clazz.setSuperClass(event);
        LinkedHashSet<String> keys = new LinkedHashSet<String>(note.getMap().keySet());
        keys.remove("data");
        keys.remove(dataType);
        keys.remove(org.fulib.workflows.StrUtil.decap(dataType));
        for (String key : keys) {
            if (key.endsWith(".back") || key.startsWith("@")) continue;
            this.mm.haveAttribute(clazz, key, "String");
        }
    }

    private void oneEventClass(EventNote note) {
        Clazz event = this.em.haveClass("Event");
        Clazz command = this.em.haveClass("Command");
        command.setSuperClass(event);
        boolean first = true;
        Clazz clazz = this.em.haveClass(note.getEventTypeName());
        if (note instanceof CommandNote) {
            clazz.setSuperClass(command);
        } else {
            clazz.setSuperClass(event);
        }
        LinkedHashSet<String> keys = new LinkedHashSet<String>(note.getMap().keySet());
        keys.remove(keys.iterator().next());
        for (String key : keys) {
            this.mm.haveAttribute(clazz, key, "String");
        }
    }

    private void generateModelElementsFor(String event) {
        int index = org.fulib.workflows.StrUtil.indexOfLastUpperChar(event);
        String dataClassName = event.substring(0, index);
        Clazz dataClazz = this.mm.haveClass(dataClassName);
        this.mm.haveAttribute(dataClazz, "id", "String");
        String declaration = String.format("public %s getOrCreate%s(String id)", dataClassName, dataClassName);
        String body = String.format("Object obj = objectMap.computeIfAbsent(id, k -> new %s().setId(k));\nreturn (%s) obj;", dataClassName, dataClassName);
        this.mm.haveMethod(this.modelClazz, declaration, body);
    }

    public WorkflowGenerator generate() {
        for (ClassModelManager manager : this.managerMap.values()) {
            Fulib.generator().generate(manager.getClassModel());
            String classDiagramName = this.getPackageDirName(manager) + "/classDiagram.svg";
            FulibTools.classDiagrams().dumpSVG(manager.getClassModel(), classDiagramName);
        }
        return this;
    }

    private String getPackageDirName(ClassModelManager manager) {
        Object packageDirName = manager.getClassModel().getPackageName().replaceAll("\\.", "/");
        packageDirName = manager.getClassModel().getMainJavaDir() + "/" + (String)packageDirName;
        return packageDirName;
    }
}

