/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.yaml;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fulib.yaml.IdMap;
import org.fulib.yaml.Reflector;
import org.fulib.yaml.ReflectorMap;
import org.fulib.yaml.YamlGenerator;
import org.fulib.yaml.YamlObject;
import org.fulib.yaml.Yamler;

public class YamlIdMap
extends IdMap {
    private static final String REMOVE = "remove";
    private String yaml;
    private boolean decodingPropertyChange;
    private Yamler yamler = new Yamler();
    private HashMap<String, String> attrTimeStamps = new HashMap();
    private String yamlChangeText;
    private boolean encodeWithSimpleClassNames = false;

    public YamlIdMap encodeWithSimpleClassNames() {
        this.encodeWithSimpleClassNames = true;
        return this;
    }

    public YamlIdMap(String packageName) {
        this(new ReflectorMap(packageName));
    }

    public YamlIdMap(String ... packageNames) {
        this(new ReflectorMap(packageNames));
    }

    public YamlIdMap(Collection<String> packageNames) {
        this(new ReflectorMap(packageNames));
    }

    public YamlIdMap(ReflectorMap reflectorMap) {
        super(reflectorMap);
    }

    public LinkedHashMap<String, Object> getObjIdMap() {
        return this.objIdMap;
    }

    public LinkedHashMap<Object, String> getIdObjMap() {
        return this.idObjMap;
    }

    @Deprecated
    public HashMap<String, String> getAttrTimeStamps() {
        return this.attrTimeStamps;
    }

    @Deprecated
    public YamlIdMap withUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public boolean isDecodingPropertyChange() {
        return this.decodingPropertyChange;
    }

    public void setDecodingPropertyChange(boolean decodingPropertyChange) {
        this.decodingPropertyChange = decodingPropertyChange;
    }

    public Object decodeCSV(String fileName) {
        try {
            byte[] bytes = Files.readAllBytes(Paths.get(fileName, new String[0]));
            String csvText = new String(bytes);
            String yamlText = this.convertCsv2Yaml(csvText);
            return this.decode(yamlText);
        }
        catch (IOException e) {
            Logger.getGlobal().log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    private String convertCsv2Yaml(String csvText) {
        String[] split = csvText.split(";");
        for (int i = 0; i < split.length; ++i) {
            Pattern pattern;
            Matcher matcher;
            boolean found;
            Object token = split[i];
            if (((String)token).startsWith("\"") && ((String)token).endsWith("\"")) continue;
            if (((String)token).startsWith("\"") && !((String)token).endsWith("\"")) {
                String nextToken;
                int j = i;
                do {
                    nextToken = split[++j];
                    split[j] = "";
                    token = (String)token + ";" + nextToken;
                } while (!nextToken.endsWith("\""));
                split[i] = token;
                i = j;
                continue;
            }
            if (((String)token).trim().length() == 0 || !(found = (matcher = (pattern = Pattern.compile("\\s")).matcher(((String)token).trim())).find())) continue;
            split[i] = token = YamlGenerator.encapsulate((String)token);
        }
        StringBuilder buf = new StringBuilder();
        for (String str : split) {
            buf.append(str).append(" ");
        }
        return buf.toString();
    }

    public Object decode(String yaml, Object root) {
        this.putObject(root);
        Object decodedRoot = this.decode(yaml);
        if (decodedRoot != root) {
            throw new RuntimeException("Object passed as root does not match the first object in the yaml string.\nEnsure that the type of the passed root and the first object in the yaml string match. \nEnsure that the key of the passed root and the key of the first object in tha yaml string match. \nYou get the key of the passed root object via 'String key = getOrCreateKey(root);'\n");
        }
        return root;
    }

    public Object decode(String yaml) {
        this.decodingPropertyChange = false;
        this.yamlChangeText = null;
        this.yaml = yaml;
        this.yamler = new Yamler(yaml);
        if (!"-".equals(this.yamler.getCurrentToken())) {
            return this.yamler.decode(yaml);
        }
        Object root = this.parseObjectIds();
        this.yamler = new Yamler(yaml);
        this.parseObjectAttrs();
        this.setDecodingPropertyChange(false);
        this.yamlChangeText = null;
        return root;
    }

    private void parseObjectAttrs() {
        while (this.yamler.getCurrentToken() != null) {
            if (!"-".equals(this.yamler.getCurrentToken())) {
                this.yamler.printError("'-' expected");
                this.yamler.nextToken();
                continue;
            }
            String key = this.yamler.nextToken();
            if (key.endsWith(":")) {
                this.parseUsualObjectAttrs();
                continue;
            }
            this.parseObjectTableAttrs();
        }
    }

    private void parseObjectTableAttrs() {
        String className = this.yamler.getCurrentToken();
        Reflector creator = this.reflectorMap.getReflector(className);
        this.yamler.nextToken();
        ArrayList<String> colNameList = new ArrayList<String>();
        while (this.yamler.getCurrentToken() != null && this.yamler.getLookAheadToken() != null && this.yamler.getLookAheadToken().endsWith(":")) {
            String colName = this.yamler.stripColon(this.yamler.getCurrentToken());
            colNameList.add(colName);
            this.yamler.nextToken();
        }
        while (this.yamler.getCurrentToken() != null && !"-".equals(this.yamler.getCurrentToken())) {
            String objectId = this.yamler.stripColon(this.yamler.getCurrentToken());
            this.yamler.nextToken();
            Object obj = this.objIdMap.get(objectId);
            int colNum = 0;
            while (this.yamler.getCurrentToken() != null && !this.yamler.getCurrentToken().endsWith(":") && !"-".equals(this.yamler.getCurrentToken())) {
                String attrName = (String)colNameList.get(colNum);
                if (this.yamler.getCurrentToken().startsWith("[")) {
                    String value = this.yamler.getCurrentToken().substring(1);
                    if ("".equals(value.trim())) {
                        value = this.yamler.nextToken();
                    }
                    this.setValue(creator, obj, attrName, value);
                    while (this.yamler.getCurrentToken() != null && !this.yamler.getCurrentToken().endsWith("]")) {
                        this.yamler.nextToken();
                        value = this.yamler.getCurrentToken();
                        if (this.yamler.getCurrentToken().endsWith("]")) {
                            value = this.yamler.getCurrentToken().substring(0, this.yamler.getCurrentToken().length() - 1);
                        }
                        if ("".equals(value.trim())) continue;
                        this.setValue(creator, obj, attrName, value);
                    }
                } else {
                    this.setValue(creator, obj, attrName, this.yamler.getCurrentToken());
                }
                ++colNum;
                this.yamler.nextToken();
            }
        }
    }

    private void parseUsualObjectAttrs() {
        String objectId = this.yamler.stripColon(this.yamler.getCurrentToken());
        String className = this.yamler.nextToken();
        this.yamler.nextToken();
        if (className.endsWith(".remove")) {
            this.objIdMap.remove(objectId);
            while (this.yamler.getCurrentToken() != null && !"-".equals(this.yamler.getCurrentToken())) {
                this.yamler.nextToken();
            }
            return;
        }
        if (".Map".equals(className)) {
            YamlObject yamlObj = (YamlObject)this.objIdMap.get(objectId);
            Map map = yamlObj.getProperties();
            while (this.yamler.getCurrentToken() != null && !"-".equals(this.yamler.getCurrentToken())) {
                String attrName = this.yamler.stripColon(this.yamler.getCurrentToken());
                this.yamler.nextToken();
                if (map == null) {
                    while (this.yamler.getCurrentToken() != null && !this.yamler.getCurrentToken().endsWith(":") && !"-".equals(this.yamler.getCurrentToken())) {
                        this.yamler.nextToken();
                    }
                    continue;
                }
                ArrayList<String> previousValue = null;
                while (this.yamler.getCurrentToken() != null && !this.yamler.getCurrentToken().endsWith(":") && !"-".equals(this.yamler.getCurrentToken())) {
                    String attrValue = this.yamler.getCurrentToken();
                    Object target = this.objIdMap.get(attrValue);
                    if (target != null) {
                        if (previousValue != null) {
                            previousValue.add((String)target);
                            map.put(attrName, previousValue);
                        } else {
                            map.put(attrName, target);
                            previousValue = new ArrayList<String>();
                            previousValue.add((String)target);
                        }
                    } else if (previousValue != null) {
                        previousValue.add(attrValue);
                        map.put(attrName, previousValue);
                    } else {
                        map.put(attrName, attrValue);
                        previousValue = new ArrayList();
                        previousValue.add(attrValue);
                    }
                    this.yamler.nextToken();
                }
            }
        } else {
            Reflector reflector = this.reflectorMap.getReflector(className);
            Object obj = this.objIdMap.get(objectId);
            while (this.yamler.getCurrentToken() != null && !"-".equals(this.yamler.getCurrentToken())) {
                String attrName = this.yamler.stripColon(this.yamler.getCurrentToken());
                this.yamler.nextToken();
                if (obj == null) {
                    while (this.yamler.getCurrentToken() != null && !this.yamler.getCurrentToken().endsWith(":") && !"-".equals(this.yamler.getCurrentToken())) {
                        this.yamler.nextToken();
                    }
                    continue;
                }
                while (this.yamler.getCurrentToken() != null && !this.yamler.getCurrentToken().endsWith(":") && !"-".equals(this.yamler.getCurrentToken())) {
                    String attrValue = this.yamler.getCurrentToken();
                    if (this.yamler.getLookAheadToken() != null && this.yamler.getLookAheadToken().endsWith(".time:")) {
                        String propWithTime = this.yamler.nextToken();
                        String newTimeStamp = this.yamler.nextToken();
                        String oldTimeStamp = this.attrTimeStamps.get(objectId + "." + attrName);
                        if (oldTimeStamp == null || oldTimeStamp.compareTo(newTimeStamp) <= 0) {
                            this.setDecodingPropertyChange(true);
                            if (this.yamlChangeText == null) {
                                this.yamlChangeText = this.yaml;
                            }
                            this.setValue(reflector, obj, attrName, attrValue);
                            this.attrTimeStamps.put(objectId + "." + attrName, newTimeStamp);
                        }
                    } else {
                        this.setValue(reflector, obj, attrName, attrValue);
                    }
                    this.yamler.nextToken();
                }
            }
        }
    }

    private void setValue(Reflector reflector, Object obj, String attrName, String attrValue) {
        block6: {
            String type = "new";
            if (attrName.endsWith(".remove")) {
                if (reflector.getValue(obj, attrName = attrName.substring(0, attrName.length() - ".remove".length())) instanceof Collection) {
                    type = REMOVE;
                } else {
                    attrValue = null;
                }
            }
            try {
                Object targetObj;
                Object setResult = reflector.setValue(obj, attrName, (Object)attrValue, type);
                if (setResult == null && (targetObj = this.objIdMap.get(attrValue)) != null) {
                    reflector.setValue(obj, attrName, targetObj, type);
                }
            }
            catch (Exception e) {
                Object targetObj = this.objIdMap.get(attrValue);
                if (targetObj == null) break block6;
                reflector.setValue(obj, attrName, targetObj, type);
            }
        }
    }

    private Object parseObjectIds() {
        Object root = null;
        while (this.yamler.getCurrentToken() != null) {
            Object now;
            if (!"-".equals(this.yamler.getCurrentToken())) {
                this.yamler.printError("'-' expected");
                this.yamler.nextToken();
                continue;
            }
            String key = this.yamler.nextToken();
            if (key.endsWith(":")) {
                now = this.parseUsualObjectId();
                if (root != null) continue;
                root = now;
                continue;
            }
            now = this.parseObjectTableIds();
            if (root != null) continue;
            root = now;
        }
        return root;
    }

    private Object parseUsualObjectId() {
        int dotIndex;
        int objectNum;
        String objectId = this.yamler.stripColon(this.yamler.getCurrentToken());
        int pos = objectId.lastIndexOf(46);
        String numPart = objectId.substring(pos + 2);
        try {
            objectNum = Integer.parseInt(numPart);
        }
        catch (NumberFormatException e) {
            objectNum = this.objIdMap.size() + 1;
        }
        if (objectNum > this.maxUsedIdNum) {
            this.maxUsedIdNum = objectNum;
        }
        String className = this.yamler.nextToken();
        Object obj = this.objIdMap.get(objectId);
        String userId = null;
        while (this.yamler.getCurrentToken() != null && !"-".equals(this.yamler.getCurrentToken())) {
            String token = this.yamler.nextToken();
            if (token == null || !token.endsWith(".time:")) continue;
            token = this.yamler.nextToken();
            userId = token.substring(token.lastIndexOf(46) + 1);
        }
        boolean foreignChange = false;
        if (userId != null && (dotIndex = objectId.indexOf(46)) > 0) {
            String ownerId = objectId.substring(0, dotIndex);
            boolean bl = foreignChange = !userId.equals(ownerId);
        }
        if (obj == null && !className.endsWith(".remove") && !foreignChange) {
            if (".Map".equals(className)) {
                obj = new YamlObject(objectId);
            } else {
                Reflector reflector = this.reflectorMap.getReflector(className);
                obj = reflector.newInstance();
            }
            this.objIdMap.put(objectId, obj);
            this.idObjMap.put(obj, objectId);
        }
        return obj;
    }

    private Object parseObjectTableIds() {
        Object root = null;
        String className = this.yamler.getCurrentToken();
        Reflector reflector = this.reflectorMap.getReflector(className);
        while (!"".equals(this.yamler.getCurrentToken()) && this.yamler.getLookAheadToken().endsWith(":")) {
            this.yamler.nextToken();
        }
        while (!"".equals(this.yamler.getCurrentToken()) && !"-".equals(this.yamler.getCurrentToken())) {
            String objectId = this.yamler.stripColon(this.yamler.getCurrentToken());
            this.yamler.nextToken();
            Object obj = reflector.newInstance();
            this.objIdMap.put(objectId, obj);
            this.idObjMap.put(obj, objectId);
            if (root == null) {
                root = obj;
            }
            while (!("".equals(this.yamler.getCurrentToken()) || this.yamler.getCurrentToken().endsWith(":") || "-".equals(this.yamler.getCurrentToken()))) {
                this.yamler.nextToken();
            }
        }
        return root;
    }

    @Deprecated
    public YamlIdMap putNameObject(String id, Object object) {
        this.putObject(id, object);
        this.discoverObjects(object);
        return this;
    }

    @Deprecated
    public String getOrCreateKey(Object obj) {
        return this.putObject(obj);
    }

    @Deprecated
    public LinkedHashSet<Object> collectObjects(Object ... roots) {
        LinkedHashSet<Object> collectedObjects = new LinkedHashSet<Object>();
        this.reflectorMap.discoverObjects(roots, collectedObjects);
        for (Object e : collectedObjects) {
            this.putObject(e);
        }
        return collectedObjects;
    }

    public String encode(Object ... roots) {
        Objects.requireNonNull(roots);
        this.collectObjects(roots);
        return this.encode();
    }

    public String encode() {
        StringBuilder buf = new StringBuilder();
        for (Map.Entry entry : this.objIdMap.entrySet()) {
            Object obj = entry.getValue();
            if (obj instanceof Enum) continue;
            String key = (String)entry.getKey();
            String className = obj.getClass().getName();
            if (this.encodeWithSimpleClassNames) {
                className = obj.getClass().getSimpleName();
            }
            buf.append("- ").append(key).append(": \t").append(className).append("\n");
            Reflector creator = this.getReflector(obj);
            for (String prop : creator.getAllProperties()) {
                String timeKey;
                String timeStamp;
                Object value = creator.getValue(obj, prop);
                if (value == null) continue;
                if (value instanceof Collection) {
                    if (((Collection)value).isEmpty()) continue;
                    buf.append("  ").append(prop).append(':');
                    for (Object item : (Collection)value) {
                        buf.append(" \t");
                        this.encodeValue(buf, item);
                    }
                    buf.append('\n');
                    continue;
                }
                if (value instanceof Map) continue;
                buf.append("  ").append(prop).append(": \t");
                this.encodeValue(buf, value);
                buf.append('\n');
                if (this.userId == null || (timeStamp = this.attrTimeStamps.get(timeKey = key + "." + prop)) == null) continue;
                buf.append("  ").append(prop).append(".time: \t").append(timeStamp).append("\n");
            }
            buf.append("\n");
        }
        return buf.toString();
    }

    private void encodeValue(StringBuilder buf, Object value) {
        if (value instanceof Enum) {
            Enum enumValue = (Enum)value;
            buf.append(enumValue.getDeclaringClass().getName()).append('.').append(enumValue.name());
            return;
        }
        String valueKey = (String)this.idObjMap.get(value);
        if (valueKey != null) {
            buf.append(valueKey);
        } else if (value instanceof String) {
            try {
                YamlGenerator.encapsulate((String)((String)value), (Appendable)buf);
            }
            catch (IOException iOException) {}
        } else {
            buf.append(value);
        }
    }

    @Deprecated
    public void encodeAttrValue(StringBuilder buf, Object obj, String propertyName, Object value) {
        String key = this.putObject(obj);
        String className = obj.getClass().getSimpleName();
        buf.append("- ").append(key).append(": \t").append(className).append("\n");
        Class<?> valueClass = value.getClass();
        if (valueClass.getName().startsWith("java.lang.") || valueClass == String.class) {
            buf.append("  ").append(propertyName).append(": \t").append(YamlGenerator.encapsulate((String)value.toString())).append("\n");
            if (this.userId != null) {
                String now = LocalDateTime.now() + "." + this.userId;
                buf.append("  ").append(propertyName).append(".time: \t").append(now).append("\n");
                this.attrTimeStamps.put(key + "." + propertyName, now);
            }
        } else {
            String valueKey = this.putObject(value);
            buf.append("  ").append(propertyName).append(": \t").append(valueKey).append("\n");
            if (this.userId != null) {
                Reflector reflector = this.reflectorMap.getReflector(obj);
                String fieldName = propertyName;
                if (propertyName.endsWith(".remove")) {
                    fieldName = propertyName.substring(0, propertyName.lastIndexOf(46));
                }
                Object fieldValue = reflector.getValue(obj, fieldName);
                String now = LocalDateTime.now() + "." + this.userId;
                if (fieldValue instanceof Collection) {
                    buf.append("  ").append(propertyName).append('.').append(valueKey).append(".time: \t").append(now).append("\n");
                    this.attrTimeStamps.put(key + "." + propertyName + "." + valueKey, now);
                } else {
                    buf.append("  ").append(propertyName).append(".time: \t").append(now).append("\n");
                    this.attrTimeStamps.put(key + "." + propertyName, now);
                }
            }
            if (!propertyName.endsWith(".remove")) {
                buf.append("- ").append(valueKey).append(": \t").append(valueClass.getSimpleName()).append("\n");
            }
        }
    }

    public String getYamlChange() {
        String result = this.yamlChangeText;
        this.yamlChangeText = "";
        return result;
    }

    @Deprecated
    public String getLastTimeStamps() {
        LinkedHashMap<String, String> user2TimeStampMap = this.getLastTimeStampMap();
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<String, String> e : user2TimeStampMap.entrySet()) {
            buf.append(e.getValue()).append(" ");
        }
        return buf.toString();
    }

    public String getAttributeTimeStamp(String attribute) {
        return this.attrTimeStamps.get(attribute);
    }

    @Deprecated
    public LinkedHashMap<String, String> getLastTimeStampMap() {
        LinkedHashMap<String, String> user2TimeStampMap = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> e : this.attrTimeStamps.entrySet()) {
            int pos;
            String timeStamp = e.getValue();
            String userName = timeStamp.substring((pos = timeStamp.lastIndexOf(46)) + 1);
            String oldTimeStamp = user2TimeStampMap.get(userName);
            if (oldTimeStamp != null && oldTimeStamp.compareTo(timeStamp) >= 0) continue;
            user2TimeStampMap.put(userName, timeStamp);
        }
        return user2TimeStampMap;
    }

    @Deprecated
    public LinkedHashMap<String, String> getLastTimeStampMap(String lastTimeStamps) {
        String[] split;
        LinkedHashMap<String, String> user2TimeStampMap = new LinkedHashMap<String, String>();
        for (String s : split = lastTimeStamps.split("\\s+")) {
            int pos = s.lastIndexOf(46);
            String user = s.substring(pos + 1);
            user2TimeStampMap.put(user, s);
        }
        return user2TimeStampMap;
    }
}

