/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.workflows;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.fulib.workflows.Policy;
import org.fulib.workflows.WorkflowNote;

public class ExternalSystemNote
extends WorkflowNote {
    public static final String PROPERTY_TIME_INTERVAL = "timeInterval";
    public static final String PROPERTY_POLICIES = "policies";
    public static final String PROPERTY_SYSTEM_NAME = "systemName";
    private String timeInterval;
    private List<Policy> policies;
    private String systemName;

    public String getTimeInterval() {
        return this.timeInterval;
    }

    public ExternalSystemNote setTimeInterval(String value) {
        if (Objects.equals(value, this.timeInterval)) {
            return this;
        }
        String oldValue = this.timeInterval;
        this.timeInterval = value;
        this.firePropertyChange(PROPERTY_TIME_INTERVAL, oldValue, value);
        return this;
    }

    public List<Policy> getPolicies() {
        return this.policies != null ? Collections.unmodifiableList(this.policies) : Collections.emptyList();
    }

    public ExternalSystemNote withPolicies(Policy value) {
        if (this.policies == null) {
            this.policies = new ArrayList<Policy>();
        }
        if (!this.policies.contains(value)) {
            this.policies.add(value);
            value.setExternalSystem(this);
            this.firePropertyChange(PROPERTY_POLICIES, null, value);
        }
        return this;
    }

    public ExternalSystemNote withPolicies(Policy ... value) {
        for (Policy item : value) {
            this.withPolicies(item);
        }
        return this;
    }

    public ExternalSystemNote withPolicies(Collection<? extends Policy> value) {
        for (Policy policy : value) {
            this.withPolicies(policy);
        }
        return this;
    }

    public ExternalSystemNote withoutPolicies(Policy value) {
        if (this.policies != null && this.policies.remove(value)) {
            value.setExternalSystem(null);
            this.firePropertyChange(PROPERTY_POLICIES, value, null);
        }
        return this;
    }

    public ExternalSystemNote withoutPolicies(Policy ... value) {
        for (Policy item : value) {
            this.withoutPolicies(item);
        }
        return this;
    }

    public ExternalSystemNote withoutPolicies(Collection<? extends Policy> value) {
        for (Policy policy : value) {
            this.withoutPolicies(policy);
        }
        return this;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public ExternalSystemNote setSystemName(String value) {
        if (Objects.equals(value, this.systemName)) {
            return this;
        }
        String oldValue = this.systemName;
        this.systemName = value;
        this.firePropertyChange(PROPERTY_SYSTEM_NAME, oldValue, value);
        return this;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder(super.toString());
        result.append(' ').append(this.getSystemName());
        result.append(' ').append(this.getTimeInterval());
        return result.toString();
    }

    @Override
    public void removeYou() {
        super.removeYou();
        this.withoutPolicies(new ArrayList<Policy>(this.getPolicies()));
    }
}

