/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.workflows;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.fulib.workflows.CommandNote;
import org.fulib.workflows.DataNote;
import org.fulib.workflows.EventStormingBoard;
import org.fulib.workflows.Policy;
import org.fulib.workflows.ServiceNote;
import org.fulib.workflows.Workflow;

public class SimulationBuilder {
    private EventStormingBoard board;
    private ArrayList<Workflow> workFlowList;
    private ArrayList<CommandNote> commandList;
    private ArrayList<Policy> policiesList;
    private ArrayList<DataNote> dataList;

    public ArrayList<Workflow> getWorkFlowList() {
        return this.workFlowList;
    }

    public EventStormingBoard addBoard(String boardName) {
        this.board = new EventStormingBoard().setName(boardName);
        return this.board;
    }

    public ArrayList<Workflow> addWorkflows(String start, String stop, String delta) {
        this.workFlowList = new ArrayList();
        String name = start;
        while (name.compareTo(stop) <= 0) {
            Workflow workflow = new Workflow().setName(name);
            workflow.setEventStormingBoard(this.board);
            this.workFlowList.add(workflow);
            name = this.add(name, delta);
        }
        return this.workFlowList;
    }

    public ArrayList<CommandNote> addCommands(String command, String delta) {
        this.commandList = new ArrayList();
        for (Workflow workflow : this.workFlowList) {
            CommandNote commandNote = new CommandNote();
            commandNote.setTime(command);
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            commandNote.setMap(map);
            map.put("command", command);
            commandNote.setWorkflow(workflow);
            this.commandList.add(commandNote);
            command = this.addTime(command, delta);
        }
        return this.commandList;
    }

    public void addPolicies(String service) {
        this.policiesList = new ArrayList();
        for (Workflow workflow : this.workFlowList) {
            Policy policy = new Policy();
            policy.setActorName(service);
            policy.setWorkflow(workflow);
            ServiceNote serv = this.board.getOrCreateFromServices(service);
            policy.setService(serv);
            this.policiesList.add(policy);
        }
    }

    public void addDatas(String data, String delta) {
        this.dataList = new ArrayList();
        String time = data.substring(data.length() - delta.length());
        data = data.substring(0, data.length() - delta.length());
        Iterator<Policy> policyIterator = this.policiesList.iterator();
        for (Workflow workflow : this.workFlowList) {
            DataNote dataNote = new DataNote();
            dataNote.setTime(time);
            policyIterator.hasNext();
            Policy policy = policyIterator.next();
            dataNote.setInteraction(policy);
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            dataNote.setMap(map);
            map.put("data", data + time);
            dataNote.setWorkflow(workflow);
            this.dataList.add(dataNote);
            time = this.addTime(time, delta);
        }
    }

    public void add(String key, String start, String delta) {
        for (CommandNote commandNote : this.commandList) {
            LinkedHashMap<String, String> map = commandNote.getMap();
            map.put(key, start);
            start = this.add(start, delta);
        }
    }

    public void addList(String key, String ... list) {
        int j = 0;
        for (CommandNote commandNote : this.commandList) {
            LinkedHashMap<String, String> map = commandNote.getMap();
            map.put(key, list[j]);
            j = (j + 1) % list.length;
        }
    }

    private String addTime(String name, String delta) {
        String prefix = name.substring(0, name.length() - delta.length());
        String index = name.substring(prefix.length());
        CharSequence[] indexSplit = index.split(":");
        String[] deltaSplit = delta.split(":");
        String carryOver = "00";
        for (int i = deltaSplit.length - 1; i >= 0; --i) {
            Object newString = this.add(indexSplit[i], deltaSplit[i]);
            Integer newInt = Integer.parseInt((String)(newString = this.add((String)newString, carryOver)));
            if (newInt >= 60) {
                carryOver = "01";
                newInt = newInt - 60;
                newString = "" + newInt;
                newString = "0000000".substring(0, deltaSplit[i].length() - ((String)newString).length()) + (String)newString;
            } else {
                carryOver = "00";
            }
            indexSplit[i] = newString;
        }
        return prefix + String.join((CharSequence)":", indexSplit);
    }

    private String add(String name, String delta) {
        String prefix = name.substring(0, name.length() - delta.length());
        Object index = name.substring(prefix.length());
        try {
            int i = Integer.parseInt((String)index);
            int d = Integer.parseInt(delta);
            index = "" + (i += d);
            index = delta.substring(0, delta.length() - ((String)index).length()) + (String)index;
        }
        catch (Exception e) {
            return prefix;
        }
        return prefix + (String)index;
    }

    public String[] repeat(int count, String ... inputList) {
        String[] result = new String[count];
        for (int i = 0; i < count; ++i) {
            int j = i % count;
            result[i] = inputList[j];
        }
        return result;
    }
}

