/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.workflows.html;

import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.fulib.workflows.BrokerTopicNote;
import org.fulib.workflows.ClassNote;
import org.fulib.workflows.CommandNote;
import org.fulib.workflows.EventModel;
import org.fulib.workflows.EventStormingBoard;
import org.fulib.workflows.PageLine;
import org.fulib.workflows.PageNote;
import org.fulib.workflows.QueryNote;
import org.fulib.workflows.ServiceNote;
import org.fulib.workflows.StrUtil;
import org.fulib.workflows.SubprocessNote;
import org.fulib.workflows.Workflow;
import org.fulib.workflows.WorkflowNote;
import org.fulib.yaml.Yaml;
import org.fulib.yaml.Yamler2;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroupFile;

public class HtmlGenerator3 {
    public BiConsumer<String, Object> dumpObjectDiagram;
    private STGroupFile htmlGroup;
    private ST st;
    private StringBuilder cssBody;
    private StringBuilder htmlBody;
    private StringBuilder jsBody;
    private EventModel eventModel;
    private int notesPerLane;
    private int maxNotesPerLane;
    private Workflow rootWorkflow;
    private EventStormingBoard eventStormingBoard;
    private ArrayList<LinkedHashMap<String, String>> historyMaps;
    private String icon;

    public void generateViewFiles4Board(EventStormingBoard board, String workFlowName) {
        this.eventModel = new EventModel();
        this.eventStormingBoard = board;
        this.generateHtml4Board(workFlowName);
        this.writeFiles(workFlowName);
    }

    public void generateViewFiles(String filename, String workFlowName) {
        this.eventModel = new EventModel();
        this.eventModel.buildEventStormModel(filename);
        this.eventStormingBoard = this.eventModel.getEventStormingBoard();
        this.generateViewFiles4Board(this.eventStormingBoard, workFlowName);
    }

    private void writeFiles(String workFlowName) {
        try {
            String outputHtmlFilePath;
            String outputDirectoryPath = String.format("tmp/%s", workFlowName);
            Files.createDirectories(Path.of(outputDirectoryPath, new String[0]), new FileAttribute[0]);
            String outputCssFilePath = "tmp/EventStorming.css";
            if (!Files.exists(Path.of(outputCssFilePath, new String[0]), new LinkOption[0])) {
                Files.createFile(Path.of(outputCssFilePath, new String[0]), new FileAttribute[0]);
                Files.write(Path.of(outputCssFilePath, new String[0]), this.cssBody.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            if (!Files.exists(Path.of(outputHtmlFilePath = String.format("tmp/%s/%sEventStorming.html", workFlowName, workFlowName), new String[0]), new LinkOption[0])) {
                Files.createFile(Path.of(outputHtmlFilePath, new String[0]), new FileAttribute[0]);
            }
            Files.write(Path.of(outputHtmlFilePath, new String[0]), this.htmlBody.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            String outputJsFilePath = String.format("tmp/%s/%sEventStorming.js", workFlowName, workFlowName);
            if (!Files.exists(Path.of(outputJsFilePath, new String[0]), new LinkOption[0])) {
                Files.createFile(Path.of(outputJsFilePath, new String[0]), new FileAttribute[0]);
            }
            Files.write(Path.of(outputJsFilePath, new String[0]), this.jsBody.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void generateHtml(String filename, String workFlowName) {
        this.eventModel = new EventModel();
        this.eventModel.buildEventStormModel(filename);
        this.eventStormingBoard = this.eventModel.getEventStormingBoard();
        this.generateHtml4Board(workFlowName);
    }

    private void generateHtml4Board(String workFlowName) {
        if (this.dumpObjectDiagram != null) {
            this.dumpObjectDiagram.accept(String.format("tmp/%s/GuiEventStormingBoard.svg", workFlowName), this.eventStormingBoard);
        }
        STGroupFile cssGroup = new STGroupFile(Objects.requireNonNull(this.getClass().getResource("css.stg")));
        this.htmlGroup = new STGroupFile(Objects.requireNonNull(this.getClass().getResource("html.stg")));
        STGroupFile jsGroup = new STGroupFile(Objects.requireNonNull(this.getClass().getResource("js.stg")));
        this.cssBody = new StringBuilder();
        this.htmlBody = new StringBuilder();
        this.jsBody = new StringBuilder();
        Iterator<Workflow> iterator = this.eventStormingBoard.getWorkflows().iterator();
        while (iterator.hasNext()) {
            Workflow workflow;
            this.rootWorkflow = workflow = iterator.next();
            String workflowName = workflow.getName();
            SubprocessNote subprocess = this.eventStormingBoard.getFromSubprocesses(workflowName);
            this.icon = "<i class=\"fa fa-cogs\">";
            if (subprocess != null) {
                this.icon = this.iconFor(subprocess);
            }
            String notes = this.notes();
            String id = this.rootWorkflow.getName().replaceAll("\\s+|_", "<br>");
            this.st = this.htmlGroup.getInstanceOf("lane2");
            this.st.add("id", (Object)id);
            this.st.add("content", (Object)notes);
            this.st.add("icon", (Object)this.icon);
            this.htmlBody.append(this.st.render());
            this.st = jsGroup.getInstanceOf("visibilityVariableAndMethod");
            this.st.add("id", (Object)id);
            this.jsBody.append(this.st.render());
        }
        this.st = cssGroup.getInstanceOf("css");
        this.st.add("width", (Object)(this.maxNotesPerLane * 220));
        this.cssBody.setLength(0);
        this.cssBody.append(this.st.render());
        this.st = this.htmlGroup.getInstanceOf("page");
        this.st.add("content", (Object)this.htmlBody.toString());
        this.st.add("workflowName", (Object)String.format("%sEventStorming", workFlowName));
        this.htmlBody.setLength(0);
        this.htmlBody.append(this.st.render());
    }

    private String notes() {
        Object laneName = null;
        StringBuilder buf = new StringBuilder();
        StringBuilder actionBuf = new StringBuilder();
        this.notesPerLane = 1;
        this.maxNotesPerLane = Math.max(this.maxNotesPerLane, this.notesPerLane);
        String previousActor = "noActor";
        String previousUserType = "noUserType";
        for (WorkflowNote note : this.rootWorkflow.getNotes()) {
            WorkflowNote subprocessNote;
            Object noteContent;
            if (note instanceof ClassNote) continue;
            String time = note.getTime();
            LinkedHashMap<String, String> map = note.getMap();
            String eventType = this.eventModel.getEventType(map);
            String user = null;
            user = note.getInteraction() != null ? note.getInteraction().getActorName() : "somebody";
            String userType = "user";
            ServiceNote serviceNote = this.eventStormingBoard.getFromServices(user);
            if (serviceNote != null) {
                userType = "server";
                previousUserType = "server";
            }
            if (previousUserType.equals("server") && userType.equals("user") || userType.equals("user") && !previousActor.equals("noActor") && !previousActor.equals(user)) {
                this.st = this.htmlGroup.getInstanceOf("lane3");
                this.st.add("id", (Object)this.rootWorkflow.getName());
                this.st.add("content", (Object)actionBuf.toString());
                this.st.add("icon", (Object)this.icon);
                buf.append(this.st.render());
                actionBuf.setLength(0);
                previousUserType = "noUserType";
            }
            String targetActor = user;
            String noteType = "event";
            if (eventType.equalsIgnoreCase("page")) {
                noteType = "page";
            } else if (eventType.equalsIgnoreCase("Data")) {
                String serviceName;
                targetActor = serviceName = note.getInteraction().getActorName();
                noteType = "data";
            } else if (note instanceof CommandNote) {
                noteType = "command";
            } else if (note instanceof QueryNote) {
                noteType = "command";
            }
            if (eventType.equalsIgnoreCase("page")) {
                PageNote pageNote = (PageNote)note;
                noteContent = this.pageNote(pageNote);
            } else if (note instanceof SubprocessNote) {
                subprocessNote = (SubprocessNote)note;
                noteType = "subprocess";
                String icon = this.iconFor((SubprocessNote)subprocessNote);
                noteContent = String.format("<div class='center'>%s</i></div>\n", icon) + String.format("<div>%s</div>\n", note.getTime());
            } else if (note instanceof BrokerTopicNote) {
                String[] split;
                subprocessNote = (BrokerTopicNote)note;
                noteType = "broker";
                StringBuilder lines = new StringBuilder();
                lines.append(String.format("<div class='box event center'>%s</i></div>\n", "E"));
                String value = (String)map.get("brokerTopic");
                for (String word : split = value.split("\\s+")) {
                    lines.append(String.format("<div class='center'>%s</i></div>\n", word));
                }
                noteContent = lines.toString();
            } else {
                noteContent = this.eventNote(note, map);
            }
            if (noteType.equals("placeholder") && !previousActor.equals(targetActor)) {
                noteContent = "<div>a_placeholder</div>";
            }
            if (!previousActor.equals(targetActor)) {
                this.st = this.htmlGroup.getInstanceOf("actor");
                this.st.add("id", (Object)user);
                this.st.add("type", (Object)userType);
                actionBuf.append(this.st.render());
            }
            previousActor = targetActor;
            this.st = this.htmlGroup.getInstanceOf("note");
            this.st.add("id", (Object)time);
            this.st.add("type", (Object)noteType);
            this.st.add("content", noteContent);
            actionBuf.append(this.st.render());
            ++this.notesPerLane;
            this.maxNotesPerLane = Math.max(this.maxNotesPerLane, this.notesPerLane);
        }
        this.st = this.htmlGroup.getInstanceOf("lane3");
        this.st.add("id", (Object)this.rootWorkflow.getName());
        this.st.add("content", (Object)actionBuf.toString());
        this.st.add("icon", (Object)this.icon);
        buf.append(this.st.render());
        return buf.toString();
    }

    private String iconFor(SubprocessNote subprocessNote) {
        String icon = subprocessNote.getKind().equals("subprocess") ? "<i class=\"fa fa-square fa-rotate-45\">" : "<i class=\"fa fa-cloud fa-cloud\" ></i>";
        return icon;
    }

    private String pageNote(PageNote note) {
        StringBuilder pageBody = new StringBuilder();
        String time = note.getTime();
        String serviceName = note.getService().getName();
        pageBody.append(String.format("<div><i class=\"fa fa-bars\"></i> %s %s</div>", serviceName, time));
        for (PageLine line : note.getLines()) {
            String html;
            String fill;
            Object value;
            String firstTag = line.getMap().keySet().iterator().next();
            if (firstTag.equalsIgnoreCase("name")) continue;
            if (firstTag.equalsIgnoreCase("label")) {
                value = line.getMap().get("label");
                String html2 = String.format("<div class=\"center\">%s</div>\n", value);
                pageBody.append(html2);
                continue;
            }
            if (firstTag.equalsIgnoreCase("input")) {
                value = line.getMap().get("input") + "?";
                fill = line.getMap().get("fill");
                if (fill != null) {
                    value = fill;
                }
                html = String.format("<div class=\"center\"><u>%s</u></div>\n", value);
                pageBody.append(html);
                continue;
            }
            if (firstTag.equalsIgnoreCase("password")) {
                value = line.getMap().get("password") + "?";
                fill = line.getMap().get("fill");
                if (fill != null) {
                    value = fill.replaceAll(".", "*");
                }
                html = String.format("<div class=\"center\"><u>%s</u></div>\n", value);
                pageBody.append(html);
                continue;
            }
            if (!firstTag.equalsIgnoreCase("button")) continue;
            value = line.getMap().get("button");
            String pointer = "";
            if (line.getMap().get("event") != null) {
                pointer = "<i class=\"fa fa-mouse-pointer\"></i>";
            }
            html = String.format("<div class=\"center\">[%s] %s</div>\n", value, pointer);
            pageBody.append(html);
        }
        String noteContent = pageBody.toString();
        return noteContent;
    }

    private String eventNote(WorkflowNote note, Map<String, String> map) {
        StringBuilder attrs = new StringBuilder();
        for (Map.Entry<String, String> attr : map.entrySet()) {
            Object key = attr.getKey();
            Object value = attr.getValue();
            if (((String)key).equals("event")) {
                key = "";
                if (!((String)value).endsWith(note.getTime())) {
                    value = (String)value + " " + note.getTime();
                }
            } else {
                key = (String)key + ":";
            }
            String line = String.format("<div>%s %s</div>\n", key, value);
            attrs.append(line);
        }
        String noteContent = attrs.toString();
        return noteContent;
    }

    public String generateHtml(LinkedHashMap history) {
        Collection values = history.values();
        Object[] objects = values.toArray();
        String yaml = Yaml.encode(objects);
        this.historyMaps = new Yamler2().decodeList(yaml);
        URL resource = this.getClass().getResource("html.stg");
        this.htmlGroup = new STGroupFile(resource);
        this.htmlBody = new StringBuilder();
        String notes = this.historyNotes();
        this.st = this.htmlGroup.getInstanceOf("lane2");
        this.st.add("id", (Object)"event<br>history");
        this.st.add("content", (Object)notes);
        this.htmlBody.append(this.st.render());
        this.st = this.htmlGroup.getInstanceOf("page");
        this.st.add("content", (Object)this.htmlBody.toString());
        this.st.add("workflowName", (Object)"history");
        this.htmlBody.setLength(0);
        this.htmlBody.append(this.st.render());
        return this.htmlBody.toString();
    }

    private String historyNotes() {
        Object laneName = null;
        StringBuilder notesBuffer = new StringBuilder();
        this.notesPerLane = 1;
        this.maxNotesPerLane = Math.max(this.maxNotesPerLane, this.notesPerLane);
        String previousActor = "noActor";
        StringBuilder noteContent = new StringBuilder();
        for (LinkedHashMap<String, String> map : this.historyMaps) {
            noteContent.setLength(0);
            LinkedHashSet<String> keySet = new LinkedHashSet<String>(map.keySet());
            String time = map.get("id");
            if (time != null) {
                time = time.replaceAll("\"", "");
            } else {
                keySet.remove("id");
            }
            keySet.remove(time);
            String block = map.get("blockId");
            keySet.remove("blockId");
            String eventTypeName = map.get(time);
            if (eventTypeName == null) {
                eventTypeName = map.values().iterator().next();
            }
            eventTypeName = StrUtil.simpleName(eventTypeName);
            String noteType = block == null ? "event" : "data";
            noteContent.append(String.format("<div>%s</div>\n", time));
            noteContent.append(String.format("<div>%s %s</div>\n", eventTypeName, block == null ? "" : block));
            for (String key : keySet) {
                String value = map.get(key);
                noteContent.append(String.format("<div>%s: %s</div>\n", key, value));
            }
            this.st = this.htmlGroup.getInstanceOf("note");
            this.st.add("id", (Object)time);
            this.st.add("type", (Object)noteType);
            this.st.add("content", (Object)noteContent.toString());
            notesBuffer.append(this.st.render());
            ++this.notesPerLane;
            this.maxNotesPerLane = Math.max(this.maxNotesPerLane, this.notesPerLane);
        }
        return notesBuffer.toString();
    }
}

