/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.yaml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.fulib.yaml.Reflector;

public class Yamler2 {
    private String yaml;
    private String[] lines;
    private Iterator<String> iterator;
    private ArrayList<LinkedHashMap<String, String>> result;
    private String line;
    private String trim;
    private String[] words;
    private LinkedHashMap<String, String> currentObject;

    public ArrayList<LinkedHashMap<String, String>> decodeList(String yaml) {
        this.yaml = yaml;
        this.lines = yaml.split("\n");
        this.iterator = Arrays.stream(this.lines).iterator();
        this.result = new ArrayList();
        this.nextLine();
        while (true) {
            if (this.trim.startsWith("#")) {
                this.nextLine();
                continue;
            }
            if (!this.trim.startsWith("-")) {
                return this.result;
            }
            LinkedHashMap<String, String> map = this.decodeObject();
            this.result.add(map);
        }
    }

    private boolean nextLine() {
        while (this.iterator.hasNext()) {
            this.line = this.iterator.next();
            this.trim = this.line.trim();
            if (this.trim.equals("")) continue;
            return true;
        }
        this.line = "";
        this.trim = "";
        return false;
    }

    private LinkedHashMap<String, String> decodeObject() {
        this.currentObject = new LinkedHashMap();
        this.trim = this.line.substring(this.line.indexOf("-") + 1).trim();
        block0: while (true) {
            this.words = this.trim.split("\\s+");
            if (this.words[0].equals("-")) {
                return this.currentObject;
            }
            if (this.words[0].equals("#")) {
                if (this.nextLine()) continue;
                return this.currentObject;
            }
            int currentIndent = this.line.indexOf(this.words[0]);
            Object key = "";
            for (int i = 0; i < this.words.length && !((String)(key = (String)key + (" " + this.words[i]).trim())).endsWith(":"); ++i) {
            }
            String attrName = this.stripColon((String)key);
            String value = this.trim.replace((CharSequence)key, "").trim();
            if (!value.equals("")) {
                this.currentObject.put(attrName, value);
                if (this.nextLine()) continue;
                return this.currentObject;
            }
            StringBuilder multiLineValue = new StringBuilder();
            while (true) {
                if (!this.nextLine()) {
                    this.currentObject.put(attrName, multiLineValue.toString());
                    return this.currentObject;
                }
                String[] newWords = this.trim.split("\\s+");
                int newIndent = this.line.indexOf(newWords[0]);
                if (currentIndent >= newIndent) {
                    this.currentObject.put(attrName, multiLineValue.toString());
                    continue block0;
                }
                multiLineValue.append(this.line).append("\n");
            }
            break;
        }
    }

    public String stripColon(String key) {
        String id = key;
        if (key.endsWith(":")) {
            id = key.substring(0, key.length() - 1);
        } else {
            this.printError("key does not end with ':' " + key);
        }
        return id;
    }

    void printError(String msg) {
        String info = this.line + "\n<--" + msg + "-->";
        System.err.println(info);
    }

    public void mergeObjects(Object oldEvent, Object event) {
        LinkedHashMap<String, String> oldMap = this.toMap(oldEvent);
        LinkedHashMap<String, String> newMap = this.toMap(event);
        for (Map.Entry<String, String> entry : newMap.entrySet()) {
            String key = entry.getKey();
            String newValue = entry.getValue();
            String oldValue = oldMap.get(key);
            if (newValue.startsWith("[")) {
                String merge = this.mergeLists(oldValue, newValue);
                oldMap.put(key, merge);
                Logger.getGlobal().info("List merge not yet implemented");
                continue;
            }
            oldMap.put(key, newValue);
        }
        this.toEvent(oldMap, event);
    }

    private String mergeLists(String oldValue, String newValue) {
        if (oldValue == null) {
            return newValue;
        }
        int start = oldValue.indexOf(91) + 1;
        int end = oldValue.indexOf(93);
        oldValue = oldValue.substring(start, end);
        String[] split = oldValue.split(",\\s+");
        ArrayList<String> resultList = new ArrayList<String>();
        resultList.addAll(Arrays.asList(split));
        start = newValue.indexOf(91) + 1;
        end = newValue.indexOf(93);
        newValue = newValue.substring(start, end);
        for (String s : split = newValue.split(",\\s+")) {
            if (resultList.contains(s)) continue;
            resultList.add(s);
        }
        CharSequence[] resultArray = resultList.toArray(new String[resultList.size()]);
        String join = String.join((CharSequence)", ", resultArray);
        return "[" + join + "]";
    }

    private Object toEvent(LinkedHashMap<String, String> map, Object event) {
        Reflector reflector = new Reflector().setClazz(event.getClass());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            reflector.setValue(event, entry.getKey(), (Object)entry.getValue());
        }
        return event;
    }

    public LinkedHashMap<String, String> toMap(Object event) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        Reflector reflector = new Reflector().setClazz(event.getClass());
        for (String property : reflector.getAllProperties()) {
            Object value = reflector.getValue(event, property);
            if (value == null) continue;
            result.put(property, value.toString());
        }
        return result;
    }

    public String toYaml(LinkedHashMap<String, String> map) {
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            buf.append(String.format("  %s: \"%s\"\n", entry.getKey(), entry.getValue()));
        }
        buf.setCharAt(0, '-');
        return buf.toString();
    }
}

