/*
 * Decompiled with CFR 0.152.
 */
package org.fulib.workflows.generators.constructors;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.antlr.v4.runtime.misc.Pair;
import org.fulib.workflows.events.BaseNote;
import org.fulib.workflows.events.Board;
import org.fulib.workflows.events.Command;
import org.fulib.workflows.events.Data;
import org.fulib.workflows.events.Event;
import org.fulib.workflows.events.ExternalSystem;
import org.fulib.workflows.events.Page;
import org.fulib.workflows.events.Policy;
import org.fulib.workflows.events.Problem;
import org.fulib.workflows.events.Service;
import org.fulib.workflows.events.User;
import org.fulib.workflows.events.Workflow;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroupFile;

public class BoardConstructor {
    private Board currentBoard;
    private STGroupFile boardGroup;

    public String buildBoard(Board board) {
        this.currentBoard = board;
        this.boardGroup = new STGroupFile(Objects.requireNonNull(this.getClass().getResource("../Board.stg")));
        StringBuilder boardBody = new StringBuilder();
        ST st = this.boardGroup.getInstanceOf("board");
        st.add("content", (Object)this.buildBoardContent());
        boardBody.append(st.render());
        return boardBody.toString();
    }

    private String buildBoardContent() {
        StringBuilder boardContent = new StringBuilder();
        for (Workflow workflow : this.currentBoard.getWorkflows()) {
            ST st = this.boardGroup.getInstanceOf("workflow");
            st.add("name", (Object)workflow.getName());
            st.add("content", (Object)this.buildWorkflow(workflow));
            boardContent.append(st.render());
        }
        return boardContent.toString();
    }

    private String buildWorkflow(Workflow workflow) {
        StringBuilder workflowContent = new StringBuilder();
        int pageNumber = 0;
        int dataNumber = 0;
        for (BaseNote note : workflow.getNotes()) {
            ST pageST;
            ST noteST = this.boardGroup.getInstanceOf("note");
            if (note instanceof Event) {
                Event event = (Event)note;
                noteST.add("content", (Object)this.buildNoteContentFromNote(event, "Event:"));
                noteST.add("color", (Object)"orange");
                workflowContent.append(noteST.render());
                continue;
            }
            if (note instanceof ExternalSystem) {
                noteST.add("content", (Object)this.buildNoteContent("External System:", note.getName()));
                noteST.add("color", (Object)"pink");
                workflowContent.append(noteST.render());
                continue;
            }
            if (note instanceof Command) {
                noteST.add("content", (Object)this.buildNoteContent("Command:", note.getName()));
                noteST.add("color", (Object)"lightskyblue");
                workflowContent.append(noteST.render());
                continue;
            }
            if (note instanceof User) {
                noteST.add("content", (Object)this.buildNoteContent("User:", note.getName()));
                noteST.add("color", (Object)"gold");
                workflowContent.append(noteST.render());
                continue;
            }
            if (note instanceof Data) {
                Data data = (Data)note;
                pageST = this.boardGroup.getInstanceOf("page");
                pageST.add("content", (Object)this.buildNoteContentFromNote(data, "Data:"));
                pageST.add("color", (Object)"darkseagreen");
                pageST.add("index", (Object)dataNumber);
                ++dataNumber;
                workflowContent.append(pageST.render());
                continue;
            }
            if (note instanceof Policy) {
                noteST.add("content", (Object)this.buildNoteContent("Policy:", note.getName()));
                noteST.add("color", (Object)"#C8A2C8");
                workflowContent.append(noteST.render());
                continue;
            }
            if (note instanceof Page) {
                Page page = (Page)note;
                pageST = this.boardGroup.getInstanceOf("page");
                pageST.add("content", (Object)this.buildNoteContentFromNote(page, "Page:"));
                pageST.add("color", (Object)"palegreen");
                pageST.add("index", (Object)pageNumber);
                ++pageNumber;
                workflowContent.append(pageST.render());
                continue;
            }
            if (note instanceof Problem) {
                noteST.add("content", (Object)this.buildNoteContent("Problem:", note.getName()));
                noteST.add("color", (Object)"indianred");
                workflowContent.append(noteST.render());
                continue;
            }
            if (!(note instanceof Service)) continue;
            noteST.add("content", (Object)this.buildNoteContent("Service:", note.getName()));
            noteST.add("color", (Object)"palevioletred");
            workflowContent.append(noteST.render());
        }
        return workflowContent.toString();
    }

    private String buildNoteContent(String noteName, String content) {
        StringBuilder textContent = new StringBuilder();
        ST st = this.boardGroup.getInstanceOf("type");
        st.add("type", (Object)noteName);
        textContent.append(st.render());
        st = this.boardGroup.getInstanceOf("text");
        st.add("text", (Object)content);
        textContent.append(st.render());
        return textContent.toString();
    }

    private String buildNoteContentFromNote(BaseNote note, String noteName) {
        Map<Object, Object> contents = new HashMap();
        StringBuilder textContent = new StringBuilder();
        ST st = this.boardGroup.getInstanceOf("type");
        st.add("type", (Object)noteName);
        textContent.append(st.render());
        switch (noteName) {
            case "Event:": {
                contents = ((Event)note).getData();
                st = this.boardGroup.getInstanceOf("text");
                st.add("text", (Object)("name= " + note.getName()));
                textContent.append(st.render());
                break;
            }
            case "Data:": {
                contents = ((Data)note).getData();
                st = this.boardGroup.getInstanceOf("text");
                st.add("text", (Object)("name= " + note.getName()));
                textContent.append(st.render());
                break;
            }
            case "Page:": {
                contents = ((Page)note).getContent();
                break;
            }
            default: {
                System.out.println("Unknown Type");
            }
        }
        for (int i = 0; i <= contents.size(); ++i) {
            Pair pair = (Pair)contents.get(i);
            if (pair == null) continue;
            String text = (String)pair.a + "= ";
            text = text + (String)pair.b;
            st = this.boardGroup.getInstanceOf("text");
            st.add("text", (Object)text);
            textContent.append(st.render());
        }
        return textContent.toString();
    }
}

